/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.smartApproval.builder.InputParameterBuilder;
import kd.ssc.smartApproval.enums.TaskDataUploadStatusEnum;
import kd.ssc.smartApproval.pojo.InputParameter;
import kd.ssc.smartApproval.util.TaskDataUploadHelper;

public class UploadDataConstructSchedule
extends AbstractTask {
    private static final int pageSize = 5000;
    private static final Log log = LogFactory.getLog((String)"UploadDataConstructSchedule");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            String isClear = TaskDataUploadHelper.getSettingInfo((String)"forcedClear");
            Boolean isForcedClearTmp = StringUtils.equals((CharSequence)isClear, (CharSequence)"true");
            this.clearTmp(isForcedClearTmp);
            String isEnable = TaskDataUploadHelper.getSettingInfo((String)"isEnableSmartApproval");
            if (!StringUtils.equals((CharSequence)isEnable, (CharSequence)"true")) {
                return;
            }
            this.deleteHisData();
            List<Long> taskIds = this.getHisTask();
            this.inputParamBuildAndSave(taskIds);
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u5ba1\u6838\u52a9\u624b\u6570\u636e\u9884\u5904\u7406\u62a5\u9519" + e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, new ErrorCode("UploadDataConstructSchedule", e.getMessage()), new Object[0]);
        }
    }

    private void deleteHisData() {
        Date oneYearBeforeNow = this.iniLastTime();
        QFilter timeFilter = new QFilter("fcreatetime", "<", (Object)oneYearBeforeNow);
        QFilter stmpFilter = new QFilter("taskid", "!=", (Object)"0");
        DeleteServiceHelper.delete((String)"task_approval_tempdata", (QFilter[])new QFilter[]{timeFilter, stmpFilter});
    }

    private void clearTmp(Boolean isForcedClearTmp) {
        if (isForcedClearTmp.booleanValue()) {
            DeleteServiceHelper.delete((String)"task_approval_tempdata", null);
            DynamicObject sscParamDyo = BusinessDataServiceHelper.loadSingle((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter("paramname", "=", (Object)"forcedClear").toArray());
            sscParamDyo.set("paramvalue", (Object)"false");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sscParamDyo});
        } else {
            QFilter retryUploadFilter;
            QFilter uploadStateFilter = new QFilter("status", "=", (Object)TaskDataUploadStatusEnum.NotUpload.getValue());
            if (!QueryServiceHelper.exists((String)"task_approval_tempdata", (QFilter[])uploadStateFilter.or(retryUploadFilter = new QFilter("count", "<", (Object)3).and(new QFilter("status", "=", (Object)TaskDataUploadStatusEnum.ErrorRetry.getValue()))).toArray())) {
                QFilter deleteFilter = new QFilter("taskid", "!=", (Object)"0");
                DeleteServiceHelper.delete((String)"task_approval_tempdata", (QFilter[])deleteFilter.toArray());
            }
        }
    }

    private List<Long> getHisTask() {
        QFilter stateFilter;
        Date completeTime;
        Date lastTime = this.getLastTime();
        if (lastTime.after(completeTime = this.getCompleteTime())) {
            return Collections.emptyList();
        }
        Date oneMonthAfterLast = this.getOneMonthAfterLast(lastTime);
        QFilter timeFilter = new QFilter("createtime", ">", (Object)lastTime).and(new QFilter("createtime", "<=", (Object)oneMonthAfterLast));
        DynamicObjectCollection hisTasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{timeFilter, stateFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.AUDIT_PASSED.getValue(), TaskStateEnum.AUDIT_NOTPASSED.getValue()})});
        if (hisTasks == null || hisTasks.isEmpty()) {
            Date now = new Date();
            if (oneMonthAfterLast.after(now)) {
                oneMonthAfterLast = now;
            }
            this.saveTimeStmp(oneMonthAfterLast);
            return Collections.emptyList();
        }
        return hisTasks.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
    }

    private void saveTimeStmp(Date oneMonthAfterLast) {
        InputParameter timeStmp = new InputParameter();
        timeStmp.setFid("0");
        timeStmp.setFcreatetime(oneMonthAfterLast);
        DynamicObject saveDyo = this.getSaveDyo(timeStmp, TaskDataUploadStatusEnum.Uploaded);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
    }

    private Date getCompleteTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return calendar.getTime();
    }

    private Date getOneMonthAfterLast(Date lastTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastTime);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    private Date getLastTime() {
        QFilter qFilter = new QFilter("fcreatetime", "!=", null);
        DynamicObjectCollection lastData = QueryServiceHelper.query((String)"task_approval_tempdata", (String)"fcreatetime", (QFilter[])qFilter.toArray(), (String)"fcreatetime desc", (int)1);
        Date lastTime = this.iniLastTime();
        if (lastData == null || lastData.isEmpty()) {
            return lastTime;
        }
        lastTime = ((DynamicObject)lastData.get(0)).getDate("fcreatetime");
        return lastTime;
    }

    private Date iniLastTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -12);
        return calendar.getTime();
    }

    private void inputParamBuildAndSave(List<Long> taskIds) {
        if (taskIds.isEmpty()) {
            return;
        }
        int total = taskIds.size();
        int page = (int)Math.ceil((double)total / 5000.0);
        int complete = 0;
        InputParameterBuilder builder = new InputParameterBuilder();
        for (int i = 0; i < page; ++i) {
            List<Long> taskSubList;
            if (complete + 5000 > total) {
                taskSubList = taskIds.subList(complete, total);
                complete = total;
            } else {
                taskSubList = taskIds.subList(complete, complete + 5000);
                complete += 5000;
            }
            List buildParams = builder.buildParameter(taskSubList);
            this.saveTmp(buildParams);
        }
    }

    private void saveTmp(List<InputParameter> buildParams) {
        if (buildParams != null) {
            ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(buildParams.size());
            for (InputParameter buildParam : buildParams) {
                DynamicObject saveDyo = this.getSaveDyo(buildParam, TaskDataUploadStatusEnum.NotUpload);
                saveDatas.add(saveDyo);
            }
            if (!saveDatas.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
            }
        }
    }

    private DynamicObject getSaveDyo(InputParameter buildParam, TaskDataUploadStatusEnum status) {
        DynamicObject saveDyo = BusinessDataServiceHelper.newDynamicObject((String)"task_approval_tempdata");
        saveDyo.set("taskid", (Object)buildParam.getFid());
        saveDyo.set("fbilltypeid", (Object)buildParam.getFbilltypeid());
        saveDyo.set("forgid", (Object)buildParam.getForgid());
        saveDyo.set("fsscid", (Object)buildParam.getFsscid());
        saveDyo.set("fimageok", (Object)buildParam.getFimageok());
        saveDyo.set("fcreatorid", (Object)buildParam.getFcreatorid());
        saveDyo.set("fcreatetime", (Object)buildParam.getFcreatetime());
        saveDyo.set("frecordtype", (Object)buildParam.getFrecordtype());
        saveDyo.set("ffeetype", (Object)buildParam.getFfeetype());
        saveDyo.set("fmoney", (Object)buildParam.getFmoney());
        saveDyo.set("fisneedimage", (Object)buildParam.getFisneedimage());
        saveDyo.set("fcreditlevel", (Object)buildParam.getFcreditlevel());
        saveDyo.set("fcreditvalue", (Object)buildParam.getFcreditvalue());
        saveDyo.set("fuser", (Object)buildParam.getFuser());
        saveDyo.set("funqualifiedtotalnum", (Object)buildParam.getFunqualifiedtotalnum().intValue());
        saveDyo.set("fyzjimported", (Object)buildParam.getFyzjimported());
        saveDyo.set("forgpatternid", (Object)buildParam.getForgpatternid());
        saveDyo.set("fispurchase", (Object)buildParam.getFispurchase());
        saveDyo.set("fissale", (Object)buildParam.getFissale());
        saveDyo.set("fisinventory", (Object)buildParam.getFisinventory());
        saveDyo.set("fisaccounting", (Object)buildParam.getFisaccounting());
        saveDyo.set("fcreatetime_org", (Object)buildParam.getFcreatetime_org());
        saveDyo.set("fisbizorg", (Object)buildParam.getFisbizorg());
        saveDyo.set("fgender", (Object)buildParam.getFgender());
        saveDyo.set("fusertype", (Object)buildParam.getFusertype());
        saveDyo.set("fstate", (Object)buildParam.getFstate());
        saveDyo.set("fcreatetime_user", (Object)buildParam.getFcreatetime_user());
        saveDyo.set("fruleresult", (Object)buildParam.getFruleresult());
        List withdrawal = buildParam.getWithdrawal();
        if (withdrawal.size() > 2) {
            withdrawal = withdrawal.subList(0, 2);
        }
        saveDyo.set("withdrawal", (Object)withdrawal.toString());
        List breakrule = buildParam.getBreakrule();
        if (breakrule.size() > 2) {
            breakrule = breakrule.subList(0, 2);
        }
        saveDyo.set("breakrule", (Object)breakrule.toString());
        saveDyo.set("operation", (Object)buildParam.getOperation());
        saveDyo.set("status", (Object)status.getValue());
        saveDyo.set("count", (Object)0);
        return saveDyo;
    }
}

