/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class AreaFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseData = (BasedataEdit)this.getControl("usessc");
        baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Long createOrgId = 0L;
        IDataModel model = this.getModel();
        Object createOrg = model.getValue("createorg");
        if (createOrg == null) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                String pageId = parentView.getFormShowParameter().getFormId();
                if ("dhc_knowledge_add".equals(pageId)) {
                    String sscId = parentView.getPageCache().get("sscId");
                    createOrgId = Long.parseLong(sscId);
                    model.setValue("createorg", (Object)createOrgId);
                }
            } else {
                createOrgId = RequestContext.getOrCreate().getOrgId();
                model.setValue("createorg", (Object)createOrgId);
            }
        } else {
            createOrgId = ((DynamicObject)createOrg).getLong("id");
        }
        model.setValue("usessc", (Object)new Object[]{createOrgId});
        Object defaultRole = this.getDefaultRole();
        model.setValue("roles", (Object)new Object[]{defaultRole});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        MulBasedataEdit edit;
        String fieldName;
        Object source = e.getSource();
        if (source instanceof MulBasedataEdit && StringUtils.equals((CharSequence)"usessc", (CharSequence)(fieldName = (edit = (MulBasedataEdit)e.getSource()).getKey()))) {
            this.addSscOrgPermFilter(e);
        }
    }

    private void addSscOrgPermFilter(BeforeF7SelectEvent e) {
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)currentUserId, (String)appId, (String)"som_knowledge_area", (String)"47150e89000000ac");
        List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
        boolean isAllPerssion = allPermOrgs.hasAllOrgPerm();
        if (!isAllPerssion) {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            QFilter qFilter = new QFilter("id", "in", (Object)hasPermOrgs);
            qFilters.add(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof Save && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }

    private Object getDefaultRole() {
        return "1MDO9B9H4ED+";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            Save operate = (Save)source;
            operate.getOption().setVariableValue("appId", this.getView().getFormShowParameter().getAppId());
        }
    }
}

