/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.bdctrl.BaseDataListPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.smartcs.factory.AreaFactory;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.AreaParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.task.util.SscLicenseUtil;

public class AreaListPlugin
extends BaseDataListPlugin {
    private static final Log log = LogFactory.getLog(AreaListPlugin.class);
    public static final String TBLASSIGN_SEARCHORG = "tblassign_searchorg";
    private static final String assignQueryPermItemId = "16G+KEKP9Z59";
    private static final String CALLBACK_SEARCH_ORG_LIST = "assignQueryCallBack";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        SscLicenseUtil.checkFeatureLicense((String)"PRO_SSC_SCS", (PreOpenFormEventArgs)e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (TBLASSIGN_SEARCHORG.equals(itemKey) && !this.checkAssignQueryPermission()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u77e5\u8bc6\u7ba1\u7406\u201d\u7684\u201c\u5206\u914d\u67e5\u8be2\u201d\u6743\u9650\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AreaListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        super.beforeItemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("editinfo".equals(key)) {
            DynamicObject operateData = this.getOperateData(args);
            if (operateData == null) {
                return;
            }
            String areaName = ((ILocaleString)operateData.get("name")).getLocaleValue();
            Long createOrgId = operateData.getLong("createorg.id");
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("som_knowledge_info");
            param.setCaption(areaName);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("areaLink", (Object)"areaLink");
            param.setCustomParam("areaId", operateData.getPkValue());
            param.setCustomParam("createOrg", (Object)createOrgId);
            this.getView().showForm((FormShowParameter)param);
        } else if ("editleadword".equals(key)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("som_leading_words");
            parameter.setPkId(this.getLeadingWordId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)parameter);
        }
        this.afterClear(args);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String callBackId = event.getActionId();
        if (CALLBACK_SEARCH_ORG_LIST.equals(callBackId)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            if (rows.size() > 0) {
                ArrayList<Long> selectIds = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    selectIds.add((Long)row.getPrimaryKeyValue());
                }
                this.writeBack(selectIds);
            }
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void writeBack(List<Long> selectIds) {
        Map<Long, DynamicObject> areaData = this.getWriteBackAreaData(selectIds);
        Map<Long, List<Long>> wbOrgData = this.getAuthOrg(selectIds);
        this.writeBackAreaData(areaData, wbOrgData);
        this.saveAreaData(areaData);
        this.synUpdatedAreaData2AI(areaData);
    }

    private void synUpdatedAreaData2AI(Map<Long, DynamicObject> areaData) {
        for (Map.Entry<Long, DynamicObject> entry : areaData.entrySet()) {
            DynamicObject dyo = entry.getValue();
            AbstractAIMetaParameter input = this.constructInput(dyo);
            if (input == null) continue;
            this.callAPI(input);
        }
    }

    private void callAPI(AbstractAIMetaParameter input) {
        AbstractAIMetaProduct product = new AreaFactory().makeMeta(input);
        product.update();
    }

    private AbstractAIMetaParameter constructInput(DynamicObject dyo) {
        AreaParameter input = new AreaParameter();
        long aiAreaId = dyo.getLong("aiareaid");
        if (aiAreaId == 0L) {
            return null;
        }
        input.setId(Long.valueOf(aiAreaId));
        input.setName(dyo.get("name") + "");
        input.setNumber(dyo.getString("number"));
        input.setUseRole(this.getUseRoleInfo(dyo));
        input.setUseScc(this.getUseOrgInfo(dyo));
        return input;
    }

    private Map<Long, String> getUseOrgInfo(DynamicObject dyo) {
        List<Long> useOrgIds = this.getSscIdList(dyo);
        HashMap<Long, String> result = new HashMap<Long, String>(useOrgIds.size());
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", useOrgIds)});
        if (!dyos.isEmpty()) {
            for (DynamicObject org : dyos) {
                Long orgId = org.getLong("id");
                String orgName = org.get("name") + "";
                result.put(orgId, orgName);
            }
        }
        return result;
    }

    private Map<String, String> getUseRoleInfo(DynamicObject dyo) {
        HashMap<String, String> useRoleInfoMap = new HashMap<String, String>(4);
        List<String> roleIds = this.getRoleIdList(dyo);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"perm_role", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
        if (!dyos.isEmpty()) {
            for (DynamicObject role : dyos) {
                String roleId = role.getString("id");
                String roleName = role.getString("name");
                useRoleInfoMap.put(roleId, roleName);
            }
        }
        return useRoleInfoMap;
    }

    private List<Long> getSscIdList(DynamicObject dyo) {
        DynamicObjectCollection assignSsc = dyo.getDynamicObjectCollection("usessc");
        ArrayList<Long> ids = new ArrayList<Long>(assignSsc.size());
        for (DynamicObject orgdyo : assignSsc) {
            Object orgid = orgdyo.get("fbasedataid_id");
            if (!(orgid instanceof Long)) continue;
            ids.add((Long)orgid);
        }
        return ids;
    }

    private List<String> getRoleIdList(DynamicObject dyo) {
        DynamicObjectCollection assignSsc = dyo.getDynamicObjectCollection("roles");
        ArrayList<String> ids = new ArrayList<String>(2);
        for (DynamicObject orgdyo : assignSsc) {
            Object roleId = orgdyo.get("fbasedataid_id");
            if (!(roleId instanceof String)) continue;
            ids.add((String)roleId);
        }
        return ids;
    }

    private void saveAreaData(Map<Long, DynamicObject> areaData) {
        if (areaData.size() > 0) {
            ArrayList<DynamicObject> saveValues = new ArrayList<DynamicObject>(areaData.values());
            SaveServiceHelper.save((DynamicObject[])saveValues.toArray(new DynamicObject[0]));
        }
    }

    private void writeBackAreaData(Map<Long, DynamicObject> areaData, Map<Long, List<Long>> wbOrgData) {
        Iterator<Map.Entry<Long, DynamicObject>> itor = areaData.entrySet().iterator();
        while (itor.hasNext()) {
            Map.Entry<Long, DynamicObject> entry = itor.next();
            Long id = entry.getKey();
            DynamicObject dyo = entry.getValue();
            List<Long> useOrgs = wbOrgData.get(id);
            if (useOrgs == null || useOrgs.isEmpty()) {
                this.clearAuthOrg(dyo);
                continue;
            }
            boolean updated = this.assignCanceled(dyo, useOrgs);
            if (updated) continue;
            itor.remove();
        }
    }

    private boolean assignCanceled(DynamicObject dyo, List<Long> useOrgs) {
        boolean assignCanceled = false;
        DynamicObjectCollection useOrgsbeforCancel = dyo.getDynamicObjectCollection("usessc");
        if (useOrgsbeforCancel.size() - 1 > useOrgs.size()) {
            assignCanceled = true;
            this.wbUseOrg(dyo, useOrgs);
        }
        return assignCanceled;
    }

    private void wbUseOrg(DynamicObject dyo, List<Long> useOrgs) {
        DynamicObjectCollection useOrgsbeforCancel = dyo.getDynamicObjectCollection("usessc");
        HashSet<Long> useOrgIdSet = new HashSet<Long>(useOrgs);
        useOrgIdSet.add(this.getCreateOrgId(dyo));
        Iterator iterator = useOrgsbeforCancel.iterator();
        while (iterator.hasNext()) {
            Long useOrgId = ((DynamicObject)iterator.next()).getLong("fbasedataid_id");
            if (useOrgIdSet.contains(useOrgId)) continue;
            iterator.remove();
        }
    }

    private Long getCreateOrgId(DynamicObject dyo) {
        Object createOrg = dyo.get("createorg");
        if (createOrg instanceof DynamicObject) {
            return (Long)((DynamicObject)createOrg).getPkValue();
        }
        return (Long)createOrg;
    }

    private void clearAuthOrg(DynamicObject dyo) {
        Object createOrg = dyo.get("createorg");
        Long createOrgId = createOrg instanceof DynamicObject ? (Long)((DynamicObject)createOrg).getPkValue() : (Long)createOrg;
        DynamicObjectCollection useOrgs = dyo.getDynamicObjectCollection("usessc");
        useOrgs.clear();
        DynamicObject addCreateOrg = useOrgs.addNew();
        addCreateOrg.set("fbasedataid_id", (Object)createOrgId);
    }

    private Map<Long, List<Long>> getAuthOrg(List<Long> selectIds) {
        DynamicObject typeDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_knowledge_area");
        String dataTableName = typeDyo.getDataEntityType().getAlias();
        String dataTableUseName = dataTableName + "UseReg";
        StringBuilder assignSql = new StringBuilder("SELECT FDATAID, FUSEORGID FROM ");
        assignSql.append(dataTableUseName);
        assignSql.append(" WHERE FDATAID IN (");
        String idString = Arrays.toString((Object[])selectIds.toArray(new Long[0]));
        assignSql.append(idString.substring(1, idString.length() - 1));
        assignSql.append(") AND FCREATEORGID <> FUSEORGID");
        String dbRouteKey = typeDyo.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getAuthOrg()"), (DBRoute)dbRoute, (String)assignSql.toString());
        HashMap<Long, List<Long>> wbOrgData = new HashMap<Long, List<Long>>(selectIds.size());
        for (Row row : dataSet) {
            Long id = row.getLong("FDATAID");
            Long useOrgId = row.getLong("FUSEORGID");
            List useOrgIdList = wbOrgData.computeIfAbsent(id, k -> new ArrayList(1));
            useOrgIdList.add(useOrgId);
        }
        return wbOrgData;
    }

    private Map<Long, DynamicObject> getWriteBackAreaData(List<Long> selectIds) {
        DynamicObject typeDyo = BusinessDataServiceHelper.newDynamicObject((String)"som_knowledge_area");
        DynamicObject[] dyns = BusinessDataServiceHelper.load((Object[])selectIds.toArray(new Long[0]), (DynamicObjectType)typeDyo.getDynamicObjectType());
        HashMap<Long, DynamicObject> areaData = new HashMap<Long, DynamicObject>(dyns.length);
        for (DynamicObject dyo : dyns) {
            areaData.put((Long)dyo.getPkValue(), dyo);
        }
        return areaData;
    }

    private DynamicObject getOperateData(AfterDoOperationEventArgs args) {
        DynamicObject operateData = null;
        try {
            Object dataId = ((Donothing)args.getSource()).getListFocusRow().getPrimaryKeyValue();
            operateData = BusinessDataServiceHelper.loadSingle((Object)dataId, (String)"som_knowledge_area");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u64cd\u4f5c\u6570\u636e", (Throwable)e);
        }
        return operateData;
    }

    private Object getLeadingWordId() {
        DynamicObjectCollection existIds = QueryServiceHelper.query((String)"som_leading_words", (String)"id", null);
        if (existIds == null || existIds.isEmpty()) {
            return null;
        }
        return ((DynamicObject)existIds.get(0)).get("id");
    }

    private boolean checkAssignQueryPermission() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "ssc";
        }
        String appId_ = AppMetadataCache.getAppInfo((String)appId).getId();
        String createOrg = this.getPageCache().get("createOrg");
        if (kd.bos.util.StringUtils.isEmpty((String)createOrg)) {
            log.info(".checkAssignQueryPermission() error. \u83b7\u53d6\u7f13\u5b58\u7684\u5171\u4eab\u4e2d\u5fc3\u5f02\u5e38");
            return false;
        }
        long userId = RequestContext.get().getCurrUserId();
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)Long.parseLong(createOrg), (String)"12", (String)appId_, (String)"som_knowledge_area", (String)assignQueryPermItemId);
        return result == 1;
    }

    private void afterClear(AfterDoOperationEventArgs args) {
        if ("cleararea".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

