/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartqualitycheck;

import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.common.smartscheme.AlgorithmDetailEnum;
import kd.ssc.task.common.smartscheme.SmartQualityCheckPredict;
import kd.ssc.task.util.SscLicenseUtil;

public class SmartQualitySchemeAlgomanagementPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(SmartQualitySchemeAlgomanagementPlugin.class);
    private static final String[] colors = new String[]{"#FFA940", "#F57582", "#45DAD1", "#40A9FF", "#73D13D", "#FFC53D", "#9F69E2", "#6682F5"};
    private static final String systemType = "ssc-task-formplugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"piechartap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"refresh"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"workflow_btn", (CharSequence)key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("task_smartworkflowpicture");
            StyleCss css = new StyleCss();
            css.setWidth("1280");
            css.setHeight("650");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)key)) {
            try {
                SmartQualityCheckPredict.getQualityDetectInformation();
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u4fe1\u606f\u8fed\u4ee3\u8fd0\u7b97\u4fe1\u606f\u5f02\u5e38");
            }
            this.generatePieChat();
            this.generatePointlineChart();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String version = LicenseServiceHelper.getProductVersion();
        if ("5.0".equals(version)) {
            SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"task_smart_algomanagement");
        } else if ("4.0".equals(version)) {
            SscLicenseUtil.checkFeatureLicense((String)"PRO_SSC_SCS", (PreOpenFormEventArgs)e);
        }
        super.preOpenForm(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("modelinit".equals(opKey) && opResult.isSuccess()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setLookUp(true);
            showParameter.setBillFormId("task_smartmodelinit");
            showParameter.setFormId("bos_listf7");
            showParameter.setMultiSelect(true);
            StyleCss css = new StyleCss();
            css.setWidth("960");
            css.setHeight("580");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowFilter(false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "propertyTree");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection ret;
        super.closedCallBack(closedCallBackEvent);
        if ("propertyTree".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null && !CollectionUtils.isEmpty((Collection)(ret = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            StringBuilder sbCode = new StringBuilder();
            StringBuilder sbName = new StringBuilder();
            for (ListSelectedRow row : ret) {
                sbCode.append(row.getNumber()).append(',');
                sbName.append(row.getName()).append(',');
            }
            String featureCode = sbCode.toString();
            String featureName = sbName.toString();
            if (StringUtils.isNotBlank((CharSequence)featureCode)) {
                featureCode = featureCode.substring(0, featureCode.length() - 1);
                featureName = featureName.substring(0, featureName.length() - 1);
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put("featureCode", featureCode);
            ConfirmCallBackListener callokListener = new ConfirmCallBackListener("callokListener", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u6a21\u578b\u521d\u59cb\u5316\u8bad\u7ec3\u91c7\u7528\u4ee5\u4e0b\u53c2\u6570\uff1a%s", (String)"SmartQualitySchemeAlgomanagementPlugin_10", (String)systemType, (Object[])new Object[0]), featureName), MessageBoxOptions.OKCancel, callokListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IPageCache pageCache;
        String featureCode;
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"callokListener", (CharSequence)messageBoxClosedEvent.getCallBackId()) && StringUtils.equals((CharSequence)"Yes", (CharSequence)messageBoxClosedEvent.getResultValue()) && StringUtils.isNotBlank((CharSequence)(featureCode = (pageCache = this.getPageCache()).get("featureCode")))) {
            this.initQualityDetectParam(featureCode);
        }
    }

    private void initQualityDetectParam(String featureCode) {
        DynamicObject[] dynamicObjects;
        String[] featureStr = featureCode.split(",");
        ArrayList<String> paramchoice = new ArrayList<String>(Arrays.asList(featureStr));
        this.generatePieChat();
        if (!SmartQualityCheckPredict.initQualityDetect(paramchoice)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u6a21\u578b\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"SmartQualitySchemeAlgomanagementPlugin_2", (String)systemType, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)featureCode)) {
            featureCode = featureCode.substring(0, featureCode.length() - 1);
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatTime = simpleDateFormat.format(date);
        DynamicObject saveVal = BusinessDataServiceHelper.newDynamicObject((String)"task_modelinitrecord");
        saveVal.set("createtime", (Object)formatTime);
        saveVal.set("featurecode", (Object)featureCode);
        saveVal.set("datatype", (Object)"0");
        QFilter statusQf = new QFilter("status", "=", (Object)"0");
        QFilter datatypeQf = new QFilter("datatype", "=", (Object)"1");
        for (DynamicObject dyn : dynamicObjects = BusinessDataServiceHelper.load((String)"task_modelinitrecord", (String)"id,status", (QFilter[])new QFilter[]{statusQf, datatypeQf})) {
            dyn.set("status", (Object)"1");
        }
        boolean retSucessFlag = true;
        try (TXHandle h = TX.required((String)(((Object)((Object)this)).getClass().getName() + "initQualityDetectParam"));){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveVal});
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
            catch (Exception e) {
                h.markRollback();
                retSucessFlag = false;
                log.error("\u667a\u80fd\u8d28\u68c0:\u521d\u59cb\u5316\u5199\u4e34\u65f6\u8868\u5931\u8d25", (Throwable)e);
            }
        }
        if (retSucessFlag) {
            try {
                SmartQualityCheckPredict.getQualityDetectInformation();
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u4fe1\u606f\u8fed\u4ee3\u8fd0\u7b97\u4fe1\u606f\u5f02\u5e38");
            }
            this.generatePointlineChart();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u6a21\u578b\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"SmartQualitySchemeAlgomanagementPlugin_9", (String)systemType, (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u6a21\u578b\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"SmartQualitySchemeAlgomanagementPlugin_2", (String)systemType, (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            SmartQualityCheckPredict.getQualityDetectInformation();
        }
        catch (Exception ex) {
            log.error("\u667a\u80fd\u8d28\u68c0\uff1a\u83b7\u53d6\u4fe1\u606f\u8fed\u4ee3\u8fd0\u7b97\u4fe1\u606f\u5f02\u5e38");
        }
        this.generatePieChat();
        this.generatePointlineChart();
    }

    private void generatePointlineChart() {
        DynamicObjectCollection queryRecord = QueryServiceHelper.query((String)"task_modelinitrecord", (String)"servicename,usedtimes,accuracy,recall,fscore,traindata,lasttraintime,version", (QFilter[])new QFilter[]{new QFilter("datatype", "=", (Object)"1"), new QFilter("status", "=", (Object)"0")});
        ArrayList<String> xDimensions = new ArrayList<String>(16);
        for (int i = 1; i <= 9; ++i) {
            xDimensions.add(String.valueOf(i));
        }
        xDimensions.add(ResManager.loadKDString((String)"10 (\u6b21\u6570)", (String)"SmartQualitySchemeAlgomanagementPlugin_11", (String)systemType, (Object[])new Object[0]));
        HashMap<String, List<Double>> showMap = new HashMap<String, List<Double>>(16);
        if (!CollectionUtils.isEmpty((Collection)queryRecord)) {
            int i;
            xDimensions.clear();
            int maxPos = queryRecord.size();
            List dynamicObjectList = queryRecord.stream().sorted((s2, s1) -> s1.getInt("version") - s2.getInt("version")).collect(Collectors.toList());
            DynamicObject baseParam = (DynamicObject)dynamicObjectList.get(0);
            ArrayList<Double> eriesDataOfAccuracy = new ArrayList<Double>();
            ArrayList<Double> eriesDataOfRecall = new ArrayList<Double>();
            ArrayList<Double> eriesDataOfFscore = new ArrayList<Double>();
            if (maxPos < 10) {
                for (i = 1; i <= 9; ++i) {
                    xDimensions.add(String.valueOf(i));
                }
                xDimensions.add(ResManager.loadKDString((String)"10 (\u6b21\u6570)", (String)"SmartQualitySchemeAlgomanagementPlugin_11", (String)systemType, (Object[])new Object[0]));
                for (i = maxPos - 1; i >= 0; --i) {
                    eriesDataOfAccuracy.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("accuracy")));
                    eriesDataOfRecall.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("recall")));
                    eriesDataOfFscore.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("fscore")));
                }
            } else {
                for (i = 9; i >= 1; --i) {
                    xDimensions.add(String.valueOf(maxPos - i));
                }
                xDimensions.add(maxPos + " " + ResManager.loadKDString((String)"(\u6b21\u6570)", (String)"SmartQualitySchemeAlgomanagementPlugin_3", (String)systemType, (Object[])new Object[0]));
                for (i = 0; i < 10; ++i) {
                    eriesDataOfAccuracy.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("accuracy")));
                    eriesDataOfRecall.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("recall")));
                    eriesDataOfFscore.add(Double.valueOf(((DynamicObject)dynamicObjectList.get(i)).getString("fscore")));
                }
                Collections.reverse(eriesDataOfAccuracy);
                Collections.reverse(eriesDataOfRecall);
                Collections.reverse(eriesDataOfFscore);
            }
            showMap.put("accuracy", eriesDataOfAccuracy);
            showMap.put("recall", eriesDataOfRecall);
            showMap.put("fscore", eriesDataOfFscore);
            String serviceName = baseParam.getString("servicename");
            String usedTimes = baseParam.getString("usedtimes");
            String trainData = baseParam.getString("traindata");
            String lastTrainTime = baseParam.getString("lasttraintime");
            ((Label)this.getControl("service")).setText(serviceName);
            ((Label)this.getControl("count")).setText(usedTimes);
            ((Label)this.getControl("iteratorcount")).setText(trainData);
            ((Label)this.getControl("time")).setText(lastTrainTime);
        }
        this.updateChartTasks(xDimensions, showMap);
    }

    private void generatePieChat() {
        Chart pieChart = (Chart)this.getControl("piechartap");
        String correlationResult = SmartQualityCheckPredict.correlationUrl();
        log.info("\u667a\u80fd\u8d28\u68c0\uff1a\u76f8\u5173\u6027\u63a5\u53e3\u8fd4\u56de\u6570\u636e " + correlationResult);
        if (correlationResult != null) {
            List resultMap;
            String predictResult;
            JSONObject resultJson = JSONObject.parseObject((String)correlationResult);
            ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(10);
            if (resultJson.get((Object)"err").equals("ok") && StringUtils.isNotBlank((CharSequence)(predictResult = resultJson.getString("result"))) && (resultMap = (List)SerializationUtils.fromJsonString((String)resultJson.getString("result"), List.class)).size() > 0) {
                resultMap.remove(resultMap.size() - 1);
                Collections.sort(resultMap, new Comparator<Map<String, Object>>(){

                    @Override
                    public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                        BigDecimal importance1 = new BigDecimal(o1.get("importance") + "");
                        BigDecimal importance2 = new BigDecimal(o2.get("importance") + "");
                        return importance2.compareTo(importance1);
                    }
                });
                int index = 0;
                for (Map item : resultMap) {
                    BigDecimal value = new BigDecimal(item.get("importance") + "");
                    if (value.compareTo(new BigDecimal(0)) < 0) {
                        value = new BigDecimal(0);
                    }
                    if (index >= colors.length - 1) continue;
                    itemValues.add(new ItemValue(AlgorithmDetailEnum.getName(item.get("feature") + "") + "", (Number)value, colors[index]));
                    ++index;
                }
                if (index < resultMap.size()) {
                    StringBuilder otherName = new StringBuilder();
                    BigDecimal otherValue = new BigDecimal("0");
                    while (index < resultMap.size()) {
                        otherName.append(((Map)resultMap.get(index)).get("feature_name")).append('\uff1a').append(((Map)resultMap.get(index)).get("importance"));
                        otherValue = otherValue.add(new BigDecimal(((Map)resultMap.get(index)).get("importance") + ""));
                        ++index;
                    }
                    if (otherValue.compareTo(new BigDecimal(0)) < 0) {
                        otherValue = new BigDecimal(0);
                    }
                    itemValues.add(new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"SmartQualitySchemeAlgomanagementPlugin_1", (String)systemType, (Object[])new Object[0]), (Number)otherValue, colors[colors.length - 1]));
                }
            }
            this.setPieChat(pieChart, itemValues.toArray(new ItemValue[0]));
        }
        pieChart.refresh();
    }

    private void updateChartTasks(ArrayList<String> xDimensions, Map<String, List<Double>> showMap) {
        PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechartap");
        pointLineChart.clearData();
        Axis xaxis = pointLineChart.createXAxis(ResManager.loadKDString((String)"(\u6b21\u6570)", (String)"SmartQualitySchemeAlgomanagementPlugin_3", (String)systemType, (Object[])new Object[0]), AxisType.category);
        xaxis.setCategorys(xDimensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#666666");
        axisLineMap.put("lineStyle", lineStyleMap);
        xaxis.setPropValue("axisLine", axisLineMap);
        Axis yAxis = pointLineChart.createYAxis(ResManager.loadKDString((String)"(\u5206\u503c)", (String)"SmartQualitySchemeAlgomanagementPlugin_4", (String)systemType, (Object[])new Object[0]), AxisType.value);
        yAxis.setInterval((Number)0.2);
        axisTick = new HashMap();
        yAxis.setPropValue("axisTick", axisTick);
        yAxis.setMax((Number)1);
        lineStyleMap.put("color", "#666666");
        axisLineMap.put("lineStyle", lineStyleMap);
        yAxis.setPropValue("axisLine", axisTick);
        yAxis.setPropValue("axisLine", axisTick);
        HashMap<String, String> nameTextStyleMap = new HashMap<String, String>();
        nameTextStyleMap.put("align", "left");
        yAxis.setPropValue("nameTextStyle", nameTextStyleMap);
        LineSeries personAvgSeries1 = pointLineChart.createLineSeries(ResManager.loadKDString((String)"\u51c6\u786e\u7387", (String)"SmartQualitySchemeAlgomanagementPlugin_5", (String)systemType, (Object[])new Object[0]));
        personAvgSeries1.setSmooth(false);
        List<Double> eriesData1 = showMap.get("accuracy");
        if (!CollectionUtils.isEmpty(eriesData1)) {
            personAvgSeries1.setLineColor("#0080FF");
            personAvgSeries1.setItemColor("#0080FF");
            personAvgSeries1.setData((Number[])eriesData1.toArray(new Double[0]));
        } else {
            personAvgSeries1.setData((Number[])new Double[0]);
        }
        LineSeries personAvgSeries2 = pointLineChart.createLineSeries(ResManager.loadKDString((String)"\u53ec\u56de\u7387", (String)"SmartQualitySchemeAlgomanagementPlugin_6", (String)systemType, (Object[])new Object[0]));
        personAvgSeries2.setSmooth(false);
        List<Double> eriesData2 = showMap.get("recall");
        if (!CollectionUtils.isEmpty(eriesData2)) {
            personAvgSeries2.setData((Number[])eriesData2.toArray(new Double[0]));
            personAvgSeries2.setLineColor("#FFD306");
            personAvgSeries2.setItemColor("#FFD306");
        } else {
            personAvgSeries2.setData((Number[])new Double[0]);
        }
        LineSeries personAvgSeries3 = pointLineChart.createLineSeries(ResManager.loadKDString((String)"F1\u503c", (String)"SmartQualitySchemeAlgomanagementPlugin_7", (String)systemType, (Object[])new Object[0]));
        personAvgSeries3.setSmooth(false);
        List<Double> eriesData3 = showMap.get("fscore");
        if (!CollectionUtils.isEmpty(eriesData3)) {
            personAvgSeries3.setData((Number[])eriesData3.toArray(new Double[0]));
            personAvgSeries3.setLineColor("#00FFFF");
            personAvgSeries3.setItemColor("#00FFFF");
        } else {
            personAvgSeries3.setData((Number[])new Double[0]);
        }
        pointLineChart.setShowTooltip(true);
        pointLineChart.refresh();
    }

    private void setPieChat(Chart pieChart, ItemValue[] data) {
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u7279\u5f81\u5411\u91cf\u6743\u91cd\u4fe1\u606f", (String)"SmartQualitySchemeAlgomanagementPlugin_8", (String)systemType, (Object[])new Object[0]));
        series.setData(data);
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(false);
        series.setLabel(label);
        series.setCenter("25%", "50%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("left", (Object)"56%");
        pieChart.setLegendPropValue("top", (Object)"15%");
        pieChart.refresh();
    }

    public void onProgress(ProgressEvent progressEvent) {
    }
}

