/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.formplugin.DynamicTaskListPlugin;
import kd.ssc.task.formplugin.taskpool.helper.ShareAuthService;
import kd.ssc.task.formplugin.taskpool.helper.TaskPoolKDStringHelper;
import kd.ssc.task.formplugin.taskpool.helper.TaskPoolService;

public class TaskPoolPlugin
extends StandardTreeListPlugin
implements TabSelectListener,
TreeNodeClickListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(TaskPoolPlugin.class);
    private boolean flag = false;

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit ssc = (BasedataEdit)this.getView().getControl("sscid");
        if (ssc != null) {
            ssc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put("sscdytaskpooltabcache", tabKey);
        this.showView(null, tabKey);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        TreeNode root = this.treeListView.getTreeModel().getRoot();
        root.setText(TaskPoolKDStringHelper.all());
        this.flag = true;
        String tab = (String)this.getView().getFormShowParameter().getCustomParam("tab");
        if (StringUtils.isEmpty((CharSequence)tab)) {
            tab = "process";
        }
        this.getPageCache().put("sscdytaskpooltabcache", tab);
        Object sscIdObj = this.getView().getFormShowParameter().getCustomParam("sscid");
        long sscId = sscIdObj == null || "0".equals(String.valueOf(sscIdObj)) ? ShareAuthService.getInstance().getUserHasPerOrgId("task_task", this.getView().getFormShowParameter().getAppId()) : Long.parseLong(String.valueOf(sscIdObj));
        LOG.info("TaskPoolPlugin_sscid={}, sscIdObj={}", (Object)sscId, sscIdObj);
        this.getPageCache().put("sscdytaskpoolsscidcache", String.valueOf(sscId));
        this.getPageCache().put("sscdytaskpoolnodeidcache", "8609760E-EF83-4775-A9FF-CCDEC7C0B689");
    }

    public void beforeBindData(EventObject e) {
        TreeNode root;
        List childNodeList;
        super.beforeBindData(e);
        if (!this.flag) {
            return;
        }
        String sscIdStr = this.getPageCache().get("sscdytaskpoolsscidcache");
        if ("0".equals(sscIdStr)) {
            this.getView().showErrorNotification(TaskPoolKDStringHelper.noShareOrg());
        } else {
            this.getModel().setValue("sscid", (Object)Long.parseLong(sscIdStr));
        }
        String tab = (String)this.getView().getFormShowParameter().getCustomParam("tab");
        if (StringUtils.isNotEmpty((CharSequence)tab)) {
            Tab tabAp = (Tab)this.getView().getControl("tabap");
            tabAp.activeTab(tab);
        }
        if ((childNodeList = (root = this.getTreeModel().getRoot()).getChildren()) == null) {
            if (this.flag) {
                this.flag = false;
                this.showDefaultTableList(null);
            }
            return;
        }
        this.flag = false;
        this.loadTree(childNodeList);
    }

    public void refreshNode(RefreshNodeEvent evt) {
        super.refreshNode(evt);
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && treeView.getTreeModel() instanceof TreeListModel) {
            TreeListModel treeModel = (TreeListModel)treeView.getTreeModel();
            if (this.flag && "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(evt.getNodeId().toString())) {
                TreeNode root = treeModel.getRoot();
                List<TreeNode> childNodeList = this.buildTree(root, null);
                evt.setChildNodes(childNodeList);
            }
        }
    }

    private List<TreeNode> buildTree(TreeNode root, String sscId) {
        if (StringUtils.isEmpty((CharSequence)sscId)) {
            sscId = this.getPageCache().get("sscdytaskpoolsscidcache");
        }
        if (StringUtils.isEmpty((CharSequence)sscId) || "0".equals(sscId)) {
            return new ArrayList<TreeNode>();
        }
        TaskPoolService service = new TaskPoolService(Long.parseLong(sscId));
        List<TreeNode> childNodeList = service.buildTree(root);
        this.setPageCache(service);
        return childNodeList;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"treeview")) {
            String cacheNodeId;
            String nodeId = (String)evt.getNodeId();
            if (nodeId.equals(cacheNodeId = this.getPageCache().get("sscdytaskpoolnodeidcache"))) {
                return;
            }
            this.getPageCache().put("sscdytaskpoolnodeidcache", nodeId);
            if (StringUtils.equals((CharSequence)nodeId, (CharSequence)"8609760E-EF83-4775-A9FF-CCDEC7C0B689")) {
                this.showDefaultTableList(null);
                return;
            }
            String tab = this.getPageCache().get("sscdytaskpooltabcache");
            if ("completed".equals(tab)) {
                Tab tabAp = (Tab)this.getView().getControl("tabap");
                tabAp.activeTab("process");
            } else {
                this.showView(nodeId, null);
            }
        }
    }

    private void showDefaultTableList(String nodeId) {
        LOG.info("TaskPoolPlugin_showDefaultTableList nodeId={}", (Object)nodeId);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            nodeId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
        }
        this.getPageCache().put("sscdytaskpoolnodeidcache", nodeId);
        String sscIdStr = this.getPageCache().get("sscdytaskpoolsscidcache");
        String tabKey = this.getTab(null);
        String pageId = DynamicTaskListPlugin.openBillList((AbstractFormPlugin)this, null, tabKey, Long.parseLong(sscIdStr), nodeId, tabKey, this.getType(nodeId), null, null, null, this.dealCusQFilter());
        this.setListPageId(nodeId, tabKey, pageId);
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        String changeKey = ee.getProperty().getName();
        if (this.getTreeModel() instanceof TreeListModel && "curnodeid".equals(changeKey)) {
            String value = (String)this.getModel().getValue("curnodeid");
            if ("-1".equals(value)) {
                return;
            }
            this.updateTree(value, null);
            this.getModel().setValue("curnodeid", (Object)"-1");
        } else if (this.getTreeModel() instanceof TreeListModel && "sscid".equals(changeKey)) {
            DynamicObject ssc = (DynamicObject)this.getModel().getValue("sscid");
            if (ssc != null) {
                String sscId = ssc.getString("id");
                this.getPageCache().put("sscdytaskpoolsscidcache", sscId);
                TreeNode root = this.getTreeModel().getRoot();
                List<TreeNode> childNodeList = this.buildTree(root, sscId);
                if (childNodeList.isEmpty()) {
                    root.setChildren(null);
                    this.getTreeView().updateNode(root);
                    this.getTreeView().focusNode(root);
                    this.showDefaultTableList(null);
                } else {
                    root.setChildren(childNodeList);
                    this.getTreeView().updateNode(root);
                    this.loadTree(childNodeList);
                }
            }
            this.getPageCache().remove("sscdytaskpoollistpagecache");
        }
    }

    private void loadTree(List<TreeNode> childNodeList) {
        boolean haveQi = false;
        boolean haveShare = false;
        String taskType = (String)this.getView().getFormShowParameter().getCustomParam("tasktype");
        for (TreeNode node : childNodeList) {
            if (!haveShare && "10002".equals(node.getId())) {
                this.getTreeView().focusNode(node);
                haveShare = true;
            }
            if (haveQi || !"10001".equals(node.getId())) continue;
            haveQi = true;
        }
        String nodeId = null;
        nodeId = "1".equals(taskType) ? (haveQi ? "10001" : (haveShare ? "10002" : "8609760E-EF83-4775-A9FF-CCDEC7C0B689")) : ("2".equals(taskType) ? (haveShare ? "10002" : "8609760E-EF83-4775-A9FF-CCDEC7C0B689") : (haveShare && haveQi ? "10002" : (haveShare ? "8609760E-EF83-4775-A9FF-CCDEC7C0B689" : (haveQi ? "10002" : "8609760E-EF83-4775-A9FF-CCDEC7C0B689"))));
        this.showView(nodeId, null);
        this.getPageCache().put("sscdytaskpoolnodeidcache", nodeId);
    }

    public void clientCallBack(ClientCallBackEvent ee) {
        super.clientCallBack(ee);
        String name = ee.getName();
        if (name != null) {
            this.updateTree(ee.getName(), null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refreshtree".equals(operateKey)) {
            String nodeId = operate.getOption().getVariableValue("nodeid", null);
            if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
                this.updateTree(nodeId, null);
            }
            args.setCancel(true);
        }
    }

    private void updateTree(String nodeId, String sscId) {
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        String oldTaskType = this.getPageCache().get("cache_type");
        TreeNode root = this.getTreeModel().getRoot();
        List<TreeNode> childNodeList = this.buildTree(root, sscId);
        if (childNodeList.isEmpty()) {
            root.setChildren(null);
        } else {
            root.setChildren(childNodeList);
        }
        this.getTreeView().updateNode(root);
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId)) {
            this.updateTreeOfRoot(root, nodeId, childNodeList, oldTaskType);
            return;
        }
        TreeNode curNode = this.getCurNode(childNodeList, nodeId);
        if (curNode == null) {
            this.getTreeView().focusNode(root);
            this.showDefaultTableList(null);
        } else {
            this.getTreeView().focusNode(curNode);
        }
    }

    private void updateTreeOfRoot(TreeNode root, String nodeId, List<TreeNode> childNodeList, String oldTaskType) {
        TreeNode shareNode = null;
        TreeNode qiNode = null;
        if (!childNodeList.isEmpty()) {
            for (TreeNode node : childNodeList) {
                if (shareNode == null && "10002".equals(node.getId())) {
                    this.getTreeView().focusNode(node);
                    shareNode = node;
                }
                if (qiNode != null || !"10001".equals(node.getId())) continue;
                qiNode = node;
            }
        }
        String newTaskType = this.getPageCache().get("cache_type");
        if ("1".equals(oldTaskType)) {
            if ("1".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
            } else if ("2".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            } else if ("0".equals(newTaskType)) {
                this.getTreeView().focusNode(qiNode);
            } else {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            }
        } else if ("2".equals(oldTaskType)) {
            if ("1".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            } else if ("2".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
            } else if ("0".equals(newTaskType)) {
                this.getTreeView().focusNode(shareNode);
            } else {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            }
        } else if ("0".equals(oldTaskType)) {
            if ("1".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            } else if ("2".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
                this.showView(nodeId, null);
            } else if ("0".equals(newTaskType)) {
                this.getTreeView().focusNode(root);
            } else {
                this.getTreeView().focusNode(root);
            }
        } else if ("1".equals(newTaskType)) {
            this.getTreeView().focusNode(qiNode);
            this.showView(nodeId, null);
        } else if ("2".equals(newTaskType)) {
            this.getTreeView().focusNode(shareNode);
            this.showView(nodeId, null);
        } else if ("0".equals(newTaskType)) {
            this.getTreeView().focusNode(root);
            this.showView(nodeId, null);
        } else {
            this.getTreeView().focusNode(root);
        }
    }

    private TreeNode getCurNode(List<TreeNode> childrenList, String curNodeId) {
        if (childrenList == null) {
            return null;
        }
        for (TreeNode node : childrenList) {
            List nextChildList;
            TreeNode curNode1;
            String id = node.getId();
            if (id.equals(curNodeId)) {
                return node;
            }
            if (node.isLeaf() || (curNode1 = this.getCurNode(nextChildList = node.getChildren(), curNodeId)) == null) continue;
            return curNode1;
        }
        return null;
    }

    private void setPageCache(TaskPoolService service) {
        Map<String, String> billRefFormIdMap = service.getBillRefFormIdMap();
        String billTypeRefStr = SerializationUtils.toJsonString(billRefFormIdMap);
        this.getPageCache().put("cache_billRefFormId", billTypeRefStr);
        Map<String, Integer> classRefNumMap = service.getClassRefNumMap();
        String classRefNumStr = SerializationUtils.toJsonString(classRefNumMap);
        this.getPageCache().put("cache_processnum", classRefNumStr);
        Map<String, String> entryIdRefTaskIdMap = service.getEntryIdRefTaskIdMap();
        String entryIdRefTaskIdStr = SerializationUtils.toJsonString(entryIdRefTaskIdMap);
        this.getPageCache().put("cache_entryreftaskid", entryIdRefTaskIdStr);
        Map<String, String> entryIdRefFormIdMap = service.getEntryIdRefFormIdMap();
        String entryIdRefFormIdStr = SerializationUtils.toJsonString(entryIdRefFormIdMap);
        this.getPageCache().put("cache_entryIdRefFormId", entryIdRefFormIdStr);
        String type = service.getType();
        this.getPageCache().put("cache_type", type);
    }

    private Map<String, String> getCache(String key) {
        HashMap<String, String> result = new HashMap<String, String>();
        String cache = this.getPageCache().get(key);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            Map billTypeRefMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            result.putAll(billTypeRefMap);
        }
        return result;
    }

    private void showView(String nodeId, String tabKey) {
        String billTypeStr;
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            nodeId = this.getPageCache().get("sscdytaskpoolnodeidcache");
        }
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        Long taskType = null;
        Long billType = null;
        Long billClassId = null;
        Map<String, String> entryIdRefTaskIdMap = this.getCache("cache_entryreftaskid");
        String taskTypeId = entryIdRefTaskIdMap.get(nodeId);
        if (StringUtils.isNotEmpty((CharSequence)taskTypeId)) {
            taskType = Long.parseLong(taskTypeId);
            Map<String, String> entryIdRefFormIdMap = this.getCache("cache_entryIdRefFormId");
            billTypeStr = entryIdRefFormIdMap.get(nodeId);
            if (StringUtils.isNotEmpty((CharSequence)billTypeStr)) {
                billType = Long.parseLong(billTypeStr);
            }
        } else {
            Map<String, String> billRefFormIdMap = this.getCache("cache_billRefFormId");
            if (StringUtils.isNotEmpty((CharSequence)billRefFormIdMap.get(nodeId))) {
                billTypeStr = billRefFormIdMap.get(nodeId);
                if (StringUtils.isNotEmpty((CharSequence)billTypeStr)) {
                    billType = Long.parseLong(billTypeStr);
                }
            } else if (!(StringUtils.equals((CharSequence)"8609760E-EF83-4775-A9FF-CCDEC7C0B689", (CharSequence)nodeId) || StringUtils.equals((CharSequence)"10002", (CharSequence)nodeId) || StringUtils.equals((CharSequence)"10001", (CharSequence)nodeId))) {
                billClassId = Long.parseLong(nodeId);
            }
        }
        tabKey = this.getTab(tabKey);
        String sscIdStr = this.getPageCache().get("sscdytaskpoolsscidcache");
        String pageId = DynamicTaskListPlugin.openBillList((AbstractFormPlugin)this, null, tabKey, Long.parseLong(sscIdStr), nodeId, tabKey, this.getType(nodeId), billClassId, billType, taskType, this.dealCusQFilter());
        this.setListPageId(nodeId, tabKey, pageId);
    }

    private String dealCusQFilter() {
        String qFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("qfilter");
        if (qFilterStr != null) {
            this.getView().getFormShowParameter().setCustomParam("qfilter", null);
            return qFilterStr;
        }
        return null;
    }

    private void setListPageId(String nodeId, String tabKey, String pageId) {
        Map<String, String> cache = this.getCache("sscdytaskpoollistpagecache");
        cache.put(nodeId + tabKey, pageId);
        String cacheStr = SerializationUtils.toJsonString(cache);
        this.getPageCache().put("sscdytaskpoollistpagecache", cacheStr);
    }

    private String getListPageId(String nodeId, String tabKey) {
        Map<String, String> cache = this.getCache("sscdytaskpoollistpagecache");
        return cache.get(nodeId + tabKey);
    }

    private String getTab(String tabKey) {
        if (StringUtils.isEmpty((CharSequence)tabKey)) {
            tabKey = this.getPageCache().get("sscdytaskpooltabcache");
        }
        if (StringUtils.isEmpty((CharSequence)tabKey)) {
            tabKey = "process";
        }
        return tabKey;
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("sscid".equals(key)) {
            Set<Long> userHasPerShareOrg = ShareAuthService.getInstance().getShareOrgIdSet("task_task", this.getView().getFormShowParameter().getAppId());
            QFilter id = new QFilter("id", "in", userHasPerShareOrg);
            beforeF7SelectEvent.addCustomQFilter(id);
        }
    }

    private String getType(String nodeId) {
        String type = "2";
        if ("10001".equals(nodeId)) {
            type = "1";
        } else if ("10002".equals(nodeId)) {
            type = "2";
        } else if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId) && ((type = this.getPageCache().get("cache_type")) == null || "-1".equals(type))) {
            type = "0";
        }
        return type;
    }
}

