/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool.baseclass;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FastSearchGridView;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterGridView;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.events.InitOperateOptionEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.ssc.task.formplugin.taskpool.InteractivePlugin;
import kd.ssc.task.formplugin.taskpool.baseclass.Action;
import kd.ssc.task.formplugin.util.MetadataUtil;
import org.jetbrains.annotations.NotNull;

public abstract class CommonTaskPool
extends AbstractListPlugin {
    protected Action action;
    protected Action primitiveAction;
    protected CommonTaskPool primitivePlugin = this;
    protected long sscId;
    String sscType = "1";
    protected boolean pluginHasChange = false;
    private static final Log log = LogFactory.getLog(CommonTaskPool.class);
    List<Map<String, Object>> listFieldsControlColumns;
    private boolean notReRegister = false;

    public long getSscId() {
        return this.sscId;
    }

    public CommonTaskPool(long sscId, Action action) {
        this.primitiveAction = action;
        this.action = action;
        this.sscId = sscId;
    }

    public void initialize() {
        String sscType;
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String primitiveListPlugin = ((Object)((Object)this)).getClass().getName();
        String primitiveAction = this.getAction().getClass().getName();
        this.getPageCache().put("primitiveListPlugin", primitiveListPlugin);
        String currentPlugin = this.getPageCache().get("currentPlugin");
        String currentAction = this.getPageCache().get("currentAction");
        if (currentPlugin == null) {
            currentPlugin = primitiveListPlugin;
        }
        if (currentAction == null) {
            currentAction = primitiveAction;
        }
        if (!this.notReRegister && !primitiveListPlugin.equals(currentPlugin)) {
            this.reRegister(currentPlugin, currentAction);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(sscType = (String)customParams.get("sscType")))) {
            this.sscType = sscType;
        }
        this.getView().addCustomControls(new String[]{"billlistap"});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if ("billlistap".equals(e.getKey()) && !(e.getControl() instanceof AllTaskBilllist)) {
            BillList billList = (BillList)e.getControl();
            AllTaskBilllist allTaskBilllist = new AllTaskBilllist(billList, this.action);
            e.setControl((Control)allTaskBilllist);
            Container rootControl = (Container)this.getView().getRootControl();
            this.changeBillListParentContainerFromRootControlBilllistap(rootControl, allTaskBilllist);
        }
    }

    private boolean changeBillListParentContainerFromRootControlBilllistap(Container rootControl, BillList billList) {
        List items = rootControl.getItems();
        for (int i = 0; i < items.size(); ++i) {
            boolean hasfind;
            Control item = (Control)items.get(i);
            if (item instanceof BillList) {
                rootControl.getItems().set(i, billList);
                return true;
            }
            if (item instanceof Container && (hasfind = this.changeBillListParentContainerFromRootControlBilllistap((Container)item, billList))) break;
        }
        return false;
    }

    public void initOperateOption(InitOperateOptionEventArgs e) {
        super.initOperateOption(e);
        AbstractOperate source = (AbstractOperate)e.getSource();
        source.setEntityId(this.action.getEntityName());
    }

    protected void billListChangeBillFormId(String billFormId) {
        billFormId = this.getChildEntity(billFormId);
        BillList billlistap = (BillList)this.getControl("billlistap");
        this.getPageCache().put("currentListFormId", billFormId);
        AbstractListView view = (AbstractListView)billlistap.getView();
        view.setBillFormId(billFormId);
        billlistap.changeBillFormId(billFormId);
        this.changeListToolbar(billFormId);
        this.registerPlugin(billFormId);
    }

    protected void registerPlugin(String billFormId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)billFormId);
        List plugins = formConfig.getPlugins();
        for (Plugin plugin : plugins) {
            try {
                Class<?> aClass = Class.forName(plugin.getClassName());
                if (!InteractivePlugin.class.isAssignableFrom(aClass)) continue;
                Constructor<?> constructor = aClass.getConstructor(new Class[0]);
                InteractivePlugin iFormPlugin = (InteractivePlugin)((Object)constructor.newInstance(new Object[0]));
                iFormPlugin.action(this);
            }
            catch (Exception e) {
                log.error(String.format("%s\u7684\u5143\u6570\u636e\u63d2\u4ef6\u6ce8\u518c\u5931\u8d25\uff0c\u63d2\u4ef6\u8bf7\u7ee7\u627f kd.ssc.task.formplugin.taskpool.InteractivePlugin", billFormId), (Throwable)e);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String currentListFormId = this.getPageCache().get("currentListFormId");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentListFormId)) {
            BillList billlistap = (BillList)this.getControl("billlistap");
            billlistap.addListFieldsControlListeners(p -> {
                BillList source = (BillList)p.getSource();
                source.setBillFormId(currentListFormId);
            });
            billlistap.addBeforeBindDataListener(p -> {
                BillList source = (BillList)p.getSource();
                source.setListFieldsControlColumns(this.getListFieldsControlColumns(source));
            });
        }
    }

    protected List<Map<String, Object>> getListFieldsControlColumns(BillList source) {
        if (this.listFieldsControlColumns != null) {
            return this.listFieldsControlColumns;
        }
        String currentListFormId = this.getPageCache().get("currentListFormId");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)currentListFormId)) {
            source.setBillFormId(currentListFormId);
            String setting = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)currentListFormId);
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                this.listFieldsControlColumns = SerializationUtils.fromJsonStringToList((String)setting, Map.class);
            }
            return this.listFieldsControlColumns;
        }
        this.listFieldsControlColumns = new ArrayList<Map<String, Object>>();
        return this.listFieldsControlColumns;
    }

    private void reRegister(@NotNull String currentPlugin, @NotNull String currentAction) {
        try {
            Class<?> aClass = Class.forName(currentPlugin);
            Constructor<?> constructor = aClass.getConstructor(Long.TYPE, Action.class);
            CommonTaskPool iFormPlugin = (CommonTaskPool)((Object)constructor.newInstance(this.getSscId(), this.getAction()));
            Class<?> actionClass = Class.forName(currentAction);
            Constructor<?> actionConstructor = actionClass.getConstructor(new Class[0]);
            Action actions = (Action)actionConstructor.newInstance(new Object[0]);
            iFormPlugin.setAction(actions);
            iFormPlugin.pluginHasChange = true;
            iFormPlugin.notReRegister = true;
            this.changePlugin(iFormPlugin);
        }
        catch (Exception e) {
            throw new KDBizException("fail to change plugin");
        }
    }

    public void setFilter(SetFilterEvent e) {
        this.action.setFilter(e);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public final Map<String, FilterColumn> getFilterContainer(FilterType filterType) {
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        List items = filtercontainerap.getItems();
        List filterColumns = new ArrayList();
        for (Control item : items) {
            if (item instanceof FastSearchGridView && filterType == FilterType.Fast) {
                filterColumns = ((FastSearchGridView)item).getFilterColumns();
                continue;
            }
            if (item instanceof FilterGridView && filterType == FilterType.Common) {
                filterColumns = ((FilterGridView)item).getFilterColumns();
                continue;
            }
            if (!(item instanceof SchemeFilterView) || filterType != FilterType.SCHEME) continue;
            filterColumns = ((SchemeFilterView)item).getFilterColumns();
        }
        return filterColumns.stream().collect(Collectors.toMap(FilterColumn::getFieldName, p -> p));
    }

    protected final void changePlugin(CommonTaskPool pluginto) {
        ListViewPluginProxy listViewPluginProxy = (ListViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        CommonTaskPool plugin = (CommonTaskPool)listViewPluginProxy.getPlugin(((Object)((Object)this)).getClass().getName());
        listViewPluginProxy.removePlugIn((IFormPlugin)plugin);
        pluginto.setView(this.getView());
        this.pluginHasChange = pluginto != this.primitivePlugin;
        pluginto.primitivePlugin = plugin.primitivePlugin;
        listViewPluginProxy.registerPlugin((IFormPlugin)pluginto);
        pluginto.initialize();
        this.getPageCache().put("currentPlugin", ((Object)((Object)pluginto)).getClass().getName());
        this.getPageCache().put("currentAction", pluginto.getAction().getClass().getName());
    }

    protected void changeListToolbar(String billFormId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billFormId)) {
            List<Map<String, Object>> items = this.createToolBar(billFormId);
            Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
            String currentToolbar = this.getPageCache().get("currentToolbar");
            if (currentToolbar != null) {
                List strings = JSONObject.parseArray((String)currentToolbar, String.class);
                toolbarap.deleteControls(strings.toArray(new String[0]));
            }
            if (!items.isEmpty()) {
                toolbarap.addControls(items);
                List key = items.stream().map(p -> (String)p.get("id")).collect(Collectors.toList());
                this.getPageCache().put("currentToolbar", JSONObject.toJSONString(key));
            }
        }
    }

    protected List<Map<String, Object>> createToolBar(String billFormId) {
        Map toolBar = FormMetadataCache.getListToolBar((String)billFormId);
        List items = (List)toolBar.get("items");
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        return items;
    }

    public String getSscType() {
        return this.sscType;
    }

    public CommonTaskPool getPrimitivePlugin() {
        return this.primitivePlugin;
    }

    public void setNotReRegister(boolean notReRegister) {
        this.notReRegister = notReRegister;
    }

    private String getChildEntity(String bill) {
        String changeBill = null;
        if (this.sscType.equals("3")) {
            changeBill = bill + "hr";
        } else if (this.sscType.equals("2")) {
            changeBill = bill + "fi";
        }
        if (changeBill != null && MetadataUtil.existFormMeta(changeBill)) {
            return changeBill;
        }
        return bill;
    }

    public static class AllTaskBilllist
    extends BillList {
        Action action;

        public AllTaskBilllist(BillList billList, Action action) {
            this.action = action;
            this.setView(billList.getView());
            this.setKey(billList.getKey());
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public EntityType getEntityType() {
            EntityType entityType1 = super.getEntityType();
            if (!(entityType1 instanceof QueryEntityType)) {
                return entityType1;
            }
            QueryEntityType entityType = (QueryEntityType)entityType1;
            try {
                entityType = (QueryEntityType)entityType.clone();
                entityType.setEntityName(this.action.getEntityName());
                entityType.setEditEntityAliasName(this.action.getEntityName());
                entityType.setEntityAlias(this.action.getEntityName());
                entityType.setAlias(this.action.getAliasTable());
                entityType.getProperties().clear();
                entityType.endInit();
            }
            catch (CloneNotSupportedException e) {
                log.error("Alltask change entity error, please call administrator");
            }
            return entityType;
        }

        public List<CreateListColumnsListener> getCreateListColumnsListenerListeners() {
            List createListColumnsListenerListeners = super.getCreateListColumnsListenerListeners();
            if (createListColumnsListenerListeners.size() == 1) {
                createListColumnsListenerListeners.add(p -> {
                    Control control;
                    BillList source = (BillList)p.getSource();
                    List items = source.getItems();
                    if (items != null && !items.isEmpty() && (control = (Control)items.get(0)) instanceof ListGridView) {
                        ListGridView listGridView = (ListGridView)control;
                        AllTaskListGridView allTaskListGridView = new AllTaskListGridView(listGridView, this.getView());
                        items.set(0, allTaskListGridView);
                    }
                });
            }
            return createListColumnsListenerListeners;
        }
    }

    public static class AllTaskListGridView
    extends ListGridView {
        public AllTaskListGridView(ListGridView listGridView, IFormView view) {
            this.getItems().addAll(listGridView.getItems());
            this.setVisible(listGridView.getVisible());
            this.setVisibleIntegerVal(listGridView.getVisibleIntegerVal());
            this.setView(view);
            this.setKey(listGridView.getKey());
        }

        public List<Map<String, Object>> createColumns(boolean isHeader) {
            return super.createColumns(false);
        }
    }

    public static enum FilterType {
        Fast,
        Common,
        SCHEME;

    }
}

