/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.container.AdvConBarItemAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.mcontrol.MBarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

public class BillAttributeControlUtil {
    private static final Log log = LogFactory.getLog(BillAttributeControlUtil.class);
    private static final Set<String> ctrlApTypes = new HashSet<String>(2);

    public static Map<String, Map<String, Object>> getNeedShowButtonAps(long billTypeId, long taskTypeId, boolean isQualityTask) {
        String billAttributeConfJson = BillAttributeControlUtil.getBillAttributeConfig(billTypeId, taskTypeId);
        if (StringUtils.isEmpty((String)billAttributeConfJson)) {
            log.info(String.format("\u672a\u914d\u7f6e\u5355\u636e\u4fee\u6539\u6743\u9650 billTypeId=%s, taskTypeId=%s, billAttributeConfJson=%s", billTypeId, taskTypeId, billAttributeConfJson));
            return new LinkedHashMap<String, Map<String, Object>>(8);
        }
        return BillAttributeControlUtil.parseBillShowButtonConfig(billAttributeConfJson, isQualityTask);
    }

    @SdkDeprecated
    public static Map<String, Map<String, Object>> getNeedShowButtonAps(long billTypeId, long taskTypeId) {
        return BillAttributeControlUtil.getNeedShowButtonAps(billTypeId, taskTypeId, false);
    }

    public static String getBillAttributeConfig(long billTypeId, long taskTypeId) {
        QFilter taskTypeIdFilter;
        if (billTypeId <= 0L || taskTypeId <= 0L) {
            return null;
        }
        QFilter billTypeFilter = new QFilter("id", "=", (Object)billTypeId);
        DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"entryentity.childpkid ", (QFilter[])new QFilter[]{billTypeFilter, taskTypeIdFilter = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId)});
        if (taskBill == null) {
            log.info("\u672a\u627e\u5230\u4e1a\u52a1\u5355\u636e\uff0cbillTypeId = {}, taskTypeId = {}", (Object)billTypeId, (Object)taskTypeId);
            return null;
        }
        long childPkId = taskBill.getLong("entryentity.childpkid");
        DynamicObject taskBillChild = QueryServiceHelper.queryOne((String)"task_taskbill_child", (String)"billattriconfigjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)childPkId)});
        return taskBillChild.getString("billattriconfigjson_tag");
    }

    public static Map<String, Map<String, Object>> parseBillShowButtonConfig(String billAttributeConfig, boolean isQualityTask) {
        LinkedHashMap<String, Map<String, Object>> buttonAps = new LinkedHashMap<String, Map<String, Object>>(8);
        List selectedValue = SerializationUtils.fromJsonStringToList((String)billAttributeConfig, Map.class);
        for (Map ctrlApInfo : selectedValue) {
            String ctrlApType = (String)ctrlApInfo.get("ctrlaptype");
            String hideKey = isQualityTask ? "qualitytaskhide" : "hide";
            boolean hide = ctrlApInfo.getOrDefault(hideKey, true);
            if (hide || !ctrlApTypes.contains(ctrlApType)) continue;
            String ctrlApNumber = (String)ctrlApInfo.get("ctrlapnumber");
            if (ctrlApNumber.indexOf(46) >= 0) {
                int pointIndex = ctrlApNumber.lastIndexOf(46);
                ctrlApNumber = ctrlApNumber.substring(pointIndex + 1);
            }
            buttonAps.put(ctrlApNumber, ctrlApInfo);
        }
        return buttonAps;
    }

    public static Map<String, Object> getBtnInfoMap(String entityNumber) {
        LinkedHashMap<String, Object> btnInfoMap = new LinkedHashMap<String, Object>(16);
        String metaDataId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetaData = (FormMetadata)MetadataDao.readRuntimeMeta((String)metaDataId, (MetaCategory)MetaCategory.Form);
        if (formMetaData == null) {
            log.error("\u83b7\u53d6\u8bbe\u8ba1\u65f6\u5143\u6570\u636e\u5f02\u5e38(" + entityNumber + ")");
            return btnInfoMap;
        }
        List items = formMetaData.getItems();
        for (ControlAp ctrlAp : items) {
            Class<?> clazz;
            String ctrlApNumber = null;
            String ctrlApName = null;
            if (ctrlAp.isHidden() || ctrlAp instanceof EntryFieldAp || ctrlAp instanceof CardEntryFieldAp || BillAttributeControlUtil.isHiddenForParentContainer(ctrlAp, formMetaData) || !BarItemAp.class.equals(clazz = ctrlAp.getClass()) && !MBarItemAp.class.equals(clazz) && !AdvConBarItemAp.class.equals(clazz)) continue;
            HashMap<String, String> info = new HashMap<String, String>(3);
            ControlAp toolBar = formMetaData.getItem(ctrlAp.getParentId());
            ctrlApNumber = toolBar.getKey() + "." + ctrlAp.getKey();
            ctrlApName = toolBar.getName().getLocaleValue() + "." + ctrlAp.getName().getLocaleValue();
            ButtonAp btn = (ButtonAp)ctrlAp;
            List dropdownItems = btn.getDropdownItems();
            if (dropdownItems != null && dropdownItems.size() > 0) {
                BillAttributeControlUtil.parseDropdownItems(clazz, toolBar, dropdownItems, btnInfoMap);
            }
            info.put("ctrlapname", ctrlApName);
            info.put("opkey", btn.getOperationKey());
            info.put("ctrlaptype", clazz.getSimpleName());
            btnInfoMap.put(ctrlApNumber, info);
            if (BarItemAp.class.equals(clazz)) continue;
            info = new HashMap(3);
            info.put("ctrlapname", toolBar.getName().getLocaleValue());
            info.put("ctrlaptype", toolBar.getClass().getSimpleName());
            btnInfoMap.put(toolBar.getKey(), info);
        }
        return btnInfoMap;
    }

    private static void parseDropdownItems(Class<?> clazz, ControlAp<?> toolBar, List<DropdownItem> dropdownItems, Map<String, Object> btnInfoMap) {
        for (DropdownItem item : dropdownItems) {
            HashMap<String, String> info = new HashMap<String, String>(3);
            String ctrlApNumber = toolBar.getKey() + "." + item.getKey();
            String ctrlApName = toolBar.getName().getLocaleValue() + "." + item.getTitle().getLocaleValue();
            info.put("ctrlapname", ctrlApName);
            info.put("opkey", item.getOperationKey());
            info.put("ctrlaptype", clazz.getSimpleName());
            btnInfoMap.put(ctrlApNumber, info);
        }
    }

    private static boolean isHiddenForParentContainer(ControlAp controlAp, FormMetadata formMetadata) {
        if (controlAp == null) {
            return false;
        }
        if (controlAp.isHidden()) {
            return true;
        }
        return BillAttributeControlUtil.isHiddenForParentContainer(formMetadata.getItem(controlAp.getParentId()), formMetadata);
    }

    static {
        ctrlApTypes.add("BarItemAp");
        ctrlApTypes.add("MBarItemAp");
    }
}

