/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SscWorkCalendarUtil {
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        ArrayList<Date> Datelist = new ArrayList<Date>(10);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            Datelist.add(calBegin.getTime());
        }
        Datelist.add(dBegin);
        return Datelist;
    }

    public static List<String> findDates(String dBegin, String dEnd) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(format.parse(dBegin));
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(format.parse(dEnd));
        ArrayList<String> Datelist = new ArrayList<String>(10);
        while (format.parse(dEnd).after(calBegin.getTime())) {
            calBegin.add(5, 1);
            Datelist.add(format.format(calBegin.getTime()));
        }
        return Datelist;
    }

    public int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static boolean compareHourAndMinute(int hourFrom, int minuteFrom, int hourTo, int minuteTo) {
        boolean flag = false;
        if (hourFrom < hourTo) {
            flag = true;
        } else if (hourFrom == hourTo && minuteFrom < minuteTo) {
            flag = true;
        }
        return flag;
    }

    public static int daysBetween(Calendar smallDate, Calendar bigDate) {
        long time1 = smallDate.getTimeInMillis();
        long time2 = bigDate.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days)) + 1;
    }

    public static boolean isSameDate(Calendar date1, Calendar date2) {
        return date1 != null && date2 != null ? date1.get(1) == date2.get(1) && date1.get(2) == date2.get(2) && date1.get(5) == date2.get(5) : false;
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(5, cal.getActualMaximum(5));
        return new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD).format(cal.getTime());
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, cal.getMinimum(5));
        return new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD).format(cal.getTime());
    }

    public static boolean isBetween(Calendar fromDate, Calendar toDate, Calendar nowCal) {
        boolean result = false;
        if (fromDate != null && toDate != null && nowCal != null) {
            if (SscWorkCalendarUtil.isSameDate(fromDate, nowCal) || SscWorkCalendarUtil.isSameDate(toDate, nowCal)) {
                result = true;
            } else if (fromDate.before(nowCal) && toDate.after(nowCal)) {
                result = true;
            }
        }
        return result;
    }

    public static String changeTime(int hour, int minute) {
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        Calendar c = Calendar.getInstance();
        c.set(11, hour);
        c.set(12, minute);
        return SDFTIME.format(c.getTime());
    }

    public static int getTimeShow(String time) {
        String[] aa = time.split(":");
        int b = Integer.parseInt(aa[0]) * 60 * 60 + Integer.parseInt(aa[1]) * 60;
        return b;
    }

    public static String getTimeShow(int time) {
        int hour = time / 3600;
        int min = (time - hour * 3600) / 60;
        StringBuilder timeSBuilder = new StringBuilder();
        if (hour < 10) {
            timeSBuilder.append('0');
        }
        timeSBuilder.append(hour).append(':');
        if (min < 10) {
            timeSBuilder.append('0');
        }
        timeSBuilder.append(min);
        return timeSBuilder.toString();
    }

    public static boolean compareDate(Calendar d1, Calendar d2) {
        int result = d1.compareTo(d2);
        return result >= 0;
    }
}

