/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.Voucher.algo.BillStatusAggFunction;
import kd.ssc.Voucher.algo.JoinIdAggFunction;
import kd.ssc.task.formplugin.util.MetadataUtil;

public class TaskAdministrateVoucherListPlugin
extends AbstractListPlugin {
    private static final String LISTNUM = "voucherno";
    private static final String LISTSTA = "voucherstat";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        boolean aiTracker = MetadataUtil.existEntity("ai_daptracker");
        boolean glVoucher = MetadataUtil.existEntity("gl_voucher");
        if (aiTracker && glVoucher) {
            args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        }
    }

    private void setVoucherFields(String entityName, DynamicObjectCollection rows, List<Long> ids) {
        if (rows.isEmpty()) {
            return;
        }
        if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)LISTNUM) && !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)LISTSTA)) {
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(LISTNUM, String.class, null));
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(LISTSTA, String.class, null));
        }
        HashMap<Long, String> taskIdBillIdMap = new HashMap<Long, String>(ids.size());
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(ids.size());
        String algoKey = this.getPluginName() + ".setVoucherFields()";
        QFilter idsFilter = new QFilter("id", "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,billid,billtype.bindbill.number billtypenumber", (QFilter[])new QFilter[]{idsFilter}, null);
             DataSet copyDataSet = dataSet.copy();
             DataSet groupBillTypeDataSet = copyDataSet.select("billid,billtypenumber").groupBy(new String[]{"billtypenumber"}).agg((CustomAggFunction)new JoinIdAggFunction(), "billid", "joinids").finish();){
            if (!dataSet.hasNext()) {
                return;
            }
            for (Row r : dataSet) {
                taskIdBillIdMap.put(r.getLong("id"), r.getString("billid"));
            }
            for (Row item : groupBillTypeDataSet) {
                String bilTypeNum = item.getString("billtypenumber");
                String joinIds = item.getString("joinids");
                this.queryVoucherInfo(bilTypeNum, joinIds, resultMap);
            }
        }
        for (DynamicObject row : rows) {
            Long taskId = Long.valueOf(row.getPkValue().toString());
            if (resultMap.get(taskIdBillIdMap.get(taskId)) == null) continue;
            String billnos = (String)((Map)resultMap.get(taskIdBillIdMap.get(taskId))).get("billnos");
            String status = (String)((Map)resultMap.get(taskIdBillIdMap.get(taskId))).get("status");
            row.set(LISTNUM, (Object)billnos);
            row.set(LISTSTA, (Object)status);
        }
    }

    private void queryVoucherInfo(String billTypeNum, String joinBillIds, Map<String, Map<String, String>> resultMap) {
        if (StringUtils.isEmpty((String)joinBillIds)) {
            return;
        }
        Set billIds = Arrays.stream(joinBillIds.split(",")).map(Long::valueOf).collect(Collectors.toSet());
        Map billVoucherIds = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getVoucherInfofromBill", (Object[])new Object[]{billTypeNum, billIds});
        ArrayList voucherIds = new ArrayList(billIds.size());
        billVoucherIds.values().forEach(voucherIds::addAll);
        String algoKey = ((Object)((Object)this)).getClass() + ".queryVoucherInfo()_0";
        try (DataSet billVoucherDs = this.createBillVoucherIdDataSet(billVoucherIds);
             DataSet voucherDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_voucher", (String)"id, billno, billstatus", (QFilter[])new QFilter("id", "in", voucherIds).toArray(), null);
             DataSet joinDs = billVoucherDs.fullJoin(voucherDs).on("voucherid", "id").select(new String[]{"billid", "billno", "billstatus"}).finish();
             DataSet resultDs = joinDs.groupBy(new String[]{"billid"}).groupConcat("billno", "billnos", ";").agg((CustomAggFunction)new BillStatusAggFunction(';'), "billstatus", "status").finish();){
            for (Row row : resultDs) {
                HashMap<String, String> reMap = new HashMap<String, String>(2);
                reMap.put("billnos", row.getString("billnos"));
                reMap.put("status", row.getString("status"));
                resultMap.put(row.getString("billid"), reMap);
            }
        }
    }

    private DataSet createBillVoucherIdDataSet(Map<Long, Set<Long>> billVoucherIds) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("billid", (DataType)DataType.LongType), new Field("voucherid", (DataType)DataType.LongType)});
        DataSetBuilder dsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Set<Long>> entry : billVoucherIds.entrySet()) {
            for (Long voucherId : entry.getValue()) {
                dsBuilder.append(new Object[]{entry.getKey(), voucherId});
            }
        }
        return dsBuilder.build();
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            EntityType entityType = this.getEntityType();
            String entityName = entityType.getName();
            if (entityType instanceof QueryEntityType) {
                entityName = ((QueryEntityType)entityType).getEntityName();
            }
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            ArrayList ids = new ArrayList();
            rows.forEach(v -> ids.add(Long.valueOf(v.getPkValue().toString())));
            if (ids.size() > 0) {
                TaskAdministrateVoucherListPlugin.this.setVoucherFields(entityName, rows, ids);
            }
            return rows;
        }
    }
}

