/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.workbill.isc.WorkBillIscDefineHelper;

public class ISCDefineFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_OPENISC = "openISC";
    private static final String OP_OPENISCPLAN = "openiscplan";
    private static final String OP_GENISCOBJECT = "geniscobject";
    private static final String OP_EDITOBJECT = "editobject";
    private static final String OP_VIEWISCPLAN = "viewiscplan";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String CALLBACKID_CONFIRM_CREATE = "confirmCreate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit targetGroup = (BasedataEdit)this.getControl("target_datas");
        targetGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String opKey = afterDoOperationEventArgs.getOperateKey();
            Long sourceId = (Long)this.getModel().getValue("sourceid");
            if (OP_OPENISC.equalsIgnoreCase(opKey)) {
                view.openUrl(UrlService.getDomainContextUrl() + "/index.html?appNumber=iscb&formId=pc_main_console");
            } else if (OP_GENISCOBJECT.equals(opKey)) {
                this.openObjectEditView(sourceId);
            } else if (OP_EDITOBJECT.equals(opKey)) {
                if (0L == sourceId) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u4e0d\u5b58\u5728\u6e90\u5bf9\u8c61\u3002", (String)"ISCDefineFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openObjectEditView(sourceId);
            } else if (OP_OPENISCPLAN.equalsIgnoreCase(opKey)) {
                this.clickCreateIscPlan(model);
            } else if (OP_VIEWISCPLAN.equals(opKey)) {
                this.clickViewIscPlan(model);
            }
        }
    }

    private void openObjectEditView(Long sourceId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setBillStatus(BillOperationStatus.AUDIT);
        parameter.setHasRight(true);
        parameter.setPkId((Object)sourceId);
        parameter.setFormId(ISC_METADATA_SCHEMA);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void clickCreateIscPlan(IDataModel model) {
        Long targetid = (Long)model.getValue("targetid");
        Long sourceid = (Long)model.getValue("sourceid");
        if (targetid == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u76ee\u6807\u5bf9\u8c61\u3002", (String)"ISCDefineFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean existIscDataCopy = WorkBillIscDefineHelper.existIscDataCopy((Long)targetid, (Long)sourceid);
        if (existIscDataCopy) {
            String confirmMsg = ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u521b\u5efa\uff1f", (String)"ISCDefineFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_CONFIRM_CREATE, (IFormPlugin)this));
        } else {
            this.createIscPlan();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (!CALLBACKID_CONFIRM_CREATE.equals(event.getCallBackId())) {
            return;
        }
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        this.createIscPlan();
    }

    private void createIscPlan() {
        IDataModel model = this.getModel();
        Object targetid = model.getValue("targetid");
        Object sourceid = model.getValue("sourceid");
        BillShowParameter parameter = new BillShowParameter();
        if (0L != (Long)sourceid) {
            Long id = WorkBillIscDefineHelper.newIscDataCopy((Long)Long.parseLong(targetid.toString()), (Long)Long.parseLong(sourceid.toString()));
            parameter.setPkId((Object)id);
        }
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setBillStatus(BillOperationStatus.ADDNEW);
        parameter.setHasRight(true);
        parameter.setFormId(ISC_DATA_COPY);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void clickViewIscPlan(IDataModel model) {
        Long targetid = (Long)model.getValue("targetid");
        if (targetid == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u76ee\u6807\u5bf9\u8c61\u3002", (String)"ISCDefineFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        List iscDataCopyIds = WorkBillIscDefineHelper.queryIscDataCopy((Long)targetid);
        if (CollectionUtils.isEmpty((Collection)iscDataCopyIds)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5bf9\u8c61\u4e0d\u5b58\u5728\u6570\u636e\u96c6\u6210\u65b9\u6848\uff0c\u8bf7\u5148\u53bb\u751f\u6210\u6570\u636e\u96c6\u6210\u65b9\u6848\u3002", (String)"ISCDefineFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if (iscDataCopyIds.size() == 1) {
            this.openIscDataCopyFormView(iscDataCopyIds);
        } else {
            this.openIscDataCopyListView(iscDataCopyIds);
        }
    }

    private void openIscDataCopyFormView(List<Long> iscDataCopyIds) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setHasRight(true);
        parameter.setPkId((Object)iscDataCopyIds.get(0));
        parameter.setFormId(ISC_DATA_COPY);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openIscDataCopyListView(List<Long> iscDataCopyIds) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("isc_integration_schema");
        listShowParameter.setBillFormId(ISC_DATA_COPY);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", iscDataCopyIds));
        listShowParameter.setListFilterParameter(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        List listFilters = showParam.getListFilterParameter().getQFilters();
        if ("target_datas".equals(propName)) {
            QFilter listFilter = new QFilter("connection_type", "=", (Object)"self");
            listFilters.add(listFilter);
        }
    }
}

