/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.util.SscLicenseUtil;

public class WokBillTreeListPlugin
extends AbstractTreeListPlugin {
    private static final String OP_NEW = "new";
    private static final String TREE_ROOT = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)((ListShowParameter)e.getFormShowParameter()).getBillFormId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnnew"});
        this.addClickListeners(new String[]{"btndel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if (OP_NEW.equalsIgnoreCase(keyName) && !args.isCancel()) {
            this.beforeNewValidate(args);
        } else if ("wflabel".equals(keyName) || "isclabel".equals(keyName)) {
            this.showEditBill(keyName, operateInfo.getListFocusRow().getPrimaryKeyValue());
        }
    }

    private void beforeNewValidate(BeforeDoOperationEventArgs args) {
        List serClassifyId;
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        if (treeview != null && !(serClassifyId = treeview.getTreeState().getSelectedNodes()).isEmpty()) {
            Map serClassifyMap = (Map)serClassifyId.get(0);
            String nodeId = (String)serClassifyMap.get("id");
            if (TREE_ROOT.equals(nodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u5de5\u5355\u65f6\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"WorkBillTreeListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object isParent = serClassifyMap.get("isParent");
            if (isParent != null && ((Boolean)isParent).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672b\u7ea7\u5206\u7c7b\u53ef\u4ee5\u6dfb\u52a0\u5171\u4eab\u5de5\u5355\u3002", (String)"WorkBillTreeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        List workBillClassifyId;
        super.beforeClick(evt);
        String key = ((Vector)evt.getSource()).getKey();
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        if (treeview != null && !(workBillClassifyId = treeview.getTreeState().getSelectedNodes()).isEmpty()) {
            Map workBillClassifyMap = (Map)workBillClassifyId.get(0);
            String nodeId = (String)workBillClassifyMap.get("id");
            if ("btnnew".equalsIgnoreCase(key)) {
                Long id;
                boolean beenRef;
                if (!TREE_ROOT.equals(nodeId) && (beenRef = QueryServiceHelper.exists((String)"ssc_billmanger", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)(id = Long.valueOf(Long.parseLong(nodeId))))}))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\u5171\u4eab\u5de5\u5355\u7684\u5206\u7c7b\u4e0b\uff0c\u4e0d\u53ef\u4ee5\u65b0\u589e\u5b50\u8282\u70b9\u3002", (String)"WorkBillTreeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            } else if ("btndel".equalsIgnoreCase(key) && !TREE_ROOT.equals(nodeId)) {
                QFilter isLeafFilter = new QFilter("isLeaf", "=", (Object)"1");
                Long id = Long.parseLong(nodeId);
                QFilter idFilter = new QFilter("id", "=", (Object)id);
                boolean isLeaf = QueryServiceHelper.exists((String)"ssc_billmangerclassify", (QFilter[])new QFilter[]{isLeafFilter, idFilter});
                if (!isLeaf) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5b58\u5728\u4e0b\u7ea7\u5206\u7c7b\u7684\u5171\u4eab\u5de5\u5355\u5206\u7c7b\u3002", (String)"WorkBillTreeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                } else {
                    boolean hasWorkBill = QueryServiceHelper.exists((String)"ssc_billmanger", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)id)});
                    if (hasWorkBill) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u5b58\u5728\u5171\u4eab\u5de5\u5355\u7684\u5206\u7c7b\u3002", (String)"WorkBillTreeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        evt.setCancel(true);
                    }
                }
            }
        }
    }

    private void showEditBill(String opKey, Object pkId) {
        String tabKey = "wflabel".equals(opKey) ? "tabpageap1" : ("isclabel".equals(opKey) ? "tabpageap2" : null);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("ssc_billmanger");
        billShowParameter.setPkId(pkId);
        billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        OpenStyle openStyle = billShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        billShowParameter.setOpenStyle(openStyle);
        billShowParameter.setCustomParam("selectTab", (Object)tabKey);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

