/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import kd.ssc.task.business.workbill.builder.WorkBillTemplateTrans;
import kd.ssc.task.business.workbill.excel.WorkBillExcelFieldTypeEnum;
import kd.ssc.task.business.workbill.excel.WorkBillExcelInfo;
import kd.ssc.task.business.workbill.excel.WorkBillImportExcelHelper;
import kd.ssc.task.business.workbill.excel.WorkBillVisibleOrMustEnum;
import kd.ssc.task.business.workbill.fieldcfg.TextAreaFieldCfg;
import kd.ssc.task.business.workbill.fieldcfg.TextFieldCfg;
import kd.ssc.workbill.field.AbstractFieldPropService;
import kd.ssc.workbill.field.FieldPropServiceFactory;
import kd.ssc.workbill.util.DataModelChangeUtil;

public class WorkBillDefineFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final String WF_TAB_LOADED = "wfTabLoaded";
    private static final String KEY_FIELDPROPERTY = "fieldproperty";
    private static final String KEY_SUBENTRY = "subentryentity";
    private static final String KEY_ENTRY = "entryentity";
    private static final String PRESET_PANEL_TYPE = "0";
    private static final String EDIT_PANEL_INDEX_KEY = "editPanelKey";
    private static final String WORK_BILL_GROUP = "group";
    private static final String OP_SUBENTRYDELETE = "deleteentry2";
    private static final String CACHEKEY_SUBENTRY = "cacheremovesubentry";
    private static final String DEL_PANEL_KEY = "delPanel";
    private static final String HAS_BIZ_DATA_KEY = "hasBizData";
    private static final String FIRST_DEL_FIELD = "firstDelField";
    private static final String IS_PREVIEW = "isPreview";
    private static Log log = LogFactory.getLog(WorkBillDefineFormPlugin.class);
    private static final String OP_IMPORT_FIELD = "importfield";
    private static final String KEY_IMPORT_DIALOG = "ssc_workbill_import";
    private static final String CALLBACK_KEY_IMPORT = "importField";
    private static final String CACHE_PANEL_INDEX = "panelIndex";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addicon"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
        TextEdit textEdit = (TextEdit)this.getView().getControl(KEY_FIELDPROPERTY);
        textEdit.addButtonClickListener((ClickListener)this);
        BasedataEdit bizBill = (BasedataEdit)this.getControl(WORK_BILL_GROUP);
        bizBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        bizBill.addBeforeF7ViewDetailListener(e1 -> {
            BasedataEdit group = (BasedataEdit)e1.getSource();
            FormShowParameter formShowParameter = group.getView().getFormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        });
        bizBill.addBeforeQuickAddNewListener(e2 -> {
            BasedataEdit group = (BasedataEdit)e2.getSource();
            FormShowParameter formShowParameter = group.getView().getFormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("addicon".equals(key)) {
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("ssc_workbillpanel");
            OpenStyle openStyle = formParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formParameter.setOpenStyle(openStyle);
            this.setNumberSet(formParameter);
            formParameter.setCustomParam("developerLogo", (Object)WorkBillCommonHelper.getIsvPrefix());
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newPanelEntry"));
            this.getView().showForm(formParameter);
        } else if (KEY_FIELDPROPERTY.equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_SUBENTRY);
            DynamicObject rowData = this.getModel().getEntryRowEntity(KEY_SUBENTRY, index);
            String fieldType = rowData.getString("fieldtype");
            AbstractFieldPropService service = FieldPropServiceFactory.getService((String)fieldType);
            if (service != null) {
                service.showFieldPropChooseView(this.getView(), this.getModel(), this.getPluginName());
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.getCurrentTab();
        if ("tabpageap".equals(tabKey)) {
            this.setISCFieldCon(false);
        } else if ("tabpageap1".equals(tabKey)) {
            String number = (String)this.getModel().getValue("number");
            if (!MetadataDao.checkNumber((String)number)) {
                tabAp.activeTab("tabpageap");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u5de5\u5355\u672a\u751f\u6210\u5143\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"WorkBillDefineFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.getPageCache().getAll().containsKey(WF_TAB_LOADED)) {
                IFormView view = tabAp.getView();
                ListShowParameter listParameter = new ListShowParameter();
                listParameter.setFormId("wf_modeltreelist");
                listParameter.setBillFormId("wf_model");
                OpenStyle openStyle = listParameter.getOpenStyle();
                openStyle.setShowType(ShowType.InContainer);
                openStyle.setTargetKey("tabpageap1");
                listParameter.setOpenStyle(openStyle);
                listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "WFListView"));
                view.showForm((FormShowParameter)listParameter);
                this.getPageCache().put(WF_TAB_LOADED, "1");
            }
            this.checkWorkBillDefineChange();
        } else if ("tabpageap2".equals(tabKey)) {
            String number = (String)this.getModel().getValue("number");
            if (!MetadataDao.checkNumber((String)number)) {
                tabAp.activeTab("tabpageap");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u5de5\u5355\u672a\u751f\u6210\u5143\u6570\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"WorkBillDefineFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setISCFieldCon(true);
            this.checkWorkBillDefineChange();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object retData = e.getReturnData();
        int index = 0;
        if ("newPanelEntry".equalsIgnoreCase(actionId)) {
            if (retData == null) {
                return;
            }
            index = this.getModel().createNewEntryRow(KEY_ENTRY);
            this.setPanelEntry(index, (DynamicObject)retData);
        } else if ("editPanelEntry".equalsIgnoreCase(actionId)) {
            if (retData == null) {
                return;
            }
            index = Integer.parseInt(this.getPageCache().get(EDIT_PANEL_INDEX_KEY));
            this.setPanelEntry(index, (DynamicObject)retData);
        } else if ("WFListView".equalsIgnoreCase(actionId)) {
            this.getView().invokeOperation("close");
        } else if (CALLBACK_KEY_IMPORT.equalsIgnoreCase(actionId)) {
            if (retData == null) {
                return;
            }
            this.importField((Map)retData);
        } else {
            AbstractFieldPropService service = FieldPropServiceFactory.getServiceByCBKey((String)e.getActionId());
            if (service != null) {
                int cuParentIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
                int cuSubIndex = this.getModel().getEntryCurrentRowIndex(KEY_SUBENTRY);
                if (retData != null) {
                    this.getModel().setValue(KEY_FIELDPROPERTY, (Object)service.getFieldProperty(retData), cuSubIndex, cuParentIndex);
                    this.getModel().setValue("fieldpropertyjson_tag", (Object)service.getFieldPropertyJSON(retData), cuSubIndex, cuParentIndex);
                }
            }
        }
    }

    private void importField(Map<String, List<WorkBillExcelInfo>> retData) {
        if (CollectionUtils.isEmpty(retData)) {
            return;
        }
        String jsonStr = this.getPageCache().get(CACHE_PANEL_INDEX);
        Map panelIndexMap = (Map)JSONObject.parseObject((String)jsonStr, Map.class);
        for (Map.Entry<String, List<WorkBillExcelInfo>> entry : retData.entrySet()) {
            String panelNum = entry.getKey();
            List<WorkBillExcelInfo> workBillFieldInfos = entry.getValue();
            Integer index = (Integer)panelIndexMap.get(panelNum);
            if (index != null) {
                this.importSubEntryEntity(index, workBillFieldInfos);
                continue;
            }
            int newIndex = this.getModel().createNewEntryRow(KEY_ENTRY);
            this.importPanelEntry(newIndex, workBillFieldInfos);
            this.importSubEntryEntity(newIndex, workBillFieldInfos);
        }
    }

    private void importSubEntryEntity(int parentRow, List<WorkBillExcelInfo> workBillFieldInfos) {
        CardEntry panelList = (CardEntry)this.getControl(KEY_ENTRY);
        panelList.clearEntryState();
        panelList.selectRows(parentRow);
        IDataModel entryOperate = this.getModel();
        for (WorkBillExcelInfo field : workBillFieldInfos) {
            int subRow = entryOperate.createNewEntryRow(KEY_SUBENTRY);
            this.getModel().setValue("fieldnumber", (Object)field.getFieldNumber(), subRow, parentRow);
            this.getModel().setValue("fieldname", (Object)field.getFieldName(), subRow, parentRow);
            this.getModel().setValue("fieldtype", (Object)field.getFieldType(), subRow, parentRow);
            this.getModel().setValue("isvisible", (Object)WorkBillVisibleOrMustEnum.YES.getName().equals(field.getIsVisible()), subRow, parentRow);
            this.getModel().setValue("ismust", (Object)WorkBillVisibleOrMustEnum.YES.getName().equals(field.getIsMust()), subRow, parentRow);
            this.getModel().setValue("ispreset", (Object)Boolean.FALSE, subRow, parentRow);
            String fieldProperty = field.getFieldProperty();
            boolean existComboFieldProp = WorkBillExcelFieldTypeEnum.COMBO.getNumber().equals(field.getFieldType()) && StringUtils.isNotEmpty((CharSequence)fieldProperty);
            if (!existComboFieldProp) continue;
            this.getModel().setValue(KEY_FIELDPROPERTY, (Object)WorkBillImportExcelHelper.splitComboCaption((String)fieldProperty), subRow, parentRow);
            this.getModel().setValue("fieldpropertyjson_tag", (Object)WorkBillImportExcelHelper.splitComboToJson((String)fieldProperty), subRow, parentRow);
        }
    }

    private void importPanelEntry(int index, List<WorkBillExcelInfo> fieldInfos) {
        WorkBillExcelInfo workBillFieldInfo = fieldInfos.get(0);
        this.getModel().setValue("pname", (Object)workBillFieldInfo.getPanelName(), index);
        String panelType = workBillFieldInfo.getPanelType();
        this.getModel().setValue("ptype", (Object)panelType, index);
        this.getModel().setValue("pnumber", (Object)workBillFieldInfo.getPanelNumber(), index);
        this.getModel().setValue("pisvisible", (Object)Boolean.TRUE, index);
        this.getModel().setValue("pispreset", (Object)Boolean.FALSE, index);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        if ("fieldnumber".equals(propName)) {
            String newNumber = (String)propValue;
            String oldNumber = (String)oldValue;
            Object fieldTypeObj = model.getValue("fieldtype", rowIndex, parentRowIndex);
            if (newNumber.isEmpty()) {
                if (fieldTypeObj == null || fieldTypeObj.toString().isEmpty()) {
                    return;
                }
                if ("Currency".equals(fieldTypeObj.toString()) && this.currencyChangeNumber(newNumber, oldNumber)) {
                    this.updateSubEntryView();
                }
            } else {
                String amendedFieldNum = this.amendFieldNum(rowIndex, parentRowIndex, newNumber);
                if (!newNumber.equals(amendedFieldNum)) {
                    model.setValue("fieldnumber", (Object)amendedFieldNum, rowIndex, parentRowIndex);
                    return;
                }
                if (fieldTypeObj != null && "Currency".equals(fieldTypeObj.toString())) {
                    this.currencyChangeNumber(newNumber, oldNumber);
                }
            }
        } else if ("number".equals(propName)) {
            boolean repeat = this.checkModelAllNumberRepeat();
            if (repeat) {
                model.setValue("number", (Object)"");
                return;
            }
            String newNumber = (String)propValue;
            String amendedNumber = this.amendNumber(newNumber);
            if (StringUtils.isNotBlank((CharSequence)newNumber) && !newNumber.equals(amendedNumber)) {
                model.setValue("number", (Object)amendedNumber);
            }
        } else if ("fieldname".equals(propName)) {
            LocaleDynamicObjectCollection newNameObj = (LocaleDynamicObjectCollection)propValue;
            LocaleDynamicObjectCollection oldNameObj = (LocaleDynamicObjectCollection)oldValue;
            String newName = this.getLocalString(newNameObj);
            String oldName = this.getLocalString(oldNameObj);
            Object fieldTypeObj = model.getValue("fieldtype", rowIndex, parentRowIndex);
            Object fieldNumObj = model.getValue("fieldnumber", rowIndex, parentRowIndex);
            if (fieldTypeObj != null && fieldNumObj != null && "Currency".equals(fieldTypeObj.toString()) && this.currencyChangeName(newName, oldName, fieldNumObj.toString())) {
                this.updateSubEntryView();
            }
        } else if ("fieldtype".equals(propName)) {
            String fieldtype;
            String fieldNumber;
            model.setValue("fieldpropertyjson_tag", (Object)"", rowIndex, parentRowIndex);
            model.setValue(KEY_FIELDPROPERTY, (Object)"", rowIndex, parentRowIndex);
            if (oldValue != null && "Currency".equals(oldValue.toString()) && this.currencyChangeNumber(null, fieldNumber = (String)model.getValue("fieldnumber", rowIndex, parentRowIndex))) {
                this.updateSubEntryView();
            }
            if ((fieldtype = String.valueOf(propValue)).startsWith("Text")) {
                TextFieldCfg textFieldCfg = fieldtype.equals("Text") ? new TextFieldCfg() : new TextAreaFieldCfg();
                model.setValue("fieldpropertyjson_tag", (Object)JSON.toJSONString((Object)textFieldCfg), rowIndex, parentRowIndex);
                model.setValue(KEY_FIELDPROPERTY, (Object)String.format(ResManager.loadKDString((String)"\u957f\u5ea6\uff1a%s", (String)"WorkBillDefineFormPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), textFieldCfg.getMaxLength()), rowIndex, parentRowIndex);
            }
        } else if (KEY_FIELDPROPERTY.equals(propName) && (propValue == null || propValue.toString().isEmpty())) {
            model.setValue("fieldpropertyjson_tag", (Object)"", rowIndex, parentRowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List templateField = WorkBillTemplateTrans.getTemplateField();
        for (Map container : templateField) {
            this.getModel().createNewEntryRow(KEY_ENTRY);
            String pName = (String)container.get("name");
            String pNumber = (String)container.get("key");
            boolean hidden = (Boolean)container.get("isHidden");
            String panelId = (String)container.get("id");
            int containerIndex = (Integer)container.get("index");
            this.getModel().setValue("pname", (Object)pName, containerIndex);
            this.getModel().setValue("ptype", (Object)PRESET_PANEL_TYPE, containerIndex);
            this.getModel().setValue("panelid", (Object)panelId, containerIndex);
            this.getModel().setValue("pnumber", (Object)pNumber, containerIndex);
            this.getModel().setValue("pisvisible", (Object)(!hidden ? 1 : 0), containerIndex);
            this.getModel().setValue("pispreset", (Object)Boolean.TRUE, containerIndex);
            List fieldInfo = (List)container.get("fieldList");
            this.buildSubEntryEntity(containerIndex, fieldInfo);
        }
    }

    private void buildSubEntryEntity(int parentRow, List<Map<String, Object>> fieldInfo) {
        IDataModel entryOperate = this.getModel();
        entryOperate.setEntryCurrentRowIndex(KEY_ENTRY, parentRow);
        for (Map<String, Object> field : fieldInfo) {
            int subRow = entryOperate.createNewEntryRow(KEY_SUBENTRY);
            this.getModel().setValue("fieldapid", field.get("id"), subRow, parentRow);
            this.getModel().setValue("fieldnumber", field.get("key"), subRow, parentRow);
            this.getModel().setValue("fieldname", field.get("name"), subRow, parentRow);
            String fieldType = (String)field.get("type");
            this.getModel().setValue("fieldtype", (Object)fieldType, subRow, parentRow);
            boolean isVisible = (Boolean)field.get("isHidden") == false;
            this.getModel().setValue("isvisible", (Object)isVisible, subRow, parentRow);
            this.getModel().setValue("ismust", field.get("isMustInput"), subRow, parentRow);
            this.getModel().setValue("ispreset", (Object)Boolean.TRUE, subRow, parentRow);
            String propertyJsonStr = JSON.toJSONString((Object)field.get("property"));
            this.getModel().setValue("fieldpropertyjson_tag", (Object)propertyJsonStr, subRow, parentRow);
            AbstractFieldPropService service = FieldPropServiceFactory.getService((String)fieldType);
            if (service == null) continue;
            String showProperty = service.convertJSONToFieldProperty(propertyJsonStr);
            this.getModel().setValue(KEY_FIELDPROPERTY, (Object)showProperty, subRow, parentRow);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String clickFieldName = hyperLinkClickEvent.getFieldName();
        if ("pname".equalsIgnoreCase(clickFieldName)) {
            int index = hyperLinkClickEvent.getRowIndex();
            FormShowParameter formParameter = new FormShowParameter();
            formParameter.setFormId("ssc_workbillpanel");
            OpenStyle openStyle = formParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Modal);
            formParameter.setOpenStyle(openStyle);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("panelType", this.getModel().getValue("ptype", index));
            params.put("name", this.getModel().getValue("pname", index));
            params.put("number", this.getModel().getValue("pnumber", index));
            params.put("isVisible", this.getModel().getValue("pisvisible", index));
            params.put("isPreset", this.getModel().getValue("pispreset", index));
            params.put("pCheckMeta", this.getModel().getValue("pcheckmeta", index));
            formParameter.setCustomParams(params);
            formParameter.setCustomParam("developerLogo", (Object)WorkBillCommonHelper.getIsvPrefix());
            this.setNumberSet(formParameter);
            this.getPageCache().put(EDIT_PANEL_INDEX_KEY, String.valueOf(index));
            formParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editPanelEntry"));
            this.getView().showForm(formParameter);
        }
    }

    private void setPanelEntry(int index, DynamicObject panelInfo) {
        this.getModel().setValue("pname", (Object)panelInfo.getString("name"), index);
        String panelType = panelInfo.getString("paneltype");
        this.getModel().setValue("ptype", (Object)panelType, index);
        this.getModel().setValue("pnumber", (Object)panelInfo.getString("number"), index);
        this.getModel().setValue("pisvisible", (Object)(!panelInfo.getBoolean("hidden") ? 1 : 0), index);
    }

    private void showImportFieldForm(Map<String, String> panelNumAndTypeMap, List<String> fieldNumList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_IMPORT_DIALOG);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("panelNumAndTypeMap", panelNumAndTypeMap);
        showParameter.setCustomParam("fieldNumList", fieldNumList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_IMPORT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (OP_SUBENTRYDELETE.equalsIgnoreCase(key)) {
            EntryGrid containerGrid = (EntryGrid)this.getControl(KEY_ENTRY);
            int[] parentSelectRows = containerGrid.getSelectRows();
            int parentRow = parentSelectRows.length == 0 ? 0 : parentSelectRows[0];
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_SUBENTRY);
            int selectRow = entryGrid.getSelectRows()[0];
            boolean isPreset = (Boolean)this.getModel().getValue("ispreset", selectRow, parentRow);
            String isCheckMeta = (String)this.getModel().getValue("fcheckmeta", selectRow, parentRow);
            if (isPreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5b57\u6bb5\u4e0d\u80fd\u5220\u9664\u3002", (String)"WorkBillDefineFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (isCheckMeta.equals("1")) {
                String firstDelFieldStr = this.getPageCache().get(FIRST_DEL_FIELD);
                String hasBizDataStr = this.getPageCache().get(HAS_BIZ_DATA_KEY);
                if (StringUtils.isEmpty((CharSequence)firstDelFieldStr) && "false".equals(hasBizDataStr)) {
                    this.saveExistBizDataStatus();
                    this.getPageCache().put(FIRST_DEL_FIELD, "false");
                    hasBizDataStr = this.getPageCache().get(HAS_BIZ_DATA_KEY);
                }
                if ("true".equals(hasBizDataStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e1a\u52a1\u6570\u636e\uff0c\u5b57\u6bb5\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"WorkBillDefineFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("fcheckmeta", (Object)"2", selectRow, parentRow);
                DynamicObject removeDyo = this.getModel().getEntryRowEntity(KEY_SUBENTRY, selectRow, parentRow);
                this.cacheDynamicObject(removeDyo, CACHEKEY_SUBENTRY, "pnumber");
            }
            this.checkCurrencyBeforeDelete(selectRow, parentRow);
        } else if ("save".equals(key)) {
            boolean isRepeat = this.checkNumberRepeat(args);
            if (isRepeat) {
                return;
            }
            boolean checkResult = this.checkClassifyIsLeaf(args);
            if (!checkResult) {
                return;
            }
            this.setRemovedDataToModel();
        } else if ("previewlayout".equals(key)) {
            String number = (String)this.getModel().getValue("number");
            boolean existMetadata = MetadataDao.checkNumber((String)number);
            if (!existMetadata) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5143\u6570\u636e\u672a\u751f\u6210\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"WorkBillDefineFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId(number);
                OpenStyle openStyle = formShowParameter.getOpenStyle();
                openStyle.setShowType(ShowType.Modal);
                formShowParameter.setHasRight(true);
                formShowParameter.setOpenStyle(openStyle);
                formShowParameter.setCaption(((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue());
                formShowParameter.setStatusValue(OperationStatus.VIEW.getValue());
                formShowParameter.setCustomParam(IS_PREVIEW, (Object)Boolean.TRUE);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        } else if ("deleteentry1".equals(key)) {
            int subRow = this.getModel().getEntryRowCount(KEY_SUBENTRY);
            if (subRow > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9762\u677f\u4e0b\u5b58\u5728\u5b57\u6bb5\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WorkBillDefineFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int row = ((CardEntry)this.getControl(KEY_ENTRY)).getSelectRows()[0];
            String pCheckMeta = (String)this.getModel().getValue("pcheckmeta", row);
            if ("1".equals(pCheckMeta)) {
                this.getModel().setValue("pcheckmeta", (Object)"2", row);
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_ENTRY, row);
                this.cacheDynamicObject(dynamicObject, DEL_PANEL_KEY, null);
            }
        } else if (OP_IMPORT_FIELD.equals(key)) {
            HashMap<String, String> panelNumAndTypeMap = new HashMap<String, String>();
            List<String> fieldNumList = this.getExistField(panelNumAndTypeMap);
            this.showImportFieldForm(panelNumAndTypeMap, fieldNumList);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        String fieldName = edit.getKey();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)WORK_BILL_GROUP)) {
            this.addLeafFilter(e);
        }
    }

    private void addLeafFilter(BeforeF7SelectEvent e) {
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)"1");
        List qFilters = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(leafFilter);
    }

    private void setNumberSet(FormShowParameter formShowParameter) {
        IDataModel model = this.getModel();
        HashSet<String> numberSet = new HashSet<String>(8);
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY);
        for (DynamicObject entry : entryEntity) {
            numberSet.add(entry.getString("pnumber"));
            DynamicObjectCollection subEntryList = entry.getDynamicObjectCollection(KEY_SUBENTRY);
            for (DynamicObject subEntry : subEntryList) {
                numberSet.add(subEntry.getString("fieldnumber"));
            }
        }
        formShowParameter.getCustomParams().put("numberSet", numberSet);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry panelList = (CardEntry)this.getControl(KEY_ENTRY);
        panelList.clearEntryState();
        panelList.selectRows(0);
        this.activeTabIfNecessary();
        this.saveExistBizDataStatus();
    }

    private void saveExistBizDataStatus() {
        String number = (String)this.getModel().getValue("number");
        boolean hasMetadata = MetadataDao.checkNumber((String)number);
        if (!hasMetadata) {
            this.getPageCache().put(HAS_BIZ_DATA_KEY, String.valueOf(Boolean.FALSE));
        }
        DBRoute dbRoute = DBRoute.of((String)"ssc");
        String algoKey = ((Object)((Object)this)).getClass() + ".existBillBizData";
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_ENTRY);
        HashSet<String> tables = new HashSet<String>(entryEntity.size() + 1);
        tables.add("t_" + number);
        for (DynamicObject entry : entryEntity) {
            String panelType = entry.getString("ptype");
            String pCheckMeta = entry.getString("pcheckmeta");
            if (!"1".equals(pCheckMeta) || !"1".equals(panelType)) continue;
            String panelNumber = entry.getString("pnumber");
            String tableName = "t_" + panelNumber + "_e";
            tables.add(tableName);
        }
        String querySql = "select 1 from %s";
        boolean hasBizData = false;
        for (String table : tables) {
            if (!DB.exitsTable((DBRoute)dbRoute, (String)table)) continue;
            DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)String.format(querySql, table));
            Throwable throwable = null;
            try {
                if (ds.isEmpty()) continue;
                hasBizData = true;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        this.getPageCache().put(HAS_BIZ_DATA_KEY, String.valueOf(hasBizData));
    }

    private boolean checkNumberRepeat(BeforeDoOperationEventArgs args) {
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = bsp.getBillStatus();
        if (billStatus != BillOperationStatus.ADDNEW) {
            return false;
        }
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        boolean numberRepeat = MetadataDao.checkNumber((String)number);
        String tableName = "t_" + number;
        boolean tableRepeat = DB.exitsTable((DBRoute)DBRoute.of((String)"ssc"), (String)tableName);
        if (numberRepeat || tableRepeat) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u53f7\u6216\u5bf9\u5e94\u8868\u540d\u91cd\u590d\u3002", (String)"WorkBillDefineFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean checkClassifyIsLeaf(BeforeDoOperationEventArgs args) {
        DynamicObject group = (DynamicObject)this.getModel().getValue(WORK_BILL_GROUP);
        if (group == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6240\u5c5e\u5206\u7c7b\u5df2\u88ab\u5220\u9664\u3002", (String)"WorkBillDefineFormPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        Long id = group.getLong("id");
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        boolean exists = QueryServiceHelper.exists((String)"ssc_billmangerclassify", (QFilter[])new QFilter[]{idFilter, leafFilter});
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672b\u7ea7\u5206\u7c7b\u53ef\u4ee5\u6dfb\u52a0\u5171\u4eab\u5de5\u5355\u3002", (String)"WorkBillDefineFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private String amendFieldNum(int cuIndex, int parentIndex, String orFieldNumber) {
        IDataModel model = this.getModel();
        String amendedNumber = this.amendNumber(orFieldNumber);
        boolean repeat = this.checkModelAllNumberRepeat();
        amendedNumber = repeat ? "" : amendedNumber;
        return amendedNumber;
    }

    private boolean checkModelAllNumberRepeat() {
        boolean repeat;
        IDataModel model = this.getModel();
        String number = this.amendNumber(String.valueOf(model.getValue("number")));
        DynamicObjectCollection panelEntitys = model.getEntryEntity(KEY_ENTRY);
        List numberList = panelEntitys.stream().map(panelObject -> panelObject.getDynamicObjectCollection(KEY_SUBENTRY).stream().map(dynamicObject -> dynamicObject.getString("fieldnumber")).filter(StringUtils::isNotBlank).map(this::amendNumber).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        numberList.add(number);
        HashSet numberSet = new HashSet(numberList);
        boolean bl = repeat = numberSet.size() < numberList.size();
        if (repeat) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"WorkBillDefineFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return repeat;
    }

    private boolean currencyChangeName(String newName, String oldName, String valueName) {
        if (oldName == null || oldName.isEmpty()) {
            return false;
        }
        boolean needUpdate = false;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityList = model.getEntryEntity(KEY_ENTRY);
        for (DynamicObject en : entryEntityList) {
            DynamicObjectCollection subEntryList = en.getDynamicObjectCollection(KEY_SUBENTRY);
            for (DynamicObject subEn : subEntryList) {
                String oldJson;
                JSONObject jsonObject;
                if (!"Amount".equals(subEn.getString("fieldtype")) || (jsonObject = JSONObject.parseObject((String)(oldJson = subEn.getString("fieldpropertyjson_tag")))) == null || !valueName.equals(jsonObject.getString("currencyFieldId"))) continue;
                this.getModel().beginInit();
                subEn.set(KEY_FIELDPROPERTY, (Object)newName);
                this.getModel().endInit();
                needUpdate = true;
            }
        }
        return needUpdate;
    }

    private boolean currencyChangeNumber(String newNum, String oldNum) {
        if (oldNum == null || oldNum.isEmpty()) {
            return false;
        }
        boolean needUpdateView = false;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntityList = model.getEntryEntity(KEY_ENTRY);
        for (DynamicObject en : entryEntityList) {
            DynamicObjectCollection subEntryList = en.getDynamicObjectCollection(KEY_SUBENTRY);
            for (DynamicObject subEn : subEntryList) {
                String oldJson;
                JSONObject jsonObject;
                if (!"Amount".equals(subEn.getString("fieldtype")) || (jsonObject = JSONObject.parseObject((String)(oldJson = subEn.getString("fieldpropertyjson_tag")))) == null || !oldNum.equals(jsonObject.getString("currencyFieldId"))) continue;
                if (newNum == null || newNum.isEmpty()) {
                    this.getModel().beginInit();
                    subEn.set("fieldpropertyjson_tag", (Object)"");
                    subEn.set(KEY_FIELDPROPERTY, (Object)"");
                    this.getModel().endInit();
                    needUpdateView = true;
                    continue;
                }
                jsonObject.put("currencyFieldId", (Object)newNum);
                this.getModel().beginInit();
                subEn.set("fieldpropertyjson_tag", (Object)jsonObject.toJSONString());
                this.getModel().endInit();
            }
        }
        return needUpdateView;
    }

    private void checkCurrencyBeforeDelete(int delIndex, int parentIndex) {
        Object fieldTypeObj = this.getModel().getValue("fieldtype", delIndex, parentIndex);
        if (fieldTypeObj == null || !"Currency".equals(fieldTypeObj.toString())) {
            return;
        }
        Object fieldNumber = this.getModel().getValue("fieldnumber", delIndex, parentIndex);
        if (fieldNumber == null || fieldNumber.toString().isEmpty()) {
            return;
        }
        if (this.currencyChangeNumber(null, fieldNumber.toString())) {
            this.updateSubEntryView();
        }
    }

    private String getLocalString(LocaleDynamicObjectCollection lDyoColl) {
        String localeId = Lang.get().toString();
        List localeData = lDyoColl.stream().filter(item -> item.get("localeid").equals(localeId)).collect(Collectors.toList());
        if (localeData.size() > 0) {
            return ((DynamicObject)localeData.get(0)).getString("fieldname");
        }
        return null;
    }

    private void updateSubEntryView() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
        this.getView().updateView(KEY_SUBENTRY);
        CardEntry panelList = (CardEntry)this.getControl(KEY_ENTRY);
        panelList.selectRows(entryCurrentRowIndex);
    }

    private void setISCFieldCon(boolean mustInput) {
        IFormView formView = this.getView();
        FieldEdit targetOBJ = (FieldEdit)formView.getControl("target_datas");
        targetOBJ.setMustInput(mustInput);
    }

    private void activeTabIfNecessary() {
        Object selectTab = this.getView().getFormShowParameter().getCustomParam("selectTab");
        if (selectTab != null) {
            Tab tabAp = (Tab)this.getView().getControl("tabap");
            tabAp.activeTab(selectTab.toString());
        }
    }

    private void cacheDynamicObject(DynamicObject cacheDyo, String cacheKey, String parentNoKey) {
        if (cacheDyo == null || cacheKey == null || cacheKey.isEmpty()) {
            return;
        }
        DynamicObjectType dynamicObjectType = cacheDyo.getDynamicObjectType();
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dynamicObjectType);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(true);
        String newCacheItem = jsr.serializeToString((Object)cacheDyo, null);
        IPageCache pageCache = this.getPageCache();
        String oldCache = pageCache.get(cacheKey);
        String newCache = null;
        if (parentNoKey != null) {
            DynamicObject parent = (DynamicObject)cacheDyo.getParent();
            if (parent == null) {
                return;
            }
            String parentNo = parent.getString(parentNoKey);
            HashMap map = oldCache == null ? new HashMap(1) : (HashMap)JSON.parseObject((String)oldCache, HashMap.class);
            map.put(newCacheItem, parentNo);
            newCache = JSON.toJSONString((Object)map);
        } else if (oldCache == null) {
            newCache = JSON.toJSONString((Object)new String[]{newCacheItem});
        } else {
            String[] r = (String[])JSON.parseObject((String)oldCache, String[].class);
            ArrayList<String> strings = new ArrayList<String>(Arrays.asList(r));
            strings.add(newCacheItem);
            newCache = JSON.toJSONString((Object)strings.toArray(new String[0]));
        }
        pageCache.put(cacheKey, newCache);
    }

    private void setRemovedDataToModel() {
        String fieldCache;
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY);
        String panelCache = pageCache.get(DEL_PANEL_KEY);
        if (panelCache != null) {
            Object[] deserialize;
            for (Object item : deserialize = DynamicObjectSerializeUtil.deserialize((String)panelCache, (DynamicObjectType)entryEntity.getDynamicObjectType())) {
                DynamicObject dyo = (DynamicObject)item;
                int index = dyo.getInt("seq");
                entryEntity.add((Object)dyo);
            }
        }
        if ((fieldCache = pageCache.get(CACHEKEY_SUBENTRY)) != null) {
            DynamicObjectType dynamicObjectType = model.getEntryEntity(KEY_SUBENTRY).getDynamicObjectType();
            HashMap<DynamicObject, String> removedFields = WorkBillDefineFormPlugin.deserializeMap(fieldCache, dynamicObjectType);
            block1: for (Map.Entry<DynamicObject, String> field : removedFields.entrySet()) {
                String panelNo = field.getValue();
                DynamicObject fieldDyo = field.getKey();
                for (DynamicObject entry : entryEntity) {
                    if (!entry.getString("pnumber").equals(panelNo)) continue;
                    entry.getDynamicObjectCollection(KEY_SUBENTRY).add((Object)fieldDyo);
                    continue block1;
                }
            }
            this.getModel().getDataEntity(true).set(KEY_ENTRY, (Object)entryEntity);
        }
        this.getPageCache().remove(DEL_PANEL_KEY);
        this.getPageCache().remove(CACHEKEY_SUBENTRY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getView().updateView(KEY_SUBENTRY);
        }
    }

    private static HashMap<DynamicObject, String> deserializeMap(String str, DynamicObjectType dt) {
        DynamicObjectSerializationBinder b = new DynamicObjectSerializationBinder(dt);
        b.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)b);
        jsr.setIsLocaleValueFull(true);
        HashMap map = (HashMap)JSON.parseObject((String)str, HashMap.class);
        HashMap<DynamicObject, String> result = new HashMap<DynamicObject, String>();
        for (Map.Entry item : map.entrySet()) {
            String mapKey = (String)item.getValue();
            String dyoJson = (String)item.getKey();
            DynamicObject o = (DynamicObject)jsr.deserializeFromString(dyoJson, null);
            result.put(o, mapKey);
        }
        return result;
    }

    private void checkWorkBillDefineChange() {
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        if (dataChanged) {
            DynamicObject dataEntity = model.getDataEntity(true);
            DataModelChangeUtil.setBizChanged((DynamicObject)dataEntity, (boolean)false, (String[])new String[]{"target_datas", "source_datas", "source_number", "source_name"});
            model.updateCache();
            if (DataModelChangeUtil.isBizChanged((DynamicObject)dataEntity)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5de5\u5355\u7ed3\u6784\u6709\u66f4\u6539\uff0c\u8bf7\u53ca\u65f6\u4fdd\u5b58\uff0c\u5426\u5219\u540e\u7eed\u64cd\u4f5c\u5c06\u65e0\u6cd5\u83b7\u53d6\u6700\u65b0\u7ed3\u6784\u3002", (String)"WorkBillDefineFormPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), model.getChangeDesc(), MessageTypes.Default);
            }
        }
    }

    private String amendNumber(String original) {
        String isvPrefix;
        String result = original.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!result.startsWith(isvPrefix = WorkBillCommonHelper.getIsvPrefix())) {
            result = isvPrefix + result;
        }
        return result;
    }

    private List<String> getExistField(Map<String, String> panelNumAndTypeMap) {
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection panelDyns = entryOperate.getEntryEntity(KEY_ENTRY);
        HashMap<String, Integer> panelIndexMap = new HashMap<String, Integer>(8);
        ArrayList<String> existFieldNumList = new ArrayList<String>();
        for (int i = 0; i < panelDyns.size(); ++i) {
            DynamicObject panelInfo = (DynamicObject)panelDyns.get(i);
            String panelType = panelInfo.getString("ptype");
            String panelNumber = panelInfo.getString("pnumber");
            String panelName = panelInfo.getString("pname");
            panelIndexMap.put(panelNumber, i);
            panelNumAndTypeMap.put(panelNumber, panelType + panelName);
            DynamicObjectCollection fieldDyns = panelInfo.getDynamicObjectCollection(KEY_SUBENTRY);
            for (DynamicObject fieldInfo : fieldDyns) {
                String fieldnumber = fieldInfo.getString("fieldnumber");
                boolean ispreset = fieldInfo.getBoolean("ispreset");
                if (ispreset) continue;
                existFieldNumList.add(fieldnumber);
            }
        }
        this.getPageCache().put(CACHE_PANEL_INDEX, JSONObject.toJSONString(panelIndexMap));
        return existFieldNumList;
    }
}

