/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.workbill.file.WorkBillExportHelper;

public class WorkBillListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(WorkBillListPlugin.class);
    private static final String EXPORT_WORKBILL = "exportworkbill";
    private static final String IMPORT_WORKBILL = "importworkbill";
    private static final String KEY_IMPORT_DIALOG = "ssc_import_workbill";
    private static final String CALLBACK_KEY_IMPORT = "importWorkBill";
    private static final String CALLBACKID_CONFIRM_EXPORT = "confirmExport";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "exportworkbill": {
                String confirmMsg = ResManager.loadKDString((String)"\u786e\u5b9a\u5bfc\u51fa\u5171\u4eab\u5de5\u5355\u53ca\u76f8\u5173\u5143\u6570\u636e\uff1f", (String)"WorkBillListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_CONFIRM_EXPORT, (IFormPlugin)this));
                break;
            }
            case "importworkbill": {
                this.showImportWorkBillForm();
                break;
            }
        }
    }

    private Long getUserOrgId() {
        String customFils = this.getPageCache().get("customfilter");
        List customFilterList = (List)SerializationUtils.fromJsonString((String)customFils, ArrayList.class);
        if (customFilterList == null || customFilterList.size() == 0) {
            return 0L;
        }
        Map filterMap = (Map)customFilterList.get(0);
        if (filterMap.size() == 0) {
            return 0L;
        }
        List userOrgIds = (List)filterMap.get("Value");
        if (CollectionUtils.isEmpty((Collection)userOrgIds)) {
            return 0L;
        }
        return Long.parseLong(userOrgIds.get(0).toString());
    }

    private void showImportWorkBillForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(KEY_IMPORT_DIALOG);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_IMPORT);
        showParameter.setCloseCallBack(closeCallBack);
        Long userOrgId = this.getUserOrgId();
        showParameter.setCustomParam("userOrgId", (Object)userOrgId);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object retData = e.getReturnData();
        if (!CALLBACK_KEY_IMPORT.equalsIgnoreCase(actionId)) {
            return;
        }
        if (retData == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)((List)retData))) {
            this.showErrorForm((List)retData);
            return;
        }
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5bfc\u5165\u6210\u529f\u3002", (String)"WorkBillListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private void showErrorForm(List<String> errorList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("ssc_wb_import_error_form");
        parameters.setCustomParam("errorMsg", errorList);
        this.getView().showForm(parameters);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CALLBACKID_CONFIRM_EXPORT.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            IListView list = (IListView)this.getView();
            ListSelectedRowCollection selectRows = list.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow listSelectedRow : selectRows) {
                ids.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            String downloadUrl = WorkBillExportHelper.exportWorkBill(ids);
            this.getView().openUrl(downloadUrl);
        }
    }
}

