/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.ssc.task.formplugin.util.ViewFlowchartUtil;

public class WorkBillTemplateListPlugin
extends AbstractListPlugin {
    private static final String NEXT_AUDITOR = "nextauditor";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                if (dynObjs.isEmpty() || !((DynamicObject)dynObjs.get(0)).getDataEntityType().getProperties().containsKey((Object)WorkBillTemplateListPlugin.NEXT_AUDITOR)) {
                    return dynObjs;
                }
                ArrayList ids = new ArrayList(dynObjs.size());
                dynObjs.forEach(v -> ids.add(String.valueOf(v.getPkValue())));
                if (ids.size() > 0) {
                    WorkBillTemplateListPlugin.this.setNextAuditor(dynObjs, ids);
                }
                return dynObjs;
            }
        });
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> ids) {
        Map<String, String> nextAuditor = ViewFlowchartUtil.getNextAuditor(ids);
        collection.forEach(v -> {
            String id = String.valueOf(v.getPkValue());
            v.set(NEXT_AUDITOR, (Object)(nextAuditor.get(id) == null ? "" : nextAuditor.get(id)));
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fileldName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        int rowIdx = args.getRowIndex();
        if (NEXT_AUDITOR.equals(fileldName)) {
            args.setCancel(true);
            Long billid = this.getSelectRowId(selectedRows, rowIdx);
            ListShowParameter listshow = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = listshow.getPageId();
            WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billid);
        }
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        int size = selectedRows.size();
        for (int i = 0; i < size; ++i) {
            int rowKey = selectedRows.get(i).getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.parseLong(selectedRows.get(i).getPrimaryKeyValue() + "");
        }
        return null;
    }
}

