/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill.importworkbill;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.ssc.task.business.workbill.file.WorkBillImportHelper;

public class ImportWorkBillFormPlugin
extends AbstractFormPlugin
implements UploadListener,
ClickListener {
    private static final String BTN_OK = "btnok";
    private static final String KEY_ATTACHMENTPANEL = "attachmentpanelap";
    private static final String KEY_URL = "url";
    private static final String CALLBACKID_CONFIRM_IMPORT = "confirmImport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        if (BTN_OK.equalsIgnoreCase(ctrl.getKey())) {
            String confirmMsg = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u8986\u76d6\u5df2\u6709\u7684\u5de5\u5355\u7ed3\u6784\uff0c\u5f53\u5bfc\u5165\u5de5\u5355\u7684\u521b\u5efa\u7ec4\u7ec7\u7f16\u53f7\u4e0d\u5b58\u5728\u65f6\uff0c\u5c06\u5bfc\u5165\u5230\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5bfc\u5165\uff1f", (String)"ImportWorkBillFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACKID_CONFIRM_IMPORT, (IFormPlugin)this));
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterUpload(evt);
        Map attachmentInfoMap = (Map)evt.getUrls()[0];
        String attachmentUrl = Optional.ofNullable(attachmentInfoMap).map(map -> map.get(KEY_URL)).map(url -> url.toString()).orElse("");
        this.getPageCache().put(KEY_URL, attachmentUrl);
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_OK});
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        this.getPageCache().put(KEY_URL, "");
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_OK});
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CALLBACKID_CONFIRM_IMPORT.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long userOrgId = Long.parseLong(parameter.getCustomParam("userOrgId").toString());
            String attachmentUrl = this.getPageCache().get(KEY_URL);
            List errorMsgList = WorkBillImportHelper.importZipFile((String)attachmentUrl, (Long)userOrgId);
            this.getView().returnDataToParent((Object)errorMsgList);
            this.getView().close();
        }
    }
}

