/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.workcalendar.pojo.Holiday;

public class SscWorkCalendarEntityPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SscWorkCalendarEntityPlugin.class);
    private int fromDateIndex = 0;
    private int toDateIndex = 1;

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.initProperty();
    }

    public void afterCreateNewData(EventObject e) {
        Object ssccenterid = this.getParamFrom().get("ssccenterid");
        boolean init = (Boolean)this.getParamFrom().get("init");
        if (init) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u53ea\u5141\u8bb8\u521d\u59cb\u5316\u4e00\u6b21\u3002\u7ed3\u675f\u521d\u59cb\u5316\u540e\uff0c\u4e0d\u5141\u8bb8\u7ef4\u62a4\u5386\u53f2\u65e5\u671f\u3002\u8bf7\u786e\u8ba4\u540e\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarEntityPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]), Integer.valueOf(60000));
            this.getPageCache().put("init", "1");
            this.getPageCache().put("initSave", "1");
        }
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        String orderby = "createtime desc";
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"*", (QFilter[])new QFilter[]{new QFilter("ssccenter", "=", (Object)Long.parseLong(ssccenterid + ""))}, (String)orderby);
        if (objs != null && objs.size() > 0) {
            DynamicObject o = (DynamicObject)objs.get(0);
            int expiringyearfrom = o.getInt("expiringyearfrom");
            String expiringmonthfrom = o.getString("expiringmonthfrom");
            String expiringdayfrom = o.getString("expiringdayfrom");
            int expiringyearto = o.getInt("expiringyearto");
            String expiringmonthto = o.getString("expiringmonthto");
            String expiringdayto = o.getString("expiringdayto");
            String hourofbegintimeam = o.getInt("hourofbegintimeam") + "";
            String minofbegintimeam = o.getInt("minofbegintimeam") + "";
            String hourofendtimeam = o.getInt("hourofendtimeam") + "";
            String minofendtimeam = o.getInt("minofendtimeam") + "";
            String hourofbegintimepm = o.getString("hourofbegintimepm");
            String minofbegintimepm = o.getInt("minofbegintimepm") + "";
            String hourofendtimepm = o.getString("hourofendtimepm");
            String minofendtimepm = o.getInt("minofendtimepm") + "";
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(21);
            boolean issunrest = o.getBoolean("issunrest");
            boolean ismonrest = o.getBoolean("ismonrest");
            boolean istuerest = o.getBoolean("istuerest");
            boolean iswedrest = o.getBoolean("iswedrest");
            boolean isthurest = o.getBoolean("isthurest");
            boolean isfrirest = o.getBoolean("isfrirest");
            boolean issatrest = o.getBoolean("issatrest");
            map.put("issunrest", issunrest);
            map.put("ismonrest", ismonrest);
            map.put("istuerest", istuerest);
            map.put("iswedrest", iswedrest);
            map.put("isthurest", isthurest);
            map.put("isfrirest", isfrirest);
            map.put("issatrest", issatrest);
            boolean ishalfsunrestam = o.getBoolean("ishalfsunrestam");
            boolean ishalfmonrestam = o.getBoolean("ishalfmonrestam");
            boolean ishalftuerestam = o.getBoolean("ishalftuerestam");
            boolean ishalfwedrestam = o.getBoolean("ishalfwedrestam");
            boolean ishalfthurestam = o.getBoolean("ishalfthurestam");
            boolean ishalffrirestam = o.getBoolean("ishalffrirestam");
            boolean ishalfsatrestam = o.getBoolean("ishalfsatrestam");
            map.put("ishalfsunrestam", ishalfsunrestam);
            map.put("ishalfmonrestam", ishalfmonrestam);
            map.put("ishalftuerestam", ishalftuerestam);
            map.put("ishalfwedrestam", ishalfwedrestam);
            map.put("ishalfthurestam", ishalfthurestam);
            map.put("ishalffrirestam", ishalffrirestam);
            map.put("ishalfsatrestam", ishalfsatrestam);
            boolean ishalfsunrestpm = o.getBoolean("ishalfsunrestpm");
            boolean ishalfmonrestpm = o.getBoolean("ishalfmonrestpm");
            boolean ishalftuerestpm = o.getBoolean("ishalftuerestpm");
            boolean ishalfwedrestpm = o.getBoolean("ishalfwedrestpm");
            boolean ishalfthurestpm = o.getBoolean("ishalfthurestpm");
            boolean ishalffrirestpm = o.getBoolean("ishalffrirestpm");
            boolean ishalfsatrestpm = o.getBoolean("ishalfsatrestpm");
            map.put("ishalfsunrestpm", ishalfsunrestpm);
            map.put("ishalfmonrestpm", ishalfmonrestpm);
            map.put("ishalftuerestpm", ishalftuerestpm);
            map.put("ishalfwedrestpm", ishalfwedrestpm);
            map.put("ishalfthurestpm", ishalfthurestpm);
            map.put("ishalffrirestpm", ishalffrirestpm);
            map.put("ishalfsatrestpm", ishalfsatrestpm);
            for (Map.Entry entry : map.entrySet()) {
                String mapKey = (String)entry.getKey();
                boolean mapValue = (Boolean)entry.getValue();
                if (!mapValue) continue;
                this.getModel().setValue(mapKey, (Object)mapValue);
            }
            IDataModel model = this.getModel();
            if (expiringyearfrom < currentYear) {
                int deviation = currentYear - expiringyearfrom;
                expiringyearfrom += deviation;
                expiringyearto += deviation;
            }
            model.setValue("expiringyearfrom", (Object)expiringyearfrom);
            model.setValue("expiringmonthfrom", (Object)expiringmonthfrom);
            model.setValue("expiringdayfrom", (Object)expiringdayfrom);
            model.setValue("expiringyearto", (Object)expiringyearto);
            model.setValue("expiringmonthto", (Object)expiringmonthto);
            model.setValue("expiringdayto", (Object)expiringdayto);
            model.setValue("hourofbegintimeam", (Object)hourofbegintimeam);
            model.setValue("minofbegintimeam", (Object)minofbegintimeam);
            model.setValue("hourofendtimeam", (Object)hourofendtimeam);
            model.setValue("minofendtimeam", (Object)minofendtimeam);
            model.setValue("hourofbegintimepm", (Object)hourofbegintimepm);
            model.setValue("minofbegintimepm", (Object)minofbegintimepm);
            model.setValue("hourofendtimepm", (Object)hourofendtimepm);
            model.setValue("minofendtimepm", (Object)minofendtimepm);
            model.setValue("getholiday", (Object)o.getBoolean("getholiday"));
            this.genDayComboItems("expiringdayfrom", expiringyearfrom, Integer.parseInt(expiringmonthfrom));
            this.genDayComboItems("expiringdayto", expiringyearto, Integer.parseInt(expiringmonthto));
        } else {
            int currentMonth = cal.get(2) + 1;
            int currentDay = cal.get(5);
            this.getModel().setValue("expiringyearfrom", (Object)currentYear);
            this.getModel().setValue("expiringmonthfrom", (Object)currentMonth);
            this.getModel().setValue("expiringdayfrom", (Object)currentDay);
            this.getModel().setValue("expiringyearto", (Object)currentYear);
            this.getModel().setValue("expiringmonthto", (Object)currentMonth);
            this.getModel().setValue("expiringdayto", (Object)currentDay);
            this.genDayComboItems("expiringdayfrom", currentYear, currentMonth);
            this.genDayComboItems("expiringdayto", currentYear, currentMonth);
        }
        this.genHourAmComboItems("hourofbegintimeam");
        this.genHourAmComboItems("hourofendtimeam");
        this.genHourPmComboItems("hourofbegintimepm");
        this.genHourPmComboItems("hourofendtimepm");
        this.genMinComboItems("minofbegintimeam");
        this.genMinComboItems("minofendtimeam");
        this.genMinComboItems("minofbegintimepm");
        this.genMinComboItems("minofendtimepm");
        this.getModel().setValue("ssccenter", (Object)Long.parseLong(ssccenterid + ""));
    }

    private void initProperty() {
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        this.genYearComboItems("expiringyearfrom", currentYear);
        this.genYearComboItems("expiringyearto", currentYear);
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(11);
        int length = 10;
        boolean init = (Boolean)this.getParamFrom().get("init");
        if (init) {
            currentYear = 2010;
            length = 20;
        }
        for (int i = 0; i <= length; ++i) {
            String year = String.valueOf(currentYear + i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    private void genDayComboItems(String propertyName, int currentYear, int currentMonth) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        String lastDay = SscWorkCalendarUtil.getLastDayOfMonth(currentYear, currentMonth);
        int len = Integer.parseInt(lastDay.split("-")[2]);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            String day = String.valueOf(i + 1);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(day));
            comboItem.setValue(day);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    private void genHourAmComboItems(String propertyName) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        int len = 12;
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(len);
        for (int i = 0; i <= len; ++i) {
            String hourAm = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(hourAm));
            comboItem.setValue(hourAm);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    private void genHourPmComboItems(String propertyName) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        int len = 12;
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(len);
        for (int i = 12; i <= 23; ++i) {
            String hourPm = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(hourPm));
            comboItem.setValue(hourPm);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    private void genMinComboItems(String propertyName) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        int len = 60;
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(len);
        for (int i = 0; i < len; ++i) {
            String min = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(min));
            comboItem.setValue(min);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if ("issunrest".equals(prop) || "ishalfsunrestam".equals(prop) || "ishalfsunrestpm".equals(prop)) {
            this.verification(prop, "issunrest", "ishalfsunrestam", "ishalfsunrestpm");
        } else if ("ismonrest".equals(prop) || "ishalfmonrestam".equals(prop) || "ishalfmonrestpm".equals(prop)) {
            this.verification(prop, "ismonrest", "ishalfmonrestam", "ishalfmonrestpm");
        } else if ("istuerest".equals(prop) || "ishalftuerestam".equals(prop) || "ishalftuerestpm".equals(prop)) {
            this.verification(prop, "istuerest", "ishalftuerestam", "ishalftuerestpm");
        } else if ("iswedrest".equals(prop) || "ishalfwedrestam".equals(prop) || "ishalfwedrestpm".equals(prop)) {
            this.verification(prop, "iswedrest", "ishalfwedrestam", "ishalfwedrestpm");
        } else if ("isthurest".equals(prop) || "ishalfthurestam".equals(prop) || "ishalfthurestpm".equals(prop)) {
            this.verification(prop, "isthurest", "ishalfthurestam", "ishalfthurestpm");
        } else if ("isfrirest".equals(prop) || "ishalffrirestam".equals(prop) || "ishalffrirestpm".equals(prop)) {
            this.verification(prop, "isfrirest", "ishalffrirestam", "ishalffrirestpm");
        } else if ("issatrest".equals(prop) || "ishalfsatrestam".equals(prop) || "ishalfsatrestpm".equals(prop)) {
            this.verification(prop, "issatrest", "ishalfsatrestam", "ishalfsatrestpm");
        }
        switch (prop) {
            case "expiringyearfrom": {
                int expiringyearfrom_y = Integer.parseInt(this.getModel().getValue("expiringyearfrom").toString());
                int expiringmonthfrom_y = Integer.parseInt(this.getModel().getValue("expiringmonthfrom").toString());
                this.genDayComboItems("expiringdayfrom", expiringyearfrom_y, expiringmonthfrom_y);
                break;
            }
            case "expiringmonthfrom": {
                int expiringyearfrom_m = Integer.parseInt(this.getModel().getValue("expiringyearfrom").toString());
                int expiringmonthfrom_m = Integer.parseInt(this.getModel().getValue("expiringmonthfrom").toString());
                this.genDayComboItems("expiringdayfrom", expiringyearfrom_m, expiringmonthfrom_m);
                break;
            }
            case "expiringyearto": {
                int expiringyearto_y = Integer.parseInt(this.getModel().getValue("expiringyearto").toString());
                int expiringmonthto_y = Integer.parseInt(this.getModel().getValue("expiringmonthto").toString());
                this.genDayComboItems("expiringdayto", expiringyearto_y, expiringmonthto_y);
                break;
            }
            case "expiringmonthto": {
                int expiringyearto_m = Integer.parseInt(this.getModel().getValue("expiringyearto").toString());
                int expiringmonthto_m = Integer.parseInt(this.getModel().getValue("expiringmonthto").toString());
                this.genDayComboItems("expiringdayto", expiringyearto_m, expiringmonthto_m);
                break;
            }
        }
    }

    private void verification(String prop, String allDay, String amDay, String pmDay) {
        boolean am = (Boolean)this.getModel().getValue(amDay);
        boolean pm = (Boolean)this.getModel().getValue(pmDay);
        Boolean rest = (Boolean)this.getModel().getValue(allDay);
        if (rest.booleanValue() && (am || pm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"SscWorkCalendarEntityPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (am && pm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u534a\u5de5\u4f5c\u65e5\u201d\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u4e0a\u5348\u548c\u4e0b\u5348\u3002", (String)"SscWorkCalendarEntityPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op;
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "save".equalsIgnoreCase((op = (AbstractOperate)source).getOperateKey())) {
            if (!this.getModel().getDataChanged()) {
                args.cancel = true;
                this.getView().close();
                return;
            }
            if (this.validate()) {
                String init = this.getPageCache().get("initSave");
                if (StringUtils.isNotBlank((CharSequence)init) && init.equals("1")) {
                    ConfirmCallBackListener initSave = new ConfirmCallBackListener("initSave");
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u53ea\u5141\u8bb8\u521d\u59cb\u5316\u4e00\u6b21\u3002\u7ed3\u675f\u521d\u59cb\u5316\u540e\uff0c\u4e0d\u5141\u8bb8\u7ef4\u62a4\u5386\u53f2\u65e5\u671f\u3002\u786e\u5b9a\u8981\u7ed3\u675f\u521d\u59cb\u5316\u5417\uff1f", (String)"SscWorkCalendarEntityPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, initSave);
                    args.setCancel(true);
                } else {
                    log.debug("\u5f00\u59cb\u6279\u91cf\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386");
                    this.generateDate();
                }
            } else {
                args.cancel = true;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            String ssc = this.getParamFrom().get("ssccenterid") + "";
            this.synchroData(ssc);
            String init = this.getPageCache().get("init");
            if (StringUtils.isNotBlank((CharSequence)init) && init.equals("1")) {
                DynamicObject initData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_workcalendar_init");
                initData.set("initssc", (Object)ssc);
                initData.set("inituser", (Object)RequestContext.get().getUserId());
                initData.set("initdate", (Object)new Date());
                initData.set("initcontent_tag", (Object)SerializationUtils.toJsonString((Object)this.getModel().getDataEntity()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getCallBackId().equals("initSave") && event.getResult().equals((Object)MessageBoxResult.Yes)) {
            log.debug("\u5f00\u59cb\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386");
            this.getPageCache().put("initSave", "-1");
            this.getView().invokeOperation("save");
        }
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        if (!this.amTimeValidate()) {
            return false;
        }
        if (!this.pmTimeValidate()) {
            return false;
        }
        if (!this.amEndAPmBeginValidate()) {
            return false;
        }
        if (!this.validateGetholiday()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    private boolean validateGetholiday() {
        DynamicObject ssccenter = (DynamicObject)this.getModel().getValue("ssccenter");
        boolean getholiday = (Boolean)this.getModel().getValue("getholiday");
        if (getholiday && ssccenter != null && ssccenter.getLong("country.id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u4e2d\u5fc3\u5bf9\u5e94\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e00\u952e\u83b7\u53d6\u8282\u5047\u65e5\uff0c\u8bf7\u7ef4\u62a4\u540e\u91cd\u8bd5\u3002", (String)"SscWorkCalendarEntityPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean dateExclusionValidate() {
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        boolean[] isHalfWorkDayAm = this.getHalfWorkDaysAm(this.getModel());
        boolean[] isHalfWorkDayPm = this.getHalfWorkDaysPm(this.getModel());
        if (isRestDay.length != isHalfWorkDayAm.length || isRestDay.length != isHalfWorkDayPm.length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (isRestDay[i] && isHalfWorkDayAm[i] || isRestDay[i] && isHalfWorkDayPm[i]) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"SscWorkCalendarEntityPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            if (!isHalfWorkDayAm[i] || !isHalfWorkDayPm[i]) continue;
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u534a\u5de5\u4f5c\u65e5\u201d\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u4e0a\u5348\u548c\u4e0b\u5348\u3002", (String)"SscWorkCalendarEntityPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean amTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (!(this.nullToZero(obj, "hourofbegintimeam") || this.nullToZero(obj, "minofbegintimeam") || this.nullToZero(obj, "hourofendtimeam") || this.nullToZero(obj, "minofendtimeam"))) {
            result = SscWorkCalendarUtil.compareHourAndMinute(obj.getInt("hourofbegintimeam"), obj.getInt("minofbegintimeam"), obj.getInt("hourofendtimeam"), obj.getInt("minofendtimeam"));
            if (!result) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SscWorkCalendarEntityPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0a\u5348\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u3002", (String)"SscWorkCalendarEntityPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        return result;
    }

    private boolean pmTimeValidate() {
        boolean result = false;
        DynamicObject obj = this.getDynamicObject();
        if (!(this.nullToZero(obj, "hourofbegintimepm") || this.nullToZero(obj, "minofbegintimepm") || this.nullToZero(obj, "hourofendtimepm") || this.nullToZero(obj, "minofendtimepm"))) {
            result = SscWorkCalendarUtil.compareHourAndMinute(obj.getInt("hourofbegintimepm"), obj.getInt("minofbegintimepm"), obj.getInt("hourofendtimepm"), obj.getInt("minofendtimepm"));
            if (!result) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u665a\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"SscWorkCalendarEntityPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u4e0b\u5348\u65f6\u95f4\u5fc5\u987b\u5f55\u5165\u3002", (String)"SscWorkCalendarEntityPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        return result;
    }

    private boolean amEndAPmBeginValidate() {
        boolean flag = false;
        DynamicObject obj = this.getDynamicObject();
        boolean result = SscWorkCalendarUtil.compareHourAndMinute(obj.getInt("hourofendtimeam"), obj.getInt("minofendtimeam"), obj.getInt("hourofbegintimepm"), obj.getInt("minofbegintimepm"));
        if (result) {
            flag = true;
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e0b\u5348\u5de5\u4f5c\u65f6\u95f4\u4e0d\u80fd\u6709\u91cd\u53e0\u3002", (String)"SscWorkCalendarEntityPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        return flag;
    }

    private boolean nullToZero(DynamicObject obj, String propertyName) {
        Object property = obj.get(propertyName);
        if (property != null && property.toString().length() != 0) {
            return false;
        }
        obj.set(propertyName, (Object)0);
        return true;
    }

    private boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expiringyearfrom") != null && obj.get("expiringmonthfrom") != null && obj.get("expiringyearto") != null && obj.get("expiringmonthto") != null && obj.get("expiringdayfrom") != null && obj.get("expiringdayto") != null) {
            Calendar curDate = Calendar.getInstance();
            Calendar fromDate = Calendar.getInstance();
            Calendar toDate = Calendar.getInstance();
            int yearFrom = obj.getInt("expiringyearfrom");
            int monthFrom = obj.getInt("expiringmonthfrom");
            int dayFrom = obj.getInt("expiringdayfrom");
            int yearTo = obj.getInt("expiringyearto");
            int monthTo = obj.getInt("expiringmonthto");
            int dayTo = obj.getInt("expiringdayto");
            fromDate.set(yearFrom, monthFrom - 1, dayFrom);
            toDate.set(yearTo, monthTo - 1, dayTo);
            boolean init = (Boolean)this.getParamFrom().get("init");
            if (!init) {
                if (!SscWorkCalendarUtil.compareDate(fromDate, curDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u8981\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"SscWorkCalendarEntityPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!SscWorkCalendarUtil.compareDate(toDate, curDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u201d\u5e94\u5927\u4e8e\u7b49\u4e8e\u201c\u5f53\u524d\u65e5\u671f\u201d\u3002", (String)"SscWorkCalendarEntityPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if (!SscWorkCalendarUtil.compareDate(toDate, fromDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u201d\u8981\u5927\u4e8e\u7b49\u4e8e\u201c\u6709\u6548\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"SscWorkCalendarEntityPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SscWorkCalendarEntityPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private void generateDate() {
        IDataModel model = this.getModel();
        DynamicObject obj = model.getDataEntity();
        Calendar[] fromAndToDate = this.getFromAndToDate();
        int hourofbegintimeam = obj.getInt("hourofbegintimeam");
        int minofbegintimeam = obj.getInt("minofbegintimeam");
        int hourofendtimeam = obj.getInt("hourofendtimeam");
        int minofendtimeam = obj.getInt("minofendtimeam");
        int hourofbegintimepm = obj.getInt("hourofbegintimepm");
        int minofbegintimepm = obj.getInt("minofbegintimepm");
        int hourofendtime = obj.getInt("hourofendtimepm");
        int minofendtime = obj.getInt("minofendtimepm");
        String beginWorkTimeAm = SscWorkCalendarUtil.changeTime(hourofbegintimeam, minofbegintimeam);
        String endWorkTimeAm = SscWorkCalendarUtil.changeTime(hourofendtimeam, minofendtimeam);
        String beginWorkTimePm = SscWorkCalendarUtil.changeTime(hourofbegintimepm, minofbegintimepm);
        String endWorkTimePm = SscWorkCalendarUtil.changeTime(hourofendtime, minofendtime);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDayAm = this.getHalfWorkDaysAm(model);
        boolean[] isHalfWorkDayPm = this.getHalfWorkDaysPm(model);
        int oldCalendarCount = this.removeDuplicateRecord(fromAndToDate[0], fromAndToDate[1]);
        int days = SscWorkCalendarUtil.daysBetween(fromAndToDate[this.fromDateIndex], fromAndToDate[this.toDateIndex]);
        try {
            Date fromDate = fromAndToDate[this.fromDateIndex].getTime();
            Date toDate = fromAndToDate[this.toDateIndex].getTime();
            log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6estart: fromDate = {}, toDate = {}, isRestDay = {}, isHalfWorkDayAm = {}, isHalfWorkDayPm = {},beginWorkTimeAm = {}, endWorkTimeAm = {}, beginWorkTimePm = {}, endWorkTimePm = {}", new Object[]{fromDate, toDate, isRestDay, isHalfWorkDayAm, isHalfWorkDayPm, beginWorkTimeAm, endWorkTimeAm, beginWorkTimePm, endWorkTimePm});
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6e\uff0c\u53c2\u6570\u65e5\u5fd7\u6253\u5370\u5f02\u5e38", (Throwable)e);
        }
        Object sscCenterId = this.getParamFrom().get("ssccenterid");
        this.getModel().setValue("ssccenter", sscCenterId);
        Map<Object, Object> holidayMap = Collections.emptyMap();
        boolean getHoliday = (Boolean)model.getValue("getholiday");
        if (getHoliday) {
            ArrayList<Holiday> holidays = new ArrayList<Holiday>(16);
            DynamicObject countryInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)"country.id as countryid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)sscCenterId))});
            if (countryInfo != null) {
                Map holidayDetailMap;
                Long countryId = countryInfo.getLong("countryid");
                Map sscPublicHoliday = I18nServiceHelper.getPublicHoliday(Collections.singleton(countryId), (Date)fromAndToDate[this.fromDateIndex].getTime(), (Date)fromAndToDate[this.toDateIndex].getTime());
                if (sscPublicHoliday != null && ((Boolean)sscPublicHoliday.get("isSuccess")).booleanValue() && (holidayDetailMap = (Map)((Map)sscPublicHoliday.get("data")).get(String.valueOf(countryId))) != null && holidayDetailMap.size() > 0) {
                    for (Map.Entry entry : holidayDetailMap.entrySet()) {
                        Map holidayDetail;
                        String dateString = (String)entry.getKey();
                        Holiday holiday = new Holiday(dateString, holidayDetail = (Map)entry.getValue(), endWorkTimeAm);
                        if (holiday.isHalfDay() && StringUtils.isBlank((CharSequence)holiday.getWorkTimeBegin())) {
                            holiday.setWorkTimeBegin(beginWorkTimeAm);
                            holiday.setWorkTimeEnd(endWorkTimeAm);
                            holiday.setAmWork(true);
                            holiday.setPmWork(false);
                        }
                        holidays.add(holiday);
                    }
                }
                holidayMap = holidays.stream().collect(Collectors.toMap(Holiday::getDate, p -> p));
            }
        }
        for (int i = 1; i <= days; ++i) {
            int index = model.createNewEntryRow("dateentry");
            model.setValue("level", (Object)SscLevelType.SSCCENTER.getValue(), index);
            model.setValue("ssc", this.getParamFrom().get("ssccenterid"), index);
            String dateString = DateUtil.format((Object)fromAndToDate[this.fromDateIndex].getTime(), (String)"yyy-MM-dd");
            model.setValue("date", (Object)dateString, index);
            Holiday holiday = (Holiday)holidayMap.get(dateString);
            if (holiday != null) {
                boolean isHalfDay = holiday.isHalfDay();
                if (!isHalfDay) {
                    model.setValue("datetype", (Object)SscDateType.HOLIDAY.getValue(), index);
                } else {
                    String halfType = holiday.isAmWork() ? SscDateType.HALFWORKDATEAM.getValue() : SscDateType.HALFWORKDATEPM.getValue();
                    model.setValue("datetype", (Object)halfType, index);
                }
            } else if (isRestDay[fromAndToDate[this.fromDateIndex].get(7) - 1]) {
                model.setValue("datetype", (Object)SscDateType.RESTDATE.getValue(), index);
            } else if (isHalfWorkDayAm[fromAndToDate[this.fromDateIndex].get(7) - 1]) {
                model.setValue("datetype", (Object)SscDateType.HALFWORKDATEAM.getValue(), index);
            } else if (isHalfWorkDayPm[fromAndToDate[this.fromDateIndex].get(7) - 1]) {
                model.setValue("datetype", (Object)SscDateType.HALFWORKDATEPM.getValue(), index);
            } else {
                model.setValue("datetype", (Object)SscDateType.WORKDATE.getValue(), index);
            }
            model.setEntryCurrentRowIndex("dateentry", index);
            DynamicObjectCollection subRowObjs = model.getEntryEntity("timeentry");
            int subIndex = 0;
            if (subRowObjs != null && subRowObjs.size() > 0) {
                subIndex = subRowObjs.size();
            }
            model.createNewEntryRow("timeentry");
            model.setValue("timetype", (Object)SscTimeType.WORKTIME.getValue(), subIndex);
            if (holiday != null && holiday.isHalfDay()) {
                if (holiday.isAmWork()) {
                    model.setValue("begintimeam", (Object)holiday.getWorkTimeBegin(), subIndex);
                    model.setValue("endtimeam", (Object)holiday.getWorkTimeEnd(), subIndex);
                    model.setValue("begintimepm", (Object)beginWorkTimePm, subIndex);
                    model.setValue("endtimepm", (Object)endWorkTimePm, subIndex);
                } else {
                    model.setValue("begintimeam", (Object)beginWorkTimeAm, subIndex);
                    model.setValue("endtimeam", (Object)endWorkTimeAm, subIndex);
                    model.setValue("begintimepm", (Object)holiday.getWorkTimeBegin(), subIndex);
                    model.setValue("endtimepm", (Object)holiday.getWorkTimeEnd(), subIndex);
                }
            } else {
                model.setValue("begintimeam", (Object)beginWorkTimeAm, subIndex);
                model.setValue("endtimeam", (Object)endWorkTimeAm, subIndex);
                model.setValue("begintimepm", (Object)beginWorkTimePm, subIndex);
                model.setValue("endtimepm", (Object)endWorkTimePm, subIndex);
            }
            fromAndToDate[this.fromDateIndex].add(5, 1);
        }
    }

    private Calendar[] getFromAndToDate() {
        Calendar[] fromAndToDate = new Calendar[2];
        IDataModel model = this.getModel();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int dayFrom = obj.getInt("expiringdayfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        int dayTo = obj.getInt("expiringdayto");
        Calendar curDate = Calendar.getInstance();
        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 0, 0, 0);
        curDate.set(14, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, dayFrom, 0, 0, 0);
        boolean init = (Boolean)this.getParamFrom().get("init");
        if (!init && curDate.after(fromDate)) {
            fromDate.setTime(curDate.getTime());
        }
        fromDate.set(14, 0);
        fromAndToDate[this.fromDateIndex] = fromDate;
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, dayTo, 0, 0, 0);
        toDate.set(14, 0);
        fromAndToDate[this.toDateIndex] = toDate;
        return fromAndToDate;
    }

    private int removeDuplicateRecord(Calendar fromDate, Calendar toDate) {
        SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
        int count = 0;
        Date datestart = null;
        Date dateend = null;
        try {
            datestart = SDF.parse(SDF.format(fromDate.getTime()));
            dateend = SDF.parse(SDF.format(toDate.getTime()));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return 0;
        }
        Object ssccenterid = this.getParamFrom().get("ssccenterid");
        QFilter filters = new QFilter("ssccenter", "=", (Object)Long.parseLong(ssccenterid + ""));
        filters.and("dateentry.date", ">=", (Object)datestart);
        filters.and("dateentry.date", "<=", (Object)dateend);
        filters.and("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue());
        Map<String, Object> dynamicObjectTypes = SscWorkCalendarLoadService.getDynamicObjectType(datestart, dateend, (String)ssccenterid);
        List ids = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters}).stream().map(id -> id.get("dateentry.id")).collect(Collectors.toList());
        if (ids.size() > 0 || dynamicObjectTypes != null) {
            count = ids.size();
            DeleteServiceHelper.delete((IDataEntityType)((DynamicObjectType)dynamicObjectTypes.get("dateEntryType")), (Object[])ids.toArray());
        }
        return count;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDaysAm(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrestam"), obj.getBoolean("ishalfmonrestam"), obj.getBoolean("ishalftuerestam"), obj.getBoolean("ishalfwedrestam"), obj.getBoolean("ishalfthurestam"), obj.getBoolean("ishalffrirestam"), obj.getBoolean("ishalfsatrestam")};
        return isHalfWorkDay;
    }

    private boolean[] getHalfWorkDaysPm(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrestpm"), obj.getBoolean("ishalfmonrestpm"), obj.getBoolean("ishalftuerestpm"), obj.getBoolean("ishalfwedrestpm"), obj.getBoolean("ishalfthurestpm"), obj.getBoolean("ishalffrirestpm"), obj.getBoolean("ishalfsatrestpm")};
        return isHalfWorkDay;
    }

    private Map<String, Object> getParamFrom() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map map = showParameter.getCustomParams();
        return map;
    }

    private void synchroData(String ssc) {
        List<String> groups = SscWorkCalendarLoadService.getGroup(ssc);
        Calendar[] fromAndToDate = this.getFromAndToDate();
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            for (Date[] eachYear : this.getEachYear(fromAndToDate)) {
                groups.forEach(group -> pub.publish((Object)new WorkCalendarTaskMessage(ssc, (String)group, SscWorkCalendarLoadService.getUserIdList(group), eachYear[0], eachYear[1], "ssc")));
            }
        }
    }

    private List<Date[]> getEachYear(Calendar[] fromAndToDate) {
        int startYear = fromAndToDate[this.fromDateIndex].get(1);
        int endYear = fromAndToDate[this.toDateIndex].get(1);
        ArrayList<Date[]> eachYears = new ArrayList<Date[]>(10);
        for (int year = startYear; year <= endYear; ++year) {
            Date[] dates = new Date[2];
            Calendar calendar = Calendar.getInstance();
            if (year == startYear) {
                calendar.setTime(fromAndToDate[this.fromDateIndex].getTime());
            } else {
                calendar.clear();
            }
            calendar.set(1, year);
            dates[0] = calendar.getTime();
            calendar = Calendar.getInstance();
            if (year == endYear) {
                calendar.setTime(fromAndToDate[this.toDateIndex].getTime());
            } else {
                calendar.clear();
                calendar.set(1, year);
                calendar.roll(6, -1);
            }
            dates[1] = calendar.getTime();
            eachYears.add(dates);
        }
        return eachYears;
    }
}

