/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.workcalendar.SscDateType;
import kd.ssc.enums.workcalendar.SscLevelType;
import kd.ssc.enums.workcalendar.SscTimeType;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;
import kd.ssc.task.formplugin.util.SscWorkCalendarLoadService;
import kd.ssc.task.formplugin.util.SscWorkCalendarUtil;
import kd.ssc.task.util.DateUtil;

public class SscWorkCalendarGroupSettingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String saveFlag = "saveFlag";
    private static final Log log = LogFactory.getLog(SscWorkCalendarGroupSettingPlugin.class);
    private boolean isUpdate = true;
    private static final String CONFIRM_BATCH_SETTING = "confirmBatchSetting";

    public void initialize() {
        super.initialize();
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String userGorup = (String)parameter.getCustomParam("groupId");
        this.getModel().setValue("usergroup", (Object)new Long[]{Long.parseLong(userGorup)});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("confirm".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            Map<String, Object> panelData = this.getPanelData();
            if (panelData == null) {
                return;
            }
            this.batchSetUserGropWorkCalendar();
        }
    }

    private void batchSetUserGropWorkCalendar() {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_BATCH_SETTING, (IFormPlugin)this);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5bf9\u201c%s\u201d\u8bbe\u7f6e\u5de5\u4f5c\u65e5\u5386\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8bbe\u7f6e\u5417\uff1f", (String)"SscWorkCalendarUserSettingPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]), this.getUserGroupName()), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private String getUserGroupName() {
        IDataModel model = this.getModel();
        DynamicObjectCollection userGroupList = (DynamicObjectCollection)model.getValue("usergroup");
        if (CollectionUtils.isEmpty((Collection)userGroupList)) {
            return "";
        }
        StringBuilder targetUserGroupNameStr = new StringBuilder();
        for (DynamicObject targetUserGroup : userGroupList) {
            String targetUserGroupName = targetUserGroup.getDynamicObject("fbasedataid").getString("name");
            targetUserGroupNameStr.append(targetUserGroupName).append("\u3001");
        }
        return targetUserGroupNameStr.substring(0, targetUserGroupNameStr.length() - 1);
    }

    private void batchSetUserGroupWorkCalendar() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String ssc = (String)parameter.getCustomParam("ssccenterid");
        Map<String, Object> panelData = this.getPanelData();
        if (panelData == null || this.getPageCache().get(saveFlag) == null) {
            return;
        }
        panelData.put("ssc", ssc);
        try {
            String panelDataJson = CollectionUtils.isEmpty(panelData) ? "" : JSONObject.toJSONString(panelData);
            log.info("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6estart: panelData = {}", (Object)panelDataJson);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386\u5c55\u793a\u6570\u636e-\u6279\u91cf\u8bbe\u7f6e\uff0c\u53c2\u6570\u65e5\u5fd7\u6253\u5370\u5f02\u5e38", (Throwable)e);
        }
        QFilter filters = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(ssc));
        filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        filters.and(new QFilter("dateentry.date", ">=", panelData.get("startworkdate")));
        filters.and(new QFilter("dateentry.date", "<=", panelData.get("endworkdate")));
        HashSet workCalendarIds = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"ssc_workcalendarsetting", (QFilter[])new QFilter[]{filters}, null, (int)-1));
        DynamicObject[] workCalendars = BusinessDataServiceHelper.load((Object[])workCalendarIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_workcalendarsetting"));
        DynamicObjectCollection dateentrys = workCalendars[0].getDynamicObjectCollection("dateentry");
        DynamicObjectType dateEntryType = dateentrys.getDynamicObjectType();
        DynamicObjectCollection timeentrys = ((DynamicObject)dateentrys.get(0)).getDynamicObjectCollection("timeentry");
        DynamicObjectType timeEntryType = timeentrys.getDynamicObjectType();
        List userGroupIdList = (List)panelData.get("usergroup");
        QFilter filters1 = new QFilter("dateentry.ssc", "=", (Object)Long.parseLong(ssc));
        filters1.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        filters1.and(new QFilter("dateentry.date", ">=", panelData.get("startworkdate")));
        filters1.and(new QFilter("dateentry.date", "<=", panelData.get("endworkdate")));
        filters1.and(new QFilter("dateentry.usergroup", "in", (Object)userGroupIdList));
        List dateEntryIds = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"dateentry.id", (QFilter[])new QFilter[]{filters1}).stream().map(id -> id.getLong("dateentry.id")).collect(Collectors.toList());
        if (dateEntryIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)dateEntryType, (Object[])dateEntryIds.toArray());
        }
        HashMap<Long, Map> userGroupDateEntryMap = new HashMap<Long, Map>(16);
        for (Object userGroupId : userGroupIdList) {
            List<Date> dates = SscWorkCalendarUtil.findDates((Date)panelData.get("startworkdate"), (Date)panelData.get("endworkdate"));
            for (Date date : dates) {
                panelData.put("date", date);
                DynamicObject dateEntry = this.createNewDateEntry(dateEntryType, panelData, userGroupId + "");
                DynamicObjectCollection timeEntrys = dateEntry.getDynamicObjectCollection("timeentry");
                DynamicObject timeEntry = this.createNewTimeEntry(timeEntryType, panelData);
                timeEntrys.add((Object)timeEntry);
                userGroupDateEntryMap.computeIfAbsent((Long)userGroupId, p -> new HashMap(16)).put(date.getTime(), dateEntry);
            }
        }
        DynamicObjectCollection dayObjs = QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.date", (QFilter[])new QFilter[]{filters});
        for (Object userGroupId : userGroupIdList) {
            Map dateEntryMap = (Map)userGroupDateEntryMap.get(userGroupId);
            for (DynamicObject workCalendar : workCalendars) {
                DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("dateentry");
                for (DynamicObject dayObj : dayObjs) {
                    if (!workCalendar.getPkValue().equals(dayObj.get("id"))) continue;
                    Date dateEntryDate = dayObj.getDate("dateentry.date");
                    DynamicObject dateEntry = (DynamicObject)dateEntryMap.get(dateEntryDate.getTime());
                    dateEntrys.add((Object)dateEntry);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])workCalendars);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SscWorkCalendarBasePlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.isUpdate = false;
        this.getView().getParentView().setReturnData((Object)"refreshData");
        this.getView().close();
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            for (Long userGorupId : userGroupIdList) {
                pub.publish((Object)new WorkCalendarTaskMessage(ssc, userGorupId + "", SscWorkCalendarLoadService.getUserIdList(userGorupId + ""), (Date)panelData.get("startworkdate"), (Date)panelData.get("endworkdate"), "usergroup"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "startworkdate": 
            case "endworkdate": {
                Date startworkdate = null;
                Date endworkdate = null;
                if (this.getModel().getValue("startworkdate") != null) {
                    startworkdate = (Date)this.getModel().getValue("startworkdate");
                }
                if (this.getModel().getValue("endworkdate") != null) {
                    endworkdate = (Date)this.getModel().getValue("endworkdate");
                }
                if (startworkdate == null || endworkdate == null) {
                    return;
                }
                this.validateDate(startworkdate, endworkdate);
            }
        }
        if ("issunrest".equals(prop) || "ishalfsunrestam".equals(prop) || "ishalfsunrestpm".equals(prop)) {
            this.verification("issunrest", "ishalfsunrestam", "ishalfsunrestpm");
        } else if ("ismonrest".equals(prop) || "ishalfmonrestam".equals(prop) || "ishalfmonrestpm".equals(prop)) {
            this.verification("ismonrest", "ishalfmonrestam", "ishalfmonrestpm");
        } else if ("istuerest".equals(prop) || "ishalftuerestam".equals(prop) || "ishalftuerestpm".equals(prop)) {
            this.verification("istuerest", "ishalftuerestam", "ishalftuerestpm");
        } else if ("iswedrest".equals(prop) || "ishalfwedrestam".equals(prop) || "ishalfwedrestpm".equals(prop)) {
            this.verification("iswedrest", "ishalfwedrestam", "ishalfwedrestpm");
        } else if ("isthurest".equals(prop) || "ishalfthurestam".equals(prop) || "ishalfthurestpm".equals(prop)) {
            this.verification("isthurest", "ishalfthurestam", "ishalfthurestpm");
        } else if ("isfrirest".equals(prop) || "ishalffrirestam".equals(prop) || "ishalffrirestpm".equals(prop)) {
            this.verification("isfrirest", "ishalffrirestam", "ishalffrirestpm");
        } else if ("issatrest".equals(prop) || "ishalfsatrestam".equals(prop) || "ishalfsatrestpm".equals(prop)) {
            this.verification("issatrest", "ishalfsatrestam", "ishalfsatrestpm");
        }
    }

    private void verification(String allDay, String amDay, String pmDay) {
        boolean am = (Boolean)this.getModel().getValue(amDay);
        boolean pm = (Boolean)this.getModel().getValue(pmDay);
        Boolean rest = (Boolean)this.getModel().getValue(allDay);
        if (rest.booleanValue() && (am || pm)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"SscWorkCalendarEntityPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (am && pm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u534a\u5de5\u4f5c\u65e5\u201d\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u4e0a\u5348\u548c\u4e0b\u5348\u3002", (String)"SscWorkCalendarEntityPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged() && this.isUpdate) {
            ConfirmCallBackListener close = new ConfirmCallBackListener("exit");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"SscWorkCalendarGroupSettingPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, close);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if ("exit".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.isUpdate = false;
            this.getView().close();
        } else if (CONFIRM_BATCH_SETTING.equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.batchSetUserGroupWorkCalendar();
        }
    }

    private Map<String, Object> getPanelData() {
        IDataModel model = this.getModel();
        HashMap<String, Object> paneldata = new HashMap<String, Object>(16);
        Object startworkdate = model.getValue("startworkdate");
        Object endworkdate = model.getValue("endworkdate");
        DynamicObjectCollection userGroupDynList = (DynamicObjectCollection)model.getValue("usergroup");
        if (startworkdate == null || endworkdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6709\u6548\u671f\u95f4\u3002", (String)"SscWorkCalendarGroupSettingPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (userGroupDynList == null || userGroupDynList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u6237\u7ec4\u3002", (String)"SscWorkCalendarGroupSettingPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        ArrayList<Long> userGroupIdList = new ArrayList<Long>();
        for (DynamicObject obj : userGroupDynList) {
            DynamicObject baseDataObj = obj.getDynamicObject("fbasedataid");
            userGroupIdList.add((Long)baseDataObj.getPkValue());
        }
        paneldata.put("usergroup", userGroupIdList);
        try {
            Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            if (((Date)startworkdate).getTime() < now.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"SscWorkCalendarGroupSettingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return null;
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return null;
        }
        paneldata.put("startworkdate", startworkdate);
        paneldata.put("endworkdate", endworkdate);
        int morningstarttime = (Integer)model.getValue("morning_starttime");
        int morningendtime = (Integer)model.getValue("morning_endtime");
        int afternoonstarttime = (Integer)model.getValue("afternoon_starttime");
        int afternoonendtime = (Integer)model.getValue("afternoon_endtime");
        if (morningstarttime < 0 || morningendtime < 0 || afternoonstarttime < 0 || afternoonendtime < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"SscWorkCalendarGroupSettingPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (morningstarttime == morningendtime || afternoonstarttime == afternoonendtime) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u76f8\u540c\u3002", (String)"SscWorkCalendarGroupSettingPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (morningendtime > afternoonstarttime) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u5348\u5de5\u4f5c\u65f6\u95f4\u5e94\u8bbe\u7f6e\u5728\u4e0a\u5348\u5de5\u4f5c\u65f6\u95f4\u4e4b\u540e\u3002", (String)"SscWorkCalendarGroupSettingPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return null;
        }
        paneldata.put("morning_starttime", SscWorkCalendarUtil.getTimeShow(morningstarttime));
        paneldata.put("morning_endtime", SscWorkCalendarUtil.getTimeShow(morningendtime));
        paneldata.put("afternoon_starttime", SscWorkCalendarUtil.getTimeShow(afternoonstarttime));
        paneldata.put("afternoon_endtime", SscWorkCalendarUtil.getTimeShow(afternoonendtime));
        boolean validate = this.dateExclusionValidate(paneldata);
        if (!validate) {
            return null;
        }
        return paneldata;
    }

    private void validateDate(Date startdate, Date enddate) {
        try {
            Date now = DateUtil.parse((String)DateUtil.format((Object)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            if (startdate.getTime() < now.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"SscWorkCalendarGroupSettingPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return;
        }
        String sscid = (String)this.getView().getFormShowParameter().getCustomParam("ssccenterid");
        Set<Date> selectDates = SscWorkCalendarLoadService.validateDateCalendar(sscid, startdate, enddate);
        if (selectDates.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u65e5\u671f\u5728\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\u4e2d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"SscWorkCalendarGroupSettingPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("startworkdate", null);
            this.getModel().setValue("endworkdate", null);
            this.getPageCache().put(saveFlag, null);
        } else {
            this.getPageCache().put(saveFlag, "1");
        }
    }

    private DynamicObject createNewDateEntry(DynamicObjectType dateEntryType, Map<String, Object> panelData, String userGroupId) {
        DynamicObject dateEntry = new DynamicObject(dateEntryType);
        dateEntry.set("ssc", panelData.get("ssc"));
        dateEntry.set("usergroup", (Object)userGroupId);
        dateEntry.set("level", (Object)SscLevelType.GROUP.getValue());
        dateEntry.set("date", panelData.get("date"));
        this.setDateType(dateEntry, panelData);
        return dateEntry;
    }

    private DynamicObject createNewTimeEntry(DynamicObjectType timeEntryType, Map<String, Object> panelData) {
        DynamicObject timeEntry = new DynamicObject(timeEntryType);
        timeEntry.set("timeType", (Object)SscTimeType.WORKTIME.getValue());
        timeEntry.set("begintimeam", panelData.get("morning_starttime"));
        timeEntry.set("begintimepm", panelData.get("afternoon_starttime"));
        timeEntry.set("endtimeam", panelData.get("morning_endtime"));
        timeEntry.set("endtimepm", panelData.get("afternoon_endtime"));
        return timeEntry;
    }

    private void setDateType(DynamicObject dateEntry, Map<String, Object> panelData) {
        Date date = (Date)panelData.get("date");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        boolean[] isRestDay = (boolean[])panelData.get("isRestDay");
        if (isRestDay[calendar.get(7) - 1]) {
            dateEntry.set("datetype", (Object)SscDateType.RESTDATE.getValue());
            return;
        }
        boolean[] isHalfWorkDayAm = (boolean[])panelData.get("isHalfWorkDayAm");
        if (isHalfWorkDayAm[calendar.get(7) - 1]) {
            dateEntry.set("datetype", (Object)SscDateType.HALFWORKDATEAM.getValue());
            return;
        }
        boolean[] isHalfWorkDayPm = (boolean[])panelData.get("isHalfWorkDayPm");
        if (isHalfWorkDayPm[calendar.get(7) - 1]) {
            dateEntry.set("datetype", (Object)SscDateType.HALFWORKDATEPM.getValue());
            return;
        }
        dateEntry.set("datetype", (Object)SscDateType.WORKDATE.getValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit targetUserGroup = (BasedataEdit)this.getView().getControl("usergroup");
        targetUserGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)"usergroup", (CharSequence)name)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String sscId = (String)parameter.getCustomParam("ssccenterid");
            QFilter qFilter = new QFilter("createorg", "=", (Object)Long.parseLong(sscId));
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private boolean dateExclusionValidate(Map<String, Object> paneldata) {
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        boolean[] isHalfWorkDayAm = this.getHalfWorkDaysAm(this.getModel());
        boolean[] isHalfWorkDayPm = this.getHalfWorkDaysPm(this.getModel());
        paneldata.put("isRestDay", isRestDay);
        paneldata.put("isHalfWorkDayAm", isHalfWorkDayAm);
        paneldata.put("isHalfWorkDayPm", isHalfWorkDayPm);
        if (isRestDay.length != isHalfWorkDayAm.length || isRestDay.length != isHalfWorkDayPm.length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (isRestDay[i] && isHalfWorkDayAm[i] || isRestDay[i] && isHalfWorkDayPm[i]) {
                result = false;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"SscWorkCalendarEntityPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                break;
            }
            if (!isHalfWorkDayAm[i] || !isHalfWorkDayPm[i]) continue;
            result = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u534a\u5de5\u4f5c\u65e5\u201d\u4e0d\u80fd\u540c\u65f6\u52fe\u9009\u4e0a\u5348\u548c\u4e0b\u5348\u3002", (String)"SscWorkCalendarEntityPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDaysAm(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrestam"), obj.getBoolean("ishalfmonrestam"), obj.getBoolean("ishalftuerestam"), obj.getBoolean("ishalfwedrestam"), obj.getBoolean("ishalfthurestam"), obj.getBoolean("ishalffrirestam"), obj.getBoolean("ishalfsatrestam")};
        return isHalfWorkDay;
    }

    private boolean[] getHalfWorkDaysPm(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrestpm"), obj.getBoolean("ishalfmonrestpm"), obj.getBoolean("ishalftuerestpm"), obj.getBoolean("ishalfwedrestpm"), obj.getBoolean("ishalfthurestpm"), obj.getBoolean("ishalffrirestpm"), obj.getBoolean("ishalfsatrestpm")};
        return isHalfWorkDay;
    }
}

