/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.enums.workcalendar.SscTimeOp;
import kd.ssc.task.common.workcalendar.WorkCalendarServiceHelper;
import kd.ssc.task.formplugin.pojo.workcalendar.WorkCalendarTaskMessage;

public class SscWorkCalendarUserSyncProcess
implements Runnable {
    private static final Log log = LogFactory.getLog(SscWorkCalendarUserSyncProcess.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String taskId;
    private String sscId;
    private Map<String, Object> panelData;
    private String offFlag;
    private String overFlag;
    private List<Long> userIds;

    public SscWorkCalendarUserSyncProcess(String taskId, String sscId, Map<String, Object> panelData, String offFlag, String overFlag, List<Long> userIds) {
        this.taskId = taskId;
        this.sscId = sscId;
        this.panelData = panelData;
        this.offFlag = offFlag;
        this.overFlag = overFlag;
        this.userIds = userIds;
    }

    public SscWorkCalendarUserSyncProcess() {
    }

    @Override
    public void run() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            SscWorkCalendarUserSyncProcess.setInterruption(this.taskId, true);
            log.error("sync date error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            SscDistributeCache.remove((String)"work_calendar_sync_other_group");
        }
    }

    private void doExecute() throws ParseException {
        log.info("update runtime data begin taskId = " + this.taskId);
        Map<Long, List<Long>> userIdAndUserGroupMap = WorkCalendarServiceHelper.batchQueryUserGroupIdByUseId(this.userIds, Long.parseLong(this.sscId));
        SscDistributeCache.put((String)"work_calendar_sync_other_group", (Object)this.sscId);
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.ssc_workcalendar_queue");){
            int totalIterations = this.getTotalIterations(userIdAndUserGroupMap);
            int currentIteration = 0;
            int progress = 0;
            for (Map.Entry<Long, List<Long>> entry : userIdAndUserGroupMap.entrySet()) {
                Long userId = entry.getKey();
                List<Long> userGroupIds = entry.getValue();
                for (Long userGroupId : userGroupIds) {
                    progress = (int)((double)currentIteration / (double)totalIterations * 100.0);
                    SscWorkCalendarUserSyncProcess.setProgress(this.taskId, progress);
                    this.syncSetting(userId, userGroupId, pub);
                    ++currentIteration;
                }
            }
        }
        SscWorkCalendarUserSyncProcess.setProgress(this.taskId, 100);
        log.info("update runtime data end taskId = " + this.taskId);
    }

    private int getTotalIterations(Map<Long, List<Long>> userIdAndUserGroupMap) {
        Collection<List<Long>> values = userIdAndUserGroupMap.values();
        int totalSize = 0;
        for (List<Long> value : values) {
            totalSize += value.size();
        }
        return totalSize;
    }

    public static int getProgress(String taskId) {
        String progress = (String)CACHE.get(SscWorkCalendarUserSyncProcess.buildCacheType(taskId), "progress");
        return StringUtils.isBlank((CharSequence)progress) ? 0 : Integer.parseInt(progress);
    }

    public static void setProgress(String taskId, int progress) {
        CACHE.put(SscWorkCalendarUserSyncProcess.buildCacheType(taskId), "progress", (Object)String.valueOf(progress));
    }

    public static boolean isInterruption(String taskId) {
        String interruption = (String)CACHE.get(SscWorkCalendarUserSyncProcess.buildCacheType(taskId), "interruption");
        return !StringUtils.isBlank((CharSequence)interruption) && Boolean.parseBoolean(interruption);
    }

    public static void setInterruption(String taskId, boolean interruption) {
        CACHE.put(SscWorkCalendarUserSyncProcess.buildCacheType(taskId), "interruption", (Object)String.valueOf(interruption));
    }

    private static String buildCacheType(String taskId) {
        return "SscWorkCalendarUserSyncProcess_" + taskId;
    }

    private void syncSetting(Long userId, Long userGroupId, MessagePublisher pub) throws ParseException {
        if (StringUtils.isNotEmpty((CharSequence)this.offFlag)) {
            String offStartDateStr = (String)this.panelData.get("offstartdate");
            String offEndDateStr = (String)this.panelData.get("offenddate");
            if (StringUtils.isNotEmpty((CharSequence)offStartDateStr) && StringUtils.isNotEmpty((CharSequence)offEndDateStr)) {
                Date offStartDate = this.dateFormat.parse(offStartDateStr);
                Date offEndDate = this.dateFormat.parse(offEndDateStr);
                String offStartTime = (String)this.panelData.get("offstarttime");
                String offEndTime = (String)this.panelData.get("offendtime");
                WorkCalendarServiceHelper.askForLeaveAndCancel(Long.parseLong(this.sscId), userGroupId, Collections.singletonList(userId), offStartDate, offStartTime, offEndDate, offEndTime, SscTimeOp.ASKFORLEAVE);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.overFlag)) {
            String overworkStartDateStr = (String)this.panelData.get("overworkstartdate");
            String overworkEndDateStr = (String)this.panelData.get("overworkenddate");
            if (StringUtils.isNotEmpty((CharSequence)overworkStartDateStr) && StringUtils.isNotEmpty((CharSequence)overworkEndDateStr)) {
                Date overworkStartDate = this.dateFormat.parse(overworkStartDateStr);
                Date overworkEndDate = this.dateFormat.parse(overworkEndDateStr);
                String overworkTimeStart = (String)this.panelData.get("overworktimestart");
                String overworkTimeEnd = (String)this.panelData.get("overworktimeend");
                String timeInterval = StringUtils.join((Object[])new String[]{overworkTimeStart, "-", overworkTimeEnd});
                List<String> timeIntervals = Collections.singletonList(timeInterval);
                WorkCalendarServiceHelper.saveDb(Long.parseLong(this.sscId), userGroupId, Collections.singletonList(userId), overworkStartDate, overworkEndDate, SscTimeOp.OVERTIME, timeIntervals);
                pub.publish((Object)new WorkCalendarTaskMessage(this.sscId, String.valueOf(userGroupId), Collections.singletonList(userId), overworkStartDate, overworkEndDate, "user"));
            }
        }
    }
}

