/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.servicehelper.MetadataServiceHelper;

public class CreditScoreFuncFormPlugin
extends AbstractFuncParamPlugIn {
    private static final String EMPLOYEE = "employee";
    private static final String METADATA_BOS_USER = "bos_user";

    public void afterCreateNewData(EventObject e) {
        MainEntityType srcMainET = MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber());
        if (srcMainET == null) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(EMPLOYEE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        Map allEntities = srcMainET.getAllEntities();
        for (EntityType entityType : allEntities.values()) {
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                ComboItem item;
                BasedataProp prop;
                if (!(property instanceof BasedataProp) || !METADATA_BOS_USER.equals((prop = (BasedataProp)property).getBaseEntityId())) continue;
                IDataEntityType parent = prop.getParent();
                if (parent == null) {
                    item = new ComboItem(prop.getDisplayName(), prop.getName());
                    items.add(item);
                    continue;
                }
                item = new ComboItem(new LocaleString(parent.getDisplayName() + "." + prop.getDisplayName()), prop.getName());
                items.add(item);
            }
        }
        comboEdit.setComboItems(items);
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String employee = (String)this.getModel().getValue(EMPLOYEE);
        if (StringUtils.isBlank((CharSequence)employee)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5458\u5de5\u3002", (String)"CreditScoreFuncFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        String employee = (String)this.getModel().getValue(EMPLOYEE);
        return String.format("%s(%s.id)", this.getFuncId(), employee);
    }
}

