/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.ssc.task.monitor.TaskUserUser;
import kd.ssc.task.monitor.TaskUserUsers;

public class MonitorAuthorizeFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String IN_TASK_TYPE = "intasktype";
    private static final String TASK_TYPE = "tasktype";
    private static final String IN_TASK_BILL = "intaskbill";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String TASK_BILL = "taskbill";
    private static final String FILTER = "filter";
    private static final String CONDITION = "condition";
    private static final String ASSIGNEE = "assignee";
    static final String SEL_TASK_USER = "seltaskuser_tag";
    static final String SSC_AUTH_F7 = "ssc_auth_f7";
    private static final String OP_NEW_ENTRY = "newentry";
    private static final String OP_COPY_ENTRY = "copyentryrow";
    private static final String CACHE_CUR_ROW = "cur_row";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONDITION});
        ((AbstractGrid)this.getControl(ENTRY_ENTITY)).addRowClickListener((RowClickEventListener)this);
        ((BasedataEdit)this.getControl(ASSIGNEE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(TASK_BILL)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl(TASK_TYPE)).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        Long scenarioDefId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("scenariodef") + "");
        this.getModel().setValue("ssc", (Object)Long.parseLong(this.getView().getFormShowParameter().getCustomParam("ssc") + ""));
        this.getModel().setValue("scenariodef", (Object)scenarioDefId);
        this.setControlState(TASK_TYPE, this.getModel().getDataEntity().getBoolean(IN_TASK_TYPE));
        this.setControlState(TASK_BILL, this.getModel().getDataEntity().getBoolean(IN_TASK_BILL));
        this.setControlState(CONDITION, null, this.getModel().getDataEntity().getBoolean(IN_TASK_BILL));
        this.setConditionEnable();
        this.getModel().setDataChanged(false);
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put(CACHE_CUR_ROW, evt.getRow() + "");
    }

    public void click(EventObject evt) {
        Object taskBill;
        int row;
        String rowStr;
        Control e = (Control)evt.getSource();
        String key = e.getKey();
        if (CONDITION.equals(key) && (rowStr = this.getPageCache().get(CACHE_CUR_ROW)) != null && (row = Integer.parseInt(rowStr)) >= 0 && (taskBill = this.getModel().getValue(TASK_BILL, row)) != null) {
            this.openNonModal((String)this.getModel().getValue(FILTER, row));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (IN_TASK_TYPE.equals(name)) {
            this.setControlState(TASK_TYPE, (Boolean)newValue);
        } else if (IN_TASK_BILL.equals(name)) {
            this.setControlState(TASK_BILL, (Boolean)newValue);
            this.setControlState(CONDITION, false, (Boolean)newValue);
            this.setConditionEnable();
        } else if (TASK_BILL.equals(name)) {
            int rowIndex = Integer.parseInt(this.getPageCache().get(CACHE_CUR_ROW));
            boolean valueAndVisible = newValue != null && !this.getView().getControl(name).isInvisible();
            this.getView().setEnable(Boolean.valueOf(valueAndVisible), changeData.getRowIndex(), new String[]{CONDITION});
            this.getModel().setValue(FILTER, null, rowIndex);
            this.getModel().setValue(CONDITION, null, rowIndex);
        } else if (CONDITION.equals(name)) {
            int rowIndex = Integer.parseInt(this.getPageCache().get(CACHE_CUR_ROW));
            String conditionValue = (String)newValue;
            if (StringUtils.isEmpty((String)conditionValue)) {
                this.getModel().setValue(FILTER, null, rowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OP_NEW_ENTRY.equals(operateKey) || OP_COPY_ENTRY.equals(operateKey)) {
            this.setConditionEnable();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (CONDITION.equals(closedCallBackEvent.getActionId())) {
            int rowIndex = Integer.parseInt(this.getPageCache().get(CACHE_CUR_ROW));
            Map ret = (Map)returnData;
            if (ret.size() == 0) {
                this.getModel().setValue(CONDITION, null, rowIndex);
                this.getModel().setValue(FILTER, null, rowIndex);
                return;
            }
            this.getModel().setValue(CONDITION, ret.get(CONDITION), rowIndex);
            this.getModel().setValue(FILTER, ret.get(FILTER), rowIndex);
        } else if (ASSIGNEE.equals(closedCallBackEvent.getActionId())) {
            String selectStr = (String)returnData;
            List<TaskUserUser> taskUserUsers = TaskUserUsers.fromJsonString(selectStr);
            if (!taskUserUsers.isEmpty()) {
                Object[] userIds = taskUserUsers.stream().map(TaskUserUser::getU).distinct().toArray();
                this.getModel().setValue(ASSIGNEE, (Object)userIds);
                this.getModel().setValue(SEL_TASK_USER, (Object)selectStr);
            } else {
                this.getModel().setValue(ASSIGNEE, null);
                this.getModel().setValue(SEL_TASK_USER, (Object)"");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        long ssc = (Long)((DynamicObject)this.getModel().getValue("ssc")).getPkValue();
        if (ASSIGNEE.equals(name)) {
            evt.setCancel(true);
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("treeusergroup_listf7");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ASSIGNEE);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setLookUp(true);
            showParameter.setCustomParam(SSC_AUTH_F7, ((DynamicObject)this.getModel().getValue("ssc")).get("id"));
            showParameter.setCaption(ResManager.loadKDString((String)"\u4f7f\u7528\u4eba", (String)"MonitorAuthorizeFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam(SEL_TASK_USER, this.getModel().getValue(SEL_TASK_USER));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (TASK_TYPE.equals(name)) {
            evt.addCustomQFilter(new QFilter("orgfield", "=", (Object)ssc));
        } else if (TASK_BILL.equals(name)) {
            evt.addCustomQFilter(new QFilter("ssccenter", "=", (Object)ssc));
        }
    }

    private void openNonModal(String filter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_authorize_filter");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(FILTER, (Object)filter);
        String formNumber = ((DynamicObject)this.getModel().getValue(TASK_BILL, 0)).getString("bindbill.number");
        showParameter.setCustomParam("form_number", (Object)formNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CONDITION);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u6761\u4ef6", (String)"MonitorAuthorizeFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void setConditionEnable() {
        boolean b = this.getModel().getDataEntity().getBoolean(IN_TASK_BILL);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(b && null != ((DynamicObject)entryEntity.get(i)).get(TASK_BILL)), i, new String[]{CONDITION});
        }
    }

    private void setControlState(String name, boolean state) {
        this.setControlState(name, state, state);
    }

    private void setControlState(String name, Boolean mustInput, boolean visible) {
        FieldEdit control = (FieldEdit)this.getView().getControl(name);
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{name});
        if (mustInput != null) {
            control.setMustInput(mustInput.booleanValue());
            IDataEntityProperty property = control.getProperty();
            if (property instanceof BasedataProp) {
                ((BasedataProp)property).setMustInput(mustInput.booleanValue());
            }
        }
    }
}

