/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.task.monitor.TaskUserUser;
import kd.ssc.task.monitor.TaskUserUsers;
import org.apache.commons.lang3.StringUtils;

public class MonitorUserGroupF7ListPlugin
extends AbstractFormPlugin
implements ListRowClickListener,
F7SelectedListRemoveListener {
    private static final String TASK_USER_GROUP_LIST = "billlistap";
    private static final String TASK_USER_LIST = "billlistap1";
    private static final String F7_SELECTED_LIST = "f7selectedlistap1";
    private static final String CACHED_F7_SELECTED_TASK_USER = "f7selectedTaskUser";
    private static final String BTN_OK = "btnok";

    public void initialize() {
        String init = this.getPageCache().get("init");
        if (init == null) {
            this.getPageCache().put("init", "1");
            String selectStr = (String)this.getView().getFormShowParameter().getCustomParam("seltaskuser_tag");
            this.fillF7(selectStr, true);
        }
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.hideTips();
        BillList groupList = (BillList)this.getControl(TASK_USER_GROUP_LIST);
        groupList.setMulti(false);
        groupList.setShowDisabledData(true);
        groupList.setPageRow(100000);
        long ssc = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("ssc_auth_f7") + "");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"task_usergroup", (Long)ssc);
        groupList.setFilter(orgFilter);
        BillList userList = (BillList)this.getControl(TASK_USER_LIST);
        userList.setMulti(true);
        userList.setShowDisabledData(true);
    }

    public void registerListener(EventObject e) {
        BillList userList = (BillList)this.getControl(TASK_USER_LIST);
        userList.addListRowClickListener((ListRowClickListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7_SELECTED_LIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener(f7SelectedListRemoveEvent -> {
            this.getPageCache().remove(CACHED_F7_SELECTED_TASK_USER);
            userList.clearSelection();
        });
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        if (BTN_OK.equals(key)) {
            String f7Data = this.getPageCache().get(CACHED_F7_SELECTED_TASK_USER);
            if (f7Data == null || "[]".equals(f7Data)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"MonitorAuthorizeFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().returnDataToParent((Object)f7Data);
                this.getView().close();
            }
        }
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        String param = (String)evt.getParam();
        String f7Data = this.getPageCache().get(CACHED_F7_SELECTED_TASK_USER);
        List<TaskUserUser> taskUserUsers = TaskUserUsers.fromJsonString(f7Data);
        Iterator<TaskUserUser> iterator = taskUserUsers.iterator();
        BillList userList = (BillList)this.getControl(TASK_USER_LIST);
        while (iterator.hasNext()) {
            TaskUserUser next = iterator.next();
            if (!param.equals(next.u + "")) continue;
            iterator.remove();
            userList.getSelectedRows().removeIf(e -> (Long)e.getPrimaryKeyValue() == next.tu);
        }
        userList.refresh();
        this.getPageCache().put(CACHED_F7_SELECTED_TASK_USER, SerializationUtils.toJsonString(taskUserUsers));
    }

    public void listRowClick(ListRowClickEvent evt) {
        Control source = (Control)evt.getSource();
        String event = source.getKey();
        String f7Data = this.getPageCache().get(CACHED_F7_SELECTED_TASK_USER);
        if (TASK_USER_GROUP_LIST.equals(event)) {
            this.fillF7(f7Data, false);
        } else if (TASK_USER_LIST.equals(event)) {
            ListSelectedRowCollection selectedRowCollection = evt.getListSelectedRowCollection();
            List taskUserPKs = selectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            DynamicObjectCollection taskUsers = QueryServiceHelper.query((String)"task_user", (String)"id,userfield.id,userfield.name", (QFilter[])new QFilter("id", "in", taskUserPKs).toArray());
            ArrayList<TaskUserUser> list = new ArrayList<TaskUserUser>(taskUsers.size());
            for (Object pk : taskUserPKs) {
                long id = (Long)pk;
                for (DynamicObject taskUser : taskUsers) {
                    if (taskUser.getLong("id") != id) continue;
                    list.add(new TaskUserUser(taskUser.getLong("id"), taskUser.getLong("userfield.id"), taskUser.getString("userfield.name")));
                }
            }
            f7Data = SerializationUtils.toJsonString(list);
            this.getPageCache().put(CACHED_F7_SELECTED_TASK_USER, f7Data);
            this.fillF7(f7Data, false);
        }
    }

    private void fillF7(String f7Data, boolean queryName) {
        if (StringUtils.isNotBlank((CharSequence)f7Data)) {
            List<TaskUserUser> objects = TaskUserUsers.fromJsonString(f7Data);
            ListSelectedRowCollection selectedRowCollection = new ListSelectedRowCollection();
            LinkedHashSet<Long> userIds = new LinkedHashSet<Long>(objects.size());
            for (TaskUserUser taskUserUser : objects) {
                ListSelectedRow row = new ListSelectedRow((Object)taskUserUser.tu);
                selectedRowCollection.add((Object)row);
                userIds.add(taskUserUser.u);
            }
            ((BillList)this.getControl(TASK_USER_LIST)).putSelectedRows(selectedRowCollection);
            if (queryName) {
                List userInfoList = UserServiceHelper.get(new ArrayList(userIds), (String[])new String[]{"id", "name"}, null);
                for (Map user : userInfoList) {
                    long id = (Long)user.get("id");
                    for (TaskUserUser object : objects) {
                        if (object.u != id) continue;
                        object.n = user.get("name").toString();
                    }
                }
                this.getPageCache().put(CACHED_F7_SELECTED_TASK_USER, SerializationUtils.toJsonString(objects));
            }
            HashSet f7NotExist = new HashSet(objects.size());
            List list = objects.stream().filter(u -> f7NotExist.add(u.u)).map(u -> new ValueTextItem(u.u + "", u.n + "")).collect(Collectors.toList());
            F7SelectedList f7 = (F7SelectedList)this.getControl(F7_SELECTED_LIST);
            f7.addItems(list);
        }
    }
}

