/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.monitor;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class SolutionFormPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        boolean isPreset = (Boolean)formShowParameter.getCustomParam("isPreset");
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            Long createOrg = Long.valueOf((String)formShowParameter.getCustomParam("createOrg"));
            model.setValue("createorg", (Object)createOrg);
        }
        this.initHyperlinkAp(model, formView, isPreset);
        String solutionText = (String)model.getValue("solution_tag");
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
        richTextEditor.setText(solutionText);
    }

    private void initHyperlinkAp(IDataModel model, IFormView formView, boolean isPreset) {
        String hyperlinkUrl;
        formView.setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        if (isPreset && StringUtils.isNotEmpty((String)(hyperlinkUrl = (String)model.getValue("hyperlinkurl")))) {
            formView.setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            Hyperlink hyperLinkAp = (Hyperlink)formView.getControl("hyperlinkap");
            hyperLinkAp.setUrl(hyperlinkUrl);
            HashMap<String, LocaleString> map1 = new HashMap<String, LocaleString>(1);
            map1.put("text", new LocaleString(hyperlinkUrl));
            formView.updateControlMetadata("hyperlinkap", map1);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl("richtexteditorap");
            String text = richTextEditor.getText();
            this.getModel().setValue("solution_tag", (Object)text);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && CollectionUtils.isNotEmpty((Collection)(successPkIds = args.getOperationResult().getSuccessPkIds()))) {
            Long pkId = (Long)successPkIds.get(0);
            this.saveSolutionId(pkId);
        }
    }

    private void saveSolutionId(Long pkId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long defId = Long.valueOf((String)formShowParameter.getCustomParam("defId"));
        if (defId != 0L) {
            QFilter filter1 = new QFilter("id", "=", (Object)defId);
            QFilter[] qFilters = new QFilter[]{filter1};
            DynamicObject scenarioDefDo = BusinessDataServiceHelper.loadSingle((String)"ssc_scenario_def", (String)"id,createorg,preset,solution", (QFilter[])qFilters);
            Long solutionId = scenarioDefDo.getLong("solution.id");
            if (solutionId == 0L) {
                scenarioDefDo.set("solution", (Object)pkId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scenarioDefDo});
            }
        }
    }
}

