/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.satisfactionevaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class EvaluateFeedbackListPlugin
extends AbstractListPlugin {
    private static final String KEY_FEEDBACK = "feedback_callback";
    private static final String BAR_FEEDBACK = "barfeedback";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter filter = new QFilter("evaluativedimension.number", "=", (Object)"entirety");
        qFilters.add(filter);
        QFilter autoEvaluateFilter = new QFilter("autoevaluate", "=", (Object)"0");
        qFilters.add(autoEvaluateFilter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (BAR_FEEDBACK.equals(itemKey)) {
            List<Long> sscIds = this.getCustomFilterIds(this.getView(), "sscid.id");
            int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)sscIds.get(0), (String)"som", (String)"som_evaluatedetail", (String)"4S8F03/V1BMU");
            if (permission == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u660e\u7ec6\u8868\u201d\u7684\u201c\u56de\u8bbf\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluateFeedbackListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            IListView list = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvaluateFeedbackListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (size > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"EvaluateFeedbackListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "barfeedback": {
                this.openFeedBackPage();
                break;
            }
        }
    }

    private void openFeedBackPage() {
        IListView list = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        String billNo = selectedRows.get(0).getBillNo();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("som_feedbackconfirm");
        showParameter.setCustomParam("evaluateId", (Object)id);
        showParameter.setCustomParam("billNo", (Object)billNo);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_FEEDBACK);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (KEY_FEEDBACK.equalsIgnoreCase(e.getActionId())) {
            String retData = (String)e.getReturnData();
            if ("ok".equalsIgnoreCase(retData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u8bbf\u6210\u529f\u3002", (String)"EvaluateFeedbackListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else if ("fail".equalsIgnoreCase(retData)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56de\u8bbf\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvaluateFeedbackListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.valueOf(v.toString()));
        }
        return ids;
    }
}

