/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.satisfactionevaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class UnsatisfiedReasonAssign
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final int MAX_ASSIGN_SIZE = 10;
    private static final Log logger = LogFactory.getLog(UnsatisfiedReasonAssign.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getView().getControl("btn_assign");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.getFilterParameter().getQFilters().add(BaseDataServiceHelper.getBaseDataFilter((String)"som_evaluative_dimension", (Long)Long.parseLong(sscId)));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_assign".equals(control.getKey())) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"UnsatisfiedReasonAssign_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            List reasonIds = (List)this.getView().getFormShowParameter().getCustomParam("unsatisfiedReasonList");
            if (CollectionUtils.isEmpty((Collection)reasonIds) && reasonIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"UnsatisfiedReasonAssign_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscId");
            ArrayList<Long> evaluativeDimensionIds = new ArrayList<Long>();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                evaluativeDimensionIds.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            Optional<String> result = this.validatorAssign(evaluativeDimensionIds, sscId, reasonIds);
            if (result.isPresent()) {
                this.getView().showTipNotification(result.get());
                return;
            }
            try {
                this.saveUnsatisfiedReasonRelation(reasonIds, evaluativeDimensionIds, sscId);
                this.getView().returnDataToParent((Object)"assignok");
            }
            catch (Exception e) {
                logger.error("assign e:", (Throwable)e);
                this.getView().returnDataToParent((Object)"assignfail");
            }
            this.getView().close();
        }
    }

    private Optional<String> validatorAssign(List<Long> evaluativeDimensionIds, String sscId, List<Long> reasonIds) {
        QFilter filter;
        Map idToNameMap;
        int limitSize;
        QFilter dimensionFilter = new QFilter("evaluativedimension", "in", evaluativeDimensionIds);
        QFilter orgFilter = new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId));
        QFilter[] filters = new QFilter[]{orgFilter, dimensionFilter};
        HashMap<Long, List> map = new HashMap<Long, List>(8);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.UnsatisfiedReasonAssign.validatorAssign", (String)"som_unsatisfiedassign_re", (String)"evaluativedimension,unsatisfiedreason", (QFilter[])filters, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                map.computeIfAbsent(row.getLong("evaluativedimension"), k -> new ArrayList()).add(row.getLong("unsatisfiedreason"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Long> overIds = new ArrayList<Long>(8);
        for (Map.Entry entry : map.entrySet()) {
            long dimensionId = (Long)entry.getKey();
            List existsReasonIdList = (List)entry.getValue();
            List<Long> existsEnableReasonIdList = this.getExistsEnableReasonIdList(existsReasonIdList);
            ArrayList<Long> reasonIdsTemp = new ArrayList<Long>(reasonIds);
            reasonIdsTemp.removeAll(existsEnableReasonIdList);
            int totalSize = reasonIdsTemp.size() + existsEnableReasonIdList.size();
            if (totalSize <= 10) continue;
            overIds.add(dimensionId);
        }
        Set dimensionSet = map.keySet();
        HashSet<Long> hashSet = new HashSet<Long>(evaluativeDimensionIds);
        hashSet.removeAll(dimensionSet);
        if (!hashSet.isEmpty() && (limitSize = 10 - reasonIds.size()) < 0) {
            overIds.addAll(hashSet);
        }
        if (overIds.size() > 0 && (idToNameMap = BusinessDataServiceHelper.loadFromCache((String)"som_evaluative_dimension", (String)"name", (QFilter[])new QFilter[]{filter = new QFilter("id", "in", overIds)})) != null && idToNameMap.size() > 0) {
            Set nameSet = idToNameMap.values().stream().map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toSet());
            String nameStr = nameSet.toString().substring(1, nameSet.toString().length() - 1);
            return Optional.of(ResManager.loadKDString((String)"\u6b64\u6b21\u8bc4\u4ef7\u7ef4\u5ea6\uff08%s\uff09\u5206\u914d\u540e\uff0c\u4e0d\u6ee1\u610f\u539f\u56e0\u5c06\u8d85\u8fc7\u4e0a\u9650\uff0810\u4e2a\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"UnsatisfiedReasonAssign_2", (String)"fi-bd-formplugin", (Object[])new Object[]{nameStr}));
        }
        return Optional.empty();
    }

    private List<Long> getExistsEnableReasonIdList(List<Long> existsReasonIdList) {
        ArrayList<Long> existsEnableReasonIdList = new ArrayList<Long>(16);
        QFilter qFilter = new QFilter("id", "in", existsReasonIdList);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.UnsatisfiedReasonAssign.getExistsEnableReasonIdList", (String)"som_unsatisfied_reason", (String)"id", (QFilter[])new QFilter[]{statusFilter, qFilter}, null);){
            for (Row row : dataSet) {
                existsEnableReasonIdList.add(row.getLong("id"));
            }
        }
        return existsEnableReasonIdList;
    }

    private void saveUnsatisfiedReasonRelation(List<Long> reasonIds, List<Long> evaluativeDimensionIds, String sscId) {
        QFilter orgFilter = new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId));
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<DynamicObject> unsatisfiedAssignRelationList = new ArrayList<DynamicObject>();
        try {
            for (Long reasonId : reasonIds) {
                QFilter reasonFilter = new QFilter("unsatisfiedreason", "=", (Object)reasonId);
                for (Long evaluativeDimensionId : evaluativeDimensionIds) {
                    QFilter evaluativeDimensionFilter = new QFilter("evaluativedimension", "=", (Object)evaluativeDimensionId);
                    boolean isExist = QueryServiceHelper.exists((String)"som_unsatisfiedassign_re", (QFilter[])new QFilter[]{orgFilter, reasonFilter, evaluativeDimensionFilter});
                    if (isExist) continue;
                    DynamicObject unsatisfiedAssignRelation = BusinessDataServiceHelper.newDynamicObject((String)"som_unsatisfiedassign_re");
                    unsatisfiedAssignRelation.set("ssccenter", (Object)sscId);
                    unsatisfiedAssignRelation.set("unsatisfiedreason", (Object)reasonId);
                    unsatisfiedAssignRelation.set("evaluativedimension", (Object)evaluativeDimensionId);
                    unsatisfiedAssignRelation.set("createtime", (Object)date);
                    unsatisfiedAssignRelation.set("creator", (Object)userId);
                    unsatisfiedAssignRelationList.add(unsatisfiedAssignRelation);
                }
            }
            if (unsatisfiedAssignRelationList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])unsatisfiedAssignRelationList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("saveUnsatisfiedReasonRelation e:", (Throwable)e);
            throw new KDBizException(BosErrorCode.systemError, new Object[]{e});
        }
    }
}

