/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.satisfactionevaluation.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.Rate;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.task.formplugin.util.DateUtil;

public class EvaluateFormUtil {
    public static void showEvaluatedData(IFormView view, String billNo, String billTypeName) {
        Label billInfo = (Label)view.getControl("billinfo");
        String title = ResManager.loadKDString((String)"\u60a8\u7684%s\u8bc4\u4ef7\u5df2\u5b8c\u6210\u3002", (String)"EvaluateFormUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[]{billNo + billTypeName});
        billInfo.setText(title);
        Label labelAp = (Label)view.getControl("labelap2");
        labelAp.setText("");
        view.setEnable(Boolean.valueOf(false), new String[]{"options", "attachmentpanelap"});
        view.setVisible(Boolean.valueOf(false), new String[]{"btn_cancel", "btn_ok"});
        QFilter billFilter = new QFilter("billno", "=", (Object)billNo);
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"som_evaluatedetail", (String)"id,evaluativedimension,opinion,isattachments,entryentity.sscuser,entryentity.stars,entryentity.unsatisfiedreason,entryentity.othertext", (QFilter[])new QFilter[]{billFilter});
        if (details != null && details.length > 0) {
            EvaluateFormUtil.setEvaluatedData(view, details);
        }
    }

    private static void setEvaluatedData(IFormView view, DynamicObject[] details) {
        ArrayList<DynamicObject> selfDimensionList = new ArrayList<DynamicObject>(16);
        for (DynamicObject detail : details) {
            DynamicObject evaluativeDimension = detail.getDynamicObject("evaluativedimension");
            if ("entirety".equals(evaluativeDimension.getString("number"))) {
                IDataModel model = view.getModel();
                model.setValue("dimension1", (Object)evaluativeDimension.getLong("id"));
                DynamicObject entry = (DynamicObject)detail.getDynamicObjectCollection("entryentity").get(0);
                Rate rate = (Rate)view.getControl("rateap1");
                int score = Integer.parseInt(entry.getString("stars"));
                rate.setRateScore((Number)score);
                view.setEnable(Boolean.valueOf(false), new String[]{"rateap1"});
                model.setValue("rateap1value", (Object)score);
                EvaluateFormUtil.setEvaluatedReason(view, entry, "reason1");
                if (StringUtils.isNotEmpty((String)entry.getString("othertext"))) {
                    view.getModel().setValue("text1", (Object)entry.getString("othertext"));
                    view.setEnable(Boolean.valueOf(false), new String[]{"text1"});
                }
                view.getModel().setValue("options", (Object)detail.getString("opinion"));
                String id = detail.getString("id");
                view.getPageCache().put("attachPkId", id);
                continue;
            }
            if ("ssc_staff".equals(evaluativeDimension.getString("number"))) {
                view.getModel().setValue("dimension11", (Object)evaluativeDimension.getLong("id"));
                EvaluateFormUtil.setSscUserFieldsValue(view, detail);
                continue;
            }
            selfDimensionList.add(detail);
        }
        EvaluateFormUtil.setSelfDimensionFieldsValue(view, selfDimensionList);
    }

    public static void bindAttachments(IFormView view) {
        String idStr = view.getPageCache().get("attachPkId");
        if (StringUtils.isNotEmpty((String)idStr)) {
            List atts = AttachmentServiceHelper.getAttachments((String)"som_evaluatedetail", (Object)idStr, (String)"attachmentpanel", (boolean)false);
            AttachmentPanel panel = (AttachmentPanel)view.getControl("attachmentpanelap");
            panel.bindData(atts);
        }
    }

    private static void setEvaluatedReason(IFormView view, DynamicObject entry, String reasonKey) {
        DynamicObjectCollection unsatisfiedReasonCollection = entry.getDynamicObjectCollection("unsatisfiedreason");
        MulComboEdit mulComboEdit = (MulComboEdit)view.getControl(reasonKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        StringBuilder value = new StringBuilder(",");
        for (DynamicObject unsatisfiedReason : unsatisfiedReasonCollection) {
            DynamicObject data = (DynamicObject)unsatisfiedReason.get("fbasedataid");
            ComboItem item = new ComboItem(new LocaleString(data.getString("name")), data.getString("id"));
            items.add(item);
            value.append(data.getString("id")).append(",");
        }
        mulComboEdit.setComboItems(items);
        view.setEnable(Boolean.valueOf(false), new String[]{reasonKey});
        if (!",".equals(value.toString())) {
            view.getModel().setValue(reasonKey, (Object)value.toString());
        }
    }

    private static void setSscUserFieldsValue(IFormView view, DynamicObject detail) {
        DynamicObjectCollection entries = detail.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            view.getModel().setValue("user" + (i + 1), (Object)entry.getDynamicObject("sscuser"));
            String key = "userrate" + (i + 1);
            Rate rate = (Rate)view.getControl(key);
            int score = Integer.parseInt(entry.getString("stars"));
            rate.setRateScore((Number)score);
            view.setEnable(Boolean.valueOf(false), new String[]{key});
            view.getModel().setValue("userrate2value", (Object)score);
            EvaluateFormUtil.setEvaluatedReason(view, entry, "userreason" + (i + 1));
            if (!StringUtils.isNotEmpty((String)entry.getString("othertext"))) continue;
            view.getModel().setValue("usertext" + (i + 1), (Object)entry.getString("othertext"));
            view.setEnable(Boolean.valueOf(false), new String[]{"usertext" + (i + 1)});
        }
    }

    private static void setSelfDimensionFieldsValue(IFormView view, List<DynamicObject> selfDimensionList) {
        for (int i = 0; i < selfDimensionList.size(); ++i) {
            view.getModel().setValue("dimension" + (i + 2), (Object)selfDimensionList.get(i).getDynamicObject("evaluativedimension"));
            DynamicObject entry = (DynamicObject)selfDimensionList.get(i).getDynamicObjectCollection("entryentity").get(0);
            String key = "rateap" + (i + 2);
            Rate rate = (Rate)view.getControl(key);
            int score = Integer.parseInt(entry.getString("stars"));
            rate.setRateScore((Number)score);
            view.setEnable(Boolean.valueOf(false), new String[]{key});
            view.getModel().setValue(key + "value", (Object)score);
            EvaluateFormUtil.setEvaluatedReason(view, entry, "reason" + (i + 2));
            if (!StringUtils.isNotEmpty((String)entry.getString("othertext"))) continue;
            view.getModel().setValue("text" + (i + 2), (Object)entry.getString("othertext"));
            view.setEnable(Boolean.valueOf(false), new String[]{"text" + (i + 2)});
        }
    }

    public static void showEvaluatingData(IFormView view, String billNo, String billTypeName) {
        view.setVisible(Boolean.valueOf(false), new String[]{"btn_close"});
        Label billInfo = (Label)view.getControl("billinfo");
        String title = ResManager.loadKDString((String)"\u60a8\u7684%s\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u4e3a\u4e86\u8fdb\u4e00\u6b65\u63d0\u5347\u670d\u52a1\u8d28\u91cf\uff0c\u8bf7\u4e3a\u672c\u6b21\u670d\u52a1\u505a\u51fa\u8bc4\u4ef7\u3002", (String)"EvaluateFormUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[]{billNo + billTypeName});
        billInfo.setText(title);
        QFilter billFilter = new QFilter("billno", "=", (Object)billNo);
        long sscId = 0L;
        long org = 0L;
        long billType = 0L;
        long billId = 0L;
        Date waiteValuateTime = null;
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.EvaluateSidebarFormPlugin.showEvaluatingData.queryEvaluatingData", (String)"som_evaluating_data", (String)"sscid,org,billtype,waitevaluatetime,billid", (QFilter[])new QFilter[]{billFilter}, (String)"createtime desc", (int)1);){
            for (Row row : orgDataSet) {
                sscId = row.getLong("sscid");
                org = row.getLong("org");
                billType = row.getLong("billtype");
                billId = row.getLong("billid");
                waiteValuateTime = row.getDate("waitevaluatetime");
            }
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>(8);
        cacheMap.put("sscId", String.valueOf(sscId));
        cacheMap.put("orgId", String.valueOf(org));
        cacheMap.put("billTypeId", String.valueOf(billType));
        cacheMap.put("billId", String.valueOf(billId));
        cacheMap.put("billNo", billNo);
        cacheMap.put("waiteValuateTime", DateUtil.format(waiteValuateTime, "yyyy-MM-dd HH:mm:ss"));
        view.getPageCache().put(cacheMap);
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"som_evaluative_dimension", (Long)sscId);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet evaluativeDimension = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.EvaluateSidebarFormPlugin.showEvaluatingData.queryDimension", (String)"som_evaluative_dimension", (String)"id,number", (QFilter[])new QFilter[]{qFilter, statusFilter}, (String)"createtime");){
            EvaluateFormUtil.setDimension(view, evaluativeDimension);
        }
        var19_18 = null;
        try (DataSet userDataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.EvaluateSidebarFormPlugin.showEvaluatingData", (String)"som_evaluating_data", (String)"handlerid", (QFilter[])new QFilter[]{billFilter}, null);){
            EvaluateFormUtil.setSscUser(view, userDataSet);
        }
        catch (Throwable throwable) {
            var19_18 = throwable;
            throw throwable;
        }
    }

    private static void setDimension(IFormView view, DataSet evaluativeDimension) {
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (Row row : evaluativeDimension) {
            if ("entirety".equals(row.getString("number"))) {
                view.getModel().setValue("dimension1", (Object)row.getLong("id"));
                continue;
            }
            if ("ssc_staff".equals(row.getString("number"))) {
                view.getModel().setValue("dimension11", (Object)row.getLong("id"));
                continue;
            }
            idList.add(row.getLong("id"));
        }
        for (int i = 0; i < idList.size(); ++i) {
            view.getModel().setValue("dimension" + (i + 2), idList.get(i));
        }
        view.getPageCache().put("dimensionNum", String.valueOf(idList.size() + 1));
    }

    private static void setSscUser(IFormView view, DataSet userDataSet) {
        ArrayList<Long> idList = new ArrayList<Long>(8);
        for (Row row : userDataSet) {
            long id = row.getLong("handlerid");
            if (idList.contains(id)) continue;
            idList.add(id);
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            for (int i = 0; i < idList.size(); ++i) {
                view.getModel().setValue("user" + (i + 1), idList.get(i));
            }
        }
        view.getPageCache().put("userNum", String.valueOf(idList.size()));
    }

    public static void setReason(IFormView view, Object dimension, int index, Number rateScore, String reasonKey, String textKey) {
        MulComboEdit mulComboEdit = (MulComboEdit)view.getControl(reasonKey + index);
        if (dimension != null && (rateScore.intValue() == 1 || rateScore.intValue() == 2)) {
            String sscId = view.getPageCache().get("sscId");
            QFilter sscFilter = new QFilter("ssccenter", "=", (Object)Long.parseLong(sscId));
            QFilter dimensionFilter = new QFilter("evaluativedimension", "=", (Object)((DynamicObject)dimension).getLong("id"));
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"som_unsatisfied_reason", (Long)Long.parseLong(sscId));
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            try (DataSet assignReason = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.EvaluateSidebarFormPlugin.setReason.queryReason", (String)"som_unsatisfiedassign_re", (String)"unsatisfiedreason.id,unsatisfiedreason.name", (QFilter[])new QFilter[]{sscFilter, dimensionFilter}, null);
                 DataSet reason = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.EvaluateSidebarFormPlugin.setReason.queryReason", (String)"som_unsatisfied_reason", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter}, null);
                 DataSet result = assignReason.join(reason, JoinType.INNER).on("unsatisfiedreason.id", "id").select(new String[]{"unsatisfiedreason.id", "unsatisfiedreason.name"}).finish();){
                for (Row row : result) {
                    ComboItem item = new ComboItem(new LocaleString(row.getString("unsatisfiedreason.name")), row.getString("unsatisfiedreason.id"));
                    items.add(item);
                }
            }
            if (CollectionUtils.isNotEmpty(items)) {
                view.setVisible(Boolean.TRUE, new String[]{reasonKey + index});
                mulComboEdit.setComboItems(items);
            } else {
                view.setVisible(Boolean.FALSE, new String[]{reasonKey + index});
                view.setVisible(Boolean.FALSE, new String[]{textKey + index});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{reasonKey + index});
            view.setVisible(Boolean.FALSE, new String[]{textKey + index});
            view.getModel().setValue(reasonKey + index, null);
            view.getModel().setValue(textKey + index, null);
        }
    }

    public static boolean isScoredOther(IDataModel model, int dimensionNum) {
        for (int i = 2; i <= dimensionNum; ++i) {
            Object score = model.getValue("rateap" + i + "value");
            if (score == null || Integer.parseInt(score.toString()) == 0) continue;
            return true;
        }
        return false;
    }

    public static void setOtherScore(IFormView view, int dimensionNum, int score) {
        for (int i = 2; i <= dimensionNum; ++i) {
            Rate rate = (Rate)view.getControl("rateap" + i);
            rate.setRateScore((Number)score);
            view.getModel().setValue("rateap" + i + "value", (Object)score);
        }
    }

    public static void setTextFlexVisible(IFormView view, String propertyName, String textFlexKey, Object newValue) {
        int index = EvaluateFormUtil.getIndex(propertyName);
        if (newValue != null && newValue.toString().contains("2121868488917593088")) {
            view.setVisible(Boolean.TRUE, new String[]{textFlexKey + index});
        } else {
            view.getModel().setValue(textFlexKey + index, null);
            view.setVisible(Boolean.FALSE, new String[]{textFlexKey + index});
        }
    }

    private static int getIndex(String str) {
        Pattern pattern = Pattern.compile("\\d+$");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            String number = matcher.group();
            return Integer.parseInt(number);
        }
        return 0;
    }

    public static void setReasonTextVisible(IFormView view, String ratePrefix, String reasonPrefix, String textPrefix, int i) {
        Object rate = view.getModel().getValue(ratePrefix + i + "value");
        Object reason = view.getModel().getValue(reasonPrefix + i);
        if (rate != null && reason != null) {
            view.setVisible(Boolean.TRUE, new String[]{reasonPrefix + i});
            if (reason.toString().contains("2121868488917593088")) {
                view.setVisible(Boolean.TRUE, new String[]{textPrefix + i});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{textPrefix + i});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{reasonPrefix + i});
            view.setVisible(Boolean.FALSE, new String[]{textPrefix + i});
        }
    }

    public static Map<String, Object> generateParamMap(IFormView view) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        int dimensionNum = Integer.parseInt(view.getPageCache().get("dimensionNum"));
        HashMap<Integer, Long> dimensionIdMap = new HashMap<Integer, Long>(16);
        for (int i = 1; i <= dimensionNum; ++i) {
            Object dimension = view.getModel().getValue("dimension" + i);
            if (dimension == null) continue;
            dimensionIdMap.put(i, ((DynamicObject)dimension).getLong("id"));
        }
        paramMap.put("dimensionIdMap", dimensionIdMap);
        long sscId = Long.parseLong(view.getPageCache().get("sscId"));
        paramMap.put("sscId", sscId);
        long orgId = Long.parseLong(view.getPageCache().get("orgId"));
        paramMap.put("orgId", orgId);
        long billTypeId = Long.parseLong(view.getPageCache().get("billTypeId"));
        paramMap.put("billTypeId", billTypeId);
        String waiteValuateTime = view.getPageCache().get("waiteValuateTime");
        paramMap.put("waiteValuateTime", waiteValuateTime);
        long billId = Long.parseLong(view.getPageCache().get("billId"));
        paramMap.put("billId", billId);
        String billNo = view.getPageCache().get("billNo");
        paramMap.put("billNo", billNo);
        Map<Integer, Integer> rateScoreMap = EvaluateFormUtil.getRateScoreMap(view.getModel(), dimensionNum, "rateap");
        paramMap.put("rateScoreMap", rateScoreMap);
        Map<Integer, String> reasonIdMap = EvaluateFormUtil.getReasonIdMap(view.getModel(), dimensionNum, "reason");
        paramMap.put("reasonIdMap", reasonIdMap);
        Map<Integer, String> textMap = EvaluateFormUtil.getTextMap(view.getModel(), dimensionNum, "text");
        paramMap.put("textMap", textMap);
        int userNum = Integer.parseInt(view.getPageCache().get("userNum"));
        long userDimensionId = view.getModel().getValue("dimension11") == null ? 0L : ((DynamicObject)view.getModel().getValue("dimension11")).getLong("id");
        paramMap.put("userDimensionId", userDimensionId);
        Map<Integer, Long> userIdMap = EvaluateFormUtil.getUserIdMap(view.getModel(), userNum);
        paramMap.put("userIdMap", userIdMap);
        Map<Integer, Integer> userRateScoreMap = EvaluateFormUtil.getRateScoreMap(view.getModel(), userNum, "userrate");
        paramMap.put("userRateScoreMap", userRateScoreMap);
        Map<Integer, String> userReasonIdMap = EvaluateFormUtil.getReasonIdMap(view.getModel(), userNum, "userreason");
        paramMap.put("userReasonIdMap", userReasonIdMap);
        Map<Integer, String> userTextMap = EvaluateFormUtil.getTextMap(view.getModel(), userNum, "usertext");
        paramMap.put("userTextMap", userTextMap);
        String options = view.getModel().getValue("options") == null ? "" : view.getModel().getValue("options").toString();
        paramMap.put("options", options);
        List attachmentList = ((AttachmentPanel)view.getControl("attachmentpanelap")).getAttachmentData();
        paramMap.put("attachmentList", attachmentList);
        return paramMap;
    }

    private static Map<Integer, Integer> getRateScoreMap(IDataModel model, int size, String ratePrefix) {
        HashMap<Integer, Integer> rateScoreMap = new HashMap<Integer, Integer>(16);
        for (int i = 1; i <= size; ++i) {
            Object rateScore = model.getValue(ratePrefix + i + "value");
            if (rateScore == null) continue;
            rateScoreMap.put(i, (Integer)rateScore);
        }
        return rateScoreMap;
    }

    private static Map<Integer, String> getReasonIdMap(IDataModel model, int size, String reasonPrefix) {
        HashMap<Integer, String> reasonIdMap = new HashMap<Integer, String>(16);
        for (int i = 1; i <= size; ++i) {
            Object reason = model.getValue(reasonPrefix + i);
            if (reason == null) continue;
            reasonIdMap.put(i, reason.toString());
        }
        return reasonIdMap;
    }

    private static Map<Integer, String> getTextMap(IDataModel model, int size, String textPrefix) {
        HashMap<Integer, String> textMap = new HashMap<Integer, String>(16);
        for (int i = 1; i <= size; ++i) {
            Object text = model.getValue(textPrefix + i);
            if (text == null || text.toString().trim() == "") continue;
            textMap.put(i, text.toString());
        }
        return textMap;
    }

    private static Map<Integer, Long> getUserIdMap(IDataModel model, int size) {
        HashMap<Integer, Long> userIdMap = new HashMap<Integer, Long>(16);
        for (int i = 1; i <= size; ++i) {
            Object user = model.getValue("user" + i);
            if (user == null) continue;
            userIdMap.put(i, ((DynamicObject)user).getLong("id"));
        }
        return userIdMap;
    }
}

