/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import org.quartz.CronExpression;

public class SmartQualitySchemeSchedule
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SmartQualitySchemeSchedule.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] schemes;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("executemode", "in", (Object)new String[]{"w", "m", "y"}));
        List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)"task_smartcheckscheme", (QFilter[])filter.toArray(), null, (int)-1);
        for (DynamicObject item : schemes = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_smartcheckscheme"))) {
            String expression = this.getCronExpression(item);
            if (StringUtils.isEmpty((String)expression)) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 2);
            calendar.set(12, 59);
            calendar.set(13, 0);
            calendar.set(14, 0);
            try {
                CronExpression cronExpression = new CronExpression(expression);
                Date nextExecuteTime = cronExpression.getNextValidTimeAfter(calendar.getTime());
                calendar.set(11, 3);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                if (!nextExecuteTime.equals(calendar.getTime())) continue;
                QualityCheckSchemeUtil.qualityCheck(item, true);
            }
            catch (ParseException e) {
                logger.info("cron\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\u5bfc\u81f4\u5b9a\u65f6\u667a\u80fd\u62bd\u68c0\u5931\u8d25\uff0c\u667a\u80fd\u8d28\u68c0\u65b9\u6848\uff1a" + item.getPkValue(), (Object)e);
            }
        }
    }

    private String getCronExpression(DynamicObject smartScheme) {
        String executeMode;
        StringBuilder plan = new StringBuilder();
        switch (executeMode = smartScheme.getString("executeMode")) {
            case "w": {
                plan.append("0 0 3");
                String week = smartScheme.getString("week") + "";
                week = week.substring(1, week.length() - 1);
                plan.append(' ').append('?').append(' ').append('*').append(' ').append(week);
                break;
            }
            case "m": {
                plan.append("0 0 3");
                String date = smartScheme.getString("date") + "";
                date = date.substring(1, date.length() - 1);
                plan.append(' ').append(date).append(' ').append('*').append(' ').append('?');
                break;
            }
            case "y": {
                plan.append("0 0 3");
                String month = smartScheme.getString("month") + "";
                String date2 = smartScheme.getString("date") + "";
                month = month.substring(1, month.length() - 1);
                date2 = date2.substring(1, date2.length() - 1);
                plan.append(' ').append(date2).append(' ').append(month).append(' ').append('?');
                break;
            }
            default: {
                return "";
            }
        }
        return plan.toString();
    }
}

