/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.ThirdCommentInfo;
import kd.ssc.enums.AuditStateEnum;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.util.RecordExceptionUtil;

public class TaskWfTransferSchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog(TaskWfTransferSchedule.class);
    private static final int RUNPAGESIZE = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ORM orm = ORM.create();
        this.transferMultiTaskData(orm);
    }

    private void transferMultiTaskData(ORM orm) {
        int start = 0;
        int pageIndex = 0;
        Map<Long, ThirdCommentInfo> thirdCommentInfoMap = null;
        DataSet nodeDataSet = null;
        nodeDataSet = this.queryMultiTaskInfoFromNode(orm, start);
        while (nodeDataSet != null && nodeDataSet.hasNext()) {
            List<Object> thirdCommentInfos = this.buildMultiTaskThirdCommentInfo(nodeDataSet);
            thirdCommentInfoMap = (thirdCommentInfos = thirdCommentInfos.parallelStream().filter(TaskWfTransferSchedule.distinctByKey(ThirdCommentInfo::getId)).collect(Collectors.toList())).stream().collect(Collectors.toMap(ThirdCommentInfo::getId, ThirdCommentInfo2 -> ThirdCommentInfo2));
            Set<Long> taskIds = thirdCommentInfoMap.keySet();
            Map<Long, String> taskDataCol = this.querySubactivityNameFromTask(taskIds);
            if (!CollectionUtils.isEmpty(taskDataCol)) {
                this.buildSubactivityNameForThirdComment(thirdCommentInfoMap, taskDataCol);
            }
            taskIds.removeAll(taskDataCol.keySet());
            if (!CollectionUtils.isEmpty(taskIds)) {
                Map<Long, String> taskHistoryDataCol = this.querySubactivityNameFromTaskHistory(taskIds);
                this.buildSubactivityNameForThirdComment(thirdCommentInfoMap, taskHistoryDataCol);
            }
            this.sendToWorkFlowService(thirdCommentInfos);
            start = 1000 * ++pageIndex;
            nodeDataSet = this.queryMultiTaskInfoFromNode(orm, start);
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        return t -> set.add(keyExtractor.apply(t));
    }

    private void sendToWorkFlowService(List<ThirdCommentInfo> thirdCommentInfos) {
        if (CollectionUtils.isEmpty(thirdCommentInfos)) {
            return;
        }
        for (ThirdCommentInfo thirdCommentInfo : thirdCommentInfos) {
            try {
                WorkflowServiceHelper.addTrdComment((ThirdCommentInfo)thirdCommentInfo);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u53d1\u9001\u7ed9\u5de5\u4f5c\u6d41\u670d\u52a1\u51fa\u73b0\u5f02\u5e38", (String)"TaskWfTransferSchedule_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                log.error(errorMsg, (Throwable)e);
                HashMap<String, String> param = new HashMap<String, String>(16);
                param.put("ThirdCommentInfo", JSONObject.toJSONString((Object)thirdCommentInfo));
                RecordExceptionUtil.saveRecordExcept((String)"ssc", (String)"kd.ssc.task.schedule.TaskWfTransferSchedule.sendToWorkFlowService()", param, (String)errorMsg, (String)ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private void buildSubactivityNameForThirdComment(Map<Long, ThirdCommentInfo> thirdCommentInfoMap, Map<Long, String> taskDataCol) {
        Set<Map.Entry<Long, ThirdCommentInfo>> entries = thirdCommentInfoMap.entrySet();
        for (Map.Entry<Long, ThirdCommentInfo> entry : entries) {
            if (taskDataCol.get(entry.getKey()) == null) continue;
            ThirdCommentInfo value = entry.getValue();
            value.setSubactivityName(taskDataCol.get(entry.getKey()));
        }
    }

    private List<ThirdCommentInfo> buildMultiTaskThirdCommentInfo(DataSet nodeDataSet) {
        Iterator rows = nodeDataSet.iterator();
        ArrayList<ThirdCommentInfo> thirdCommentInfoList = new ArrayList<ThirdCommentInfo>(16);
        while (rows != null && rows.hasNext()) {
            ThirdCommentInfo thirdCommentInfo = null;
            try {
                Row data = (Row)rows.next();
                thirdCommentInfo = WorkflowServiceHelper.createNewTrdComment();
                thirdCommentInfo.setId(data.getLong("taskid"));
                Long workflowId = data.getLong("workflowid");
                if (workflowId == null || workflowId == 0L) {
                    log.error("Error build instance for ThirdCommentInfo: workflowId = {}, taskId = {}", (Object)workflowId, (Object)data.getLong("taskid"));
                }
                thirdCommentInfo.setTaskId(workflowId);
                thirdCommentInfo.setUserId(data.getLong("personid"));
                thirdCommentInfo.setAuditTime(Long.valueOf(data.getDate("dealdate").getTime()));
                thirdCommentInfo.setSourceSystem("ssc");
                if (InstNodeEnum.PROCESSING.getValue() != data.getInteger("state").intValue()) {
                    String resultNumber = "Reject";
                    String decisiontype = "reject";
                    if (AuditStateEnum.PASS.getValue().equals(AuditStateEnum.getValueByState((String)data.getString("taskstate")))) {
                        resultNumber = "Consent";
                        decisiontype = "approve";
                    }
                    thirdCommentInfo.setResultNumber(resultNumber);
                    thirdCommentInfo.setDecisiontype(decisiontype);
                }
                if (AuditStateEnum.RETURN.getValue().equals(AuditStateEnum.getValueByState((String)data.getString("taskstate")))) {
                    thirdCommentInfo.setResultNumber("Reject");
                    thirdCommentInfo.setDecisiontype("reject");
                }
                thirdCommentInfo.setResultName(AuditStateEnum.getValueByState((String)data.getString("taskstate")));
                thirdCommentInfo.setAuditMesssage(data.getString("auditmsg"));
                thirdCommentInfoList.add(thirdCommentInfo);
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u6784\u9020\u591a\u7ea7\u4efb\u52a1\u7b2c\u4e09\u65b9\u5ba1\u6279\u4fe1\u606f\u5bf9\u8c61\u5f02\u5e38", (String)"TaskWfTransferSchedule_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                log.error(errorMsg, (Throwable)e);
                HashMap<String, String> param = new HashMap<String, String>(16);
                param.put("ThirdCommentInfo", JSONObject.toJSONString((Object)thirdCommentInfo));
                RecordExceptionUtil.saveRecordExcept((String)"ssc", (String)"kd.ssc.task.schedule.TaskWfTransferSchedule.buildMultiTaskThirdCommentInfo()", param, (String)errorMsg, (String)ExceptionUtil.getStackTrace((Throwable)e));
                log.error("thirdCommentInfo=" + (thirdCommentInfo == null ? "" : thirdCommentInfo.getId()));
            }
        }
        return thirdCommentInfoList;
    }

    private DataSet queryMultiTaskInfoFromNode(ORM orm, int start) {
        Date startDate;
        String selectField = "workflowid,taskid,personid,taskstate,dealdate,auditmsg,state";
        QFilter qFilter = new QFilter("taskstate", "!=", (Object)AuditStateEnum.CANCEL.getState());
        Date endDate = TaskWfTransferSchedule.getSSCConfigParam("wfdataSyncEndDate");
        if (endDate == null) {
            endDate = new Date();
        }
        if ((startDate = TaskWfTransferSchedule.getSSCConfigParam("wfdataSyncStartDate")) == null) {
            startDate = TaskWfTransferSchedule.dateBeforeOrAfter(endDate, -60);
        }
        QFilter startDateQ = new QFilter("dealdate", ">=", (Object)startDate);
        QFilter endDateQ = new QFilter("dealdate", "<=", (Object)endDate);
        DataSet nodeDataSet = orm.queryDataSet("kd.ssc.task.schedule.TaskWfTransferSchedule.queryMultiTaskInfoFromNode()", "task_partaskinstnode", selectField, new QFilter[]{qFilter, startDateQ, endDateQ}, null, start, 1000);
        return nodeDataSet;
    }

    private static Date dateBeforeOrAfter(Date date, int interval) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        String formatDate = format.format(date);
        Calendar calendar = Calendar.getInstance();
        try {
            date = format.parse(formatDate);
        }
        catch (ParseException e) {
            log.error("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u65e5\u671f\u524d\u63a8\u6216\u540e\u79fb\uff1a\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (Throwable)e);
        }
        calendar.setTime(date);
        calendar.add(5, interval + 1);
        return calendar.getTime();
    }

    private Map<Long, String> querySubactivityNameFromTask(Set<Long> idSet) {
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid.name", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, String> ret = new HashMap<Long, String>(16);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return ret;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject item = dynamicObjects[i];
            ret.put(item.getLong("id"), item.getString("tasktypeid.name"));
        }
        return ret;
    }

    private Map<Long, String> querySubactivityNameFromTaskHistory(Set<Long> idSet) {
        QFilter qFilter = new QFilter("sourcetaskid", "in", idSet);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"task_taskhistory", (String)"sourcetaskid,tasktypeid.name", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, String> ret = new HashMap<Long, String>(16);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return ret;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject item = dynamicObjects[i];
            ret.put(item.getLong("sourcetaskid"), item.getString("tasktypeid.name"));
        }
        return ret;
    }

    public static Date getSSCConfigParam(String key) {
        Object paramvalue;
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)key)});
        Date date = null;
        if (dynamicObject != null && (paramvalue = dynamicObject.get("paramvalue")) != null && paramvalue != "") {
            try {
                date = format.parse(paramvalue.toString());
            }
            catch (ParseException e) {
                log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return date;
    }
}

