/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule.achieve;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpEnum;
import kd.ssc.task.formplugin.pojo.achieve.AchieveExpInfo;
import kd.ssc.task.formplugin.util.AchieveUtil;

public class OnDutyTimeScheduleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OnDutyTimeScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date beforeDay = AchieveDateUtil.getBeforeDay();
        try {
            AchieveUtil.deleteDate(Collections.singletonList(beforeDay), null);
            AchieveUtil.saveUserTime(beforeDay, null);
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u4eba\u5458\u5728\u5c97\u65f6\u95f4\u751f\u6210\u6570\u636e\u5931\u8d25,\u5931\u8d25\u65e5\u671f\uff1a" + sdf.format(beforeDay), (Throwable)e);
            ArrayList<AchieveExpInfo> infos = new ArrayList<AchieveExpInfo>(16);
            List<Long> sscIds = AchieveUtil.getSscCenters();
            List<Long> exitSscIds = AchieveUtil.getExistWorkCalendarSsc(sscIds, beforeDay);
            for (Long sid : exitSscIds) {
                AchieveExpInfo achieveExpInfo = AchieveUtil.buildAchieveExp(sid, AchieveExpEnum.SSC_USERONDUTYTIME.getValue(), "1", 0, e.getMessage(), beforeDay, beforeDay);
                infos.add(achieveExpInfo);
            }
            AchieveUtil.saveAchieveExp(infos);
        }
    }
}

