/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.filter.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.approveRebuild.AppTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.helper.ComboItemHelper;
import kd.ssc.task.helper.FormShowParameterHelper;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;

public class TaskSscIdFilterServiceImpl
implements TaskCommonFilterService {
    public static final Log log = LogFactory.getLog(TaskSscIdFilterServiceImpl.class);

    @Override
    public void invokeAudit(CommonFilterDTO commonFilterDTO) {
        String ssc = commonFilterDTO.getPageCache().get("sscid.id");
        IDataEntityProperty basedataProp = commonFilterDTO.getFc().getEntityType().findProperty(commonFilterDTO.getFc().getEntityType().getMainOrg());
        QFilter mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)((BasedataProp)basedataProp), (String)"task_task", (String)commonFilterDTO.getAppId());
        List<ComboItem> sscItems = CommonFilterUtil.getComboItems("bos_org", mainOrgFilter);
        ArrayList<String> sscTypeList = new ArrayList<String>();
        sscTypeList.add(SSCTypeEnum.HR.getValue());
        this.filterSscBySscTpe(sscItems, sscTypeList);
        commonFilterDTO.getCommonFilterColumn().setComboItems(sscItems);
        commonFilterDTO.getPageCache().put("myTaskListSscStr", SerializationUtils.toJsonString(sscItems.stream().map(ComboItem::getValue).collect(Collectors.toList())));
        if (ssc == null) {
            String sscId = ComboItemHelper.getSscId(sscItems, RequestContext.get().getOrgId());
            commonFilterDTO.getPageCache().put("sscid.id", sscId);
            commonFilterDTO.getCommonFilterColumn().setDefaultValue(sscId);
            if ("-1".equals(sscId)) {
                commonFilterDTO.setRight(false);
            }
        } else {
            commonFilterDTO.getPageCache().put("sscid.id", ssc);
            String isScheme = commonFilterDTO.getPageCache().get("isSchemeFilter");
            String isSsc = commonFilterDTO.getPageCache().get("isSscid");
            if ("true".equals(isScheme)) {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(ssc);
            }
            if ("true".equals(isSsc)) {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(ssc);
                commonFilterDTO.getPageCache().put("isSscid", "false");
            }
        }
    }

    @Override
    public void invokeQuality(CommonFilterDTO commonFilterDTO) {
        this.invokeAudit(commonFilterDTO);
    }

    @Override
    public void invokeAuditAdmin(CommonFilterDTO commonFilterDTO) {
        ArrayList<String> sscTypeList;
        IDataEntityProperty basedataProp = commonFilterDTO.getFc().getEntityType().findProperty(commonFilterDTO.getFc().getEntityType().getMainOrg());
        QFilter mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)((BasedataProp)basedataProp), (String)"task_administrate", (String)commonFilterDTO.getAppId());
        List<ComboItem> sscItems = CommonFilterUtil.getComboItems("bos_org", mainOrgFilter);
        sscItems = CommonFilterUtil.handleUserGroupFilter(sscItems, true, commonFilterDTO);
        IFormView formView = commonFilterDTO.getFormView();
        String appId = formView.getFormShowParameter().getAppId();
        String cusAppId = (String)formView.getFormShowParameter().getCustomParam("cusAppId");
        if (StringUtils.isNotEmpty((CharSequence)cusAppId)) {
            appId = cusAppId;
        }
        if (AppTypeEnum.HSTC.getValue().equals(appId)) {
            sscTypeList = new ArrayList<String>();
            sscTypeList.add(SSCTypeEnum.GM.getValue());
            sscTypeList.add(SSCTypeEnum.FI.getValue());
            this.filterSscBySscTpe(sscItems, sscTypeList);
        } else {
            sscTypeList = new ArrayList();
            sscTypeList.add(SSCTypeEnum.HR.getValue());
            this.filterSscBySscTpe(sscItems, sscTypeList);
        }
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
        if (sscItems.size() > 0) {
            List comboItemList = commonFilterDTO.getCommonFilterColumn().getComboItems();
            comboItemList.clear();
            commonFilterDTO.getCommonFilterColumn().setComboItems(sscItems);
            String sscid = commonFilterDTO.getPageCache().get("sscid");
            if ("true".equals(commonFilterDTO.getPageCache().get("is_firsttime_from_index"))) {
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(sscid);
                commonFilterDTO.getCommonFilterColumn().setDefValue(sscid);
                return;
            }
            if (null == commonFilterDTO.getPageCache().get("isfirstSetSSC") || "true".equals(commonFilterDTO.getPageCache().get("isSchemeFilter"))) {
                sscid = ComboItemHelper.getSscId(sscItems, RequestContext.get().getOrgId());
                commonFilterDTO.getPageCache().put("sscid", sscid);
                commonFilterDTO.getPageCache().put("isfirstSetSSC", "false");
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(sscid);
                commonFilterDTO.getCommonFilterColumn().setDefValue(sscid);
            }
        } else {
            commonFilterDTO.setRight(false);
        }
    }

    @Override
    public void invokeQualityList(CommonFilterDTO commonFilterDTO) {
        List sscIds = (List)FormShowParameterHelper.getParameterByKey(commonFilterDTO.getFormView(), "qualitysscid");
        String source = (String)FormShowParameterHelper.getParameterByKey(commonFilterDTO.getFormView(), "sources");
        IDataEntityProperty basedataProp = commonFilterDTO.getFc().getEntityType().findProperty(commonFilterDTO.getFc().getEntityType().getMainOrg());
        QFilter mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)((BasedataProp)basedataProp), (String)"task_doqualitymanagement", (String)commonFilterDTO.getAppId());
        String sscid = "-1";
        List<ComboItem> sscItems = CommonFilterUtil.getComboItems("bos_org", mainOrgFilter);
        sscItems = CommonFilterUtil.handleUserGroupFilter(sscItems, false, commonFilterDTO);
        ArrayList<String> sscTypeList = new ArrayList<String>();
        sscTypeList.add(SSCTypeEnum.HR.getValue());
        this.filterSscBySscTpe(sscItems, sscTypeList);
        log.info("mainOrgFilter: " + mainOrgFilter + "***sscItems.size=" + sscItems.size() + "***");
        if (sscItems.size() > 0) {
            List listcomitemSsc = commonFilterDTO.getCommonFilterColumn().getComboItems();
            listcomitemSsc.clear();
            commonFilterDTO.getCommonFilterColumn().setComboItems(sscItems);
            String cahceSscid = commonFilterDTO.getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
            if (StringUtils.isEmpty((CharSequence)cahceSscid)) {
                sscid = "qualitysamplelibrary".equalsIgnoreCase(source) ? (sscIds == null || sscIds.get(0) == null ? null : sscIds.get(0).toString()) : ComboItemHelper.getSscId(sscItems, RequestContext.get().getOrgId());
                commonFilterDTO.getCommonFilterColumn().setDefaultValue(sscid);
            } else {
                sscid = cahceSscid;
            }
            commonFilterDTO.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SSCID", sscid);
        } else {
            commonFilterDTO.setRight(false);
            commonFilterDTO.getPageCache().put("CACHE_QUALITYCHECKMANAGEMENT_SSCID", sscid);
        }
        commonFilterDTO.getCommonFilterColumn().setMustInput(true);
    }

    private void filterSscBySscTpe(List<ComboItem> sscItems, List<String> sscTypeList) {
        if (CollectionUtils.isNotEmpty(sscItems)) {
            List sscIdList = sscItems.stream().map(p -> Long.valueOf(p.getValue())).collect(Collectors.toList());
            Map sscTypeMap = DutyManageDataHelper.getSSCTypeByBatch(sscIdList);
            Iterator<ComboItem> iterator = sscItems.iterator();
            while (iterator.hasNext()) {
                ComboItem sscItem = iterator.next();
                Long sscId = Long.valueOf(sscItem.getValue());
                String sscType = (String)sscTypeMap.get(sscId);
                if (StringUtils.isEmpty((CharSequence)sscType)) {
                    sscType = SSCTypeEnum.GM.getValue();
                }
                if (!sscTypeList.contains(sscType)) continue;
                iterator.remove();
            }
        }
    }
}

