/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.filter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.common.TaskTypeUtil;
import kd.ssc.task.service.filter.TaskCommonFilterService;
import kd.ssc.task.service.filter.dto.CommonFilterDTO;

public class TaskTypeFilterServiceImpl
implements TaskCommonFilterService {
    @Override
    public void invokeAudit(CommonFilterDTO commonFilterDTO) {
        String sscid = commonFilterDTO.getPageCache().get("sscid.id");
        List listcomitem = commonFilterDTO.getCommonFilterColumn().getComboItems();
        listcomitem.clear();
        if (StringUtils.isNotBlank((CharSequence)sscid)) {
            FormShowParameter formShowParameter = commonFilterDTO.getFormView().getFormShowParameter();
            List taskPropertyList = (List)formShowParameter.getCustomParam("taskPropertyList");
            if (!CollectionUtils.isEmpty((Collection)taskPropertyList)) {
                QFilter taskpropertyfilter = new QFilter("qualityjudge", "in", (Object)taskPropertyList);
                QFilter sscfilter = new QFilter("orgfield", "=", (Object)Long.valueOf(sscid));
                List<String> tasktypelist = TaskTypeUtil.getTaskTypeIds(new QFilter[]{sscfilter, taskpropertyfilter});
                commonFilterDTO.getCommonFilterColumn().setDefaultValues(tasktypelist.toArray());
            }
            this.setComboItems(commonFilterDTO, sscid, null);
        }
    }

    private void setComboItems(CommonFilterDTO commonFilterDTO, String sscid, QFilter andFilter) {
        List<ComboItem> taskType;
        QFilter filter = new QFilter("orgfield", "=", (Object)Long.valueOf(sscid));
        if (andFilter != null) {
            filter.and(andFilter);
        }
        if ((taskType = CommonFilterUtil.getComboItems("task_tasktype", filter)).size() == 0) {
            taskType.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TaskTypeFilterServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0])), ""));
        }
        commonFilterDTO.getCommonFilterColumn().setComboItems(taskType);
    }

    @Override
    public void invokeQuality(CommonFilterDTO commonFilterDTO) {
        this.invokeAudit(commonFilterDTO);
    }

    @Override
    public void invokeQualityList(CommonFilterDTO commonFilterDTO) {
        List taskTypeCbList = commonFilterDTO.getCommonFilterColumn().getComboItems();
        taskTypeCbList.clear();
        String sscid = commonFilterDTO.getPageCache().get("CACHE_QUALITYCHECKMANAGEMENT_SSCID");
        QFilter taskpropertyfilter = new QFilter("qualityjudge", "=", (Object)TaskPropertyEnum.QUACHECKTASK.getValue());
        String tasktypeIdString = commonFilterDTO.getPageCache().get("taskManager_Usergroup_Tasktype");
        if (tasktypeIdString != null) {
            ArrayList tasktypeIdList = (ArrayList)SerializationUtils.fromJsonStringToList((String)tasktypeIdString, Long.class);
            QFilter tasktypeIdFilter = new QFilter("id", "in", (Object)tasktypeIdList);
            taskpropertyfilter.and(tasktypeIdFilter);
        }
        this.setComboItems(commonFilterDTO, sscid, taskpropertyfilter);
    }

    @Override
    public void invokeAuditAdmin(CommonFilterDTO commonFilterDTO) {
        String sscid = commonFilterDTO.getPageCache().get("sscid");
        List listcomitemBilltype = commonFilterDTO.getCommonFilterColumn().getComboItems();
        listcomitemBilltype.clear();
        if (sscid != null) {
            String tasktypeIdString = commonFilterDTO.getPageCache().get("taskManager_Usergroup_Tasktype");
            QFilter taskpropertyfilter = new QFilter("qualityjudge", "!=", (Object)TaskPropertyEnum.QUACHECKTASK.getValue());
            if (tasktypeIdString != null) {
                ArrayList tasktypeIdList = (ArrayList)SerializationUtils.fromJsonStringToList((String)tasktypeIdString, Long.class);
                QFilter tasktypeIdFilter = new QFilter("id", "in", (Object)tasktypeIdList);
                taskpropertyfilter.and(tasktypeIdFilter);
            }
            this.setComboItems(commonFilterDTO, sscid, taskpropertyfilter);
        }
    }
}

