/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.rpt.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.service.rpt.TaskCountService;

public class TaskCountServiceImpl
implements TaskCountService {
    private static final String PROCESSING = "processing";
    private static final String FINISH = "finish";
    private static final String FIELDS = "receivetime, sscid, tasktypeid, personid, pooltype, coefficient";
    private static final int PAGE_SIZE = 1000;
    private static String[] groupBy = new String[]{"sscid", "tasktypeid", "personid"};

    @Override
    public void countTask() {
        DateRangeEnum[] dateRangeEnums = DateRangeEnum.values();
        for (int i = 0; i < dateRangeEnums.length; ++i) {
            DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnums[i]);
            DataSet taskData = this.query(dateRangeEnums[i]);
            taskData = this.process(taskData, dateRange.getStartDate(), dateRange.getEndDate());
            this.delete(dateRangeEnums[i]);
            this.save(taskData, dateRangeEnums[i]);
        }
    }

    private DataSet query(DateRangeEnum dateRangeEnum) {
        String fields = FIELDS;
        QFilter[] processingFilters = this.getFilters(PROCESSING, dateRangeEnum);
        QFilter[] finishFilters = this.getFilters(FINISH, dateRangeEnum);
        DataSet processingData = QueryServiceHelper.queryDataSet((String)"TaskCountServiceImpl.query", (String)"task_task", (String)fields, (QFilter[])processingFilters, null);
        DataSet finishedData = QueryServiceHelper.queryDataSet((String)"TaskCountServiceImpl.query", (String)"task_taskhistory", (String)fields, (QFilter[])finishFilters, null);
        return processingData.union(finishedData);
    }

    private DataSet process(DataSet taskData, Date startDate, Date endDate) {
        String recvTimeCaseFilter = this.getRecvTimeCaseFilter(startDate, endDate);
        return taskData.groupBy(groupBy).sum("cast(case when pooltype = '1' then 1 else 0 end as integer)", PROCESSING).sum("cast(case when " + recvTimeCaseFilter + " then 1 else 0 end as integer)", "allocated").sum("cast(case when pooltype = '2' then 1 else 0 end as integer)", "taskcount").sum("cast(case when pooltype = '2' then coefficient else 0 end as double)", "rankcoefficient").sum("cast(case when pooltype = '1' then coefficient else 0 end as double)", "processingrankcoefficient").finish();
    }

    private void delete(DateRangeEnum dateRangeEnum) {
        QFilter filter = new QFilter("daterange", "=", (Object)dateRangeEnum.getValue());
        DeleteServiceHelper.delete((String)"task_counttask", (QFilter[])new QFilter[]{filter});
    }

    private void save(DataSet dataSet, DateRangeEnum dateRangeEnum) {
        int totalCount = dataSet.copy().count("sscid", false);
        int pageCount = totalCount / 1000;
        int remiCount = totalCount;
        for (int i = 0; i <= pageCount; ++i) {
            int fromIndex = i * 1000;
            int pageSizeAcu = Math.min(remiCount, 1000);
            DataSet subDataSet = dataSet.range(fromIndex, pageSizeAcu);
            this.savePage(subDataSet, dateRangeEnum, pageSizeAcu);
            if ((remiCount -= 1000) <= 0) break;
        }
        dataSet.close();
    }

    private void savePage(DataSet subDataSet, DateRangeEnum dateRangeEnum, int size) {
        DynamicObject[] dataArr = new DynamicObject[size];
        int i = 0;
        for (Row row : subDataSet) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"task_counttask");
            obj.set("sscid", row.get("sscid"));
            obj.set("tasktypeid", row.get("tasktypeid"));
            obj.set("daterange", (Object)dateRangeEnum.getValue());
            obj.set("personid", row.get("personid"));
            obj.set("rankcoefficient", row.get("rankcoefficient"));
            obj.set("processingrankcoefficient", row.get("processingrankcoefficient"));
            obj.set("taskcount", row.get("taskcount"));
            obj.set(PROCESSING, row.get(PROCESSING));
            obj.set("allocated", row.get("allocated"));
            obj.set("createtime", (Object)new Date());
            dataArr[i++] = obj;
        }
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    private HashSet<Long> getUsers() {
        HashSet<Long> users = new HashSet<Long>();
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter robotsFilter = new QFilter("isrobots", "=", (Object)"0");
        DynamicObjectCollection dync = QueryServiceHelper.query((String)(this.getClass().getName() + ".users"), (String)"task_usergroup", (String)"id,entryentity.userfield userid", (QFilter[])new QFilter[]{enable, status, robotsFilter}, null);
        for (DynamicObject dyn : dync) {
            users.add(dyn.getLong("userid"));
        }
        return users;
    }

    private QFilter[] getFilters(String type, DateRangeEnum dateRangeEnum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<Long> users = this.getUsers();
        filters.add(new QFilter("personid", "in", users));
        filters.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        filters.add(new QFilter("autoprocess", "=", (Object)"0"));
        if (PROCESSING.equalsIgnoreCase(type)) {
            filters.add(new QFilter("pooltype", "=", (Object)"1"));
        }
        if (FINISH.equalsIgnoreCase(type)) {
            filters.add(new QFilter("pooltype", "=", (Object)"2"));
            filters.add(new QFilter("ishandled", "=", (Object)"0"));
            DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnum);
            filters.add(new QFilter("completetime", ">=", (Object)dateRange.getStartDate()));
            filters.add(new QFilter("completetime", "<", (Object)dateRange.getEndDate()));
        }
        return filters.toArray(new QFilter[0]);
    }

    private String getRecvTimeCaseFilter(Date startDate, Date endDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int receiveTime1 = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        calendar.setTime(endDate);
        int receiveTime2 = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        return "cast(year(receivetime) as integer)*10000+cast( month(receivetime) as integer)*100+cast(day(receivetime) as integer) >= " + receiveTime1 + " and cast(year(receivetime) as integer)*10000+cast( month(receivetime) as integer)*100+cast(day(receivetime) as integer) < " + receiveTime2;
    }
}

