/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.rpt.impl;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.DateRangeEnum;
import kd.ssc.task.common.DateRangeUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.formplugin.pojo.DateRange;
import kd.ssc.task.service.rpt.TaskCountService;

public class TaskTableCountServiceImpl
implements TaskCountService {
    private static final String SELECTFIELD = "pooltype,sscid,tasktypeid,personid,orgid,billtype";
    private static final String[] GROUPBY = new String[]{"sscid", "pooltype", "tasktypeid", "personid", "orgid", "billtype"};
    private static final int PAGE_SIZE = 1000;

    @Override
    public void countTask() {
        DateRangeEnum[] dateRangeEnums;
        for (DateRangeEnum dateRangeEnum : dateRangeEnums = DateRangeEnum.values()) {
            DateRange dateRange = DateRangeUtil.getDateRange(dateRangeEnum);
            DataSet taskData = this.query(dateRange);
            taskData = this.process(taskData);
            this.delete(dateRangeEnum);
            this.save(taskData, dateRangeEnum);
        }
    }

    private DataSet query(DateRange dateRange) {
        QFilter[] filters2dist = this.getFilters(dateRange, 0);
        DataSet data2dist = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.TaskTableCountServiceImpl.query", (String)"task_task", (String)SELECTFIELD, (QFilter[])filters2dist, null);
        QFilter[] filtersProc = this.getFilters(dateRange, 1);
        DataSet dataProc = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.TaskTableCountServiceImpl.query", (String)"task_task", (String)SELECTFIELD, (QFilter[])filtersProc, null);
        QFilter[] filtersCompl = this.getFilters(dateRange, 2);
        DataSet dataCompl = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.TaskTableCountServiceImpl.query", (String)"task_taskhistory", (String)SELECTFIELD, (QFilter[])filtersCompl, null);
        return data2dist.union(dataProc).union(dataCompl);
    }

    private DataSet process(DataSet dataSet) {
        String caseSql = this.getCaseSql(0);
        DataSet dataSet2dist = dataSet.copy().select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        caseSql = this.getCaseSql(1);
        DataSet dataSetProc = dataSet.copy().select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        caseSql = this.getCaseSql(2);
        DataSet dataSetCompl = dataSet.copy().select(SELECTFIELD).groupBy(GROUPBY).sum(caseSql, "count").finish();
        return dataSet2dist.union(dataSetProc).union(dataSetCompl);
    }

    private void delete(DateRangeEnum dateRangeEnum) {
        QFilter filter = new QFilter("datetype", "=", (Object)dateRangeEnum.getValue());
        DeleteServiceHelper.delete((String)"task_progress_statistics", (QFilter[])new QFilter[]{filter});
    }

    private void save(DataSet taskData, DateRangeEnum dateRangeEnum) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1000);
        int currentIndex = 0;
        for (Row row : taskData) {
            DynamicObject dyo = this.saveDyoFromQryRow(row, dateRangeEnum);
            dynamicObjectList.add(dyo);
            if (currentIndex % 1000 == 999) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
                dynamicObjectList.clear();
            }
            ++currentIndex;
        }
        if (!dynamicObjectList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject saveDyoFromQryRow(Row row, DateRangeEnum dateRangeEnum) {
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)"task_progress_statistics");
        dyo.set("sscid", row.get("sscid"));
        dyo.set("tasktypeid", row.get("tasktypeid"));
        dyo.set("pooltype", row.get("pooltype"));
        dyo.set("datetype", (Object)dateRangeEnum.getValue());
        dyo.set("personid", row.get("personid"));
        dyo.set("orgid", row.get("orgid"));
        dyo.set("billtype", row.get("billtype"));
        dyo.set("count", row.get("count"));
        return dyo;
    }

    private QFilter[] getFilters(DateRange dateRange, int pooltype) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK));
        filterList.add(new QFilter("autoprocess", "=", (Object)"0"));
        if (pooltype == 0) {
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue()));
        } else if (pooltype == 1) {
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue()));
        } else {
            filterList.add(new QFilter("createtime", ">=", (Object)dateRange.getStartDate()));
            filterList.add(new QFilter("createtime", "<", (Object)dateRange.getEndDate()));
            filterList.add(new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.COMPLETE.getValue()));
        }
        return filterList.toArray(new QFilter[0]);
    }

    private String getCaseSql(int pooltype) {
        return String.format("cast(case when pooltype = '%d' then 1 else 0 end as integer)", pooltype);
    }
}

