/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.userworkload;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterScriptBuilder;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.WorkLoad;
import kd.ssc.task.dis.WorkLoadUtil;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.util.DateUtil;
import kd.ssc.task.util.TaskDisUtil;

public class TaskUserWorkLoadHelper {
    private static final Log log = LogFactory.getLog(TaskUserWorkLoadHelper.class);
    private static final String DISRULEMETA = "task_disrule";

    public static String getFormId() {
        String formId = "task_userworkload_new";
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"taskUserWorkLoadBackUp"))) {
            formId = "task_userworkload";
        }
        return formId;
    }

    public static Map<String, WorkerStatusPojo> initEnableAndWorkUserMap(DynamicObjectCollection rows) {
        Object workerStatusPojo;
        log.info("Optimize initEnableAndWorkUserMap() begin");
        long begin2 = System.currentTimeMillis();
        HashMap<String, WorkerStatusPojo> workerStatusMap = new HashMap<String, WorkerStatusPojo>(16);
        HashSet<Long> groupIdSet = new HashSet<Long>(8);
        HashSet<Long> userIdSet = new HashSet<Long>(16);
        Long sscId = null;
        String timezoneNumber = "";
        for (DynamicObject row : rows) {
            if (sscId == null) {
                sscId = row.getLong("createorg.id");
                timezoneNumber = row.getString("createorg.timezone.number");
            }
            Long userGroupID = row.getLong("id");
            BigDecimal ability = row.getBigDecimal("entryentity.ability").setScale(1, RoundingMode.HALF_UP);
            Long userID = ((DynamicObject)row.get("entryentity.userfield")).getLong("id");
            workerStatusPojo = new WorkerStatusPojo();
            ((WorkerStatusPojo)workerStatusPojo).setSscId(sscId);
            ((WorkerStatusPojo)workerStatusPojo).setUserId(userID);
            ((WorkerStatusPojo)workerStatusPojo).setUserGroupId(userGroupID);
            ((WorkerStatusPojo)workerStatusPojo).setTimezoneNumber(timezoneNumber);
            ((WorkerStatusPojo)workerStatusPojo).setAbilityValue(ability);
            groupIdSet.add(userGroupID);
            userIdSet.add(userID);
            workerStatusMap.put(userGroupID + "_" + userID, (WorkerStatusPojo)workerStatusPojo);
        }
        Map<Long, Set<Long>> userMapOnWork = SscWorkCalendarApi.queryUserOnWork(groupIdSet, DateUtil.changeTimeZone((Date)new Date(), (String)timezoneNumber));
        QFilter PersonIDS = new QFilter("personid", "in", userIdSet);
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        DataSet taskDS = QueryServiceHelper.queryDataSet((String)"TaskUserWorkLoadHelper QueryTask", (String)"task_task", (String)"personid,usergroup", (QFilter[])new QFilter[]{PersonIDS, disedTKFilter}, null);
        workerStatusPojo = null;
        try (DataSet taskAfterGroupDS2 = taskDS.groupBy(new String[]{"personid", "usergroup"}).count("workload").finish().orderBy(new String[]{"workload desc"});){
            for (Row taskAfterOrderRow : taskAfterGroupDS2) {
                Long persionID = taskAfterOrderRow.getLong("personid");
                Long usergroup = taskAfterOrderRow.getLong("usergroup");
                Integer workload = taskAfterOrderRow.getInteger("workload");
                WorkerStatusPojo workerStatusPojo2 = (WorkerStatusPojo)workerStatusMap.get(usergroup + "_" + persionID);
                if (workerStatusPojo2 == null) continue;
                workerStatusPojo2.setTaskTotal(workload);
            }
        }
        catch (Throwable taskAfterGroupDS2) {
            workerStatusPojo = taskAfterGroupDS2;
            throw taskAfterGroupDS2;
        }
        finally {
            if (taskDS != null) {
                if (workerStatusPojo != null) {
                    try {
                        taskDS.close();
                    }
                    catch (Throwable taskAfterGroupDS2) {
                        ((Throwable)workerStatusPojo).addSuppressed(taskAfterGroupDS2);
                    }
                } else {
                    taskDS.close();
                }
            }
        }
        for (Map.Entry entry : workerStatusMap.entrySet()) {
            WorkerStatusPojo workerStatusPojo3 = (WorkerStatusPojo)entry.getValue();
            Set<Long> userIds = userMapOnWork.get(workerStatusPojo3.getUserGroupId());
            if (CollectionUtils.isNotEmpty(userIds) && userIds.contains(workerStatusPojo3.getUserId())) {
                workerStatusPojo3.setPresent(true);
                continue;
            }
            workerStatusPojo3.setPresent(false);
        }
        long end2 = System.currentTimeMillis();
        log.info("Optimize initEnableAndWorkUserMap() end :{}ms, groupIdSet={}, rowsSize={}", new Object[]{end2 - begin2, groupIdSet.size(), rows.size()});
        return workerStatusMap;
    }

    public static WorkerStatusPojo getMatchAndLeastPerson(List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, Long applierOfCurTask) {
        WorkLoad workLoad = new WorkLoad();
        HashMap<Long, Integer> groupId2Priority = TaskUserWorkLoadHelper.buildHandleGroupMapByAssign(new ArrayList<Long>(4), taskOrgList, taskSscList, taskIdList, tIDTTypeBTypeList);
        if (groupId2Priority.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", groupId2Priority.keySet());
        QFilter userGroupEnable = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        QFilter exceptRebotsFilter = new QFilter("isrobots", "!=", (Object)"1");
        ArrayList<QFilter> usergroupFilterList = new ArrayList<QFilter>(3);
        usergroupFilterList.add(filter);
        usergroupFilterList.add(userGroupEnable);
        usergroupFilterList.add(exceptRebotsFilter);
        workLoad.setUsergroupFilterList(usergroupFilterList);
        workLoad.setGroupId2Priority(groupId2Priority);
        workLoad.setApplierOfCurTask(applierOfCurTask);
        workLoad.prepareData();
        return workLoad.getMatchAndLeastPerson();
    }

    public static HashMap<Long, Integer> buildHandleGroupMapByAssign(List<Long> errDyns, List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList) {
        HashMap<Long, Integer> groupId2Priority = new HashMap<Long, Integer>(8);
        DynamicObject[] disrules = TaskUserWorkLoadHelper.buildLongNumGatherRuleMap(taskSscList, tIDTTypeBTypeList);
        if (CollectionUtils.isEmpty(taskOrgList)) {
            return groupId2Priority;
        }
        Map<Long, String> billTypeMap = TaskUserWorkLoadHelper.buildTypeMap();
        for (String taskOrgIdStr : taskOrgList) {
            for (DynamicObject rule : disrules) {
                try {
                    TaskUserWorkLoadHelper.ruleMatching(groupId2Priority, billTypeMap, taskOrgIdStr, rule, taskIdList);
                }
                catch (Exception e) {
                    Long id = rule.getLong("id");
                    errDyns.add(id);
                    log.error("\u4efb\u52a1\u5206\u914d\u6761\u4ef6\u5339\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u5206\u914d\u89c4\u5219id\uff1a" + id, (Throwable)e);
                }
            }
        }
        return groupId2Priority;
    }

    private static Map<Long, String> buildTypeMap() {
        DynamicObject[] billTypeDyObjs = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"bindbill.number", null);
        HashMap<Long, String> billTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject billType : billTypeDyObjs) {
            long billTypeID = billType.getLong("id");
            String billTypeNum = billType.getString("bindbill.number");
            if (StringUtils.isEmpty((String)billTypeNum)) continue;
            billTypeMap.put(billTypeID, billTypeNum);
        }
        return billTypeMap;
    }

    private static void ruleMatching(HashMap<Long, Integer> groupId2Priority, Map<Long, String> billTypeMap, String taskOrgIdStr, DynamicObject rule, List<Long> taskIdList) {
        DynamicObjectCollection entryCols = rule.getDynamicObjectCollection("entryentity1");
        DynamicObjectCollection entryRules = rule.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty(taskIdList)) {
            return;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)"id,tasktypeid,billtype,state,orgid,sscid,billid,creator", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIdList)});
        String billId = task.getString("billid");
        Long creator = task.getLong("creator.id");
        Long billTypeId = task.getLong("billtype.id");
        String ssc = task.getString("sscid.id");
        boolean isMatched = false;
        for (DynamicObject entryRule : entryRules) {
            Long billType = entryRule.getLong("billtype.id");
            if (billTypeId.compareTo(billType) != 0) continue;
            String filterRuleJson = entryRule.getString("filterrulejson_tag");
            String applyCreditLevelJson = entryRule.getString("applycreditleveljoson_tag");
            String metaNum = billTypeMap.get(billType);
            if (!TaskUserWorkLoadHelper.billCusFilterMatch(metaNum, billId, filterRuleJson) || !TaskUserWorkLoadHelper.creditMatch(applyCreditLevelJson, creator, ssc)) continue;
            isMatched = true;
            break;
        }
        if (!isMatched) {
            return;
        }
        Long targetOrgId = Long.valueOf(taskOrgIdStr);
        block1: for (DynamicObject entryObj : entryCols) {
            DynamicObjectCollection ruleOrgCols = entryObj.getDynamicObjectCollection("orgrange");
            for (DynamicObject ruleOrg : ruleOrgCols) {
                Long groupId;
                Integer priority;
                if (targetOrgId.compareTo(ruleOrg.getLong("FBasedataId_id")) != 0 || (priority = groupId2Priority.get(groupId = Long.valueOf(entryObj.getDynamicObject("usergroup").getLong("id")))) != null && priority <= rule.getInt("priority")) continue;
                groupId2Priority.put(groupId, rule.getInt("priority"));
                continue block1;
            }
        }
    }

    private static boolean billCusFilterMatch(String entityName, String billIdStr, String billCusFilterJson) {
        QFilter billFilter = BillCusFilter.getBillFilter(entityName, billCusFilterJson);
        if (billFilter == null) {
            return true;
        }
        QFilter idFilters = null;
        boolean res = false;
        try {
            idFilters = new QFilter("id", "=", (Object)Long.parseLong(billIdStr));
            res = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{idFilters, billFilter});
        }
        catch (Throwable e) {
            log.warn("\u81ea\u5b9a\u4e49\u6761\u4ef6\u5339\u914d\u62a5\u9519\uff0cbillIdStr = " + billIdStr, e);
            idFilters = new QFilter("id", "=", (Object)billIdStr);
            res = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{idFilters, billFilter});
        }
        return res;
    }

    private static boolean creditMatch(String applyCreditFilter, Long userId, String sscid) {
        boolean matchresult = false;
        if (StringUtils.isEmpty((String)applyCreditFilter)) {
            log.info("\u91cd\u5206\u914d\uff1a\u672a\u8bbe\u7f6e\u4fe1\u7528\u7b49\u7ea7\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6;\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
            matchresult = true;
        } else {
            Map filters = (Map)SerializationUtils.fromJsonString((String)applyCreditFilter, HashMap.class);
            Object filterRow = filters.get("filterRow");
            if (filterRow == null || ((List)filterRow).size() == 0) {
                log.info("\u91cd\u5206\u914d\uff1a\u672a\u8bbe\u7f6e\u4fe1\u7528\u7b49\u7ea7\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6;\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
                matchresult = true;
            } else {
                QFilter[] qFilters = new QFilter[]{new QFilter("user", "in", (Object)userId), new QFilter("status", "!=", (Object)Character.valueOf('D'))};
                DynamicObject[] creditFiles = BusinessDataServiceHelper.load((String)"task_creditfiles", (String)"user.id,creditlevel.name", (QFilter[])qFilters);
                if (creditFiles.length <= 0) {
                    log.info("\u91cd\u5206\u914d\uff1a\u672a\u627e\u5230\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\uff0c\u4fe1\u7528\u5339\u914d\u5931\u8d25");
                    return matchresult;
                }
                String creLevelName = creditFiles[0].getString("creditlevel.name");
                log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a" + applyCreditFilter + ";");
                log.info("\u91cd\u5206\u914d\uff1a\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\u4e3a\uff1a" + creLevelName + ";");
                if (StringUtils.isEmpty((String)creLevelName)) {
                    log.info("\u91cd\u5206\u914d\uff1a\u672a\u627e\u5230\u7528\u6237\u4fe1\u7528\u7b49\u7ea7\uff0c\u4fe1\u7528\u5339\u914d\u5931\u8d25");
                    return matchresult;
                }
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("applycreditlevel.name", creLevelName);
                String creFormula = TaskUserWorkLoadHelper.getCreExpFormular(applyCreditFilter);
                Object result = "false";
                try {
                    result = FormulaEngine.execExcelFormula((String)creFormula, map);
                }
                catch (FormulaException e) {
                    log.error("\u91cd\u5206\u914d\uff1a\u4efb\u52a1\u5206\u914d\u89c4\u5219\u89e3\u6790\u5931\u8d25:" + creFormula, (Throwable)e);
                }
                if ("true".equals(result.toString())) {
                    log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u6210\u529f");
                    matchresult = true;
                } else {
                    log.info("\u91cd\u5206\u914d\uff1a\u4fe1\u7528\u7b49\u7ea7\u5339\u914d\u5931\u8d25");
                }
            }
        }
        return matchresult;
    }

    private static String getCreExpFormular(String applyCreditFilter) {
        String creditFilterJson = applyCreditFilter;
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)creditFilterJson, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"task_disrulef7creditlevel");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, fc);
        filterBuilder.buildFilter(false);
        FilterObject filterObject = filterBuilder.getFilterObject();
        if (filterObject == null) {
            return "1 = 2";
        }
        FilterScriptBuilder scriptBuilder = new FilterScriptBuilder();
        String[] filterScript = scriptBuilder.buildFilterScript(filterObject);
        return filterScript[0];
    }

    public static Map<Long, Integer> buildHandleGroupMapByAssignNew(List<Long> errRuleDyns, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification) {
        Long taskId = 0L;
        if (CollectionUtils.isNotEmpty(taskIdList) && taskIdList.size() == 1) {
            taskId = taskIdList.get(0);
        }
        DynamicObject[] rules = TaskUserWorkLoadHelper.buildLongNumGatherRuleMap(taskSscList, tIDTTypeBTypeList);
        Map<Long, Set<Long>> matchRuleAndGroups = Distribution.manualDistribution(taskId, rules, isRectification, errRuleDyns);
        if (matchRuleAndGroups.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, Integer> rulePriorities = TaskUserWorkLoadHelper.buildRulePriorities(matchRuleAndGroups.keySet());
        return TaskUserWorkLoadHelper.buildGroupMap(matchRuleAndGroups, rulePriorities);
    }

    private static Map<Long, Integer> buildRulePriorities(Set<Long> rules) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rules)};
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)DISRULEMETA, (String)"id,priority", (QFilter[])qFilters);
        HashMap<Long, Integer> rtnMap = new HashMap<Long, Integer>(rules.size());
        for (DynamicObject dyn : dyns) {
            rtnMap.put(dyn.getLong("id"), dyn.getInt("priority"));
        }
        return rtnMap;
    }

    private static Map<Long, Integer> buildGroupMap(Map<Long, Set<Long>> matchRuleAndGroups, Map<Long, Integer> rulePriorities) {
        HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>(8);
        for (Map.Entry<Long, Set<Long>> entry : matchRuleAndGroups.entrySet()) {
            Long rule = entry.getKey();
            Set<Long> groups = entry.getValue();
            Integer priority = rulePriorities.get(rule);
            for (Long groupId : groups) {
                Integer oldValue = groupMap.computeIfAbsent(groupId, g -> priority);
                if (oldValue <= priority) continue;
                groupMap.put(groupId, priority);
            }
        }
        return groupMap;
    }

    public static DynamicObject[] buildLongNumGatherRuleMap(List<String> taskSscList, List<String> tIDTTypeBTypeList) {
        QFilter[] qfilters = TaskUserWorkLoadHelper.buildFilterByTaskParam(taskSscList, tIDTTypeBTypeList);
        DynamicObject[] disrules = BusinessDataServiceHelper.load((String)DISRULEMETA, (String)"id,number,name,priority,ssccenter,tasktype,entryentity1.id,entryentity1.orgrange,entryentity1.usergroup,entryentity.billtype,entryentity.filterrulejson_tag,entryentity.applycreditleveljoson_tag", (QFilter[])qfilters);
        return disrules;
    }

    private static QFilter[] buildFilterByTaskParam(List<String> taskSscList, List<String> tIDTTypeBTypeList) {
        QFilter sscQFilter = TaskUserWorkLoadHelper.buildSscQfilterBySscidList("ssccenter", taskSscList);
        QFilter billTypeAndTaskTypeQFilter = TaskUserWorkLoadHelper.buildCurTaskDisRuleQfilterByTypeAndSsc(tIDTTypeBTypeList);
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        billTypeAndTaskTypeQFilter = billTypeAndTaskTypeQFilter.and(sscQFilter).and(disruleEnbaleQFilter);
        QFilter[] qfilters = new QFilter[]{billTypeAndTaskTypeQFilter};
        return qfilters;
    }

    public static QFilter buildSscQfilterBySscidList(String field, List<String> taskSscList) {
        if (CollectionUtils.isEmpty(taskSscList)) {
            return new QFilter(field, "=", (Object)"-1");
        }
        String sscid = taskSscList.get(0);
        return new QFilter(field, "=", (Object)Long.valueOf(sscid));
    }

    private static QFilter buildCurTaskDisRuleQfilterByTypeAndSsc(List<String> tIDTTypeBTypeList) {
        QFilter billTypeAndTaskTypeQFilter = new QFilter("id", "!=", (Object)-10);
        if (CollectionUtils.isEmpty(tIDTTypeBTypeList)) {
            return billTypeAndTaskTypeQFilter;
        }
        for (String taskTypeBillType : tIDTTypeBTypeList) {
            if (taskTypeBillType == null) continue;
            String[] taskTypeBillTypes = taskTypeBillType.split(",");
            QFilter taskTypeQFilter = new QFilter("tasktype", "=", (Object)Long.valueOf(taskTypeBillTypes[0]));
            QFilter billTypeQFilter = new QFilter("entryentity.billtype", "=", (Object)Long.valueOf(taskTypeBillTypes[1]));
            taskTypeQFilter = taskTypeQFilter.and(billTypeQFilter);
            billTypeAndTaskTypeQFilter = billTypeAndTaskTypeQFilter.and(taskTypeQFilter);
        }
        return billTypeAndTaskTypeQFilter;
    }

    public static WorkerStatusPojo queryReformerMinWorkload(List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification, boolean isExceptRebots) {
        List<WorkerStatusPojo> resultList = TaskUserWorkLoadHelper.queryGridData(false, taskOrgList, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification, isExceptRebots);
        if (resultList != null && resultList.size() > 0) {
            return resultList.get(0);
        }
        return null;
    }

    private static List<WorkerStatusPojo> queryGridData(boolean includenoperm, List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification, boolean isExceptRebots) {
        List<Object> userIDList = new ArrayList(8);
        userIDList = !includenoperm ? TaskUserWorkLoadHelper.getDisUserAndUserGroupIDS(taskOrgList, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification, isExceptRebots) : TaskUserWorkLoadHelper.getAllUserInGroup(taskSscList);
        TaskUserWorkLoadHelper.addUserWorklingJobLoad(userIDList);
        return userIDList;
    }

    private static List<WorkerStatusPojo> getDisUserAndUserGroupIDS(List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification, boolean isExceptRebots) {
        List<Long> userGroupIDList = TaskUserWorkLoadHelper.getMatchedUserGroup(taskOrgList, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification);
        List<WorkerStatusPojo> userIDList = TaskUserWorkLoadHelper.addUserGoupMembers(userGroupIDList, isExceptRebots);
        return userIDList;
    }

    private static List<Long> getMatchedUserGroup(List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification) {
        ArrayList<Long> userGroupIDList = new ArrayList<Long>(8);
        HashSet<Long> groupHandlerHashSet = TaskUserWorkLoadHelper.buildHandleGroupMap(taskOrgList, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification);
        userGroupIDList.addAll(groupHandlerHashSet);
        return userGroupIDList;
    }

    public static List<WorkerStatusPojo> addUserGoupMembers(List<Long> userGroupIDList, boolean isExceptRebots) {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter userGroupFilter = new QFilter("id", "in", userGroupIDList);
        QFilter userGroupEnable = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        filters.add(userGroupFilter);
        filters.add(userGroupEnable);
        QFilter enableQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter userEnabled = new QFilter("entryentity.usestatus", "=", (Object)Character.valueOf('1'));
        filters.add(enableQF);
        filters.add(userEnabled);
        if (isExceptRebots) {
            QFilter exceptRebotsFilter = new QFilter("isrobots", "!=", (Object)"1");
            filters.add(exceptRebotsFilter);
        }
        QFilter[] filterArr = new QFilter[filters.size()];
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])filters.toArray(filterArr));
        TaskUserWorkLoadHelper.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }

    private static HashSet<Long> buildHandleGroupMap(List<String> taskOrgList, List<String> taskSscList, List<Long> taskIdList, List<String> tIDTTypeBTypeList, boolean isRectification) {
        if (CollectionUtils.isEmpty(taskIdList)) {
            return new HashSet<Long>(8);
        }
        Long taskId = taskIdList.get(0);
        DynamicObject[] disrules = TaskUserWorkLoadHelper.buildLongNumGatherRuleMap(taskSscList, tIDTTypeBTypeList);
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            ArrayList<Long> errRuleDyns = new ArrayList<Long>(4);
            Map<Long, Set<Long>> matchRuleAndGroups = Distribution.manualDistribution(taskId, disrules, isRectification, errRuleDyns);
            if (matchRuleAndGroups.isEmpty()) {
                return new HashSet<Long>(8);
            }
            return (HashSet)matchRuleAndGroups.values().stream().reduce((v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }).get();
        }
        return TaskUserWorkLoadHelper.getMatchGroupOld(disrules, taskOrgList);
    }

    public static List<WorkerStatusPojo> getAllUserInGroup(List<String> taskSscList) {
        ArrayList<WorkerStatusPojo> userIDList = new ArrayList<WorkerStatusPojo>(8);
        QFilter sscQFilter = TaskUserWorkLoadHelper.buildSscQfilterBySscidList("orgfield", taskSscList);
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        log.info("TaskUserWorkLoadHelper.getAllUserInGroup() begin");
        long begin = System.currentTimeMillis();
        DynamicObject[] userGroups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name,createorg,entryentity.userfield,entryentity.ability,entryentity.usestatus", (QFilter[])new QFilter[]{sscQFilter, enableUserQF, enableUserGroupQF});
        long end = System.currentTimeMillis();
        log.info("TaskUserWorkLoadHelper.getAllUserInGroup() end :{}ms", (Object)(end - begin));
        TaskUserWorkLoadHelper.initEnableAndWorkUserList(userIDList, userGroups);
        return userIDList;
    }

    public static void initEnableAndWorkUserList(List<WorkerStatusPojo> userIDList, DynamicObject[] userGroups) {
        if (userGroups == null || userGroups.length == 0) {
            return;
        }
        log.info("TaskUserWorkLoadHelper.initEnableAndWorkUserList() begin");
        long begin = System.currentTimeMillis();
        ArrayList<Long> groupList = new ArrayList<Long>(10);
        Long sscId = userGroups[0].getLong("createorg.id");
        DynamicObject createorg = userGroups[0].getDynamicObject("createorg");
        DynamicObject timezone = createorg.getDynamicObject("timezone");
        String timezonenumber = "";
        if (timezone != null) {
            timezonenumber = timezone.getString("number");
        }
        for (DynamicObject usergroup : userGroups) {
            DynamicObjectCollection usergroupColl = usergroup.getDynamicObjectCollection("entryentity");
            Long userGroupID = usergroup.getLong("id");
            groupList.add(userGroupID);
            for (DynamicObject user : usergroupColl) {
                if (!user.getBoolean("userfield.enable") || !user.getBoolean("usestatus")) continue;
                BigDecimal ability = user.getBigDecimal("ability").setScale(1, RoundingMode.HALF_UP);
                Long userID = user.getLong("userfield.id");
                WorkerStatusPojo workerStatusPojo = new WorkerStatusPojo();
                workerStatusPojo.setSscId(sscId);
                workerStatusPojo.setUserId(userID);
                workerStatusPojo.setUserGroupId(userGroupID);
                workerStatusPojo.setTimezoneNumber(timezonenumber);
                workerStatusPojo.setAbilityValue(ability);
                userIDList.add(workerStatusPojo);
            }
        }
        Map<Long, Set<Long>> userMapOnWork = SscWorkCalendarApi.queryUserOnWork(new HashSet<Long>(groupList), DateUtil.changeTimeZone((Date)new Date(), (String)timezonenumber));
        for (int i = 0; i < userIDList.size(); ++i) {
            WorkerStatusPojo workerStatusPojo = userIDList.get(i);
            Set<Long> userIds = userMapOnWork.get(workerStatusPojo.getUserGroupId());
            if (CollectionUtils.isNotEmpty(userIds) && userIds.contains(workerStatusPojo.getUserId())) {
                workerStatusPojo.setPresent(true);
                continue;
            }
            workerStatusPojo.setPresent(false);
        }
        long end = System.currentTimeMillis();
        log.info("TaskUserWorkLoadHelper.initEnableAndWorkUserList() end :{}ms, groupListSize={}, userIDListSize={}", new Object[]{end - begin, groupList.size(), userIDList.size()});
    }

    private static HashSet<Long> getMatchGroupOld(DynamicObject[] disrules, List<String> taskOrgList) {
        HashSet<Long> groupHandlerHsSet = new HashSet<Long>(8);
        if (CollectionUtils.isEmpty(taskOrgList)) {
            return groupHandlerHsSet;
        }
        for (String taskOrgIdStr : taskOrgList) {
            for (DynamicObject rule : disrules) {
                DynamicObjectCollection entryCols = rule.getDynamicObjectCollection("entryentity1");
                for (DynamicObject entryObj : entryCols) {
                    DynamicObjectCollection ruleOrgCols = entryObj.getDynamicObjectCollection("orgrange");
                    for (DynamicObject ruleOrg : ruleOrgCols) {
                        if (!TaskDisUtil.orgMatch((Long)ruleOrg.getLong("FBasedataId_id"), (Long)Long.valueOf(taskOrgIdStr))) continue;
                        groupHandlerHsSet.add(entryObj.getDynamicObject("usergroup").getLong("id"));
                    }
                }
            }
        }
        return groupHandlerHsSet;
    }

    public static void addUserWorklingJobLoad(List<WorkerStatusPojo> workerStatusPojos) {
        if (CollectionUtils.isEmpty(workerStatusPojos)) {
            return;
        }
        log.info("TaskUserWorkLoadHelper.addUserWorklingJobLoad() begin");
        long begin = System.currentTimeMillis();
        ORM orm = ORM.create();
        HashSet<Long> userIDList = new HashSet<Long>(16);
        HashMap<String, Integer> taskTotalMap = new HashMap<String, Integer>(16);
        for (WorkerStatusPojo workerStatusPojo : workerStatusPojos) {
            userIDList.add(workerStatusPojo.getUserId());
        }
        QFilter PersonIDS = new QFilter("personid", "in", userIDList);
        QFilter disedTKFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateExFilter = WorkLoadUtil.getWorkloadStateExFilter();
        if (stateExFilter != null) {
            disedTKFilter.and(stateExFilter);
        }
        try (DataSet taskDS = orm.queryDataSet("TaskUserWorkLoadHelper.addUserWorklingJobLoad", "task_task", "personid,usergroup", new QFilter[]{PersonIDS, disedTKFilter});
             DataSet taskAfterGroupDS = taskDS.groupBy(new String[]{"personid", "usergroup"}).count("workload").finish().orderBy(new String[]{"workload desc"});){
            for (Row taskAfterOrderRow : taskAfterGroupDS) {
                Long persionID = taskAfterOrderRow.getLong("personid");
                Long usergroup = taskAfterOrderRow.getLong("usergroup");
                Integer workload = taskAfterOrderRow.getInteger("workload");
                taskTotalMap.put(usergroup + "_" + persionID, workload);
            }
        }
        if (taskTotalMap.size() == 0) {
            return;
        }
        for (WorkerStatusPojo workerStatusPojo : workerStatusPojos) {
            Integer integer = (Integer)taskTotalMap.get(workerStatusPojo.getUserGroupId() + "_" + workerStatusPojo.getUserId());
            if (integer == null) continue;
            workerStatusPojo.setTaskTotal(integer);
        }
        if (workerStatusPojos.size() > 0) {
            Collections.sort(workerStatusPojos, new UserWorkLoadCompare());
        }
        long end = System.currentTimeMillis();
        log.info("TaskUserWorkLoadHelper.addUserWorklingJobLoad() end :{}ms", (Object)(end - begin));
    }

    private static class UserWorkLoadCompare
    implements Comparator<WorkerStatusPojo> {
        private UserWorkLoadCompare() {
        }

        @Override
        public int compare(WorkerStatusPojo o1, WorkerStatusPojo o2) {
            if (Long.compare(o1.getUserGroupId(), o2.getUserGroupId()) == 0) {
                return Integer.compare(o1.getTaskTotal(), o2.getTaskTotal());
            }
            return Long.compare(o1.getUserGroupId(), o2.getUserGroupId());
        }
    }
}

