/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.userworkload;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.teamleader.TeamLeaderApi;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.userworkload.DisTaskWithUserIdHelper;
import kd.ssc.task.userworkload.TaskUserWorkLoadHelper;

public class UserWorkLoadNewFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(UserWorkLoadNewFormPlugin.class);
    private static final String INCLUDENOPERM = "includenoperm";
    private static final int BATCH_COUNT = 20;
    private Set<String> qualityPages = new HashSet<String>(Arrays.asList("task_doqualitymanagement", "task_quality_docheck"));
    private static final String MINE_GROUP_LEADER = "minegroupleader";
    private boolean ORDER_FLAG = false;

    public void initialize() {
        this.addClickListeners(new String[]{INCLUDENOPERM, "btok"});
        this.addItemClickListeners(new String[]{INCLUDENOPERM});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
                args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int start, int limit) {
                        DynamicObjectCollection rows = super.getData(start, limit);
                        if (rows.isEmpty()) {
                            return rows;
                        }
                        log.info("Optimize getData() begin");
                        long begin = System.currentTimeMillis();
                        DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDynamicObjectType().getProperties();
                        if (!properties.containsKey((Object)"workstatus")) {
                            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("workstatus", String.class, null));
                        }
                        if (!properties.containsKey((Object)"workload")) {
                            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("workload", String.class, null));
                        }
                        Map<String, WorkerStatusPojo> workerStatusMap = TaskUserWorkLoadHelper.initEnableAndWorkUserMap(rows);
                        for (DynamicObject row : rows) {
                            Long userGroupID = row.getLong("id");
                            Long userID = ((DynamicObject)row.get("entryentity.userfield")).getLong("id");
                            WorkerStatusPojo workerStatusPojo = workerStatusMap.get(userGroupID + "_" + userID);
                            if (workerStatusPojo != null) {
                                row.set("workstatus", (Object)workerStatusPojo.isPresent());
                                row.set("workload", (Object)workerStatusPojo.getTaskTotal());
                                continue;
                            }
                            row.set("workload", (Object)0);
                        }
                        if (UserWorkLoadNewFormPlugin.this.ORDER_FLAG) {
                            if (CollectionUtils.isNotEmpty((Collection)rows)) {
                                rows.sort((Comparator)new UserWorkLoadCompare());
                            }
                            UserWorkLoadNewFormPlugin.this.ORDER_FLAG = false;
                        }
                        long end = System.currentTimeMillis();
                        log.info("Optimize getData() end :{}ms, rowsSize={}", (Object)(end - begin), (Object)rows.size());
                        return rows;
                    }
                });
            }
        });
        billList.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent packageDataEvent) {
                Object source = packageDataEvent.getSource();
                if (source != null) {
                    String key;
                    if (source instanceof ComboColumnDesc) {
                        String key2 = ((ComboColumnDesc)source).getKey();
                        if ("workstatus".equals(key2)) {
                            Object workstatus = packageDataEvent.getRowData().get("workstatus");
                            packageDataEvent.setFormatValue(workstatus);
                        }
                    } else if (source instanceof TextColumnDesc && "workload".equals(key = ((TextColumnDesc)source).getKey())) {
                        Object workload = packageDataEvent.getRowData().get("workload");
                        packageDataEvent.setFormatValue(workload);
                    }
                }
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String entryfieldchange = e.getProperty().getName();
        ChangeData[] data = e.getChangeSet();
        Object newValue = data[0].getNewValue();
        if (entryfieldchange.equals(INCLUDENOPERM)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
            }
            this.queryData(Boolean.parseBoolean(this.getView().getModel().getValue(INCLUDENOPERM).toString()), false, true);
        } else if (entryfieldchange.equals(MINE_GROUP_LEADER)) {
            Boolean isOpen = (Boolean)newValue;
            if (isOpen.booleanValue()) {
                this.getModel().setValue(INCLUDENOPERM, (Object)Boolean.FALSE);
                this.queryMineGroupLeaderData();
            } else {
                boolean isSysAdmin = true;
                String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
                if (!"sysadmin".equals(identity)) {
                    isSysAdmin = false;
                }
                this.queryData(false, true, isSysAdmin);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btok")) {
            this.disToUser();
        }
    }

    public void afterCreateNewData(EventObject e) {
        boolean isSysAdmin = true;
        String identity = (String)this.getView().getFormShowParameter().getCustomParam("identity");
        if (!"sysadmin".equals(identity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{INCLUDENOPERM});
            isSysAdmin = false;
        }
        this.showMineGroupLeader();
        this.queryData(false, true, isSysAdmin);
    }

    private void batchProcessing(Long userId, List<Long> taskIds, Long userGroup) {
        log.info("batchProcessing begin");
        long begin = System.currentTimeMillis();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_allocation_progress");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customPara = parameter.getCustomParams();
        customPara.put("userid", userId);
        customPara.put("taskids", SerializationUtils.toJsonString(taskIds));
        customPara.put("batchcount", 20);
        customPara.put("usergroup", userGroup);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "batchAllocation");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
        long end = System.currentTimeMillis();
        log.info("batchProcessing end :{}ms", (Object)(end - begin));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("batchAllocation".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void queryData(boolean includenoperm, boolean isFromButton, boolean isSysAdmin) {
        List taskSscList;
        log.info("UserWorkLoadNewFormPlugin.queryData() begin\uff1a includenoperm = {}, isFromButton = {}, isSysAdmin = {}", new Object[]{includenoperm, isFromButton, isSysAdmin});
        long begin = System.currentTimeMillis();
        ArrayList<Long> errRuleDyns = new ArrayList<Long>(4);
        List<QFilter> billListFilter = this.queryGridDataByAssign(includenoperm, errRuleDyns);
        if (isFromButton && !isSysAdmin && (taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs")) != null && taskSscList.size() > 0) {
            HashSet<Long> manageGroup = UserGroupUtil.getManageGroup((String)taskSscList.get(0), RequestContext.get().getUserId());
            if (billListFilter != null) {
                billListFilter.add(new QFilter("id", "in", manageGroup));
            }
        }
        this.refreshBillList(billListFilter);
        if (!errRuleDyns.isEmpty()) {
            this.showWarningMsg(errRuleDyns);
        }
        long end = System.currentTimeMillis();
        log.info("UserWorkLoadNewFormPlugin.queryData() end :{}ms", (Object)(end - begin));
    }

    private void queryMineGroupLeaderData() {
        log.info("UserWorkLoadNewFormPlugin.queryMineGroupLeaderData()");
        long begin = System.currentTimeMillis();
        List<QFilter> billListFilter = this.getAllUserByGroupLeader();
        this.refreshBillList(billListFilter);
        long end = System.currentTimeMillis();
        log.info("UserWorkLoadNewFormPlugin.queryMineGroupLeaderData() end :{}ms", (Object)(end - begin));
    }

    private List<QFilter> queryGridDataByAssign(boolean includenoperm, List<Long> errRuleDyns) {
        List<QFilter> billListFilter = new ArrayList<QFilter>();
        billListFilter.add(new QFilter("id", "=", (Object)-1L));
        List taskidList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (!includenoperm && taskidList.size() == 1) {
            billListFilter = this.getDisUserAndUserGroupIDSByAssign(errRuleDyns);
        } else if (includenoperm) {
            billListFilter = this.getAllUserInGroup();
        }
        return billListFilter;
    }

    public List<QFilter> getDisUserAndUserGroupIDSByAssign(List<Long> errRuleDyns) {
        Map<Long, Integer> groupId2Priority;
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        List taskIdList = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        List tIDTTypeBTypeList = (List)this.getView().getFormShowParameter().getCustomParam("taskdisParameters");
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            boolean isRectification = false;
            Object rectify = this.getView().getFormShowParameter().getCustomParam("isRectification");
            if (rectify != null) {
                isRectification = (Boolean)rectify;
            }
            groupId2Priority = TaskUserWorkLoadHelper.buildHandleGroupMapByAssignNew(errRuleDyns, taskSscList, taskIdList, tIDTTypeBTypeList, isRectification);
        } else {
            List orgIdList = (List)this.getView().getFormShowParameter().getCustomParam("orgIDList");
            groupId2Priority = TaskUserWorkLoadHelper.buildHandleGroupMapByAssign(errRuleDyns, orgIdList, taskSscList, taskIdList, tIDTTypeBTypeList);
        }
        return this.addUserGroupMembers(new ArrayList<Long>(groupId2Priority.keySet()));
    }

    private List<QFilter> getAllUserInGroup() {
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        QFilter sscQFilter = TaskUserWorkLoadHelper.buildSscQfilterBySscidList("orgfield", taskSscList);
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(sscQFilter);
        filters.add(enableUserQF);
        filters.add(enableUserGroupQF);
        return filters;
    }

    private List<QFilter> getAllUserByGroupLeader() {
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        QFilter sscQFilter = new QFilter("createorg", "=", (Object)Long.valueOf(sscId));
        QFilter enableUserQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter enableUserGroupQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("");
        HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId));
        QFilter manageGroupQF = new QFilter("id", "in", manageGroupSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(sscQFilter);
        filters.add(enableUserQF);
        filters.add(enableUserGroupQF);
        filters.add(manageGroupQF);
        return filters;
    }

    private void refreshBillList(List<QFilter> qFilter) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (qFilter != null) {
            log.info("refreshBillList qFilter = {}", (Object)JSONObject.toJSONString(qFilter));
            FilterParameter filterParameter = new FilterParameter(qFilter, null);
            billList.setQueryFilterParameter(filterParameter);
            billList.setOrderBy("number asc");
            this.ORDER_FLAG = true;
        }
        billList.refresh();
        billList.clearSelection();
    }

    private void showWarningMsg(List<Long> errRuleDyns) {
        log.info("UserWorkLoadNewFormPlugin.showWarningMsg begin");
        long begin = System.currentTimeMillis();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", errRuleDyns)};
        String selectFields = "number";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"task_disrule", (String)selectFields, (QFilter[])qFilters);
        StringBuilder numbers = new StringBuilder();
        for (DynamicObject dyo : dyns) {
            numbers.append(dyo.get("number"));
            numbers.append("\u3001");
        }
        StringBuilder warningMsg = new StringBuilder();
        warningMsg.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u53ef\u5206\u914d\u4eba\u5458\u65f6\uff0c\u90e8\u5206\u4efb\u52a1\u5206\u914d\u89c4\u5219\u6267\u884c\u51fa\u9519\uff0c\u89c4\u5219\u7f16\u7801\u4e3a\uff1a%1$s\u3002", (String)"UserWorkLoadNewFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), numbers));
        this.getView().showTipNotification(warningMsg.toString());
        long end = System.currentTimeMillis();
        log.info("UserWorkLoadNewFormPlugin.showWarningMsg() end :{}ms", (Object)(end - begin));
    }

    private void showMineGroupLeader() {
        HashSet<Long> manageGroupSet;
        List taskSscList = (List)this.getView().getFormShowParameter().getCustomParam("sscs");
        String sscId = (String)taskSscList.get(0);
        Long currUserId = RequestContext.get().getCurrUserId();
        this.getModel().setValue(MINE_GROUP_LEADER, (Object)Boolean.FALSE);
        if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId)) && CollectionUtils.isNotEmpty(manageGroupSet = UserGroupUtil.getManageGroup(sscId, String.valueOf(currUserId)))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MINE_GROUP_LEADER});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{MINE_GROUP_LEADER});
    }

    private List<QFilter> addUserGroupMembers(List<Long> userGroupIDList) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter userGroupFilter = new QFilter("id", "in", userGroupIDList);
        QFilter userGroupEnable = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        filters.add(userGroupFilter);
        filters.add(userGroupEnable);
        QFilter enableQF = CommonFilterUtil.getEnableMetaQFilterByMetaName("entryentity.userfield");
        QFilter userEnabled = new QFilter("entryentity.usestatus", "=", (Object)Character.valueOf('1'));
        filters.add(enableQF);
        filters.add(userEnabled);
        boolean isExceptRebots = false;
        IFormView view = this.getView();
        if (view != null) {
            Object isexceptrebots = view.getFormShowParameter().getCustomParam("isexceptrebots");
            boolean bl = isExceptRebots = isexceptrebots != null && (Boolean)isexceptrebots != false;
        }
        if (isExceptRebots) {
            QFilter exceptRebotsFilter = new QFilter("isrobots", "!=", (Object)"1");
            filters.add(exceptRebotsFilter);
        }
        return filters;
    }

    private void disToUser() {
        boolean success;
        Long entryId;
        QFilter filter2;
        log.info("disToUser begin");
        long begin = System.currentTimeMillis();
        ListSelectedRowCollection selectRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        if (selectRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4f4d\u4efb\u52a1\u5206\u914d\u4eba\u5458\u3002", (String)"UserWorkLoadNewFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = selectRows.get(0);
        Long userGroup = (Long)row.getPrimaryKeyValue();
        QFilter filter1 = new QFilter("id", "=", (Object)userGroup);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,entryentity.userfield", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("entryentity.id", "=", (Object)(entryId = (Long)row.getEntryPrimaryKeyValue()))});
        if (dynamicObject == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237ID\u4e0d\u5b58\u5728\u3002", (String)"UserWorkLoadNewFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        Long userID = dynamicObject.getLong("entryentity.userfield");
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (this.qualityPages.contains(parentFormId)) {
            if ("task_quality_docheck".equals(parentFormId)) {
                this.getView().returnDataToParent((Object)userID);
            } else {
                this.getView().returnDataToParent((Object)(userID + "_" + userGroup));
            }
            this.getView().close();
            return;
        }
        List taskIDs = (List)this.getView().getFormShowParameter().getCustomParam("taskdis");
        if (taskIDs.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1ID\u3002", (String)"UserWorkLoadNewFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        int taskSize = taskIDs.size();
        Boolean includeNoPermOpen = (Boolean)this.getModel().getValue(INCLUDENOPERM);
        Boolean mineGroupLeaderOpen = (Boolean)this.getModel().getValue(MINE_GROUP_LEADER);
        if (!(taskSize != 1 || includeNoPermOpen.booleanValue() || mineGroupLeaderOpen.booleanValue() || (success = this.checkApplier((Long)taskIDs.get(0), userID)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u81ea\u63d0\u81ea\u5ba1\u3002", (String)"UserWorkLoadNewFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        if (taskSize < 20) {
            this.disTaskWithUserId(userID, taskIDs, this.getView(), false, userGroup);
        } else {
            this.batchProcessing(userID, taskIDs, userGroup);
        }
        long end = System.currentTimeMillis();
        log.info("disToUser end :{}ms", (Object)(end - begin));
    }

    private boolean checkApplier(Long taskId, Long userId) {
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"creator.id,billtype.id,qualitysamplelibrary.id", (QFilter[])new QFilter("id", "=", (Object)taskId).toArray());
        if (task == null || task.getLong("qualitysamplelibrary.id") > 0L) {
            return true;
        }
        DynamicObject billType = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"allowanyapplier", (QFilter[])new QFilter("id", "=", (Object)task.getLong("billtype.id")).toArray());
        return billType.getBoolean("allowanyapplier") || !userId.equals(task.getLong("creator.id"));
    }

    public void disTaskWithUserId(Long userId, List<Long> taskIds, IFormView view, boolean isBatchProcessing, Long userGroup) {
        log.info("disTaskWithUserId begin");
        long begin = System.currentTimeMillis();
        StringBuilder errorMsg = new StringBuilder();
        boolean isRedistribute = "admin_redistribution".equals(view.getFormShowParameter().getCustomParam("operation"));
        Map task2Index = (Map)view.getFormShowParameter().getCustomParam("task2Index");
        List<Long> successIds = DisTaskWithUserIdHelper.disTaskNew(userId, taskIds, errorMsg, userGroup, isRedistribute, task2Index);
        if (!isBatchProcessing) {
            HashMap<String, Object> returnDataMap = new HashMap<String, Object>(8);
            int totalTaskCount = taskIds.size();
            int totalSuccessCount = successIds.size();
            returnDataMap.put("totalTaskCount", totalTaskCount);
            returnDataMap.put("totalSuccessCount", totalSuccessCount);
            String digest = this.createTipDigest(totalTaskCount, totalSuccessCount);
            returnDataMap.put("digest", digest);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorMsg.deleteCharAt(errorMsg.length() - 1);
                returnDataMap.put("errorMsg", errorMsg.toString());
            }
            String jsonString = JSON.toJSONString(returnDataMap);
            log.info(jsonString);
            this.getView().returnDataToParent((Object)jsonString);
            this.getView().close();
            long end = System.currentTimeMillis();
            log.info("disTaskWithUserId end :{}ms", (Object)(end - begin));
        }
    }

    public String createTipDigest(Integer totalTaskCount, Integer totalSuccessCount) {
        String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4efb\u52a1\uff0c\u5206\u914d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"UserWorkLoadNewFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
        return digest;
    }

    private static class UserWorkLoadCompare
    implements Comparator<DynamicObject> {
        private UserWorkLoadCompare() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            String firstSort = "number";
            String secondSort = "workload";
            if (o1.getString(firstSort).compareTo(o2.getString(firstSort)) == 0) {
                return Integer.compare(o1.getInt(secondSort), o2.getInt(secondSort));
            }
            return o1.getString(firstSort).compareTo(o2.getString(firstSort));
        }
    }
}

