/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.eas.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.ssc.task.bill.AbsTaskBillHandler;
import kd.ssc.task.eas.EASConfig;
import kd.ssc.task.eas.EasWebServiceClient;
import kd.ssc.task.eas.axis.EASLoginProxyServiceStub;

@KSObject
public abstract class EASTaskBillHandler
extends AbsTaskBillHandler {
    private static final Log logger = LogFactory.getLog(EASTaskBillHandler.class);
    private static final String HTTP = "http://";

    public Map<String, String> getCompanyTax(String metadatatType, String bizdata) {
        Set<Long> costcompany = this.getCompany(metadatatType, bizdata);
        HashMap<String, String> costCompanyMap = new HashMap<String, String>();
        ORM orm = ORM.create();
        if (!costcompany.isEmpty()) {
            QFilter nameFilter = new QFilter("id", "in", costcompany);
            DataSet dataSet = orm.queryDataSet("ssc.TaskApprevalPlugin.costcompany", "bos_org", "id,name,ffirmname,ftaxregnum", new QFilter[]{nameFilter});
            for (Row row : dataSet) {
                costCompanyMap.put(row.getString("ffirmname"), row.getString("ftaxregnum"));
            }
            dataSet.close();
        }
        return costCompanyMap;
    }

    public Set<Long> getCompany(String metadatatType, String bizdata) {
        HashSet<Long> costcompany = new HashSet<Long>();
        if (!this.canSerialization(metadatatType, bizdata)) {
            return costcompany;
        }
        ORM orm = ORM.create();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)orm.getDataEntityType(metadatatType));
        binder.setIgnoreCase(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
        if (dataEntity != null) {
            this.process(dataEntity, costcompany);
        }
        return costcompany;
    }

    public abstract void process(DynamicObject var1, Set<Long> var2);

    private boolean canSerialization(String metadatatType, String bizdata) {
        return metadatatType != null && metadatatType.trim().length() != 0 && bizdata != null && bizdata.trim().length() != 0;
    }

    public HashMap<String, Object> getOpinionField(String metadatatType, String bizdata) {
        HashMap<String, Object> opinionMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)orm.getDataEntityType(metadatatType));
        binder.setIgnoreCase(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
        if (dataEntity != null) {
            this.getOpinion(dataEntity, opinionMap);
        }
        return opinionMap;
    }

    public abstract void getOpinion(DynamicObject var1, HashMap<String, Object> var2);

    @KSMethod
    public BigDecimal getPreparedAmt(String billID) {
        EASConfig eas = EASConfig.getConfig();
        long strattime = System.currentTimeMillis();
        EASLoginProxyServiceStub.WSContext svcCtx = EASConfig.loginEAS((EASConfig)eas);
        if (svcCtx == null) {
            throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\u3002", (String)"EASTaskBillHandler_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        long endtime_1 = System.currentTimeMillis();
        logger.info("\u767b\u5f55EAS\u8017\u65f6\uff08getPreparedAmt\uff09\uff1a" + (endtime_1 - strattime) + "ms");
        String sessionId = svcCtx.getSessionId();
        if (sessionId != null && StringUtils.isNotEmpty((String)sessionId)) {
            try {
                String methodName = "getAcctAmount";
                Object[] params = new Object[]{billID};
                EasWebServiceClient call = EasWebServiceClient.getInstance();
                String namespaceURI = HTTP + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSIntegrateBillFacade?wsdl";
                String result = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
                long endtime_2 = System.currentTimeMillis();
                logger.info("\u83b7\u53d6EAS\u5907\u7528\u91d1\uff08getPreparedAmt\uff09\u8017\u65f6\uff1a" + (endtime_2 - endtime_1) + "ms");
                if (StringUtils.isEmpty((String)result)) {
                    result = "0.00";
                } else {
                    Map relMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                    result = (String)relMap.get("amount");
                }
                return new BigDecimal(result);
            }
            catch (Exception e1) {
                logger.error("\u83b7\u53d6\u5907\u7528\u91d1\u53d1\u751f\u5f02\u5e38", (Throwable)e1);
            }
        } else {
            logger.info("\u767b\u5f55EAS\u83b7\u53d6sessionId\u5931\u8d25");
            throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\u3002", (String)"EASTaskBillHandler_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        return BigDecimal.ZERO;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KSMethod
    public void importLoanbill(long applierID, String billType, String sourceBillType) {
        EASConfig eas = EASConfig.getConfig();
        EASLoginProxyServiceStub.WSContext svcCtx = EASConfig.loginEAS((EASConfig)eas);
        long strattime = System.currentTimeMillis();
        if (svcCtx == null) {
            throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\u3002", (String)"EASTaskBillHandler_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        long endtime_1 = System.currentTimeMillis();
        logger.info("\u767b\u5f55EAS\u8017\u65f6\uff08importLoanbill\uff09\uff1a" + (endtime_1 - strattime) + "ms");
        String sessionId = svcCtx.getSessionId();
        if (sessionId == null || !StringUtils.isNotEmpty((String)sessionId)) throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\u3002", (String)"EASTaskBillHandler_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        Map innerOrgMap = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_user", (String)Long.toString(applierID), null, null);
        if (innerOrgMap == null) {
            throw new KDException(ResManager.loadKDString((String)"\u5355\u636e\u7533\u8bf7\u4eba\u6ca1\u6709\u4e0e\u5916\u90e8\u7cfb\u7edf\u7528\u6237\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5728\u201c\u57fa\u7840\u670d\u52a1\u201d\u4e2d\u914d\u7f6e\u3002", (String)"EASTaskBillHandler_1", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        try {
            String methodName = "getLoanData";
            HashMap param = new HashMap();
            param.put("applier", innerOrgMap.get("id"));
            param.put("billType", billType);
            param.put("sourceBillType", sourceBillType);
            Object[] params = new Object[]{SerializationUtils.toJsonString(param)};
            EasWebServiceClient call = EasWebServiceClient.getInstance();
            String namespaceURI = HTTP + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSIntegrateBillFacade?wsdl";
            String result = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
            long endtime_2 = System.currentTimeMillis();
            logger.info("\u67e5\u8be2EAS\u501f\u6b3e\u4fe1\u606f\u8017\u65f6\uff08importLoanbill\uff09\uff1a" + (endtime_2 - endtime_1) + "ms");
            String resultNOTab = result.replaceAll("\\t", " ");
            logger.info("list\u5bf9\u8c61-->json-->result" + result);
            if (StringUtils.isEmpty((String)result)) return;
            if ("applierUserid not found Error".equals(result)) {
                throw new KDException(String.format(ResManager.loadKDString((String)"EAS\u7cfb\u7edf\u4e2d\u672a\u67e5\u627e\u5230\u7528\u6237ID\u201c%s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"EASTaskBillHandler_2", (String)"ssc-task-ext", (Object[])new Object[0]), innerOrgMap.get("id")));
            }
            List relList = (List)SerializationUtils.fromJsonString((String)resultNOTab, List.class);
            logger.info("json-->list\u5bf9\u8c61-->reList" + relList);
            ORM orm = ORM.create();
            ArrayList<String> entryids = new ArrayList<String>(10);
            ArrayList<DynamicObject> loanArrayList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> loanArrayListNew = new ArrayList<DynamicObject>();
            for (Map map : relList) {
                void var32_31;
                String entryid = (String)map.get("entryid");
                entryids.add(entryid);
                QFilter filter = new QFilter("entryid", "=", (Object)entryid);
                DynamicObject[] loans = BusinessDataServiceHelper.load((String)"task_loan", (String)"id,applier.id,sourcetype,rateconvertmode,rateprecision,rate,number,entryid,currency.id,cause,easid,amountbalance,expensetype,billtype", (QFilter[])new QFilter[]{filter});
                if (loans != null && loans.length > 0) {
                    DynamicObject dynamicObject = loans[0];
                    loanArrayList.add(dynamicObject);
                } else {
                    DynamicObject dynamicObject = orm.newDynamicObject("task_loan");
                    dynamicObject.set("sourcetype", (Object)"1");
                    loanArrayListNew.add(dynamicObject);
                }
                EASTaskBillHandler.fillLoanProperty((DynamicObject)var32_31, map);
                DynamicObject applier = orm.newDynamicObject("bos_user");
                applier.set("id", (Object)applierID);
                var32_31.set("applier", (Object)applier);
            }
            if (relList.size() <= 0) return;
            if (loanArrayList.size() > 0) {
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)loanArrayList.get(0)).getDataEntityType(), (Object[])loanArrayList.toArray());
            }
            if (loanArrayListNew.size() > 0) {
                BusinessDataWriter.save((IDataEntityType)((DynamicObject)loanArrayListNew.get(0)).getDataEntityType(), (Object[])loanArrayListNew.toArray());
            }
            String billtype = ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"EASTaskBillHandler_4", (String)"ssc-task-ext", (Object[])new Object[0]);
            if ("dailyLoan".equals(sourceBillType)) {
                billtype = ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"EASTaskBillHandler_4", (String)"ssc-task-ext", (Object[])new Object[0]);
            } else if ("evectionLoan".equals(sourceBillType)) {
                billtype = ResManager.loadKDString((String)"\u51fa\u5dee\u501f\u6b3e\u5355", (String)"EASTaskBillHandler_5", (String)"ssc-task-ext", (Object[])new Object[0]);
            }
            Object[] loans = BusinessDataServiceHelper.load((String)"task_loan", (String)"id,sourcetype", (QFilter[])new QFilter[]{new QFilter("entryid", "not in", entryids), new QFilter("applier.id", "=", (Object)applierID), new QFilter("billtype", "=", (Object)billtype)});
            if (loans == null || loans.length <= 0) return;
            for (DynamicObject dynamicObject : loans) {
                dynamicObject.set("sourcetype", (Object)2);
            }
            BusinessDataWriter.save((IDataEntityType)loans[0].getDataEntityType(), (Object[])loans);
            return;
        }
        catch (Exception e1) {
            logger.error("\u8c03\u7528EAS\u67e5\u8be2\u501f\u6b3e\u5355\u63a5\u53e3\u670d\u52a1\u51fa\u9519", (Throwable)e1);
            throw new KDException((Throwable)e1, new ErrorCode("fi.ssc.ImportLoanBillException", String.format(ResManager.loadKDString((String)"\u8c03\u7528EAS\u67e5\u8be2\u501f\u6b3e\u5355\u63a5\u53e3\u670d\u52a1\u51fa\u9519\uff1a%s\u3002", (String)"EASTaskBillHandler_6", (String)"ssc-task-ext", (Object[])new Object[0]), e1.getMessage())), new Object[0]);
        }
    }

    public static void fillLoanProperty(DynamicObject ep, Map<String, Object> orginValue) {
        ep.set("rateconvertmode", orginValue.get("convertmode"));
        ep.set("rateprecision", orginValue.get("precision"));
        ep.set("rate", orginValue.get("exchangerate"));
        ep.set("number", orginValue.get("number"));
        ep.set("entryid", orginValue.get("entryid"));
        ORM orm = ORM.create();
        String easCurrencyID = (String)orginValue.get("currency");
        Map innerOrgMap = SysIntegrationServiceHelper.getInternalData((Long)1L, (String)"bd_currency", (String)easCurrencyID, null, null);
        DynamicObject currency = null;
        if (innerOrgMap != null && innerOrgMap.size() > 0) {
            currency = BusinessDataServiceHelper.loadSingle(innerOrgMap.get("id"), (String)"bd_currency", (String)"id,number,name,amtprecision");
        }
        ep.set("currency", currency);
        ep.set("cause", orginValue.get("cause"));
        ep.set("easid", orginValue.get("id"));
        ep.set("amountbalance", orginValue.get("amountbalance"));
        ep.set("expensetype", orginValue.get("expensetype"));
        ep.set("billtype", orginValue.get("billtype"));
    }
}

