/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.eas.EASConfig;
import kd.ssc.task.eas.EasWebServiceClient;
import kd.ssc.task.eas.axis.EASLoginProxyServiceStub;
import kd.ssc.task.util.AttachmentHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/*
 * Exception performing whole class analysis ignored.
 */
public class AttachmentHelper {
    public static final String BOS_ATTACHMENT_ENTITY_NAME = "bos_attachment";
    private static final Log log = LogFactory.getLog(AttachmentHelper.class);
    private static final String HTTP = "http://";

    public void syncAddedAttachmentByBill(Long billPK, String easBillId) {
        this.syncAddedAttachment(this.getAddedAttachmentsByBill(billPK), easBillId);
    }

    public void syncAddedAttachmentByPKs(List<Long> pks, String easBillId) {
        this.syncAddedAttachment(this.getAddedAttachmentsByPKs(pks), easBillId);
    }

    public void syncAddedAttachmentByPK(Long pk, String easBillId) {
        this.syncAddedAttachment(this.getAttachmentByPK(pk), easBillId);
    }

    public void syncDeletedAttachmentByPK(Long pk, String easBillId) {
        this.syncDeletedAttachment(this.getAttachmentByPK(pk), easBillId);
    }

    private void syncDeletedAttachment(DynamicObject attachment, String easBillId) {
        ArrayList<DynamicObject> attachmentList = new ArrayList<DynamicObject>();
        attachmentList.add(attachment);
        String reqJson = this.getDelReqs(attachmentList, easBillId);
        this.syncAttachment(reqJson);
    }

    private void syncAddedAttachment(DynamicObject attachment, String easBillId) {
        ArrayList<DynamicObject> attachmentList = new ArrayList<DynamicObject>();
        attachmentList.add(attachment);
        String reqJson = this.getAddReqs(attachmentList, easBillId);
        this.syncAttachment(reqJson);
    }

    private void syncAddedAttachment(List<DynamicObject> attachmentList, String easBillId) {
        String reqJson = this.getAddReqs(attachmentList, easBillId);
        this.syncAttachment(reqJson);
    }

    private DynamicObject getAttachmentByPK(Long pk) {
        return ORM.create().getById("bos_attachment", (Object)pk);
    }

    private List<DynamicObject> getAddedAttachmentsByPKs(List<Long> pks) {
        return this.getAddAttachments(this.getAttachmentsByPKs(pks));
    }

    private List<DynamicObject> getAddedAttachmentsByBill(Long billPK) {
        return this.getAddAttachments(this.getAttachmentsByBill(billPK));
    }

    private void syncAttachment(String reqJson) {
        if (reqJson == null) {
            return;
        }
        EASConfig eas = EASConfig.getConfig();
        EASLoginProxyServiceStub.WSContext svcCtx = EASConfig.loginEAS((EASConfig)eas);
        if (svcCtx == null) {
            throw new KDException(ResManager.loadKDString((String)"\u767b\u5f55EAS\u7cfb\u7edf\u5931\u8d25\u3002", (String)"AttachmentHelper_0", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        String sessionId = svcCtx.getSessionId();
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            // empty if block
        }
        String respJson = null;
        try {
            String methodName = "syncAttachment";
            Object[] params = new Object[]{reqJson};
            EasWebServiceClient call = EasWebServiceClient.getInstance();
            String namespaceURI = "http://" + eas.getIP() + ":" + eas.getPort() + "/ormrpc/services/WSFetchDataFacade?wsdl";
            respJson = (String)call.callMethodForEasService(params, namespaceURI, methodName, sessionId);
        }
        catch (Exception e1) {
            log.error("\u540c\u6b65\u9644\u4ef6\u5230EAS\u7cfb\u7edf\u5931\u8d25", (Throwable)e1);
            throw new KDException((Throwable)e1, new ErrorCode("fi.ssc.SyncAttachmentException", String.format(ResManager.loadKDString((String)"\u540c\u6b65\u9644\u4ef6\u5230EAS\u7cfb\u7edf\u5931\u8d25\uff1a%s", (String)"AttachmentHelper_1", (String)"ssc-task-ext", (Object[])new Object[0]), e1.getMessage())), new Object[0]);
        }
        try {
            TX.beginNew();
            this.consoleAttachmentResp(respJson);
        }
        catch (Exception e) {
            TX.markRollback();
            throw e;
        }
        finally {
            TX.end();
        }
    }

    private String getAddReqs(List<DynamicObject> attachmentList, String easBillId) {
        return this.getReqs(attachmentList, easBillId, OpEnum.ADD);
    }

    private String getDelReqs(List<DynamicObject> attachmentList, String easBillId) {
        return this.getReqs(attachmentList, easBillId, OpEnum.DELETE);
    }

    private String getReqs(List<DynamicObject> attachmentList, String easBillId, OpEnum op) {
        if (easBillId == null) {
            throw new KDException(ResManager.loadKDString((String)"\u9644\u4ef6\u540c\u6b65\u5fc5\u987b\u6307\u5b9aeas\u5355\u636e", (String)"AttachmentHelper_2", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        if (attachmentList == null || attachmentList.size() == 0) {
            return null;
        }
        ArrayList reqMapList = new ArrayList(attachmentList.size());
        for (DynamicObject attachment : attachmentList) {
            HashMap<String, Object> reqMap = new HashMap<String, Object>();
            if (OpEnum.ADD == op) {
                reqMap.put("downloadUrl", UrlService.getAttachmentFullUrl((String)this.removeHeadFileSeparator(attachment.getString("FFileId"))));
            } else if (OpEnum.DELETE == op) {
                reqMap.put("easAttachmentId", AttachmentHelper.getTRDId("bos_attachment", attachment.getPkValue()));
            }
            reqMap.put("ngAttachmentPK", attachment.getPkValue());
            reqMap.put("easBillId", easBillId);
            reqMap.put("op", op.getName());
            reqMapList.add(reqMap);
        }
        String reqJson = null;
        try {
            reqJson = SerializationUtils.toJsonString(reqMapList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("fi.ssc.SyncAttachmentSerializationException", ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u5e8f\u5217\u5316\u9519\u8bef", (String)"AttachmentHelper_3", (String)"ssc-task-ext", (Object[])new Object[0])), new Object[0]);
        }
        return reqJson;
    }

    private void consoleAttachmentResp(String respJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        ORM orm = ORM.create();
        try {
            JsonNode root = objectMapper.readTree(respJson);
            int size = root.size();
            for (int idx = 0; idx < size; ++idx) {
                JsonNode node = root.get(idx);
                OpEnum op = OpEnum.valueOf((String)node.get("op").asText());
                if (OpEnum.ADD == op) {
                    String easAttachmentId = node.get("easAttachmentId").asText();
                    String ngAttachmentPK = node.get("ngAttachmentPK").asText();
                    AttachmentHelper.saveId("bos_attachment", ngAttachmentPK, easAttachmentId);
                    continue;
                }
                if (OpEnum.DELETE != op) continue;
                String ngAttachmentPK = node.get("ngAttachmentPK").asText();
                QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)"bos_attachment"), new QFilter("nextgenerationid", "=", (Object)ngAttachmentPK)};
                DynamicObject relation = orm.queryOne("er_relationtotrdsystem", filters);
                orm.delete("er_relationtotrdsystem", relation.getPkValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String removeHeadFileSeparator(String str) {
        return AttachmentServiceHelper.removeUrlVersion((String)str);
    }

    private List<DynamicObject> getAddAttachments(Map<String, DynamicObject> attachmentMap) {
        ArrayList<DynamicObject> attachmentList = new ArrayList<DynamicObject>();
        for (Map.Entry<String, DynamicObject> entry : attachmentMap.entrySet()) {
            String key = entry.getKey();
            if (this.isExistRelation(key, "bos_attachment")) continue;
            attachmentList.add(entry.getValue());
        }
        return attachmentList;
    }

    private Map<String, DynamicObject> getAttachmentsByBill(Long billPK) {
        return this.getAttachmentMapByFilter(new QFilter("FInterID", "=", (Object)billPK));
    }

    private Map<String, DynamicObject> getAttachmentsByPKs(List<Long> pks) {
        return this.getAttachmentMapByFilter(new QFilter("id", "in", pks));
    }

    private DynamicObjectCollection getAttachmentsByFilter(QFilter filter) {
        ORM orm = ORM.create();
        if (orm.exists("bos_attachment", new QFilter[]{filter})) {
            return orm.query("bos_attachment", new QFilter[]{filter});
        }
        return null;
    }

    private Map<String, DynamicObject> getAttachmentMapByFilter(QFilter filter) {
        HashMap<String, DynamicObject> attachmentMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection attachments = this.getAttachmentsByFilter(filter);
        if (attachments != null) {
            for (DynamicObject attachment : attachments) {
                attachmentMap.put(attachment.getPkValue().toString(), attachment);
            }
        }
        return attachmentMap;
    }

    private boolean isExistRelation(String nextgenerationid, String type) {
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("nextgenerationid", "=", (Object)nextgenerationid)};
        return ORM.create().exists("er_relationtotrdsystem", filters);
    }

    public static void saveId(String type, DynamicObject ngObj, String easId) {
        AttachmentHelper.saveId(type, ngObj.getPkValue().toString(), easId);
    }

    public static void saveId(String type, String ngId, String easId) {
        DynamicObject relation = AttachmentHelper.getRelationToTrdSystemDynamicObject(type, ngId, easId);
        ORM.create().save(relation);
    }

    public static void saveIds(DynamicObject[] relations) {
        ORM.create().save(relations);
    }

    public static DynamicObject getRelationToTrdSystemDynamicObject(String type, String ngId, String easId) {
        DynamicObject relation = ORM.create().newDynamicObject("er_relationtotrdsystem");
        relation.set("nextgenerationid", (Object)ngId);
        relation.set("type", (Object)type);
        relation.set("trdsystemid", (Object)easId);
        return relation;
    }

    public static String getTRDId(String type, Object ngId) {
        QFilter[] filters = new QFilter[]{new QFilter("nextgenerationid", "=", ngId), new QFilter("type", "=", (Object)type)};
        log.info("kd.ssc.task.util.AttachmentHelper.getTRDId(String, Object) : type - " + type);
        log.info("kd.ssc.task.util.AttachmentHelper.getTRDId(String, Object) : ngId - " + ngId);
        DynamicObject queryOne = BusinessDataServiceHelper.loadSingle((String)"er_relationtotrdsystem", (String)"id,trdsystemid", (QFilter[])filters);
        if (queryOne == null) {
            log.error("kd.ssc.task.util.AttachmentHelper.getTRDId(String, Object) : queryOne is null");
            return null;
        }
        log.info("kd.ssc.task.util.AttachmentHelper.getTRDId(String, Object) : trdsystemid - " + queryOne.getString("trdsystemid"));
        return queryOne.getString("trdsystemid");
    }

    private String getBaseUrl() {
        String fileServerUrl = ConfigurationFactory.getGlobalConfiguration().getProperty("attachment.fileserver");
        if (fileServerUrl == null) {
            throw new KDException(ResManager.loadKDString((String)"fileserver \u672a\u8bbe\u7f6e", (String)"AttachmentHelper_4", (String)"ssc-task-ext", (Object[])new Object[0]));
        }
        return fileServerUrl;
    }

    private String getEasLoginHttpUrl() {
        EASConfig eas = EASConfig.getConfig();
        StringBuilder urlBuf = new StringBuilder();
        urlBuf.append("http://");
        urlBuf.append(eas.getIP());
        urlBuf.append(':');
        urlBuf.append(eas.getPort());
        urlBuf.append("/easportal/eip/webAPI/login?user=");
        urlBuf.append(eas.getUserName());
        urlBuf.append("&password=");
        urlBuf.append(eas.getPassword());
        urlBuf.append("&dcName=");
        urlBuf.append(eas.getDataCenter());
        urlBuf.append("&language=");
        urlBuf.append(eas.getLanguage());
        StringBuilder logError = new StringBuilder();
        logError.append("loginHttpUrl : ").append((CharSequence)urlBuf);
        return urlBuf.toString();
    }

    protected ApiRequest getLoginRequestContext() {
        String method = "get";
        String url = this.getEasLoginHttpUrl();
        ApiRequest request = new ApiRequest(method, url);
        return request;
    }

    private ApiResult invokeApi(ApiRequest request) {
        ApiClient.Option option = new ApiClient.Option();
        option.readTimeout = 5000;
        ApiResult apiResult = null;
        try (ApiClient client = null;){
            client = ApiClientFactory.getExternal((ApiClient.Option)option);
            apiResult = client.execute(request);
        }
        return apiResult;
    }

    private String loginEasHttpApi() {
        ApiRequest loginApiRequest = this.getLoginRequestContext();
        ApiResult apiResult = this.invokeApi(loginApiRequest);
        return this.handleResult(apiResult);
    }

    protected String handleResult(ApiResult result) {
        String msg = null;
        if (result.isOk()) {
            result.getData();
            try {
                Map map = (Map)JSONUtils.cast((String)result.getData(), Map.class);
                if (!map.get("code").equals(0)) {
                    log.error("\u8bf7\u6c42\u7ed3\u679c\u6ca1\u6709code");
                    throw TaskKDExcetptionUtil.createKDException((String)"fi.ssc.NotTokenRequestResultError", (String)ResManager.loadKDString((String)"\u8bf7\u6c42\u7ed3\u679c\u6ca1\u6709Token", (String)"AttachmentHelper_6", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
                }
                msg = String.valueOf(map.get("token"));
            }
            catch (IOException e) {
                log.error("\u7ed3\u679c\u8f6c\u5316\u4e3ajson\u9519\u8bef", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)"fi.ssc.JsonParseError", (String)ResManager.loadKDString((String)"JSON\u8f6c\u6362\u9519\u8bef", (String)"AttachmentHelper_7", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
            }
            return msg;
        }
        throw TaskKDExcetptionUtil.createKDException((String)"fi.ssc.RequestEasTokenEception", (String)ResManager.loadKDString((String)"\u8bf7\u6c42eas Token\u5931\u8d25", (String)"AttachmentHelper_8", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
    }

    private String getEasAttachMentUrl(String attachId) {
        StringBuilder urlSb = new StringBuilder();
        StringBuilder urlSufix = new StringBuilder();
        String token = this.loginEasHttpApi();
        EASConfig eas = EASConfig.getConfig();
        try {
            token = URLEncoder.encode(token, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)"fi.ssc.EncodeError", (String)ResManager.loadKDString((String)"token \u7f16\u7801\u9519\u8bef", (String)"AttachmentHelper_9", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
        }
        urlSb.append("http://").append(eas.getIP()).append(':').append(eas.getPort()).append("/easportal/eip/").append("getAttachment");
        urlSufix.append("?id=").append(attachId).append("&token=").append(token);
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("getAttachMentUrl : ").append((CharSequence)urlSufix);
        log.info(logInfo.toString());
        return urlSb.append((CharSequence)urlSufix).toString();
    }

    public InputStream getEasAttachMent(String attachmentID) {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet get = new HttpGet(this.getEasAttachmentURI(attachmentID));
        InputStream inputStream = null;
        try {
            int len;
            CloseableHttpResponse exception = client.execute((HttpUriRequest)get);
            inputStream = exception.getEntity().getContent();
            ByteArrayOutputStream ioException = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                ioException.write(buffer, 0, len);
            }
            ioException.flush();
            ByteArrayInputStream inputStream1 = new ByteArrayInputStream(ioException.toByteArray());
            return inputStream1;
        }
        catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e1) {
                    throw TaskKDExcetptionUtil.createKDException((Throwable)e1, (String)"fi.ssc.IOClosedError", (String)ResManager.loadKDString((String)"IO\u5173\u95ed\u5f02\u5e38", (String)"AttachmentHelper_10", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
                }
            }
            throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)"fi.ssc.GetAttachmentError", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u9644\u4ef6\u9519\u8bef", (String)"AttachmentHelper_11", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
        }
    }

    private URI getEasAttachmentURI(String attachmentID) {
        StringBuilder urlSb = new StringBuilder();
        EASConfig eas = EASConfig.getConfig();
        String url = urlSb.append("http://").append(eas.getIP()).append(':').append(eas.getPort()).append("/easportal/eip/getAttachment").toString();
        String token = this.loginEasHttpApi();
        try {
            token = URLEncoder.encode(token, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)"fi.ssc.EncodeError", (String)ResManager.loadKDString((String)"token \u7f16\u7801\u9519\u8bef", (String)"AttachmentHelper_9", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
        }
        URI uri = null;
        try {
            uri = new URIBuilder(url).setParameter("id", attachmentID).setParameter("token", token).build();
        }
        catch (URISyntaxException e) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u9644\u4ef6\u7684URI\u5f02\u5e38", (Throwable)e);
            throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)"fi.ssc.GetAttachmentError", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bf7\u6c42\u9644\u4ef6\u7684URL\u5f02\u5e38\u3002", (String)"AttachmentHelper_12", (String)"ssc-task-ext", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
        }
        return uri;
    }
}

