/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.eventSend.event;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.Source;
import kd.ssc.enums.TaskSourceTypeEnum;
import kd.ssc.eventSend.core.SscEventContext;
import kd.ssc.eventSend.entity.PersonChangeTypeEnum;
import kd.ssc.eventSend.entity.SscEventDo;
import kd.ssc.eventSend.event.SscSendEvent;
import kd.ssc.eventSend.util.DutyManageDataHelper;
import kd.ssc.eventSend.util.SscEventResultHelper;

public class TaskPersonChangeEvent
implements SscSendEvent {
    private static final Log logger = LogFactory.getLog(TaskPersonChangeEvent.class);

    public Map<String, Object> event(SscEventContext context) {
        DynamicObjectCollection taskDyos;
        Long sscId = context.getSscId();
        List<Long> taskIds = context.getTaskIdList();
        PersonChangeTypeEnum personChangeType = context.getPersonChangeType();
        SscEventDo sscEventDo = context.getSscEventDo();
        logger.info("TaskPersonChangeEvent.event() start, taskIds = {}, personChangeType = {}", taskIds, (Object)personChangeType.getValue());
        if (PersonChangeTypeEnum.DELETE == personChangeType) {
            taskDyos = context.getTaskInfoDoList();
        } else {
            String entityName = context.getTaskEntityNumber();
            QFilter idFilter = new QFilter("id", "in", taskIds);
            String selectFields = "id, sscid, billlongid, billtype.bindbill.number, personid.id, pooltype, state, source, sourcetype, tasktypeid.qualityjudge";
            taskDyos = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        }
        return this.taskPersonChange(sscEventDo, sscId, (List<DynamicObject>)taskDyos, personChangeType);
    }

    private Map<String, Object> taskPersonChange(SscEventDo sscEventDo, Long sscId, List<DynamicObject> taskDyos, PersonChangeTypeEnum personChangeType) {
        if (CollectionUtils.isEmpty(taskDyos)) {
            logger.error("TaskPersonChangeEvent.event() end\uff1a\u5171\u4eab\u4efb\u52a1\u4e0d\u5b58\u5728");
            return SscEventResultHelper.getSuccessResult(null);
        }
        if (sscId == null || sscId == 0L) {
            sscId = taskDyos.get(0).getLong("sscid");
        }
        String sscType = DutyManageDataHelper.getSSCType((long)sscId);
        Iterator<DynamicObject> it = taskDyos.iterator();
        while (it.hasNext()) {
            DynamicObject taskDyo = it.next();
            String taskProperty = taskDyo.getString("tasktypeid.qualityjudge");
            if ("1".equals(taskProperty)) {
                logger.info("TaskPersonChangeEvent.event() doing. taskProperty = {}\uff1a\u8be5\u4efb\u52a1\u5c5e\u6027\u4e0d\u652f\u6301", (Object)taskProperty);
                it.remove();
                continue;
            }
            if (!SSCTypeEnum.HR.getValue().equals(sscType)) continue;
            int source = taskDyo.getInt("source");
            String sourceType = taskDyo.getString("sourcetype");
            if (Source.MService.getValue() == source && TaskSourceTypeEnum.HR_ACTIVITY.getValue().equals(sourceType)) continue;
            it.remove();
            logger.info("TaskPersonChangeEvent.event() doing. source = {}\uff0csourceType = {}\uff1a\u8be5\u573a\u666f\u65e0\u9700\u901a\u77e5HR\u4e2d\u53f0", (Object)source, (Object)sourceType);
        }
        if (taskDyos.size() == 0) {
            logger.info("TaskPersonChangeEvent.event() end. taskDyos.size() == 0");
            return SscEventResultHelper.getSuccessResult(null);
        }
        return this.doBizService(sscEventDo, taskDyos, personChangeType, sscType);
    }

    private Map<String, Object> doBizService(SscEventDo sscEventDo, List<DynamicObject> taskDyos, PersonChangeTypeEnum personChangeType, String sscType) {
        QFilter filter3;
        QFilter filter2;
        String caseNumber = sscEventDo.getEventType().getCaseNumber();
        QFilter filter1 = new QFilter("bizextcase.number", "=", (Object)caseNumber);
        DynamicObject bizExtServiceDo = QueryServiceHelper.queryOne((String)"ssc_bizextservice", (String)"id,servicename,methodname,cloudid.number,appid.number", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("sscbusinesstype", "=", (Object)sscType), filter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (bizExtServiceDo == null) {
            logger.info("TaskPersonChangeEvent.event() end\uff0csscType = {}\uff0ccaseNumber = {}\uff1a\u672a\u627e\u5230\u76f8\u5173\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u65e0\u9700\u6267\u884c", (Object)sscType, (Object)caseNumber);
            return SscEventResultHelper.getSuccessResult(null);
        }
        String serviceName = bizExtServiceDo.getString("servicename");
        String methodName = bizExtServiceDo.getString("methodname");
        String cloudId = bizExtServiceDo.getString("cloudid.number");
        String appId = bizExtServiceDo.getString("appid.number");
        if (StringUtils.isEmpty((Object)serviceName) || StringUtils.isEmpty((Object)methodName) || StringUtils.isEmpty((Object)cloudId) || StringUtils.isEmpty((Object)appId)) {
            logger.info("TaskPersonChangeEvent.event() end\uff0c\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u76f8\u5173\u914d\u7f6e\u4e3a\u7a7a");
            return SscEventResultHelper.getSuccessResult(null);
        }
        cloudId = cloudId.toLowerCase();
        ArrayList paramList = new ArrayList(taskDyos.size());
        Date now = new Date();
        for (DynamicObject taskDyo : taskDyos) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("billEntityType", taskDyo.getString("billtype.bindbill.number"));
            paramMap.put("billId", taskDyo.getLong("billlongid"));
            paramMap.put("taskId", taskDyo.getLong("id"));
            paramMap.put("personId", taskDyo.getLong("personid.id"));
            paramMap.put("poolType", taskDyo.getString("pooltype"));
            paramMap.put("state", taskDyo.getString("state"));
            paramMap.put("eventTime", now);
            paramMap.put("eventType", personChangeType.getValue());
            paramList.add(paramMap);
        }
        String paramJson = JSONObject.toJSONString(paramList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        sscEventDo.setEventDetailJson(paramJson);
        int maxCount = sscEventDo.getMaxCount();
        for (int i = 1; i <= maxCount; ++i) {
            try {
                logger.info("TaskPersonChangeEvent.event(), paramMap=" + paramJson);
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{paramList});
                logger.info("TaskPersonChangeEvent.event(), resultMap=" + JSONObject.toJSONString((Object)resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                return resultMap;
            }
            catch (Exception e) {
                logger.error("TaskPersonChangeEvent.event() failed:", (Throwable)e);
                if (i != maxCount) continue;
                throw e;
            }
        }
        return SscEventResultHelper.getSuccessResult(null);
    }
}

