/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.eventSend.poolexecutor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;

public class PreDistributionPoolExecutor
implements Runnable {
    private static final ThreadPool pool = ThreadPools.newFixedThreadPool((String)"SSC_Task_Pre_Distribution", (int)4);
    private static final Log logger = LogFactory.getLog(PreDistributionPoolExecutor.class);
    private Long sscId;
    private List<Long> taskIdList;

    public void execute() {
        pool.execute((Runnable)this);
    }

    @Override
    public void run() {
        try {
            if (this.sscId == null || this.sscId <= 0L || CollectionUtils.isEmpty(this.taskIdList)) {
                return;
            }
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("sscId", this.sscId);
            input.put("taskIdList", this.taskIdList);
            Map output = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskPreDistribute", (Object[])new Object[]{input});
            if (output != null && "true".equals(output.get("success"))) {
                Map data = (Map)output.get("data");
                List successTaskList = (List)data.get("successTaskIds");
                ArrayList<Long> failedTaskList = new ArrayList<Long>(this.taskIdList);
                failedTaskList.removeAll(successTaskList);
                if (!failedTaskList.isEmpty()) {
                    logger.error("\u9884\u5206\u914d\u5931\u8d25\uff0c\u5931\u8d25\u7684\u4efb\u52a1id\u5217\u8868\uff1a" + failedTaskList);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u9884\u5206\u914d\u5f02\u5e38", (Throwable)e);
        }
    }

    public PreDistributionPoolExecutor(Long sscId, List<Long> taskIdList) {
        this.sscId = sscId;
        this.taskIdList = taskIdList;
    }

    public Long getSscId() {
        return this.sscId;
    }

    public void setSscId(Long sscId) {
        this.sscId = sscId;
    }

    public List<Long> getTaskIdList() {
        return this.taskIdList;
    }

    public void setTaskIdList(List<Long> taskIdList) {
        this.taskIdList = taskIdList;
    }
}

