/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class SscFunctionTypes {
    private static Log log = LogFactory.getLog(SscFunctionTypes.class);
    public static final String FuncFile_SSC = "/SSC_BillFuncTypes.xml";
    private static final String FUNCFILE_FI_DAP_EN_US = "/SSC_BillFuncTypes.en_US.xml";
    public static final String SSCFuncModelDefineFile = "/func/ssc/sscfuncmodules.txt";
    private static final String FUNC_PATH = "/func/ssc/";
    private static final String FUNC_END_SUFFIX = ".func";
    private static final String FUNC_END_LANG = "en_US";
    private static FunctionTypes sysSscFuncs = null;
    private static String sysLanguage = null;

    public static synchronized FunctionTypes get() {
        String language = ResManager.getLanguage();
        if (!language.equals(sysLanguage)) {
            URL url = FunctionTypes.class.getResource(SscFunctionTypes.getFuncFileName());
            sysSscFuncs = FunctionTypes.get((URL)url, (boolean)false);
            FunctionTypes bizBillFuncTypes = SscFunctionTypes.loadBizCloudFuncTypes();
            sysSscFuncs.getFunctionGroups().addAll(bizBillFuncTypes.getFunctionGroups());
            sysSscFuncs.getFunctionTypes().addAll(bizBillFuncTypes.getFunctionTypes());
        }
        sysLanguage = language;
        return sysSscFuncs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FunctionTypes loadBizCloudFuncTypes() {
        FunctionTypes functionTypes = new FunctionTypes();
        InputStream modulesStream = FunctionTypes.class.getResourceAsStream(SSCFuncModelDefineFile);
        if (modulesStream != null) {
            BufferedReader modulesReader = null;
            try {
                String[] mos;
                modulesReader = new BufferedReader(new InputStreamReader(modulesStream));
                String modules = modulesReader.readLine();
                if (StringUtils.isNotEmpty((String)modules) && (mos = modules.split(",")) != null && mos.length > 0) {
                    for (String m : mos) {
                        URL url = FunctionTypes.class.getResource(SscFunctionTypes.getFuncPath(m));
                        if (url == null) continue;
                        FunctionTypes appFuncs = FunctionTypes.get((URL)url, (boolean)false);
                        functionTypes.getFunctionGroups().addAll(appFuncs.getFunctionGroups());
                        functionTypes.getFunctionTypes().addAll(appFuncs.getFunctionTypes());
                    }
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            finally {
                if (modulesReader != null) {
                    try {
                        modulesReader.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
            }
        }
        return functionTypes;
    }

    private static String getFuncFileName() {
        String language = ResManager.getLanguage().toLowerCase();
        if (language.startsWith("en_")) {
            return FUNCFILE_FI_DAP_EN_US;
        }
        return FuncFile_SSC;
    }

    private static String getFuncPath(String module) {
        String language = ResManager.getLanguage().toLowerCase();
        StringBuilder sb = new StringBuilder(FUNC_PATH);
        sb.append(module.toLowerCase());
        if (language.startsWith("en_")) {
            sb.append(".").append(FUNC_END_LANG);
        }
        sb.append(FUNC_END_SUFFIX);
        return sb.toString();
    }
}

