/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.satisfactionevaluation.service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.ssc.enums.satisfactionevaluation.EvaluateStarEnum;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.satisfactionevaluation.service.ValidationPipeline;
import kd.ssc.task.util.DateUtil;

public class EvaluateOpHelper {
    private static final Log log = LogFactory.getLog(EvaluateOpHelper.class);
    private static final String CONFIG_KEY = "tempfile/download.do?configKey";
    private static final String OTHER_ID_STR = "2121868488917593088";
    private static final long ENTIRETY_ID = 2119557781294981120L;
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String REIMBURSEMENT_UPDATE_SQL = "update t_dhc_mybilllist set fevaluatestatus=? where fbillid =? and fevaluatestatus=?";

    public static Optional<String> doEvaluate(Map<String, Object> paramMap) {
        Optional<String> validateMessage = EvaluateOpHelper.evaluateValidate(paramMap);
        if (validateMessage.isPresent()) {
            return validateMessage;
        }
        List<DynamicObject> detailList = EvaluateOpHelper.genEvaluateDetailList(paramMap);
        if (detailList.size() > 0) {
            Object[] ids;
            long billId = (Long)paramMap.get("billId");
            QFilter qFilter = new QFilter("billid", "=", (Object)billId);
            if (QueryServiceHelper.exists((String)"som_evaluatedetail", (QFilter[])new QFilter[]{qFilter})) {
                return Optional.of(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8bc4\u4ef7\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"EvaluateOpHelper_0", (String)"ssc-task-common", (Object[])new Object[0]));
            }
            try (TXHandle tx = TX.required((String)"kd.ssc.satisfactionevaluation.service.EvaluateOpHelper.doEvaluate");){
                try {
                    ids = SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
                    DeleteServiceHelper.delete((String)"som_evaluating_data", (QFilter[])new QFilter[]{qFilter});
                    Object[] param = new Object[]{EvaluateStatusEnum.EVALUATED_STATE.getStatus(), billId, EvaluateStatusEnum.EVALUATING_STATE.getStatus()};
                    DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)REIMBURSEMENT_UPDATE_SQL, (Object[])param);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    log.error("doEvaluate save data e:", e);
                    throw new KDBizException(BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AutoEvaluateScheduleTask_0", (String)"ssc-task-formplugin", (Object[])new Object[0])});
                }
            }
            List attachmentList = (List)paramMap.get("attachmentList");
            if (ids != null && ids.length > 0 && CollectionUtils.isNotEmpty((Collection)attachmentList)) {
                long attachId = 0L;
                for (Object id : ids) {
                    boolean isAttachMent = ((DynamicObject)id).getBoolean("isattachments");
                    if (!isAttachMent) continue;
                    attachId = ((DynamicObject)id).getLong("id");
                    break;
                }
                if (attachId > 0L) {
                    EvaluateOpHelper.attachMentDeal(attachmentList, attachId);
                }
            }
        }
        return Optional.empty();
    }

    private static void attachMentDeal(List<Map<String, Object>> attachmentList, Object attachId) {
        if (CollectionUtils.isNotEmpty(attachmentList)) {
            for (Map<String, Object> temp : attachmentList) {
                String tempUrl = (String)temp.get("url");
                String fileName = (String)temp.get("name");
                if (!StringUtils.isNotEmpty((String)tempUrl) || !tempUrl.contains(CONFIG_KEY)) continue;
                String fileId = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"som", (String)"som_evaluatedetail", (Object)attachId, (String)fileName, (boolean)true);
                temp.put("url", fileId);
            }
            AttachmentServiceHelper.upload((String)"som_evaluatedetail", (Object)attachId, (String)"attachmentpanel", attachmentList);
        }
    }

    private static List<DynamicObject> genEvaluateDetailList(Map<String, Object> paramMap) {
        long sscId = (Long)paramMap.get("sscId");
        long orgId = (Long)paramMap.get("orgId");
        long billTypeId = (Long)paramMap.get("billTypeId");
        String waiteValuateTime = (String)paramMap.get("waiteValuateTime");
        long billId = (Long)paramMap.get("billId");
        String billNo = (String)paramMap.get("billNo");
        Map dimensionIdMap = (Map)paramMap.get("dimensionIdMap");
        Map rateScoreMap = (Map)paramMap.get("rateScoreMap");
        Map reasonIdMap = (Map)paramMap.get("reasonIdMap");
        Map textMap = (Map)paramMap.get("textMap");
        long userDimensionId = (Long)paramMap.get("userDimensionId");
        Map userRateScoreMap = (Map)paramMap.get("userRateScoreMap");
        Map userReasonIdMap = (Map)paramMap.get("userReasonIdMap");
        Map userTextMap = (Map)paramMap.get("userTextMap");
        String options = (String)paramMap.get("options");
        List attachmentList = (List)paramMap.get("attachmentList");
        Date date = new Date();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(1024);
        for (Map.Entry entry : dimensionIdMap.entrySet()) {
            Integer index = (Integer)entry.getKey();
            Long dimensionId = (Long)entry.getValue();
            DynamicObject evaluateDetail = BusinessDataServiceHelper.newDynamicObject((String)"som_evaluatedetail");
            evaluateDetail.set("billid", (Object)billId);
            evaluateDetail.set("billno", (Object)billNo);
            evaluateDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
            evaluateDetail.set("org", (Object)orgId);
            evaluateDetail.set("sscid", (Object)sscId);
            evaluateDetail.set("evaluativedimension", (Object)dimensionId);
            evaluateDetail.set("autoevaluate", (Object)false);
            if (2119557781294981120L == dimensionId) {
                evaluateDetail.set("opinion", (Object)options);
                if (CollectionUtils.isNotEmpty((Collection)attachmentList)) {
                    evaluateDetail.set("isattachments", (Object)true);
                }
            } else {
                evaluateDetail.set("isattachments", (Object)false);
            }
            evaluateDetail.set("createtime", (Object)date);
            try {
                evaluateDetail.set("evaluatebegintime", (Object)DateUtil.parse(waiteValuateTime, PATTERN));
            }
            catch (ParseException e) {
                log.error("date parse exception, e:", (Throwable)e);
            }
            evaluateDetail.set("billtype", (Object)billTypeId);
            DynamicObjectCollection detailEntryList = evaluateDetail.getDynamicObjectCollection("entryentity");
            DynamicObject detailEntry = new DynamicObject(detailEntryList.getDynamicObjectType());
            int rateScore = (Integer)rateScoreMap.get(index);
            detailEntry.set("stars", (Object)rateScore);
            String reasonIdStr = (String)reasonIdMap.get(index);
            if (StringUtils.isNotEmpty((String)reasonIdStr)) {
                String[] reasonIds = reasonIdStr.split(",");
                String[] reasonArray = EvaluateOpHelper.removeEmptyStrings(reasonIds);
                Long[] longReasonIdArray = (Long[])Arrays.stream(reasonArray).map(Long::valueOf).toArray(Long[]::new);
                if (rateScore <= 2) {
                    DynamicObjectCollection dynamicObjectCollection = detailEntry.getDynamicObjectCollection("unsatisfiedreason");
                    for (Long reasonId : longReasonIdArray) {
                        DynamicObject newRow = dynamicObjectCollection.addNew();
                        newRow.set("fbasedataid_id", (Object)reasonId);
                    }
                }
                if (reasonArray.length > 0 && Arrays.stream(reasonArray).anyMatch(element -> OTHER_ID_STR.equals(element))) {
                    detailEntry.set("othertext", textMap.get(index));
                }
            }
            detailEntryList.add((Object)detailEntry);
            detailList.add(evaluateDetail);
        }
        DynamicObject userEvaluateDetail = BusinessDataServiceHelper.newDynamicObject((String)"som_evaluatedetail");
        userEvaluateDetail.set("billid", (Object)billId);
        userEvaluateDetail.set("billno", (Object)billNo);
        userEvaluateDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
        userEvaluateDetail.set("org", (Object)orgId);
        userEvaluateDetail.set("sscid", (Object)sscId);
        userEvaluateDetail.set("evaluativedimension", (Object)userDimensionId);
        userEvaluateDetail.set("autoevaluate", (Object)false);
        userEvaluateDetail.set("isattachments", (Object)false);
        userEvaluateDetail.set("createtime", (Object)date);
        try {
            userEvaluateDetail.set("evaluatebegintime", (Object)DateUtil.parse(waiteValuateTime, PATTERN));
        }
        catch (ParseException e) {
            log.error("date parse exception, e:", (Throwable)e);
        }
        userEvaluateDetail.set("billtype", (Object)billTypeId);
        DynamicObjectCollection detailEntryList = userEvaluateDetail.getDynamicObjectCollection("entryentity");
        Map userIdMap = (Map)paramMap.get("userIdMap");
        for (Map.Entry userIdEntry : userIdMap.entrySet()) {
            Integer index = (Integer)userIdEntry.getKey();
            Long userId = (Long)userIdEntry.getValue();
            DynamicObject detailEntry = new DynamicObject(detailEntryList.getDynamicObjectType());
            detailEntry.set("sscuser", (Object)userId);
            Integer rateScore = (Integer)userRateScoreMap.get(index);
            if (rateScore != null && rateScore > 0) {
                detailEntry.set("stars", (Object)rateScore.toString());
            } else {
                detailEntry.set("stars", (Object)EvaluateStarEnum.FOUR.getValue());
            }
            String reasonIdStr = (String)userReasonIdMap.get(index);
            if (StringUtils.isNotEmpty((String)reasonIdStr)) {
                String[] reasonIds = reasonIdStr.split(",");
                String[] reasonArray = EvaluateOpHelper.removeEmptyStrings(reasonIds);
                Long[] longReasonIdArray = (Long[])Arrays.stream(reasonArray).map(Long::valueOf).toArray(Long[]::new);
                if (rateScore != null && rateScore <= 2) {
                    DynamicObjectCollection dynamicObjectCollection = detailEntry.getDynamicObjectCollection("unsatisfiedreason");
                    for (Long reasonId : longReasonIdArray) {
                        DynamicObject newRow = dynamicObjectCollection.addNew();
                        newRow.set("fbasedataid_id", (Object)reasonId);
                    }
                }
                if (reasonArray.length > 0 && Arrays.stream(reasonArray).anyMatch(element -> OTHER_ID_STR.equals(element))) {
                    detailEntry.set("othertext", userTextMap.get(index));
                }
            }
            detailEntryList.add((Object)detailEntry);
        }
        detailList.add(userEvaluateDetail);
        return detailList;
    }

    public static Optional<String> evaluateValidate(Map<String, Object> paramMap) {
        Map textMap;
        Map reasonIdMap;
        Map rateScoreMap;
        Map dimensionIdMap = (Map)paramMap.get("dimensionIdMap");
        QFilter filter = new QFilter("id", "in", dimensionIdMap.values());
        Map idNameMap = BusinessDataServiceHelper.loadFromCache((String)"som_evaluative_dimension", (String)"name", (QFilter[])new QFilter[]{filter});
        Optional<String> validateRes = ValidationPipeline.validate(idNameMap, dimensionIdMap, rateScoreMap = (Map)paramMap.get("rateScoreMap"), reasonIdMap = (Map)paramMap.get("reasonIdMap"), textMap = (Map)paramMap.get("textMap"));
        if (validateRes.isPresent()) {
            return validateRes;
        }
        Map userIdMap = (Map)paramMap.get("userIdMap");
        QFilter userFilter = new QFilter("id", "in", userIdMap.values());
        Map userIdNameMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{userFilter});
        Map userRateScoreMap = (Map)paramMap.get("userRateScoreMap");
        Map userReasonIdMap = (Map)paramMap.get("userReasonIdMap");
        Map userTextMap = (Map)paramMap.get("userTextMap");
        return ValidationPipeline.validateSscUser(userIdNameMap, userIdMap, userRateScoreMap, userReasonIdMap, userTextMap);
    }

    private static String[] removeEmptyStrings(String[] arr) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            if (!StringUtils.isNotEmpty((String)s)) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }
}

