/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.satisfactionevaluation.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;

public class ValidationPipeline {
    private static final String OTHER_ID_STR = "2121868488917593088";

    public static Optional<String> validate(Map<Object, DynamicObject> idNameMap, Map<Integer, Long> dimensionIdMap, Map<Integer, Integer> rateScoreMap, Map<Integer, String> reasonIdMap, Map<Integer, String> textMap) {
        List<Supplier> validators = Arrays.asList(() -> ValidationPipeline.validateRateScore(idNameMap, dimensionIdMap, rateScoreMap), () -> ValidationPipeline.validateReasonsForLowScores(idNameMap, dimensionIdMap, rateScoreMap, reasonIdMap), () -> ValidationPipeline.validateTextForOther(idNameMap, dimensionIdMap, reasonIdMap, textMap));
        for (Supplier validator : validators) {
            Optional result = (Optional)validator.get();
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public static Optional<String> validateSscUser(Map<Object, DynamicObject> userIdNameMap, Map<Integer, Long> userIdMap, Map<Integer, Integer> rateScoreMap, Map<Integer, String> reasonIdMap, Map<Integer, String> textMap) {
        List<Supplier> validators = Arrays.asList(() -> ValidationPipeline.validateUserReasonsForLowScores(userIdNameMap, userIdMap, rateScoreMap, reasonIdMap), () -> ValidationPipeline.validateUserTextForOther(userIdNameMap, userIdMap, reasonIdMap, textMap));
        for (Supplier validator : validators) {
            Optional result = (Optional)validator.get();
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    private static Optional<String> validateRateScore(Map<Object, DynamicObject> idNameMap, Map<Integer, Long> dimensionIdMap, Map<Integer, Integer> rateScoreMap) {
        for (Map.Entry<Integer, Long> entry : dimensionIdMap.entrySet()) {
            Integer index = entry.getKey();
            if (!rateScoreMap.containsKey(index)) {
                String name = idNameMap.get(entry.getValue()).getString("name");
                return Optional.of(ResManager.loadKDString((String)"\u8bf7\u8bc4\u4ef7\u201c%s\u201d\u3002", (String)"ValidationPipeline_0", (String)"ssc-task-common", (Object[])new Object[]{name}));
            }
            Integer score = rateScoreMap.get(index);
            if (score != null && score > 0) continue;
            String name = idNameMap.get(entry.getValue()).getString("name");
            return Optional.of(ResManager.loadKDString((String)"\u8bf7\u8bc4\u4ef7\u201c%s\u201d\u3002", (String)"ValidationPipeline_0", (String)"ssc-task-common", (Object[])new Object[]{name}));
        }
        return Optional.empty();
    }

    private static Optional<String> validateReasonsForLowScores(Map<Object, DynamicObject> idNameMap, Map<Integer, Long> dimensionIdMap, Map<Integer, Integer> rateScoreMap, Map<Integer, String> reasonIdMap) {
        for (Map.Entry<Integer, Integer> entry : rateScoreMap.entrySet()) {
            String reason;
            Integer index = entry.getKey();
            Integer score = entry.getValue();
            if (score > 2 || !StringUtils.isEmpty((String)(reason = reasonIdMap.get(index)))) continue;
            String name = idNameMap.get(dimensionIdMap.get(index)).getString("name");
            return Optional.of(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u8bc4\u4ef7\u7ef4\u5ea6\u201c%s\u201d\u7684\u5dee\u8bc4\u7406\u7531\u3002", (String)"ValidationPipeline_1", (String)"ssc-task-common", (Object[])new Object[]{name}));
        }
        return Optional.empty();
    }

    private static Optional<String> validateUserReasonsForLowScores(Map<Object, DynamicObject> userIdNameMap, Map<Integer, Long> userIdMap, Map<Integer, Integer> rateScoreMap, Map<Integer, String> reasonIdMap) {
        for (Map.Entry<Integer, Integer> entry : rateScoreMap.entrySet()) {
            String reason;
            Integer index = entry.getKey();
            Integer score = entry.getValue();
            if (score <= 0 || score > 2 || !StringUtils.isEmpty((String)(reason = reasonIdMap.get(index)))) continue;
            String name = userIdNameMap.get(userIdMap.get(index)).getString("name");
            return Optional.of(ResManager.loadKDString((String)"\u672a\u9009\u62e9SSC\u4eba\u5458\u201c%s\u201d\u7684\u5dee\u8bc4\u7406\u7531\u3002", (String)"ValidationPipeline_2", (String)"ssc-task-common", (Object[])new Object[]{name}));
        }
        return Optional.empty();
    }

    private static Optional<String> validateTextForOther(Map<Object, DynamicObject> idNameMap, Map<Integer, Long> dimensionIdMap, Map<Integer, String> reasonIdMap, Map<Integer, String> textMap) {
        for (Map.Entry<Integer, String> entry : reasonIdMap.entrySet()) {
            Integer index = entry.getKey();
            String reason = entry.getValue();
            String[] reasonIds = reason.split(",");
            if (reasonIds.length <= 0 || !Arrays.stream(reasonIds).anyMatch(element -> OTHER_ID_STR.equals(element))) continue;
            String name = idNameMap.get(dimensionIdMap.get(index)).getString("name");
            String text = textMap.get(index);
            if (!StringUtils.isEmpty((String)text)) continue;
            return Optional.of(ResManager.loadKDString((String)"\u672a\u586b\u5199\u8bc4\u4ef7\u7ef4\u5ea6\u201c%s\u201d\u7684\u5176\u4ed6\u539f\u56e0\u3002", (String)"ValidationPipeline_3", (String)"ssc-task-common", (Object[])new Object[]{name}));
        }
        return Optional.empty();
    }

    private static Optional<String> validateUserTextForOther(Map<Object, DynamicObject> userIdNameMap, Map<Integer, Long> userIdMap, Map<Integer, String> reasonIdMap, Map<Integer, String> textMap) {
        for (Map.Entry<Integer, String> entry : reasonIdMap.entrySet()) {
            String text;
            Integer index = entry.getKey();
            String reason = entry.getValue();
            String[] reasonIds = reason.split(",");
            if (reasonIds.length <= 0 || !Arrays.stream(reasonIds).anyMatch(element -> OTHER_ID_STR.equals(element)) || !StringUtils.isEmpty((String)(text = textMap.get(index)))) continue;
            String name = userIdNameMap.get(userIdMap.get(index)).getString("name");
            return Optional.of(ResManager.loadKDString((String)"\u672a\u586b\u5199SSC\u4eba\u5458\u201c%s\u201d\u7684\u5176\u4ed6\u539f\u56e0\u3002", (String)"ValidationPipeline_4", (String)"ssc-task-common", (Object[])new Object[]{name}));
        }
        return Optional.empty();
    }
}

