/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.partask.util.FixCheckTask;
import kd.ssc.task.util.DateUtil;

public class NextTaskCompensateSchedule
extends AbstractTask {
    private static final Log log = LogFactory.getLog((String)"NextTaskCompensateSchedule");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Long> hisTaskIdList = this.detectRecord();
        for (Long taskid : hisTaskIdList) {
            try {
                FixCheckTask.fixNextCheckTask((long)taskid);
                log.info("");
            }
            catch (Exception e) {
                log.error("\u590d\u6838\u4efb\u52a1\u8865\u507f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> detectRecord() {
        DataSet wf_dataset = null;
        DataSet task_dataset = null;
        DataSet joinDataSet = null;
        DataSet process_task_dataset = null;
        try {
            String wf_select = "id,businesskey,modifydate";
            ArrayList<QFilter> wf_filters = new ArrayList<QFilter>(2);
            wf_filters.add(new QFilter("category", "=", (Object)"SSCApprove"));
            wf_filters.add(new QFilter("modifydate", "<=", (Object)this.getFilterDate()));
            String wf_orderBy = "modifydate";
            String task_select = "billid,assignid";
            String ready_task_select = "billid,cast(assignid as long) wfid";
            String[] task_group = new String[]{"billid", "assignid"};
            ArrayList<QFilter> task_filters = new ArrayList<QFilter>(1);
            task_filters.add(new QFilter("completetime", ">=", (Object)DateUtil.addMonth(new Date(), -1)));
            task_filters.add(new QFilter("assignid", ">", (Object)"0"));
            task_filters.add(new QFilter("qualitysamplelibrary", "=", (Object)0L));
            task_dataset = QueryServiceHelper.queryDataSet((String)"NextTaskCompensateSchedule.task", (String)"task_taskhistory", (String)task_select, (QFilter[])task_filters.toArray(new QFilter[0]), null).groupBy(task_group).count("count").finish().filter("count = 1");
            task_dataset = task_dataset.select(ready_task_select);
            wf_dataset = QueryServiceHelper.queryDataSet((String)"NextTaskCompensateSchedule.wf", (String)"wf_task", (String)wf_select, (QFilter[])wf_filters.toArray(new QFilter[0]), (String)wf_orderBy);
            joinDataSet = task_dataset.join(wf_dataset, JoinType.INNER).on("billid", "businesskey").on("wfid", "id").select(new String[]{"billid", "wfid", "modifydate"}).finish().orderBy(new String[]{"modifydate"});
            HashSet<Object> billIdList = new HashSet<Object>(64);
            for (Row row : joinDataSet) {
                billIdList.add(row.get("billid"));
            }
            QFilter billIdFil = new QFilter("billid", "in", billIdList);
            QFilter QuaSplFil = new QFilter("qualitysamplelibrary", "=", (Object)0L);
            process_task_dataset = QueryServiceHelper.queryDataSet((String)"NextTaskCompensateSchedule.process_task", (String)"task_task", (String)"billid", (QFilter[])new QFilter[]{billIdFil, QuaSplFil}, null);
            HashSet<Object> processBillIdList = new HashSet<Object>(64);
            for (Row row : process_task_dataset) {
                processBillIdList.add(row.get("billid"));
            }
            billIdList.removeAll(processBillIdList);
            DataSet rtnDataSet = QueryServiceHelper.queryDataSet((String)"NextTaskCompensateSchedule.finish", (String)"task_taskhistory", (String)"id", (QFilter[])new QFilter("billid", "in", billIdList).toArray(), null);
            HashSet<Long> taskIdList = new HashSet<Long>(billIdList.size());
            for (Row row : rtnDataSet) {
                taskIdList.add(row.getLong("id"));
            }
            ArrayList arrayList = new ArrayList(taskIdList);
            return arrayList;
        }
        catch (Exception e) {
            log.error("\u590d\u6838\u8865\u507f\uff0c\u6570\u636e\u67e5\u8be2\u62a5\u9519", (Throwable)e);
            ArrayList<Long> arrayList = new ArrayList<Long>(0);
            return arrayList;
        }
        finally {
            if (wf_dataset != null) {
                wf_dataset.close();
            }
            if (task_dataset != null) {
                task_dataset.close();
            }
            if (joinDataSet != null) {
                joinDataSet.close();
            }
            if (process_task_dataset != null) {
                process_task_dataset.close();
            }
        }
    }

    private Date getFilterDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        return calendar.getTime();
    }
}

