/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.fi.ssc.extpoint.create.ITaskCreateService;
import kd.ssc.enums.MultiState;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.TaskFieldConfigEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskSourceTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.eventSend.util.DutyManageDataHelper;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.formula.context.TaskConditionContext;
import kd.ssc.formula.service.impl.TaskBillDataSource;
import kd.ssc.smartApproval.predict.IntelligentExecutor;
import kd.ssc.task.bill.TaskBillHandler;
import kd.ssc.task.bill.TaskBillHandlerFactory;
import kd.ssc.task.helper.TaskBillChildQueryServiceHelper;
import kd.ssc.task.util.TaskOwningSysUtil;
import kd.ssc.task.util.TaskRuleUtil;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractCreateTask {
    private static final Log log = LogFactory.getLog(AbstractCreateTask.class);
    protected DynamicObject taskType;
    protected DynamicObject billType;
    protected String billID;
    protected long sysBillID;
    protected DynamicObject ssc;
    protected String executeOprt;
    protected String reverseOprt;
    protected DynamicObject org;
    protected DynamicObject applier;
    protected Date applytime;
    protected DynamicObject billData = null;
    protected String imageNumber;
    protected DynamicObject task;
    protected DynamicObject taskLevel;
    protected String assignID;
    protected String procinstID;
    protected String subject;
    protected boolean imageok;
    protected boolean islastaudit;
    protected int source;
    protected DynamicObject extenderp;
    protected int pooltype = -1;
    protected String state = "-1";
    protected ORM orm = ORM.create();
    protected DynamicObject createRule;
    protected BigDecimal restTime = null;
    protected boolean isFromExternalSystem = true;
    protected boolean needimage = false;
    protected String sourceType = TaskSourceTypeEnum.ELSE.getValue();

    protected long createTask() {
        this.prepareTaskData();
        if (!this.conditionValidate()) {
            return 0L;
        }
        long taskId = this.packTask();
        if (taskId != 0L) {
            this.afterCreateTask();
        }
        return taskId;
    }

    private boolean conditionValidate() {
        return this.sscBillOrgPartition();
    }

    protected void prepareTaskData() {
        this.billType = this.getBillType();
        if (this.billType == null) {
            throw TaskKDExcetptionUtil.createKDException((String)TaskErrorCodeEnum.C_BILLTYPE_NOTEXISTS.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u5728\u5171\u4eab\u5e73\u53f0\u914d\u7f6e\u4e1a\u52a1\u5355\u636e\u57fa\u7840\u8d44\u6599\u3002", (String)"AbstractCreateTask_0", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        this.taskType = this.getTaskType();
        if (this.taskType == null) {
            throw TaskKDExcetptionUtil.createKDException((String)TaskErrorCodeEnum.C_TASKTYPE_NOTEXISTS.getCode(), (String)ResManager.loadKDString((String)"\u8bf7\u5728\u5171\u4eab\u5e73\u53f0\u914d\u7f6e\u4efb\u52a1\u7c7b\u578b\u57fa\u7840\u8d44\u6599\u3002", (String)"AbstractCreateTask_1", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        this.createRule = this.getCreateRule(this.taskType, this.billType);
        if (this.createRule != null) {
            this.needimage = (Boolean)this.createRule.get("needimage");
            DynamicObjectCollection levels = this.createRule.getDynamicObjectCollection("entryentitylevel");
            levels.sort((o1, o2) -> {
                String rule1 = (String)o1.get("priorityrule");
                String rule2 = (String)o2.get("priorityrule");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rule1) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rule2)) {
                    return -1;
                }
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rule1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rule2)) {
                    return 1;
                }
                return 0;
            });
            DynamicObject defaultPriority = null;
            BigDecimal defaultTimeliness = null;
            boolean flag = false;
            DynamicObject bindbill = (DynamicObject)this.billType.get("bindbill");
            String entityNumber = (String)bindbill.get("number");
            MainEntityType dataType = null;
            try {
                dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (Exception e) {
                log.error("\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u5355\u636e\u62a5\u9519", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_GETDATAENTITYTYPE_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u521b\u5efa\u4efb\u52a1\u65f6\uff0c\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u5355\u636e\u62a5\u9519\u3002", (String)"AbstractCreateTask_2", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[]{new Object()});
            }
            for (DynamicObject level : levels) {
                String priorityrule = (String)level.get("priorityrule");
                DynamicObject priority = (DynamicObject)level.get("priority");
                boolean isdefault = level.getBoolean("isdefault");
                BigDecimal timeliness = (BigDecimal)level.get("timeliness");
                if (priority != null && isdefault) {
                    defaultPriority = priority;
                    defaultTimeliness = timeliness;
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)priorityrule)) continue;
                String priorityrulejson = (String)level.get("priorityrulejson");
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)priorityrulejson, FilterCondition.class);
                String erpNumber = this.billType.getString("externalerp.number");
                QFilter qfilter = TaskOwningSysUtil.getBillIdQFilter(erpNumber, this.billID);
                DynamicObjectCollection collection = new DynamicObjectCollection();
                if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
                    CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)priorityrulejson, CRCondition.class);
                    TaskConditionContext context = new TaskConditionContext();
                    ArrayList<QFilter> qfilters = new ArrayList<QFilter>(4);
                    qfilters.add(qfilter);
                    context.setQfilters(qfilters);
                    context.setCondition(conditionObj);
                    TaskBillDataSource iDataSource = new TaskBillDataSource();
                    List<QFilter> qFilters = iDataSource.buildFilter(entityNumber, context);
                    try {
                        collection = iDataSource.getData(entityNumber, qFilters, context);
                    }
                    catch (Exception e) {
                        log.error("Formula getData error:", (Throwable)e);
                    }
                } else {
                    FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, true);
                    filterBuilder.buildFilter(false);
                    collection = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{filterBuilder.getQFilter(), qfilter});
                }
                if (collection.size() == 0 || priority == null) continue;
                this.taskLevel = priority;
                this.restTime = timeliness;
                flag = true;
                break;
            }
            if (!flag) {
                this.taskLevel = defaultPriority;
                this.restTime = defaultTimeliness;
            }
        }
        this.afterPrepareTaskData();
    }

    protected void afterPrepareTaskData() {
    }

    protected abstract DynamicObject getBillType();

    protected abstract DynamicObject getTaskType();

    protected long packTask() {
        this.task = this.orm.newDynamicObject("task_task");
        this.verify();
        this.task.set("tasktypeid", (Object)this.taskType);
        this.task.set("billtype", (Object)this.billType);
        this.task.set("billid", (Object)this.billID);
        if (org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)this.billID)) {
            this.task.set("billlongid", (Object)Long.parseLong(this.billID));
        }
        DynamicObject billImageMap = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"imagestate,imagenumber,needimagescan", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)this.billID)});
        if (this.needimage) {
            if (billImageMap == null) {
                this.pooltype = Integer.parseInt(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue());
                this.state = TaskStateEnum.TO_UPLOAD_IMAGE.getValue();
            } else {
                if (!"2".equals(billImageMap.getString("needimagescan"))) {
                    log.info("\u521b\u5efa\u4efb\u52a1\u65f6\u67e5\u8be2\u5230\u7684billImageMap\uff1a" + billImageMap);
                    if ("2".equals(billImageMap.get("imagestate")) || "4".equals(billImageMap.get("imagestate"))) {
                        this.imageok = true;
                    } else {
                        this.pooltype = Integer.parseInt(TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue());
                        this.state = TaskStateEnum.TO_UPLOAD_IMAGE.getValue();
                    }
                }
                this.task.set("imageNumber", (Object)billImageMap.getString("imagenumber"));
            }
        }
        if (billImageMap != null && ("2".equals(billImageMap.get("imagestate")) || "4".equals(billImageMap.get("imagestate")))) {
            this.imageok = true;
        }
        if (this.ssc == null) {
            this.ssc = this.orm.newDynamicObject("bos_org");
            this.ssc.set("id", this.billType.get("ssccenter.id"));
        }
        this.task.set("sscid", (Object)this.ssc);
        if (this.applier == null) {
            RequestContext requestContext = RequestContext.get();
            long userid = requestContext.getCurrUserId();
            this.applier = this.orm.newDynamicObject("bos_user");
            this.applier.set("id", (Object)userid);
        }
        this.task.set("creator", (Object)this.applier);
        this.task.set("oprt", (Object)this.executeOprt);
        this.task.set("extenderp", (Object)this.extenderp);
        this.task.set("source", (Object)this.source);
        if (this.pooltype == -1) {
            this.pooltype = Integer.parseInt(TaskPoolTypeEnum.TO_BE_DIS.getValue());
        }
        this.task.set("pooltype", (Object)this.pooltype);
        if ("-1".equals(this.state)) {
            this.state = TaskStateEnum.TO_BE_DIS.getValue();
        }
        this.task.set("state", (Object)this.state);
        this.task.set("multistate", (Object)MultiState.Normal.getValue());
        if (this.restTime == null) {
            this.taskLevel = this.orm.queryOne("task_tasklevel", new QFilter[]{new QFilter("number", "=", (Object)"002")});
            this.restTime = new BigDecimal("48");
        }
        if (this.taskLevel != null) {
            this.task.set("tasklevelid", (Object)this.taskLevel);
            this.task.set("level", this.taskLevel.get("priority"));
        }
        this.task.set("resttime", (Object)this.restTime);
        Date now = new Date();
        this.task.set("createtime", (Object)now);
        this.task.set("taskcreatetime", (Object)now);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(12, 2);
        this.task.set("predictdistime", (Object)calendar.getTime());
        this.task.set("expirestate", (Object)1);
        this.task.set("autoprocess", (Object)0);
        this.task.set("sourcetype", (Object)this.sourceType);
        this.orgImport();
        this.workflow();
        this.image();
        String json = null;
        if (this.billData != null && this.isFromExternalSystem) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(this.billData.getDynamicObjectType());
            binder.setIgnoreCase(true);
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            jser.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            json = jser.serializeToString((Object)this.billData, null);
            this.task.set("bizdata_tag", (Object)json);
        }
        String uselang = null;
        try {
            uselang = this.billType.getString("uselang");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bed\u8a00\u73af\u5883\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)uselang)) {
            uselang = "zh_CN";
        }
        this.task.set("subject", (Object)this.getSubjectFromRule(this.billData, uselang));
        this.task.set("billnumber", (Object)this.getBillNumber(this.billData));
        this.task.set("islastaudit", (Object)this.islastaudit);
        this.task.set("info", (Object)"operation=11");
        try {
            this.saveCoefficient();
        }
        catch (Exception e) {
            log.error("\u9ed8\u8ba4\u4efb\u52a1\u91cf\u7cfb\u6570\u62a5\u9519", (Throwable)e);
        }
        boolean pass = this.beforeSaveTask(this.task);
        String opinion = "";
        try {
            HashMap opinionField = (HashMap)this.opinionField(this.billID, this.billType.getString("bindbill.number"), json);
            opinion = this.setOpinionDefaultValue(Long.valueOf(this.billType.getString("id")), this.taskType.getLong("id"), this.billType.getString("bindbill.number"), this.billID, opinionField, json);
            log.info("kd.ssc.task.create.AbstractCreateTask  opinion:" + opinion);
        }
        catch (Exception e) {
            log.warn("kd.ssc.task.create.AbstractCreateTask: \u9ed8\u8ba4\u5ba1\u6279\u610f\u89c1\u62a5\u9519\uff01", (Throwable)e);
        }
        this.task.set("apprevalmessage", (Object)(opinion.length() > 2000 ? opinion.substring(0, 2000) : opinion));
        this.setBillInfoEntry();
        log.info("\u5224\u65ad\u662f\u5426\u91cd\u590d\u521b\u5efa\u4efb\u52a1\uff0c\u5de5\u4f5c\u6d41id:" + this.assignID);
        boolean exist = this.isTaskExist();
        boolean valResult = this.validateWorkflow();
        long id = 0L;
        if (!exist && pass && valResult) {
            PluginProxy pluginProxy = PluginProxy.create(null, ITaskCreateService.class, (String)"kd.ssc.task.create.AbstractCreateTask.packTask");
            log.info("\u521b\u5efa\u4efb\u52a1\u4fdd\u5b58\u4e4b\u524d\u8c03\u7528\u63a5\u53e3ITaskCreateService\u6269\u5c55\u5b9e\u73b0\u7684beforeSaveTask()\u65b9\u6cd5\uff0c plugins.size = " + pluginProxy.getPlugins().size());
            pluginProxy.callReplace(p -> {
                p.beforeSaveTask(this.task, this.billType, this.taskType, this.assignID, this.billData);
                return null;
            });
            Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.task});
            if (ids != null && ids.length >= 1) {
                id = NumberUtils.toLong((String)((DynamicObject)ids[0]).getString("id"));
            }
            log.info("\u5171\u4eab\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff0c[\u4efb\u52a1id,\u5de5\u4f5c\u6d41id]\u4e3a:[" + id + "," + this.assignID + "]");
        }
        return id;
    }

    protected boolean isTaskExist() {
        QFilter[] qFilters = new QFilter[]{new QFilter("tasktypeid", "=", this.taskType.getPkValue()), new QFilter("billtype", "=", this.billType.getPkValue()), new QFilter("billid", "=", (Object)this.billID), new QFilter("extenderp", "=", this.extenderp.getPkValue())};
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_task", (String)"id, sscid.id, assignid", (QFilter[])qFilters);
        if (task != null) {
            long taskid = task.getLong("id");
            String assignid = task.getString("assignid");
            log.info("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5171\u4eab\u4efb\u52a1\uff0c[\u4efb\u52a1id,\u5de5\u4f5c\u6d41id]\u4e3a:[" + taskid + "," + assignid + "]");
            DeleteServiceHelper.delete((String)"task_task", (QFilter[])qFilters);
            log.info("\u76f8\u540c\u4efb\u52a1\u5df2\u5220\u9664\uff0c\u51c6\u5907\u521b\u5efa\u65b0\u4efb\u52a1");
            Long sscId = task.getLong("sscid.id");
            SscEventDistributor.taskSyncData("task_task", DataChangeTypeEnum.DELETE, sscId, taskid);
        }
        return false;
    }

    protected boolean validateWorkflow() {
        boolean isHR = SSCTypeEnum.HR.getValue().equals(DutyManageDataHelper.getSSCType((long)this.task.getLong("sscid.id")));
        if (this.extenderp != null && "KDCC".equals(this.extenderp.getString("number")) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.assignID) && !isHR) {
            QFilter idFil = new QFilter("id", "=", (Object)Long.valueOf(this.assignID));
            boolean valResult = QueryServiceHelper.exists((String)"wf_task", (QFilter[])new QFilter[]{idFil});
            if (!valResult) {
                log.warn("kd.ssc.task.create.AbstractCreateTask: validate workflow failed! billid = {}, wf_task[id = {}] not exist.", (Object)this.billID, (Object)this.assignID);
            }
            return valResult;
        }
        return true;
    }

    private boolean sscBillOrgPartition() {
        DynamicObjectCollection sscBillOrgParColl = this.billType.getDynamicObjectCollection("sscbillorgpar");
        DynamicObject org = this.getMainOrg(this.billType);
        long billOrgID = org.getLong("id");
        for (DynamicObject sscBillOrgPar : sscBillOrgParColl) {
            if (sscBillOrgPar.getLong("fbasedataid_id") != billOrgID) continue;
            return true;
        }
        log.info("\u4e0d\u6ee1\u8db3\u521b\u5efa\u4efb\u52a1\u6761\u4ef6\uff0c\u521b\u5efa\u4efb\u52a1\u5931\u8d25\uff01\u5355\u636e\u7f16\u53f7\uff1a" + this.getBillNumber(this.billData));
        return false;
    }

    private void saveCoefficient() {
        DynamicObjectCollection coefficientInfo = this.queryTaskCoefficients(this.billType.getPkValue(), this.taskType.getPkValue());
        BigDecimal coefficients = BigDecimal.ONE;
        if (coefficientInfo == null || coefficientInfo.size() == 0) {
            this.task.set("coefficient", (Object)coefficients);
            return;
        }
        String bindBillNumber = this.billType.getString("bindbill.number");
        BigDecimal coefficient = ((DynamicObject)coefficientInfo.get(0)).getBigDecimal("coefficientshead");
        if (!this.isFromExternalSystem) {
            coefficient = this.getNextCoefficient(bindBillNumber, this.billID, coefficient, coefficientInfo, this.billType.getPkValue());
        }
        this.task.set("coefficient", (Object)coefficient);
    }

    private BigDecimal getNextCoefficient(String bindBillNumber, String billID, BigDecimal coefficient, DynamicObjectCollection coefficientInfo, Object billtypeId) {
        DynamicObject bindBill = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"task_taskbill", (String)"id, bindbill.number,bindbill.name,entryentityfield.fieldconfiguration,entryentityfield.sourcefieldname,entryentityfield.sourcefieldnumber");
        DynamicObjectCollection entryentityfield = bindBill.getDynamicObjectCollection("entryentityfield");
        String sourcefieldnumber = null;
        if (entryentityfield != null) {
            for (DynamicObject entry : entryentityfield) {
                if (!"80".equals(entry.getString("fieldconfiguration"))) continue;
                sourcefieldnumber = entry.getString("sourcefieldnumber");
                break;
            }
        }
        if (sourcefieldnumber == null) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u4efb\u52a1\u91cf\u7cfb\u6570\u56e0\u5b50\uff1a" + billtypeId);
            return coefficient;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billID))};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)bindBillNumber, sourcefieldnumber, (QFilter[])filters);
        String radioId = dynamicObject.getString(sourcefieldnumber);
        log.info("radioId\uff1a" + radioId);
        for (DynamicObject subentry : coefficientInfo) {
            if (!radioId.equals(subentry.getString("ratioid"))) continue;
            return subentry.getBigDecimal("coefficientssub");
        }
        log.info("\u6ca1\u6709\u627e\u5230\uff1a" + radioId + "\u5bf9\u5e94\u7684\u914d\u7f6e\uff1a" + billtypeId);
        return coefficient;
    }

    public DynamicObjectCollection queryTaskCoefficients(Object billtypeId, Object tasktypeId) {
        QFilter h = new QFilter("basetype", "=", billtypeId);
        QFilter j = new QFilter("entryentity.tasktype", "=", tasktypeId);
        DynamicObjectCollection coefficients = QueryServiceHelper.query((String)"task_taskquantcoefficient", (String)"coefficientshead,entryentity.id,entryentity.subentryentity.taskratio as taskratio,entryentity.subentryentity.coefficientssub as coefficientssub,entryentity.subentryentity.ratioid as ratioid", (QFilter[])new QFilter[]{h, j});
        return coefficients;
    }

    protected boolean beforeSaveTask(DynamicObject task) {
        return true;
    }

    private void workflow() {
        this.task.set("assignid", (Object)this.assignID);
        this.task.set("procinstid", (Object)this.procinstID);
    }

    private void orgImport() {
        this.org = this.getMainOrg(this.billType);
        if (this.org == null) {
            return;
        }
        this.task.set("orgid", (Object)this.org);
        DynamicObject orgView = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"id,longnumber", (QFilter[])new QFilter[]{new QFilter("org.id", "=", this.org.getPkValue()), new QFilter("view.treetype", "=", (Object)"10")});
        String orgLongNumber = "08!011!014!015!016!01";
        if (orgView != null) {
            orgLongNumber = orgView.getString("longnumber");
        }
        this.task.set("orglongnumber", (Object)orgLongNumber);
    }

    protected DynamicObject getMainOrg(DynamicObject billType) {
        if (billType != null) {
            if (this.org == null) {
                DynamicObjectCollection fields = billType.getDynamicObjectCollection("entryentityfield");
                Object orgObj = null;
                for (DynamicObject field : fields) {
                    String fieldNumber;
                    String fieldName = (String)field.get("fieldconfiguration");
                    if (!TaskFieldConfigEnum.ORG.getFieldKey().equals(fieldName) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(fieldNumber = (String)field.get("sourcefieldnumber")))) continue;
                    orgObj = this.billData.get(fieldNumber);
                    break;
                }
                if (orgObj != null) {
                    DynamicObject orgRel;
                    if (orgObj instanceof DynamicObject) {
                        log.info("kd.ssc.task.create.AbstractCreateTask.getMainOrg(): org:" + orgObj);
                        return (DynamicObject)orgObj;
                    }
                    if (orgObj instanceof String && (orgRel = this.orm.queryOne("bos_org", new QFilter[]{new QFilter("name", "=", (Object)orgObj.toString())})) != null) {
                        log.info("kd.ssc.task.create.AbstractCreateTask.getMainOrg(): org:" + orgRel);
                        return orgRel;
                    }
                }
            } else {
                log.info("kd.ssc.task.create.AbstractCreateTask.getMainOrg(): org:" + this.org);
                return this.org;
            }
        }
        DynamicObject org = this.orm.newDynamicObject("bos_org");
        org.set("id", (Object)1L);
        return org;
    }

    private void image() {
        this.task.set("imageok", (Object)(this.imageok ? 1 : 0));
        if (this.imageok) {
            this.task.set("imageuploadtime", this.task.get("createtime"));
        }
    }

    protected void verify() {
    }

    protected DynamicObject getCreateRule(DynamicObject taskType, DynamicObject billType) {
        long taskTypeId = (Long)taskType.getPkValue();
        DynamicObjectCollection billEntry = billType.getDynamicObjectCollection("entryentity");
        long createRuleId = 0L;
        for (DynamicObject billEntryInfo : billEntry) {
            long etasktypeid = billEntryInfo.getLong("tasktype.id");
            if (taskTypeId != etasktypeid) continue;
            createRuleId = (Long)billEntryInfo.get("childpkid");
            break;
        }
        if (createRuleId > 0L) {
            ORM orm = ORM.create();
            return orm.getById("task_taskbill_child", (Object)createRuleId);
        }
        return null;
    }

    protected String getSubjectFromRule(DynamicObject billData, String uselang) {
        Object billTypeName;
        DynamicObject taskSubject;
        Object subjectId;
        StringBuilder subject = new StringBuilder();
        if (this.createRule != null && (subjectId = this.createRule.get("tasksubjectid")) != null && !"0".equals(subjectId) && (taskSubject = this.orm.queryOne("task_tasksubject", "id,entryentity.id,entryentity.pretext,entryentity.posttext,entryentity.billfield,entryentity.seq", new QFilter[]{new QFilter("id", "=", subjectId)})) != null) {
            DynamicObjectCollection entryentity = taskSubject.getDynamicObjectCollection("entryentity");
            entryentity.sort(Comparator.comparingInt(o -> o.getInt("seq")));
            for (DynamicObject entry : entryentity) {
                String postText;
                String element;
                String preText = entry.getString("pretext");
                if (preText != null) {
                    subject.append(preText);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(element = (String)entry.get("billfield")))) {
                    DynamicObject dyo = billData;
                    if (element.indexOf(46) != -1) {
                        String[] eles = element.split("\\.");
                        String[] elesT = new String[eles.length - 1];
                        element = eles[eles.length - 1];
                        System.arraycopy(eles, 0, elesT, 0, elesT.length);
                        for (String ele : elesT) {
                            Object o2 = dyo.get(ele);
                            if (o2 instanceof DynamicObjectCollection) {
                                if (((DynamicObjectCollection)o2).size() > 0) {
                                    dyo = (DynamicObject)((DynamicObjectCollection)o2).get(0);
                                    continue;
                                }
                                dyo = null;
                                break;
                            }
                            if (o2 instanceof DynamicObject) {
                                dyo = (DynamicObject)o2;
                                continue;
                            }
                            dyo = null;
                            break;
                        }
                    }
                    if (dyo != null) {
                        Object elementData;
                        BigDecimal elementValue;
                        Object elementObject = dyo.get(element);
                        if (elementObject instanceof BigDecimal) {
                            elementValue = (BigDecimal)dyo.get(element);
                            elementData = elementValue.setScale(2, 0);
                        } else if (elementObject instanceof OrmLocaleValue) {
                            elementValue = (OrmLocaleValue)elementObject;
                            elementData = elementValue.getItem(uselang);
                        } else {
                            elementData = dyo.get(element);
                        }
                        elementData = this.getPropertyValue(elementData, element, dyo);
                        if (elementData != null) {
                            subject.append(elementData);
                        }
                    }
                }
                if ((postText = entry.getString("posttext")) == null) continue;
                subject.append(postText);
            }
            if (subject.length() > 0) {
                return subject.length() > 255 ? subject.substring(0, 255) : subject.toString();
            }
        }
        if ((billTypeName = this.billType.get("name")) instanceof OrmLocaleValue) {
            OrmLocaleValue billName = (OrmLocaleValue)billTypeName;
            subject.append(billName.getItem(uselang));
        } else {
            subject.append(billTypeName);
        }
        Object taskTypeName = this.taskType.get("name");
        if (taskTypeName instanceof OrmLocaleValue) {
            OrmLocaleValue taskType = (OrmLocaleValue)taskTypeName;
            subject.append(taskType.getItem(uselang));
        } else {
            subject.append(taskTypeName);
        }
        subject.append(this.getBillNumber(this.billData));
        return subject.length() > 255 ? subject.substring(0, 255) : subject.toString();
    }

    protected String getBillNumber(DynamicObject billData) {
        String billNumber = " ";
        if (billData == null) {
            log.info("getBillNumber() end. billData is null");
            return billNumber;
        }
        DynamicObjectType type = billData.getDynamicObjectType();
        if (type instanceof BillEntityType) {
            String numberProp = ((BillEntityType)type).getBillNo();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)numberProp)) {
                billNumber = billData.getString(numberProp);
                return billNumber;
            }
            log.warn("\u5b9e\u4f53{}\u4e0d\u5b58\u5728\u7f16\u7801\u5c5e\u6027", (Object)type.getName());
        }
        try {
            billNumber = billData.getString("number");
        }
        catch (Exception e) {
            log.info("an exception occured while getBillNumber(\"number\").");
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billNumber)) {
            try {
                billNumber = billData.getString("billno");
            }
            catch (Exception e) {
                log.info("an exception occured while getBillNumber(\"billno\").");
            }
        }
        return billNumber;
    }

    private Map<String, Object> opinionField(String billId, String metadatatType, String bizdata) {
        log.info("opinionField\u65b9\u6cd5\u53c2\u6570\uff1abillId: " + billId + " ,metadatatType :" + metadatatType + ",bizdata :" + bizdata);
        HashMap<String, Object> costCompanyMap = new HashMap<String, Object>();
        if (bizdata != null) {
            TaskBillHandler handler = TaskBillHandlerFactory.getBillHandlerFactory("eas", metadatatType);
            log.info("TaskBillHandler\u7684\u53d6\u503c\uff1a" + handler.getClass().getName());
            costCompanyMap = handler.getOpinionField(metadatatType, bizdata);
        } else {
            DynamicObject bill = this.orm.getById(metadatatType, (Object)Long.valueOf(billId));
            if (bill != null) {
                DynamicObjectCollection billCollection = null;
                DynamicObject billObject = null;
                Long field = null;
                if ("er_dailyloanbill".equalsIgnoreCase(metadatatType) || "er_dailyreimbursebill".equalsIgnoreCase(metadatatType)) {
                    billCollection = bill.getDynamicObjectCollection("expenseentryentity");
                    billObject = (DynamicObject)billCollection.get(0);
                    field = billObject.getLong("expenseitem.id");
                } else {
                    billObject = bill.getDynamicObject("triptype");
                    field = billObject.getLong("id");
                }
                costCompanyMap.put("fieldKey", field);
            }
        }
        log.info("costCompanyMap:" + costCompanyMap);
        return costCompanyMap;
    }

    public String setOpinionDefaultValue(Long billTypeId, Long taskTypeId, String bindBillNo, String pkId, HashMap opinionField, String bizdata) {
        log.info("setOpinionDefaultValue\u65b9\u6cd5 \u53c2\u6570:billTypeId:" + billTypeId + ",taskTypeId:" + taskTypeId + ",bindBillNo:" + bindBillNo + " ,pkId:" + pkId + " ,opinionField:" + opinionField + ",bizdata:" + bizdata);
        DynamicObject cc = TaskRuleUtil.queryOpinion((Object)billTypeId, (Object)taskTypeId);
        if (cc == null || opinionField.isEmpty()) {
            return "";
        }
        DynamicObjectCollection dimensionentry = ((DynamicObject)cc.getDynamicObjectCollection("opiniontypeentry").get(0)).getDynamicObjectCollection("dimensionentry");
        String opinions = "";
        String universalopinion = cc.getString("universalopinion");
        log.info("universalopinion:" + universalopinion);
        log.info("dimensionentry:" + dimensionentry);
        Long field = (Long)opinionField.get("fieldKey");
        for (DynamicObject dimensionentryinfo : dimensionentry) {
            long expensetype = dimensionentryinfo.getLong("expensetype_Id");
            long expenseitem = dimensionentryinfo.getLong("expenseitem_Id");
            long triptype = dimensionentryinfo.getLong("triptype_Id");
            long expense = 0L;
            expense = triptype != 0L ? triptype : (expenseitem == 0L ? expensetype : expenseitem);
            if (!field.equals(expense)) continue;
            opinions = dimensionentryinfo.getString("opinion");
            break;
        }
        log.info("opinions:" + opinions);
        if ("".equals(opinions)) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)universalopinion)) {
                opinions = universalopinion;
            } else {
                return "";
            }
        }
        List<String> opinionsList = this.match(opinions);
        log.info("\u6b63\u5219\u8868\u8fbe\u5f0f\u4ee5\u540e\u7684opinions:" + opinionsList);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (opinionsList.size() > 0) {
            MainEntityType cache = EntityMetadataCache.getDataEntityType((String)bindBillNo);
            DataEntityPropertyCollection pro = cache.getProperties();
            for (IDataEntityProperty procol : pro) {
                DynamicProperty dp = (DynamicProperty)procol;
                LocaleString procolNameLc = dp.getDisplayName();
                String procolName = "";
                procolName = procolNameLc == null ? dp.getName() : procolNameLc.toString();
                if (procol instanceof EntryProp) {
                    EntryProp procols = (EntryProp)procol;
                    String entryPropkey = procols.getName();
                    LocaleString entryPropName = procols.getDisplayName();
                    EntryType entrytype = (EntryType)procols._collectionItemPropertyType;
                    DataEntityPropertyCollection entrypro = entrytype.getProperties();
                    for (IDataEntityProperty entryprocol : entrypro) {
                        DynamicProperty dps = (DynamicProperty)entryprocol;
                        LocaleString procolNameLcs = dps.getDisplayName();
                        String procolNames = "";
                        procolNames = procolNameLcs == null ? dps.getName() : procolNameLcs.toString();
                        String entryprocolNameU = entryPropName + "." + procolNames;
                        if (!opinionsList.contains(entryprocolNameU)) continue;
                        for (String opiniion : opinionsList) {
                            if (!opiniion.equals(entryprocolNameU)) continue;
                            String procolKey = entryPropkey + "." + entryprocol.getName();
                            returnMap.put(entryprocolNameU, procolKey);
                        }
                    }
                    continue;
                }
                if (!opinionsList.contains(procolName)) continue;
                for (String opiniion : opinionsList) {
                    if (!opiniion.equals(procolName)) continue;
                    String procolKey = procol.getName();
                    returnMap.put(procolName, procolKey);
                }
            }
        }
        log.info("returnMap:" + returnMap);
        StringBuilder strBuild = new StringBuilder();
        List<String> allSplitList = this.sub(opinions, opinionsList);
        for (int i = 0; i < allSplitList.size(); ++i) {
            String nameValue = allSplitList.get(i);
            if (returnMap.keySet().contains(nameValue)) {
                String nameKey = (String)returnMap.get(nameValue);
                Object nameValueOb = this.getBindBillValue(pkId, bindBillNo, nameKey, bizdata);
                if (nameValueOb == null) {
                    nameValue = " ";
                } else if (nameValueOb instanceof DynamicObject) {
                    DynamicObject nameValueDy = (DynamicObject)nameValueOb;
                    nameValue = nameValueDy.getString("name");
                    if ("pur_project".equals(nameValueDy.getDataEntityType().getName())) {
                        String proNumber = nameValueDy.getString("number");
                        nameValue = proNumber == null || "".equals(proNumber) ? " " : nameValueDy.getString("number");
                    }
                } else if (nameValueOb instanceof BigDecimal) {
                    BigDecimal temp = ((BigDecimal)nameValueOb).setScale(2, 4);
                    nameValue = String.valueOf(temp);
                } else {
                    nameValue = String.valueOf(nameValueOb);
                }
            }
            strBuild.append(nameValue);
        }
        String endStr = strBuild.toString();
        return endStr;
    }

    public List<String> match(String s) {
        String regex = "@([\u4e00-\u9fa5]+(\\.[\u4e00-\u9fa5]+)?)#";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(s);
        ArrayList<String> matchRegexList = new ArrayList<String>();
        while (m.find()) {
            matchRegexList.add(m.group().substring(1, m.group().length() - 1));
        }
        return matchRegexList;
    }

    public Object getBindBillValue(String pkId, String bindBillNo, String nameKey, String bizdata) {
        ORM orm = ORM.create();
        String erpNumber = this.billType.getDynamicObject("externalerp").getString("number");
        if ("eas".equalsIgnoreCase(erpNumber)) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)orm.getDataEntityType(bindBillNo));
            DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
            DynamicObject dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
            String[] nameKeyArray = nameKey.split("\\.");
            if (nameKeyArray.length == 2) {
                String entryKey = nameKeyArray[0];
                String nameKeyValue = nameKeyArray[1];
                DynamicObjectCollection dataCc = dataEntity.getDynamicObjectCollection(entryKey);
                DynamicObject dataDb = (DynamicObject)dataCc.get(0);
                Object field = dataDb.get(nameKeyValue);
                if (field instanceof Date) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    field = formatter.format(field);
                }
                return field;
            }
            Object field = dataEntity.get(nameKey);
            if (field instanceof Date) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                field = formatter.format(field);
            }
            return field;
        }
        QFilter f = new QFilter("id", "=", (Object)NumberUtils.toLong((String)pkId, (long)-1L));
        switch (nameKey) {
            case "expenseentryentity.expenseitem": 
            case "applier": {
                nameKey = nameKey + ".name";
                break;
            }
        }
        DynamicObject bindBill = BusinessDataServiceHelper.loadSingle((String)bindBillNo, (String)nameKey, (QFilter[])new QFilter[]{f});
        log.info(String.format("AbstractCreateTask ----  bindBillNo = %s, nameKey = %s, id = %s", bindBillNo, nameKey, pkId));
        if (bindBill != null) {
            return bindBill.get(nameKey);
        }
        return null;
    }

    private List<String> sub(String str, List<String> matchRegexList) {
        String regex = "@([\u4e00-\u9fa5]+(\\.[\u4e00-\u9fa5]+)?)#";
        Pattern pattern = Pattern.compile(regex);
        String[] result = pattern.split(str);
        ArrayList<String> allSplitList = new ArrayList<String>();
        int len = matchRegexList.size() > result.length ? matchRegexList.size() : result.length;
        for (int i = 0; i < len; ++i) {
            if (i < result.length) {
                allSplitList.add(result[i]);
            }
            if (i >= matchRegexList.size()) continue;
            allSplitList.add(matchRegexList.get(i));
        }
        return allSplitList;
    }

    public void setTestData(Map<String, Object> map) {
        Object billType = map.get("billType");
        if (billType != null) {
            this.billType = (DynamicObject)billType;
        }
    }

    public void setBillInfoEntry() {
        Object fieldNum;
        DynamicObjectCollection taskFieldEntrys = this.billType.getDynamicObjectCollection("entryentityfield");
        StringBuilder sqlStr = new StringBuilder();
        for (DynamicObject dynObj : taskFieldEntrys) {
            String fieldKey = dynObj.getString("fieldconfiguration");
            fieldNum = dynObj.getString("sourcefieldnumber");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldNum)) break;
            try {
                if (fieldKey.equals(TaskFieldConfigEnum.APPLYTIME.getFieldKey())) {
                    this.applytime = this.billData.getDate((String)fieldNum);
                    this.task.set("applytime", (Object)this.applytime);
                    continue;
                }
                if (!fieldKey.equals(TaskFieldConfigEnum.COSTDEPT.getFieldKey()) && !fieldKey.equals(TaskFieldConfigEnum.EXPENSEITEM.getFieldKey()) && !fieldKey.equals(TaskFieldConfigEnum.EXPENSEAMOUNT.getFieldKey()) && !fieldKey.equals(TaskFieldConfigEnum.SUPPLIER.getFieldKey()) || sqlStr.indexOf((String)fieldNum + ",") != -1) continue;
                sqlStr.append((String)fieldNum).append(',');
            }
            catch (Exception e) {
                StringBuilder errorStr = new StringBuilder();
                errorStr.append("setBillInfoEntry().e1: ").append(e).append(' ').append(e.getStackTrace()[0]).append(' ').append(e.getMessage()).append(' ').append(e.getCause()).append(' ').append(fieldKey).append(' ').append((String)fieldNum);
                log.error(errorStr.toString());
            }
        }
        if (sqlStr.length() == 0) {
            return;
        }
        String algoKey = this.getClass() + "setBillInfoEntry()";
        QFilter idFil = new QFilter("id", "=", (Object)Long.valueOf(this.billID));
        try {
            DataSet dSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)this.billType.getString("bindbill.number"), (String)sqlStr.substring(0, sqlStr.length() - 1), (QFilter[])new QFilter[]{idFil}, null);
            fieldNum = null;
            try {
                DynamicObjectCollection billInfoEntry = this.task.getDynamicObjectCollection("billinfoentry");
                Map<String, String> fieldType = new HashMap<String, String>(1);
                for (Row row : dSet) {
                    DynamicObject billInfo = billInfoEntry.addNew();
                    for (DynamicObject dynObj : taskFieldEntrys) {
                        Object val;
                        String fieldKey = dynObj.getString("fieldconfiguration");
                        String fieldNum2 = dynObj.getString("sourcefieldnumber");
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fieldNum2)) continue;
                        if (fieldKey.equals(TaskFieldConfigEnum.EXPENSEAMOUNT.getFieldKey())) {
                            val = row.get(fieldNum2);
                            if (!(val instanceof BigDecimal)) continue;
                            billInfo.set("expenseamount", val);
                            continue;
                        }
                        if (fieldKey.equals(TaskFieldConfigEnum.COSTDEPT.getFieldKey())) {
                            val = row.get(fieldNum2);
                            if (!(val instanceof Long)) continue;
                            DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                            org.set("id", val);
                            billInfo.set("costdept", (Object)org);
                            continue;
                        }
                        if (fieldKey.equals(TaskFieldConfigEnum.EXPENSEITEM.getFieldKey())) {
                            val = row.get(fieldNum2);
                            if (val instanceof Long) {
                                DynamicObject expenseItem = BusinessDataServiceHelper.loadSingleFromCache((Object)val, (String)"er_expenseitemedit");
                                if (expenseItem == null) continue;
                                billInfo.set("expenseitem", expenseItem.get("name"));
                                continue;
                            }
                            if (!(val instanceof String)) continue;
                            billInfo.set("expenseitem", val);
                            continue;
                        }
                        if (!fieldKey.equals(TaskFieldConfigEnum.SUPPLIER.getFieldKey())) continue;
                        val = row.get(fieldNum2);
                        if (val instanceof Long && (Long)val != 0L) {
                            DynamicObject supplier;
                            if (fieldType.get(fieldNum2) == null) {
                                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.billType.getString("bindbill.number"));
                                DataEntityPropertyCollection properties = entityType.getProperties();
                                String[] simpleFieldNums = fieldNum2.split("\\.");
                                fieldType = this.getFieldType(properties, simpleFieldNums, 0, fieldType);
                            }
                            if ("null".equals(fieldType.get(fieldNum2)) || (supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)val, (String)((String)fieldType.get(fieldNum2)), (String)"name")) == null) continue;
                            billInfo.set("supplier", supplier.get("name"));
                            continue;
                        }
                        if (!(val instanceof String)) continue;
                        billInfo.set("supplier", val);
                    }
                }
            }
            catch (Throwable throwable) {
                fieldNum = throwable;
                throw throwable;
            }
            finally {
                if (dSet != null) {
                    if (fieldNum != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)fieldNum).addSuppressed(throwable);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
        }
        catch (Exception e) {
            StringBuilder errorStr = new StringBuilder();
            errorStr.append("setBillInfoEntry().e2: ").append(e).append(' ').append(e.getStackTrace()[0]).append(' ').append(e.getMessage()).append(' ').append(e.getCause());
            log.error(errorStr.toString());
        }
    }

    private Map<String, String> getFieldType(DataEntityPropertyCollection properties, String[] simpleFieldNums, int index, Map<String, String> fieldType) {
        int length = simpleFieldNums.length;
        if (index < 0 || index > length || length == 0) {
            return fieldType;
        }
        String simpleFieldNum = simpleFieldNums[index];
        if (index < length - 1) {
            for (IDataEntityProperty property : properties) {
                if (!simpleFieldNum.equals(property.getName())) continue;
                DataEntityPropertyCollection properties_ = null;
                if (property instanceof EntryProp) {
                    DynamicObjectType propertyType = ((EntryProp)property)._collectionItemPropertyType;
                    properties_ = propertyType.getProperties();
                } else if (property instanceof DynamicComplexProperty) {
                    DynamicComplexProperty complexProp = (DynamicComplexProperty)property;
                    IDataEntityType dEntityType = complexProp.getComplexType();
                    MainEntityType mEntityType = EntityMetadataCache.getDataEntityType((String)dEntityType.getName());
                    properties_ = mEntityType.getProperties();
                }
                return this.getFieldType(properties_, simpleFieldNums, ++index, fieldType);
            }
        } else {
            for (IDataEntityProperty property : properties) {
                if (!simpleFieldNum.equals(property.getName()) || !(property instanceof BasedataProp)) continue;
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                fieldType.put(String.join((CharSequence)".", simpleFieldNums), baseEntityId);
                return fieldType;
            }
        }
        log.error("simpleFieldNums: " + Arrays.toString(simpleFieldNums) + ", index = " + index);
        fieldType.put(String.join((CharSequence)".", simpleFieldNums), "null");
        return fieldType;
    }

    protected void doSetApplier() {
        this.setApplier();
        if (this.applier == null) {
            this.setOldApplier();
        }
    }

    private void setApplier() {
        if (this.billType != null) {
            try {
                DynamicObjectCollection field = this.billType.getDynamicObjectCollection("entryentityfield");
                String applierName = null;
                for (DynamicObject dyn : field) {
                    if (!dyn.getString("fieldconfiguration").equals(TaskFieldConfigEnum.APPLIER.getFieldKey())) continue;
                    applierName = dyn.getString("sourcefieldnumber");
                    break;
                }
                if (StringUtils.isEmpty(applierName)) {
                    return;
                }
                DynamicObject applierDyn = this.billData.getDynamicObject(applierName);
                if (applierDyn != null && "bos_user".equals(applierDyn.getDataEntityType().getName())) {
                    this.applier = this.billData.getDynamicObject(applierName);
                }
            }
            catch (Exception e) {
                log.error(this.getClass() + "setApplier()_1: " + e.getMessage(), (Throwable)e);
            }
        } else {
            log.error(this.getClass() + "setApplier()_2, billType = null");
        }
    }

    private void setOldApplier() {
        boolean hasApplier = true;
        if (this.billData == null || !this.billData.getDataEntityType().getProperties().containsKey((Object)"creator")) {
            hasApplier = false;
        } else {
            DynamicObject creator = this.billData.getDynamicObject("creator");
            if (creator == null || creator.getLong("id") == 0L) {
                hasApplier = false;
            }
        }
        if (hasApplier) {
            this.applier = (DynamicObject)this.billData.get("creator");
        } else {
            RequestContext requestContext = RequestContext.get();
            long userid = requestContext.getCurrUserId();
            this.applier = this.orm.newDynamicObject("bos_user");
            this.applier.set("id", (Object)userid);
        }
    }

    protected void afterCreateTask() {
        PluginProxy pluginProxy = PluginProxy.create(null, ITaskCreateService.class, (String)"kd.ssc.task.create.AbstractCreateTask.packTask");
        log.info("\u521b\u5efa\u4efb\u52a1\u6210\u529f\u540e\u8c03\u7528\u63a5\u53e3ITaskCreateService\u6269\u5c55\u5b9e\u73b0\u7684afterCreateTask()\u65b9\u6cd5\uff0c plugins.size = " + pluginProxy.getPlugins().size());
        pluginProxy.callReplace(p -> {
            p.afterCreateTask(this.task, this.billType, this.taskType, this.assignID, this.billData);
            return null;
        });
        Long taskId = this.task.getLong("id");
        Long sscId = this.task.getLong("sscid.id");
        SscEventDistributor.taskSyncData("task_task", DataChangeTypeEnum.INSERT, sscId, taskId);
        SscEventDistributor.preDistribute(sscId, Collections.singletonList(taskId));
        IntelligentExecutor executor = new IntelligentExecutor(this.task.getLong("id"), this.taskType.getLong("id"), this.billType.getLong("id"), this.billID);
        executor.execute();
        this.callAttachmentReview();
    }

    private void callAttachmentReview() {
        try {
            if (this.billType.getBoolean("preprocess")) {
                List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)this.billType.getLong("id"), (Long)this.taskType.getLong("id"));
                DynamicObject bindbill = (DynamicObject)this.billType.get("bindbill");
                String entityNumber = (String)bindbill.get("number");
                Object[] param = new Object[]{entityNumber, NumberUtils.toLong((String)this.billID, (long)0L), Boolean.FALSE, idiSchemaList};
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"BillAuditService", (String)"gptAudit", (Object[])param);
            }
        }
        catch (Throwable e) {
            log.error(String.format("\u5355\u636e_%s\u53d1\u8d77\u9644\u4ef6\u5ba1\u6838\u5931\u8d25", this.billID), e);
        }
    }

    private Object getPropertyValue(Object value, String propertyName, DynamicObject dyo) {
        EntityType entityType;
        DynamicProperty prop;
        IDataEntityType dataEntityType = dyo.getDataEntityType();
        if (value != null && dataEntityType instanceof EntityType && (prop = (entityType = (EntityType)dataEntityType).getProperty(propertyName)) != null) {
            if (prop instanceof MulComboProp) {
                MulComboProp comboProp = (MulComboProp)prop;
                value = this.getMulComboProp(value, comboProp);
            } else if (prop instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)prop;
                value = this.getComboProp(value, comboProp);
            } else if (prop instanceof DateProp) {
                value = new SimpleDateFormat("yyyy-MM-dd").format(value);
            } else if (prop instanceof DateTimeProp) {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
            } else if (prop instanceof TimeProp) {
                Calendar c = Calendar.getInstance();
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, Integer.parseInt(String.valueOf(value)));
                value = new SimpleDateFormat("HH:mm:ss").format(c.getTime());
            }
        }
        return value;
    }

    private Object getMulComboProp(Object value, MulComboProp comboProp) {
        String str = (String)value;
        ArrayList<String> strList = new ArrayList<String>();
        for (ValueMapItem comboItem : comboProp.getComboItems()) {
            if (!str.contains(comboItem.getValue())) continue;
            strList.add(comboItem.getName().getLocaleValue());
        }
        if (CollectionUtils.isNotEmpty(strList)) {
            value = Joiner.on((String)",").join(strList);
        }
        return value;
    }

    private Object getComboProp(Object value, ComboProp comboProp) {
        for (ValueMapItem comboItem : comboProp.getComboItems()) {
            if (!comboItem.getValue().equals(value)) continue;
            value = comboItem.getName().getLocaleValue();
        }
        return value;
    }
}

