/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.enums.Source;
import kd.ssc.eventSend.core.SscEventDistributor;
import kd.ssc.eventSend.entity.DataChangeTypeEnum;
import kd.ssc.task.create.AbstractCreateTask;
import kd.ssc.task.create.CreateTaskByWorkflow;
import kd.ssc.task.face.ICreateTask4Rule;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.enums.InstNodeEnum;
import kd.ssc.task.partask.factory.PublisherFactory;
import kd.ssc.task.partask.service.impl.ParTaskFlowInstServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskFlowServiceImpl;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;

public class CreateParTaskByWorkFlow
extends AbstractCreateTask
implements ICreateTask4Rule {
    private static final Log log = LogFactory.getLog(CreateParTaskByWorkFlow.class);
    private long taskTypeID;
    private long billTypeID;

    @Override
    protected DynamicObject getBillType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.billTypeID, (String)"task_taskbill");
    }

    @Override
    protected DynamicObject getTaskType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.taskTypeID, (String)"task_tasktype");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkDeprecated
    public boolean publishInialMessage(String billId, Long billTypeId, Long[] taskTypeIds, long workFlowId) {
        if (!QueryServiceHelper.exists((String)"task_taskbill", (Object)billTypeId)) {
            log.error("\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1, entityName:task_taskbill, billTypeId:" + billTypeId);
            return false;
        }
        this.billTypeID = billTypeId;
        ParTaskFlowServiceImpl defService = new ParTaskFlowServiceImpl();
        DynamicObject taskBillDo = BusinessDataServiceHelper.loadSingle((Object)billTypeId, (String)"task_taskbill", (String)"id,ssccenter.id");
        long sscId = taskBillDo.getLong("ssccenter.id");
        Long defId = defService.findParTaskFlowDef(Long.valueOf(sscId), Long.valueOf(this.billTypeID));
        if (defId == -1L) {
            log.error("\u5e76\u884c\u4efb\u52a1\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1, flowDefId:" + defId + ", sscId:" + sscId + ", billTypeID:" + this.billTypeID);
            return false;
        }
        ParTaskFlowInstServiceImpl instService = new ParTaskFlowInstServiceImpl();
        long instId = instService.CreateParTaskIns(sscId, this.billTypeID, billId, defId, workFlowId);
        List startNodeId = null;
        try {
            startNodeId = defService.getStartNode(defId);
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728, flowDefId:" + defId + ", sscId:" + sscId + ", billTypeID:" + this.billTypeID, (Throwable)e);
            return false;
        }
        if (!this.isMatchedTaskType(taskTypeIds, startNodeId)) {
            log.error("\u4efb\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1, taskTypeIds:" + Arrays.asList(taskTypeIds) + ", startNodeId:" + startNodeId);
            return false;
        }
        ParTaskNodeServiceImpl nodeService = new ParTaskNodeServiceImpl();
        ArrayList<ParTaskMessage> msgList = new ArrayList<ParTaskMessage>(10);
        for (Object nodeDefId : startNodeId) {
            long nodeTaskType = nodeService.getTaskTypeIdFromNodeDefId((String)nodeDefId);
            ParTaskMessage msg = new ParTaskMessage(sscId, this.billTypeID, billId, defId.longValue(), instId, nodeTaskType, (String)nodeDefId, workFlowId);
            msgList.add(msg);
        }
        try (MessagePublisher parTaskPub = PublisherFactory.getParTaskPub();){
            for (ParTaskMessage msg : msgList) {
                parTaskPub.publish((Object)msg);
            }
        }
        return true;
    }

    public long createTask(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID, String assignID) {
        this.assignID = assignID;
        return this.createTask(taskTypeID, billTypeID, billID, sscID, executeOprtNumber, reverseOprtNumber, taskSubjectID);
    }

    public long createTask(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        this.taskTypeID = taskTypeID;
        this.billTypeID = billTypeID;
        this.billID = billID;
        this.executeOprt = executeOprtNumber;
        this.reverseOprt = reverseOprtNumber;
        this.isFromExternalSystem = false;
        return super.createTask();
    }

    @Override
    protected void afterPrepareTaskData() {
        this.source = Source.ParTask.getValue();
        this.extenderp = CreateTaskByWorkflow.setExtendErp(this.billTypeID);
        this.billData = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(this.billID), (String)this.billType.getString("bindbill.number"));
        super.doSetApplier();
    }

    @Override
    protected boolean isTaskExist() {
        QFilter[] qFilters = new QFilter[]{new QFilter("billtype", "=", this.billType.getPkValue()), new QFilter("billid", "=", (Object)Long.valueOf(this.billID)), new QFilter("ptstatus", "=", (Object)FlowInstEnum.PROCESSING.getValue()), new QFilter("workflowid", "not in", (Object)new Long[]{Long.valueOf(this.assignID), 0L})};
        DynamicObject[] insts = BusinessDataServiceHelper.load((String)"task_partaskinst", (String)"id, ptstatus", (QFilter[])qFilters);
        if (insts == null || insts.length == 0) {
            return false;
        }
        HashSet<Long> instIdSet = new HashSet<Long>(insts.length);
        for (DynamicObject dynamicObject : insts) {
            instIdSet.add((Long)dynamicObject.getPkValue());
            dynamicObject.set("ptstatus", (Object)FlowInstEnum.FAILED.getValue());
        }
        QFilter[] nodeFilter = new QFilter[]{new QFilter("instantid", "in", instIdSet)};
        DynamicObject[] nodes = BusinessDataServiceHelper.load((String)"task_partaskinstnode", (String)"taskid,state", (QFilter[])nodeFilter);
        if (nodes == null || nodes.length == 0) {
            SaveServiceHelper.save((DynamicObject[])insts);
            return false;
        }
        HashSet<Long> taskIdSet = new HashSet<Long>(nodes.length);
        for (DynamicObject node : nodes) {
            taskIdSet.add((Long)node.get("taskid"));
            if (node.getInt("state") != InstNodeEnum.PROCESSING.getValue()) continue;
            node.set("state", (Object)InstNodeEnum.FAILED.getValue());
        }
        QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", taskIdSet)};
        try (TXHandle h = TX.required((String)(this.getClass().getName() + "isTaskExistSave"));){
            try {
                SaveServiceHelper.save((DynamicObject[])insts);
                SaveServiceHelper.save((DynamicObject[])nodes);
                DeleteServiceHelper.delete((String)"task_task", (QFilter[])qFilterArray);
            }
            catch (Exception e) {
                h.markRollback();
                log.error("CreateParTaskByWorkFlow.isTaskExistSave1:\u540c\u6b65\u5b9e\u4f8b\u72b6\u6001\u5931\u8d25", (Throwable)e);
                boolean bl = true;
                if (h != null) {
                    if (var9_15 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return bl;
            }
        }
        if (CollectionUtils.isNotEmpty(taskIdSet)) {
            Long sscId = this.task.getLong("sscid.id");
            ArrayList<Long> taskIdList = new ArrayList<Long>(taskIdSet);
            SscEventDistributor.taskSyncData("task_task", DataChangeTypeEnum.DELETE, sscId, taskIdList);
        }
        return false;
    }

    private boolean isMatchedTaskType(Long[] taskTypeids, List<String> startNodeDefIds) {
        ParTaskNodeServiceImpl nodeService = new ParTaskNodeServiceImpl();
        ArrayList<Long> startNodeTaskTypeId = new ArrayList<Long>(10);
        for (String nodeDefId : startNodeDefIds) {
            startNodeTaskTypeId.add(nodeService.getTaskTypeIdFromNodeDefId(nodeDefId));
        }
        return Arrays.asList(taskTypeids).containsAll(startNodeTaskTypeId);
    }

    @Override
    protected void afterCreateTask() {
        CreateTaskByWorkflow.updateTaskMsgWorkflow(this.task.getLong("id"));
        super.afterCreateTask();
    }
}

