/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.RespCodeEnum;
import kd.ssc.enums.Source;
import kd.ssc.exception.ExceptionUtil;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.ExceptionTypeEnum;
import kd.ssc.exception.enums.InterfaceTypeEnum;
import kd.ssc.exception.enums.NotCompensateEnum;
import kd.ssc.exception.enums.SourceSystemEnum;
import kd.ssc.exception.util.ExceptionHelperUtil;
import kd.ssc.exception.util.QueryParamUtil;
import kd.ssc.monitor.pojo.MonitorRecord;
import kd.ssc.monitor.pojo.SSCTraceInfo;
import kd.ssc.monitor.pojo.SSCTraceInfos;
import kd.ssc.monitor.pojo.ScenarioLocator;
import kd.ssc.task.create.AbstractCreateTask;
import kd.ssc.task.dto.TaskLogRecordDTO;
import kd.ssc.task.face.ICreateTask4Rule;
import kd.ssc.task.ierp.TaskLogFacadeImpl;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class CreateTaskByWorkflow
extends AbstractCreateTask
implements ICreateTask4Rule {
    private static final Log log = LogFactory.getLog(CreateTaskByWorkflow.class);
    private long taskTypeID;
    private long billTypeID;

    public long createTask(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        this.taskTypeID = taskTypeID;
        this.billTypeID = billTypeID;
        this.billID = billID;
        this.executeOprt = executeOprtNumber;
        this.reverseOprt = reverseOprtNumber;
        this.isFromExternalSystem = false;
        boolean result = this.taskCreateMethodValidate(billTypeID, taskTypeID);
        if (result) {
            return super.createTask();
        }
        ErrorCode code = new ErrorCode("fi.ssc.taskCreateMethod", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4efb\u52a1\u521b\u5efa\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef\u3002", (String)"CreateTaskByWorkflow_5", (String)"ssc-task-common", (Object[])new Object[0]));
        throw new KDException(code, new Object[]{ResManager.loadKDString((String)"\u4e0b\u4e00\u4ee3\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1listener\u62a5\u9519\u3002", (String)"CreateTaskByWorkflow_3", (String)"ssc-task-common", (Object[])new Object[0])});
    }

    public long createTaskForTest(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        this.taskTypeID = taskTypeID;
        this.billTypeID = billTypeID;
        this.billID = billID;
        this.executeOprt = executeOprtNumber;
        this.reverseOprt = reverseOprtNumber;
        this.isFromExternalSystem = false;
        super.prepareTaskData();
        super.packTask();
        return 0L;
    }

    public long createTask(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID, String assignID) {
        long taskID;
        this.assignID = assignID;
        try {
            taskID = this.createTask(taskTypeID, billTypeID, billID, sscID, executeOprtNumber, reverseOprtNumber, taskSubjectID);
        }
        catch (Exception e) {
            Map<String, Object> param = this.buildRequestParam(taskTypeID, billTypeID, billID, sscID, executeOprtNumber, reverseOprtNumber, taskSubjectID);
            TaskLogRecordDTO tlr = TaskLogRecordDTO.builder().appId("ssc-task").errorMsg(e instanceof KDException ? ((KDException)e).getErrorCode().getCode() : e.getMessage()).errorStack(ExceptionUtil.getStackTrace(e, 1000)).respCode(Integer.valueOf(RespCodeEnum.create_task_error.getValue())).voucher(billTypeID + "").voucherId(billID).method("kd.ssc.task.create.CreateTaskByWorkflow.createTask").param(param).retry(Boolean.FALSE).type("CreateTaskByWorkflow").build();
            TaskLogFacadeImpl taskLogFacade = new TaskLogFacadeImpl();
            taskLogFacade.saveTaskLogRecord(tlr);
            log.error("kd.ssc.task.create.CreateTaskByWorkflow.createTask# Create Task By Workflow error, billID: " + billID, (Throwable)e);
            this.saveExceptionRecord(taskTypeID, billTypeID, billID, assignID, e);
            String monitorRetry = this.buildMonitorRetry("kd.ssc.task.create.CreateTaskByWorkflow", "createTask", taskTypeID, billTypeID, billID, sscID, executeOprtNumber, reverseOprtNumber, taskSubjectID);
            this.saveMonitorException(taskTypeID, billTypeID, billID, monitorRetry, e);
            throw e;
        }
        return taskID;
    }

    public static long updateTaskMsgWorkflow(long taskID) {
        if (taskID == 0L) {
            log.info("\u4efb\u52a1\u6ca1\u6709\u63d2\u5165\u6570\u636e\u5e93\u6216\u5339\u914d\u7ec4\u7ec7\u6ca1\u6709\u6210\u529f");
            return taskID;
        }
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskID, (String)"task_task", (String)"id, pooltype, assignid, state, source, billtype, tasktypeid, subject, personid, sscid");
        TaskWorkFlowUtil.updateMsgCreateTask(new DynamicObject[]{task}, ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"CreateTaskByWorkflow_1", (String)"ssc-task-common", (Object[])new Object[0]));
        return taskID;
    }

    private String getBillTypeName(Long billTypeId) {
        String billTypeNo = null;
        if (QueryServiceHelper.exists((String)"task_taskbill", (Object)billTypeId)) {
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)billTypeId, (String)"task_taskbill");
            billTypeNo = dyo.getString("bindbill.number");
        }
        return billTypeNo;
    }

    private void saveExceptionRecord(long taskTypeId, long billTypeId, String billId, String assignId, Throwable e) {
        String failureReason;
        log.warn("\u5355\u636e\u8865\u507f\u53c2\u6570[taskTypeId,billId]:[" + taskTypeId + "," + billId + "]");
        String isCompensate = NotCompensateEnum.Y_COMPENSATE.getValue();
        String errorCode = ExceptionTypeEnum.EXCEPTION_TYPE_TASK_WF.getCode();
        if (e instanceof KDException) {
            String code = ((KDException)e).getErrorCode().getCode();
            if ("fi.ssc.taskCreateMethod".equals(code)) {
                isCompensate = NotCompensateEnum.N_COMPENSATE.getValue();
                errorCode = ExceptionTypeEnum.EXCEPTION_TYPE_TASK_CREATEMETHOD.getCode();
            }
            failureReason = ((KDException)e).getStackTraceMessage();
        } else {
            failureReason = Arrays.toString(e.getStackTrace());
        }
        String failureMsg = e.getMessage();
        String queryParam = QueryParamUtil.getWfTaskQryParam((String)billId, (String)String.valueOf(billTypeId), (String)String.valueOf(taskTypeId), (String)assignId);
        log.info("\u521b\u5efa\u4efb\u52a1\u8bf7\u6c42\u53c2\u6570queryParam:" + queryParam);
        InterfaceTypeEnum interfaceTypeEnum = InterfaceTypeEnum.SSCTask;
        SourceSystemEnum sourceSystemEnum = SourceSystemEnum.NextGeneration;
        String billTypeNo = this.getBillTypeName(billTypeId);
        ExceptionDTO dto = ExceptionDTO.builder().billId(billId).billType(billTypeNo).exceptionCode(errorCode).requestParam(queryParam).failureMsg(failureMsg).failureReason(failureReason).failureTime(new Date()).interfaceType(interfaceTypeEnum.getValue()).sourceSystem(sourceSystemEnum.getValue()).isCompensate(isCompensate).build();
        ExceptionHelperUtil.updateTableAfterException((ExceptionDTO)dto);
    }

    private Map<String, Object> buildRequestParam(long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("taskTypeID", taskTypeID);
        param.put("billTypeID", billTypeID);
        param.put("billID", billID);
        param.put("sscID", sscID);
        param.put("executeOprtNumber", executeOprtNumber);
        param.put("reverseOprtNumber", reverseOprtNumber);
        param.put("taskSubjectID", taskSubjectID);
        param.put("assignID", this.assignID);
        return param;
    }

    @Override
    protected void afterPrepareTaskData() {
        this.source = Source.WorkFlow.getValue();
        this.extenderp = CreateTaskByWorkflow.setExtendErp(this.billTypeID);
        this.billData = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(this.billID), (String)this.billType.getString("bindbill.number"));
        super.doSetApplier();
    }

    public static DynamicObject setExtendErp(long billTypeId) {
        DynamicObject extenderpTemp = null;
        DynamicObject taskBill = BusinessDataServiceHelper.loadSingle((Object)billTypeId, (String)"task_taskbill");
        if (taskBill != null) {
            extenderpTemp = taskBill.getDynamicObject("externalerp");
        }
        if (extenderpTemp == null) {
            extenderpTemp = BusinessDataServiceHelper.loadSingle((String)"bas_extenderp", (String)"id,number,name,producer,fversion,impleclass,fdescription,cfgfolder", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"KDCC")});
        }
        if (extenderpTemp == null) {
            ErrorCode errorCode = new ErrorCode("fi.ssc.externalErpEmpty", ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u4e3a\u7a7a", (String)"CreateTaskByWorkflow_2", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{ResManager.loadKDString((String)"\u4e0b\u4e00\u4ee3\u5de5\u4f5c\u6d41\u521b\u5efa\u4efb\u52a1listener\u62a5\u9519\u3002", (String)"CreateTaskByWorkflow_3", (String)"ssc-task-common", (Object[])new Object[0])});
        }
        return extenderpTemp;
    }

    @Override
    protected DynamicObject getBillType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.billTypeID, (String)"task_taskbill");
    }

    @Override
    protected DynamicObject getTaskType() {
        return BusinessDataServiceHelper.loadSingle((Object)this.taskTypeID, (String)"task_tasktype");
    }

    private boolean taskCreateMethodValidate(long billTypeId, long taskTypeId) {
        QFilter idFil = new QFilter("id", "=", (Object)billTypeId);
        QFilter taskTypeFil = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        DynamicObject taskBill = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"entryentity.childpkid childpkid", (QFilter[])new QFilter[]{idFil, taskTypeFil});
        if (taskBill == null) {
            String info = String.format("taskCreateMethodValidate().taskBill == null: billTypeId = %s, taskTypeId = %s", billTypeId, taskTypeId);
            log.error(info);
            return false;
        }
        QFilter idFil_2 = new QFilter("id", "=", (Object)taskBill.getLong("childpkid"));
        QFilter originalFil = new QFilter("taskoriginal", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"task_taskbill_child", (QFilter[])new QFilter[]{idFil_2, originalFil});
    }

    private void saveMonitorException(long taskTypeId, long billTypeId, String billId, String monitorRetry, Exception e) {
        Date monitorTime = new Date();
        String billNumber = "no-number";
        try {
            billNumber = this.getBillNumber(this.billData);
        }
        catch (Exception numberExc) {
            log.error("kd.ssc.task.create.AbstractCreateTask.getBillNumber \u4fdd\u5b58\u76d1\u63a7\u5f02\u5e38\u65f6\u83b7\u53d6\u5355\u636e\u7f16\u7801\u5931\u8d25\u3002", (Throwable)numberExc);
        }
        Long scenarioId = ScenarioLocator.findScenario((StackTraceElement[])e.getStackTrace());
        if (scenarioId == null || scenarioId == 0L) {
            log.error("\u627e\u5bfb\u9884\u7f6e\u5f02\u5e38\u573a\u666f\u5931\u8d25,scenarioId\uff1a", (Object)scenarioId);
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)scenarioId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject scenarioDefDo = BusinessDataServiceHelper.loadSingle((String)"ssc_scenario_def", (QFilter[])new QFilter[]{idFilter, enableFilter});
        if (scenarioDefDo == null) {
            return;
        }
        SSCTraceInfo.Builder sscTraceInfoBuilder = SSCTraceInfo.builder().billId(Long.parseLong(billId)).billType(billTypeId).scenario(scenarioId.longValue()).taskTypeId(taskTypeId).latestTime(monitorTime).billNo(billNumber).retry(monitorRetry);
        long sscId = this.billType != null ? this.billType.getLong("ssccenter.id") : 0L;
        sscTraceInfoBuilder.ssc(sscId);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        if (stackTrace.length() > 5000) {
            stackTrace = stackTrace.substring(0, 5000);
        }
        MonitorRecord m = MonitorRecord.builder().monitorTime(monitorTime).executeMethod("2").traceId(RequestContext.get().getTraceId()).ip(RequestContext.get().getLoginIP()).log(stackTrace).executor(Long.valueOf(RequestContext.get().getCurrUserId())).build();
        sscTraceInfoBuilder.monitorRecordList(Collections.singletonList(m));
        new SSCTraceInfos().saveTranceInfo(sscTraceInfoBuilder.build());
    }

    private String buildMonitorRetry(String className, String method, long taskTypeID, long billTypeID, String billID, long sscID, String executeOprtNumber, String reverseOprtNumber, long taskSubjectID) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("className", className);
        param.put("method", method);
        param.put("taskTypeID", taskTypeID);
        param.put("billTypeID", billTypeID);
        param.put("billID", billID);
        param.put("sscID", sscID);
        param.put("executeOprtNumber", executeOprtNumber);
        param.put("reverseOprtNumber", reverseOprtNumber);
        param.put("taskSubjectID", taskSubjectID);
        param.put("assignID", this.assignID);
        return SerializationUtils.toJsonString(param);
    }

    @Override
    protected void afterCreateTask() {
        CreateTaskByWorkflow.updateTaskMsgWorkflow(this.task.getLong("id"));
        super.afterCreateTask();
    }
}

