/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.delete.util;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkDeprecated;
import kd.ssc.monitor.util.ExceptionSaveUtil;
import kd.ssc.task.delete.service.impl.DeleteTaskServiceImpl;

public class DeleteTaskUtil {
    private static final Log log = LogFactory.getLog(DeleteTaskUtil.class);

    public static Long[] deleteTaskAfterProcessAbandon(Long[] taskIds) {
        String newStatus = ResManager.loadKDString((String)"\u6d41\u7a0b\u5e9f\u5f03", (String)"DeleteTaskUtil_0", (String)"ssc-task-common", (Object[])new Object[0]);
        String newComment = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u672a\u5b8c\u6210\u5904\u7406\uff0c\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u5220\u9664\u3002", (String)"DeleteTaskUtil_1", (String)"ssc-task-common", (Object[])new Object[0]);
        return DeleteTaskUtil.deleteTasksForMutiParam(taskIds, newStatus, newComment, -2L, true, 0);
    }

    public static Long[] deleteTasks(Long[] taskIds, long userId) {
        String newStatus = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664", (String)"DeleteTaskUtil_2", (String)"ssc-task-common", (Object[])new Object[0]);
        String newComment = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4eba\u5de5\u5220\u9664\u3002", (String)"DeleteTaskUtil_3", (String)"ssc-task-common", (Object[])new Object[0]);
        return DeleteTaskUtil.deleteTasksForMutiParam(taskIds, newStatus, newComment, userId, false, 1);
    }

    public static boolean deleteSingleTask(long taskId, long userId) throws Exception {
        String newStatus = ResManager.loadKDString((String)"\u4efb\u52a1\u5220\u9664", (String)"DeleteTaskUtil_2", (String)"ssc-task-common", (Object[])new Object[0]);
        String newComment = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u4eba\u5de5\u5220\u9664\u3002", (String)"DeleteTaskUtil_3", (String)"ssc-task-common", (Object[])new Object[0]);
        boolean deleteSuccess = false;
        try {
            deleteSuccess = new DeleteTaskServiceImpl().deleteSingleTask(taskId, newStatus, newComment, userId, 1);
        }
        catch (Exception e) {
            KDException kde;
            if (e instanceof KDException && "delete_task_2".equals((kde = (KDException)((Object)e)).getErrorCode().getCode())) {
                String taskStr = ((KDException)((Object)e)).getArgs()[0] + "";
                if (!"empty".equals(taskStr)) {
                    DeleteTaskUtil.saveException(e, 1, taskStr, "delete_task_2");
                }
                return true;
            }
            log.error("\u4efb\u52a1\u5220\u9664\u5931\u8d25\uff0c\u4efb\u52a1id\uff1a" + taskId, (Throwable)e);
            throw e;
        }
        return deleteSuccess;
    }

    private static Long[] deleteTasksForMutiParam(Long[] taskIds, String newStatus, String newComment, long userId, boolean remeberException, int status) {
        DeleteTaskServiceImpl deleteTaskService = new DeleteTaskServiceImpl();
        ArrayList<Long> successDeleteTaskId = new ArrayList<Long>();
        boolean deleteSuccess = false;
        for (Long taskId : taskIds) {
            try {
                deleteSuccess = deleteTaskService.deleteSingleTask(taskId, newStatus, newComment, userId, status);
                if (!deleteSuccess) continue;
                successDeleteTaskId.add(taskId);
            }
            catch (Exception e) {
                String taskStr;
                KDException kde;
                ErrorCode code;
                if (e instanceof KDException && (code = (kde = (KDException)((Object)e)).getErrorCode()) != null && code.getCode().startsWith("delete_task") && !"empty".equals(taskStr = ((KDException)((Object)e)).getArgs()[0] + "") && (remeberException || code.getCode().equals("delete_task_2"))) {
                    DeleteTaskUtil.saveException(e, status, taskStr, code.getCode());
                    successDeleteTaskId.add(taskId);
                    continue;
                }
                log.error("\u4efb\u52a1\u5220\u9664\u5931\u8d25\uff0c\u4efb\u52a1id\uff1a" + taskId, (Throwable)e);
            }
        }
        return successDeleteTaskId.toArray(new Long[0]);
    }

    private static void saveException(Exception e, int status, String taskStr, String code) {
        Map taskMap = (Map)SerializationUtils.fromJsonString((String)taskStr, Map.class);
        Long taskId = DeleteTaskUtil.getLong(taskMap.get("id"));
        Long sscId = DeleteTaskUtil.getLong(taskMap.get("sscid"));
        Long taskTypeId = DeleteTaskUtil.getLong(taskMap.get("tasktypeid"));
        Long billTypeId = DeleteTaskUtil.getLong(taskMap.get("billtype"));
        Long workflowId = DeleteTaskUtil.getLong(taskMap.get("assignid"));
        String billId = taskMap.get("billid") + "";
        String billNumber = (String)taskMap.get("billnumber");
        Long scenarioId = DeleteTaskUtil.getScenarioId(code);
        String bizAttribute = DeleteTaskUtil.getBizAttribute(status);
        String monitorRetry = workflowId + "";
        ExceptionSaveUtil.saveMonitorException((long)scenarioId, (long)taskId, (long)sscId, (long)billTypeId, (long)taskTypeId, (String)billId, (String)billNumber, (Throwable)e, (String)monitorRetry, (String)bizAttribute);
    }

    private static Long getLong(Object o) {
        if (o == null) {
            return 0L;
        }
        return Long.valueOf(o + "");
    }

    private static String getBizAttribute(int status) {
        if (status == 0) {
            return ResManager.loadKDString((String)"\u6d41\u7a0b\u7ec8\u6b62\u5220\u9664", (String)"DeleteTaskUtil_4", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        if (status == 1) {
            return ResManager.loadKDString((String)"\u624b\u5de5\u5220\u9664", (String)"DeleteTaskUtil_5", (String)"ssc-task-common", (Object[])new Object[0]);
        }
        return "";
    }

    private static Long getScenarioId(String code) {
        long scenarioId = 0L;
        if ("delete_task_0".equals(code)) {
            scenarioId = 7L;
        } else if ("delete_task_1".equals(code)) {
            scenarioId = 6L;
        } else if ("delete_task_2".equals(code)) {
            scenarioId = 5L;
        }
        return scenarioId;
    }

    @SdkDeprecated
    public static boolean deleteTaskWithoutUpdateWf(long taskId) {
        boolean deleteSuccess = false;
        try {
            deleteSuccess = new DeleteTaskServiceImpl().deleteTaskWithoutUpdateWf(taskId);
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u4efb\u52a1\u5220\u9664\u5931\u8d25\uff0c\u4efb\u52a1id: " + taskId, (Throwable)e);
        }
        return deleteSuccess;
    }
}

