/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.config.TaskParamHelper;

public class MessageHelper {
    private static final Log log = LogFactory.getLog(MessageHelper.class);
    public static final ExecutorService threadPool = ThreadPools.newCachedExecutorService((String)"ssc-send-message", (int)5, (int)10);
    public static final String channelParamKey = "msgCenterChannelNumbers";

    public static void sendMessage(DynamicObject[] disTasks) {
        if (disTasks == null || disTasks.length <= 0) {
            return;
        }
        threadPool.execute(() -> {
            String channels = MessageHelper.getChannels();
            if (StringUtils.isEmpty((String)channels)) {
                return;
            }
            try {
                Map<Long, List<DynamicObject>> person2Tasks = Arrays.stream(disTasks).collect(Collectors.groupingBy(MessageHelper::getPersonId));
                ArrayList<MessageInfo> msgInfos = new ArrayList<MessageInfo>(person2Tasks.size());
                for (Map.Entry<Long, List<DynamicObject>> entry : person2Tasks.entrySet()) {
                    int taskCount = entry.getValue().size();
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString messageTitle = ResManager.getLocaleString((String)"\u60a8\u6709%s\u4e2a\u5171\u4eab\u4efb\u52a1\u5f85\u5904\u7406\u3002", (String)"MessageHelper_0", (String)"ssc-task-common");
                    Set entrySet = messageTitle.entrySet();
                    for (Map.Entry locale : entrySet) {
                        String key = (String)locale.getKey();
                        String value = (String)locale.getValue();
                        if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
                        messageTitle.put(key, (Object)String.format(value, taskCount));
                    }
                    messageInfo.setMessageTitle((ILocaleString)messageTitle);
                    messageInfo.setMessageContent((ILocaleString)ResManager.getLocaleString((String)"\u8bf7\u6253\u5f00PC\u7aef\u201c\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3>\u6211\u7684\u4efb\u52a1\u201d\u83dc\u5355\u3002", (String)"MessageHelper_1", (String)"ssc-task-common"));
                    messageInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u5171\u4eab\u4efb\u52a1\u5904\u7406", (String)"MessageHelper_2", (String)"ssc-task-common"));
                    messageInfo.setUserIds(Collections.singletonList(entry.getKey()));
                    messageInfo.setEntityNumber("task_task");
                    messageInfo.setNotifyType(channels);
                    messageInfo.setType("message");
                    msgInfos.add(messageInfo);
                }
                MessageCenterServiceHelper.batchSendMessages(msgInfos);
            }
            catch (Exception e) {
                log.error("Error on sending message by channel[{}]", (Object)channels, (Object)e);
            }
        });
    }

    private static String getChannels() {
        String channelStr = TaskParamHelper.getTaskParamByName(channelParamKey);
        if (StringUtils.isBlank((String)channelStr)) {
            return null;
        }
        Set configChannels = Arrays.stream(channelStr.split(",")).collect(Collectors.toSet());
        Set invalidChannels = Arrays.stream(BusinessDataServiceHelper.load((String)"msg_channel", (String)"number", (QFilter[])new QFilter("number", "in", configChannels).toArray())).map(c -> c.getString("number")).collect(Collectors.toSet());
        if (configChannels.contains(MessageChannels.MC.getNumber())) {
            invalidChannels.add(MessageChannels.MC.getNumber());
        }
        return String.join((CharSequence)",", invalidChannels);
    }

    private static Long getPersonId(DynamicObject task) {
        Object personId = task.get("personid");
        if (personId instanceof DynamicObject) {
            return ((DynamicObject)personId).getLong("id");
        }
        return (Long)personId;
    }
}

