/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.approve.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.smartApproval.enums.IDISchemaStatusEnum;
import kd.ssc.task.domain.RecordExceptionDO;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.service.approve.IntelligentDecisionService;
import kd.ssc.task.util.RecordExceptionUtil;
import kd.ssc.task.util.SSCBosUtil;

public class IntelligentDecisionServiceImpl
implements IntelligentDecisionService {
    private static final int MAX_ERROR_INFO = 2000;
    private static final Log log = LogFactory.getLog(IntelligentDecisionServiceImpl.class);

    public DecisionResult decisionAnalysis(Long taskId, String invoRecognize, DynamicObject billDataEntity, List<String> schemaList) {
        if (billDataEntity == null) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(billDataEntity);
        params.add(schemaList);
        DecisionResult deciResult = null;
        Object resultStr = null;
        try {
            log.info(String.format("\u5bf9\u4efb\u52a1%s\u8fdb\u884c\u667a\u80fd\u6d1e\u5bdf\u3002", taskId));
            String needAIAttachmentResult = SSCBosUtil.getCtrlParam((String)"smartApprovalNeedAIAttachmentResult");
            boolean isNeedAIAttachmentResult = Boolean.parseBoolean(needAIAttachmentResult);
            if (isNeedAIAttachmentResult) {
                params.clear();
                params.add(billDataEntity.get("id"));
                params.add(billDataEntity.getDataEntityType().getName());
                params.add(schemaList);
                HashMap<String, Boolean> customParamMap = new HashMap<String, Boolean>(2);
                customParamMap.put("needAiAttachmentResult", isNeedAIAttachmentResult);
                customParamMap.put("needAiAttachment", isNeedAIAttachmentResult);
                params.add(customParamMap);
            }
            resultStr = DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaService", (String)"executeSchemaNativeByList", (Object[])params.toArray());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u667a\u80fd\u6d1e\u5bdf\u5f02\u5e38", (Throwable)e);
            deciResult = new DecisionResult();
            deciResult.setStatus(IDISchemaStatusEnum.CALL_ERROR.getValue());
            deciResult.setSucess(false);
            deciResult.setErrorInfo(ResManager.loadKDString((String)"\u8c03\u7528\u667a\u80fd\u6d1e\u5bdf\u5f02\u5e38\u3002", (String)"IntelligentDecisionServiceImpl_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        log.info("executeSchemaNativeByList return:" + resultStr);
        if (resultStr != null && StringUtils.isNotEmpty((String)(resultStr + ""))) {
            JSONObject resultJson = JSON.parseObject((String)(resultStr + ""));
            deciResult = this.parseResult(resultJson);
        }
        if (deciResult == null) {
            log.error("\u667a\u80fd\u6d1e\u5bdf\u89e3\u6790\u56de\u5e94\u5931\u8d25");
            deciResult = new DecisionResult();
            deciResult.setStatus(IDISchemaStatusEnum.NO_RESULT.getValue());
            deciResult.setSucess(false);
            deciResult.setErrorInfo(ResManager.loadKDString((String)"\u667a\u80fd\u51b3\u7b56\u5206\u6790\u5f02\u5e38", (String)"IntelligentDecisionServiceImpl_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        String info = String.format("taskId = %s, billId = %s, schemaList = %s", taskId, String.valueOf(billDataEntity.getPkValue()), schemaList);
        if (!deciResult.isSucess()) {
            RecordExceptionDO recordExc = RecordExceptionDO.builder().appId("ssc_intelligentDecision").errorMsg(info).errorStack(new Date().toString() + ": " + resultStr).build();
            RecordExceptionUtil.saveRecordExcept(recordExc);
        }
        return deciResult;
    }

    private DecisionResult parseResult(JSONObject resultJson) {
        DecisionResult deciResult = new DecisionResult();
        String status = resultJson.getString("status");
        deciResult.setStatus(status == null ? IDISchemaStatusEnum.OLD_VERSION.getValue() : status);
        deciResult.setScore(resultJson.getLong("score"));
        boolean flag = resultJson.getBoolean("isPass");
        String errorMsg = StringUtils.getEmpty();
        if (flag) {
            deciResult.setSucess(true);
            deciResult.setErrorInfo(errorMsg);
            return deciResult;
        }
        JSONArray notDetectedItemArray = resultJson.getJSONArray("notDetectedItem");
        if (notDetectedItemArray != null && (errorMsg = String.join((CharSequence)",", notDetectedItemArray.toJavaList(String.class))).length() > 2000) {
            errorMsg = errorMsg.substring(0, 1997) + "...";
        }
        deciResult.setSucess(false);
        deciResult.setErrorInfo(errorMsg);
        return deciResult;
    }
}

