/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkDeprecated;

public class TaskDateUtil {
    private static final Log log = LogFactory.getLog(TaskDateUtil.class);

    @SdkDeprecated
    public static String dateConvertFormatString(Date currentDate, String pattern) {
        if (currentDate == null) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return currentDate.toString();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format(currentDate);
    }

    @SdkDeprecated
    public static Date stringConvertFormatDate(String dateString, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            return formatter.parse(dateString);
        }
        catch (Exception e) {
            log.error("\u5b57\u7b26\u4e32\u65e5\u671f\u683c\u5f0f\u65e5\u671f\u5316\u51fa\u9519", (Throwable)e);
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    public static Date formatDate(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        String formatDate = dateFormat.format(date);
        try {
            return dateFormat.parse(formatDate);
        }
        catch (ParseException e) {
            log.error("\u683c\u5f0f\u5316\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static Map<String, Date> getQueryTimeParams(String timeRangeType, Date toStartTime, Date toEndTime) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        Date beginDate = null;
        Date endDate = null;
        Calendar calendar = Calendar.getInstance();
        switch (timeRangeType) {
            case "0": {
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "1": {
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                calendar.add(5, -2);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "2": {
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                calendar.add(5, -3);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "3": {
                calendar.setFirstDayOfWeek(2);
                calendar.set(7, 2);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                calendar.set(7, 1);
                endDate = TaskDateUtil.getLastTime(calendar);
                break;
            }
            case "4": {
                calendar.setFirstDayOfWeek(2);
                calendar.set(7, 2);
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                calendar.add(5, -6);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "5": {
                calendar.set(5, 1);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                calendar.add(2, 1);
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                break;
            }
            case "6": {
                calendar.set(5, 1);
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                calendar.set(5, 1);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "7": {
                calendar.set(6, 1);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                calendar.add(1, 1);
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                break;
            }
            case "8": {
                calendar.set(6, 1);
                calendar.add(5, -1);
                endDate = TaskDateUtil.getLastTime(calendar);
                calendar.add(1, -1);
                calendar.add(5, 1);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                break;
            }
            case "9": {
                calendar.setTime(toStartTime);
                beginDate = TaskDateUtil.getFirstTime(calendar);
                calendar.setTime(toEndTime);
                endDate = TaskDateUtil.getLastTime(calendar);
            }
        }
        map.put("startdate", beginDate);
        map.put("enddate", endDate);
        return map;
    }

    public static Date getFirstTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getLastTime(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }
}

