/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.withdraw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.sdk.fi.ssc.extpoint.task.withdraw.service.InDealTaskWithdrawService;
import kd.sdk.fi.ssc.extpoint.task.withdraw.service.TaskWithdrawService;
import kd.ssc.enums.Source;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.create.helper.CreateTaskHelper;
import kd.ssc.task.helper.MessageHelper;
import kd.ssc.task.util.ParTaskAuditMsgUpdateUtil;
import kd.ssc.task.util.TaskWorkFlowUtil;
import kd.ssc.task.withdraw.service.impl.InDealTaskWithdrawServiceImpl;
import kd.ssc.task.withdraw.service.impl.TaskWithdrawServiceImpl;

public class TaskWithdrawUtil {
    private static final Log log = LogFactory.getLog(TaskWithdrawUtil.class);

    public static boolean taskWithdraw(String billId, String wfTaskId) {
        boolean result = false;
        try {
            InDealTaskWithdrawServiceImpl inDealTaskWithdrawService = new InDealTaskWithdrawServiceImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)inDealTaskWithdrawService, InDealTaskWithdrawService.class, (String)"kd.sdk.fi.ssc.extpoint.task.withdraw.service.InDealTaskWithdrawService.withdrawExt");
            List results = pluginProxy.callReplaceIfPresent(p -> p.withdraw(billId, wfTaskId));
            if (results != null && !results.isEmpty()) {
                result = (Boolean)results.get(0);
            }
        }
        catch (Exception e) {
            log.error("\u5171\u4eab\u4efb\u52a1\u64a4\u56de\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public static boolean taskWithdrawBySSC(long taskId) throws Exception {
        String selectFields = "assignid,personid,usergroup,billid";
        QFilter[] priFilter = new QFilter[]{new QFilter("id", "=", (Object)taskId)};
        DynamicObject task = QueryServiceHelper.queryOne((String)"task_taskhistory", (String)selectFields, (QFilter[])priFilter);
        if (task == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868\u3002", (String)"TaskWithdrawUtil_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        Long wfTaskId = task.getLong("assignid");
        WorkflowServiceHelper.withdrawTaskByTaskId((Long)wfTaskId, (Long)RequestContext.get().getCurrUserId());
        TaskWithdrawUtil.deleteWfTrdComment(wfTaskId);
        CreateTaskHelper.isLegitimateInput((Long)taskId, (Long)wfTaskId);
        long newTaskId = CreateTaskHelper.createTaskByWithdrawZxjt((Long)taskId, (Long)wfTaskId);
        Long userId = task.getLong("personid");
        Long groupId = task.getLong("usergroup");
        TaskWithdrawUtil.disApprovalTask4GivenUser(newTaskId, groupId, userId);
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
        return true;
    }

    public static boolean canWithdraw(String billId, String entityNumber, long workFlowId) {
        boolean result = false;
        try {
            TaskWithdrawServiceImpl taskWithdrawService = new TaskWithdrawServiceImpl();
            PluginProxy proxy = PluginProxy.create((Object)taskWithdrawService, TaskWithdrawService.class, (String)"kd.sdk.fi.ssc.extpoint.task.withdraw.service.TaskWithdrawService.withdrawExt");
            List results = proxy.callReplaceIfPresent(p -> p.canWithdraw(billId, entityNumber, workFlowId));
            if (results != null && !results.isEmpty()) {
                result = (Boolean)results.get(0);
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u5171\u4eab\u4efb\u52a1\u662f\u5426\u53ef\u4ee5\u64a4\u56de\u529f\u80fd\u5f02\u5e38, billId: " + billId, (Throwable)e);
            throw e;
        }
        return result;
    }

    private static void deleteWfTrdComment(long wfTaskId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)wfTaskId)};
        DeleteServiceHelper.delete((String)"wf_trdhicomment", (QFilter[])qFilters);
    }

    public static boolean disApprovalTask4GivenUser(Long taskId, Long groupId, Long userId) throws Exception {
        if (!TaskWithdrawUtil.validateInput(taskId, groupId, userId)) {
            return false;
        }
        QFilter[] taskIdFilters = new QFilter[]{new QFilter("id", "=", (Object)taskId)};
        String selectFields = "id,personid,usergroup,pooltype,tasktypeid,billtype,billtype.externalerp.number,billid,source,state,receivetime,bizdata_tag,assignid,subject,qualitysamplelibrary.id,qualitystate,orignalperson,autoprocess,sscid";
        DynamicObject disTask = BusinessDataServiceHelper.loadSingle((String)"task_task", (String)selectFields, (QFilter[])taskIdFilters);
        String msg = "";
        if (disTask.getLong("qualitysamplelibrary.id") > 0L) {
            msg = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5206\u914d\u8d28\u68c0\u4efb\u52a1", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_quality", msg);
            throw new KDBizException(code, new Object[0]);
        }
        if (!TaskWithdrawUtil.isKdccTask(disTask)) {
            msg = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u7531\u5f02\u6784\u7cfb\u7edf\u521b\u5efa\uff0c\u4e0d\u5141\u8bb8\u5206\u914d", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_quality", msg);
            throw new KDBizException(code, new Object[0]);
        }
        String curPoolType = disTask.getString("pooltype");
        ArrayList<DynamicObject> stateChangeDynObjs = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        if (TaskPoolTypeEnum.TO_BE_DIS.getValue().equals(curPoolType)) {
            TaskWithdrawUtil.setState4DisTask(disTask, now, stateChangeDynObjs, userId);
        } else if (TaskPoolTypeEnum.PROCESSING.getValue().equals(curPoolType)) {
            TaskWithdrawUtil.setState4RedisTask(disTask, now, stateChangeDynObjs, userId);
        } else {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u65e0\u6cd5\u88ab\u5206\u914d", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_type", msg);
            throw new KDBizException(code, new Object[0]);
        }
        disTask.set("personid", (Object)userId);
        disTask.set("usergroup", (Object)groupId);
        disTask.set("pooltype", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        disTask.set("receivetime", (Object)now);
        disTask.set("autoprocess", (Object)TaskWithdrawUtil.isRobotGroup(groupId));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{disTask});
        SaveServiceHelper.save((DynamicObject[])stateChangeDynObjs.toArray(new DynamicObject[0]));
        TaskWithdrawUtil.deletePriorityLog(Collections.singletonList(taskId));
        TaskWithdrawUtil.addTaskCommon(disTask);
        ParTaskAuditMsgUpdateUtil.updateNodeInfoAfterDist(new DynamicObject[]{disTask});
        MessageHelper.sendMessage(new DynamicObject[]{disTask});
        return true;
    }

    private static void addTaskCommon(DynamicObject disTask) {
        TaskWorkFlowUtil.updatePersonAndMsgDisTask(new DynamicObject[]{disTask}, ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"", (String)"", (Object[])new Object[0]));
    }

    private static void deletePriorityLog(List<Long> taskIds) {
        QFilter[] taskIdFilters = new QFilter[]{new QFilter("job", "in", taskIds)};
        DeleteServiceHelper.delete((String)"task_prioritychangerecord", (QFilter[])taskIdFilters);
    }

    private static void setState4RedisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Long userId) {
        String curState = disTask.getString("state");
        DynamicObject stateChangeObj = TaskWithdrawUtil.createTaskStateChangeDynObj(disTask.getLong("id"), curState, curState, now, "7", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private static boolean validateInput(Long taskId, Long groupId, Long userId) {
        String msg = "";
        if (taskId == null || taskId == 0L) {
            msg = ResManager.loadKDString((String)"\u5165\u53c2\u6709\u8bef\uff0c\u4efb\u52a1id\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_input", msg);
            throw new KDBizException(code, new Object[0]);
        }
        if (groupId == null || groupId == 0L) {
            msg = ResManager.loadKDString((String)"\u5165\u53c2\u6709\u8bef\uff0c\u7528\u6237\u7ec4id\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_input", msg);
            throw new KDBizException(code, new Object[0]);
        }
        if (userId == null || userId == 0L) {
            msg = ResManager.loadKDString((String)"\u5165\u53c2\u6709\u8bef\uff0c\u7528\u6237id\u4e3a\u7a7a", (String)"", (String)"", (Object[])new Object[0]);
            ErrorCode code = new ErrorCode("dis_error_input", msg);
            throw new KDBizException(code, new Object[0]);
        }
        return true;
    }

    private static void setState4DisTask(DynamicObject disTask, Date now, List<DynamicObject> stateChangeDynObjs, Long userId) {
        String curState = disTask.getString("state");
        disTask.set("state", (Object)TaskStateEnum.TO_BE_AUDIT.getValue());
        DynamicObject stateChangeObj = TaskWithdrawUtil.createTaskStateChangeDynObj(disTask.getLong("id"), disTask.getString("state"), curState, now, "6", disTask.getLong("tasktypeid.id"), disTask.getLong("billtype.id"), userId);
        stateChangeDynObjs.add(stateChangeObj);
    }

    private static DynamicObject createTaskStateChangeDynObj(Long taskId, String newJobState, String oldJobState, Date changeTime, String operation, Long tasktype_id, Long billtype_id, Long userId) {
        DynamicObject stateChangeDynObj = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        stateChangeDynObj.set("jobid", (Object)taskId);
        stateChangeDynObj.set("newjobstate", (Object)newJobState);
        stateChangeDynObj.set("oldjobstate", (Object)oldJobState);
        stateChangeDynObj.set("changetime", (Object)changeTime);
        stateChangeDynObj.set("operatorid_id", (Object)userId);
        stateChangeDynObj.set("operation", (Object)operation);
        stateChangeDynObj.set("tasktype_id", (Object)tasktype_id);
        stateChangeDynObj.set("billtype_id", (Object)billtype_id);
        return stateChangeDynObj;
    }

    private static boolean isKdccTask(DynamicObject disTask) {
        String source = disTask.getString("source");
        String extendNum = disTask.getString("billtype.externalerp.number");
        return (source.equals(Integer.toString(Source.WorkFlow.getValue())) || source.equals(Integer.toString(Source.ParTask.getValue()))) && "KDCC".equalsIgnoreCase(extendNum);
    }

    private static boolean isRobotGroup(Long userGroupId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)userGroupId, (String)"task_usergroup", (String)"isrobots");
        return dynamicObject.getBoolean("isrobots");
    }
}

